/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.G;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.util.NumberedString;

public class EntryPoints {
    final NumberedString sigMain = Scene.v().getSubSigNumberer().findOrAdd("void main(java.lang.String[])");
    final NumberedString sigFinalize = Scene.v().getSubSigNumberer().findOrAdd("void finalize()");
    final NumberedString sigExit = Scene.v().getSubSigNumberer().findOrAdd("void exit()");
    final NumberedString sigClinit = Scene.v().getSubSigNumberer().findOrAdd("void <clinit>()");
    final NumberedString sigInit = Scene.v().getSubSigNumberer().findOrAdd("void <init>()");
    final NumberedString sigStart = Scene.v().getSubSigNumberer().findOrAdd("void start()");
    final NumberedString sigRun = Scene.v().getSubSigNumberer().findOrAdd("void run()");
    final NumberedString sigObjRun = Scene.v().getSubSigNumberer().findOrAdd("java.lang.Object run()");
    final NumberedString sigForName = Scene.v().getSubSigNumberer().findOrAdd("java.lang.Class forName(java.lang.String)");
    final RefType clPrivilegedAction = RefType.v("java.security.PrivilegedAction");
    final RefType clPrivilegedExceptionAction = RefType.v("java.security.PrivilegedExceptionAction");
    final RefType clRunnable = RefType.v("java.lang.Runnable");

    public EntryPoints(Singletons.Global g) {
    }

    public static EntryPoints v() {
        return G.v().EntryPoints();
    }

    private final void addMethod(List set, SootClass cls, NumberedString methodSubSig) {
        if (cls.declaresMethod(methodSubSig)) {
            set.add(cls.getMethod(methodSubSig));
        }
    }

    private final void addMethod(List set, String methodSig) {
        if (Scene.v().containsMethod(methodSig)) {
            set.add(Scene.v().getMethod(methodSig));
        }
    }

    public List application() {
        ArrayList ret = new ArrayList();
        this.addMethod(ret, Scene.v().getMainClass(), this.sigMain);
        this.addMethod(ret, Scene.v().getMainClass(), this.sigClinit);
        return ret;
    }

    public List implicit() {
        ArrayList ret = new ArrayList();
        this.addMethod(ret, "<java.lang.System: void initializeSystemClass()>");
        this.addMethod(ret, "<java.lang.ThreadGroup: void <init>()>");
        this.addMethod(ret, "<java.lang.ThreadGroup: void remove(java.lang.Thread)>");
        this.addMethod(ret, "<java.lang.ThreadGroup: void uncaughtException(java.lang.Thread,java.lang.Throwable)>");
        this.addMethod(ret, "<java.lang.System: void loadLibrary(java.lang.String)>");
        this.addMethod(ret, "<java.lang.ClassLoader: java.lang.Class loadClassInternal(java.lang.String)>");
        this.addMethod(ret, "<java.lang.ClassLoader: void checkPackageAccess(java.lang.Class,java.security.ProtectionDomain)>");
        this.addMethod(ret, "<java.lang.ClassLoader: void addClass(java.lang.Class)>");
        this.addMethod(ret, "<java.lang.ClassLoader: long findNative(java.lang.ClassLoader,java.lang.String)>");
        this.addMethod(ret, "<java.security.PrivilegedActionException: void <init>(java.lang.Exception)>");
        this.addMethod(ret, "<java.lang.ref.Finalizer: void register(java.lang.Object)>");
        this.addMethod(ret, "<java.lang.ref.Finalizer: void runFinalizer()>");
        this.addMethod(ret, "<java.lang.String: byte[] getBytes()>");
        return ret;
    }

    public List all() {
        ArrayList ret = new ArrayList();
        ret.addAll(this.application());
        ret.addAll(this.implicit());
        return ret;
    }

    public List clinits() {
        ArrayList ret = new ArrayList();
        Iterator clIt = Scene.v().getClasses().iterator();
        while (clIt.hasNext()) {
            SootClass cl = (SootClass)clIt.next();
            this.addMethod(ret, cl, this.sigClinit);
        }
        return ret;
    }

    public List inits() {
        ArrayList ret = new ArrayList();
        Iterator clIt = Scene.v().getClasses().iterator();
        while (clIt.hasNext()) {
            SootClass cl = (SootClass)clIt.next();
            this.addMethod(ret, cl, this.sigInit);
        }
        return ret;
    }

    public List methodsOfApplicationClasses() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        Iterator clIt = Scene.v().getApplicationClasses().iterator();
        while (clIt.hasNext()) {
            SootClass cl = (SootClass)clIt.next();
            Iterator mIt = cl.getMethods().iterator();
            while (mIt.hasNext()) {
                SootMethod m = (SootMethod)mIt.next();
                if (!m.isConcrete()) continue;
                ret.add(m);
            }
        }
        return ret;
    }
}

