/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.nullcheck;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.ArrayType;
import soot.EquivalentValue;
import soot.Local;
import soot.NullType;
import soot.RefType;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.EqExpr;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.MonitorStmt;
import soot.jimple.NeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NullConstant;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.toolkits.annotation.nullcheck.RefIntPair;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArrayFlowUniverse;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardBranchedFlowAnalysis;

public class BranchedRefVarsAnalysis
extends ForwardBranchedFlowAnalysis {
    private boolean isNotConservative = false;
    private boolean isBranched = true;
    private boolean careForAliases = false;
    private boolean careForMethodCalls = true;
    protected final int kBottom = 0;
    protected final int kNull = 1;
    protected final int kNonNull = 2;
    protected final int kTop = 99;
    protected FlowSet emptySet;
    protected FlowSet fullSet;
    protected Map unitToGenerateSet;
    protected Map unitToPreserveSet;
    protected Map unitToAnalyzedChecksSet;
    protected Map unitToArrayRefChecksSet;
    protected Map unitToInstanceFieldRefChecksSet;
    protected Map unitToInstanceInvokeExprChecksSet;
    protected Map unitToLengthExprChecksSet;
    protected List refTypeLocals;
    protected List refTypeInstFields;
    protected List refTypeInstFieldBases;
    protected List refTypeStaticFields;
    protected List refTypeValues;
    protected FlowSet tempFlowSet = null;
    private HashMap valueToEquivValue = new HashMap(2293, 0.7f);
    private HashMap kRefBotttomPairs = new HashMap(2293, 0.7f);
    private HashMap kRefNonNullPairs = new HashMap(2293, 0.7f);
    private HashMap kRefNullPairs = new HashMap(2293, 0.7f);
    private HashMap kRefTopPairs = new HashMap(2293, 0.7f);

    public EquivalentValue getEquivalentValue(Value v) {
        if (this.valueToEquivValue.containsKey(v)) {
            return (EquivalentValue)this.valueToEquivValue.get(v);
        }
        EquivalentValue ev = new EquivalentValue(v);
        this.valueToEquivValue.put(v, ev);
        return ev;
    }

    public RefIntPair getKRefIntPair(EquivalentValue r, int v) {
        HashMap pairsMap = null;
        if (v == 2) {
            pairsMap = this.kRefNonNullPairs;
        } else if (v == 1) {
            pairsMap = this.kRefNullPairs;
        } else if (v == 99) {
            pairsMap = this.kRefTopPairs;
        } else if (v == 0) {
            pairsMap = this.kRefBotttomPairs;
        } else {
            throw new RuntimeException("invalid constant (" + v + ")");
        }
        if (pairsMap.containsKey(r)) {
            return (RefIntPair)pairsMap.get(r);
        }
        RefIntPair pair = new RefIntPair(r, v, this);
        pairsMap.put(r, pair);
        return pair;
    }

    private final boolean isAlwaysNull(Value r) {
        return r instanceof NullConstant || r.getType() instanceof NullType;
    }

    private final boolean isAlwaysTop(Value r) {
        if (this.isNotConservative) {
            return false;
        }
        return r instanceof InstanceFieldRef || r instanceof StaticFieldRef;
    }

    private final boolean isAlwaysNonNull(Value ro) {
        if (ro instanceof NewExpr) {
            return true;
        }
        if (ro instanceof NewArrayExpr) {
            return true;
        }
        if (ro instanceof NewMultiArrayExpr) {
            return true;
        }
        if (ro instanceof ThisRef) {
            return true;
        }
        if (ro instanceof CaughtExceptionRef) {
            return true;
        }
        return ro instanceof StringConstant;
    }

    private final boolean isAnalyzedRef(Value r) {
        if (this.isAlwaysNull(r) || this.isAlwaysTop(r)) {
            return false;
        }
        if (r instanceof Local || r instanceof InstanceFieldRef || r instanceof StaticFieldRef) {
            Type rType = r.getType();
            return rType instanceof RefType || rType instanceof ArrayType;
        }
        return false;
    }

    protected final int refInfo(EquivalentValue r, FlowSet fs) {
        boolean isNull = fs.contains(this.getKRefIntPair(r, 1));
        boolean isNonNull = fs.contains(this.getKRefIntPair(r, 2));
        if (isNull && isNonNull) {
            return 99;
        }
        if (isNull) {
            return 1;
        }
        if (isNonNull) {
            return 2;
        }
        return 0;
    }

    protected final int refInfo(Value r, FlowSet fs) {
        return this.refInfo(this.getEquivalentValue(r), fs);
    }

    protected final int anyRefInfo(Value r, FlowSet f) {
        if (this.isAlwaysNull(r)) {
            return 1;
        }
        if (this.isAlwaysTop(r)) {
            return 99;
        }
        if (this.isAlwaysNonNull(r)) {
            return 2;
        }
        return this.refInfo(r, f);
    }

    private final void uAddTopToFlowSet(EquivalentValue r, FlowSet genFS, FlowSet preFS) {
        RefIntPair nullPair = this.getKRefIntPair(r, 1);
        RefIntPair nullNonPair = this.getKRefIntPair(r, 2);
        if (genFS != preFS) {
            preFS.remove(nullPair, preFS);
            preFS.remove(nullNonPair, preFS);
        }
        genFS.add(nullPair, genFS);
        genFS.add(nullNonPair, genFS);
    }

    private final void uAddTopToFlowSet(Value r, FlowSet genFS, FlowSet preFS) {
        this.uAddTopToFlowSet(this.getEquivalentValue(r), genFS, preFS);
    }

    private final void uAddTopToFlowSet(Value r, FlowSet fs) {
        this.uAddTopToFlowSet(this.getEquivalentValue(r), fs, fs);
    }

    private final void uAddTopToFlowSet(EquivalentValue r, FlowSet fs) {
        this.uAddTopToFlowSet(r, fs, fs);
    }

    /*
     * WARNING - void declaration
     */
    private final void uAddInfoToFlowSet(EquivalentValue r, int v, FlowSet genFS, FlowSet preFS) {
        void var5_5;
        int kill;
        if (v == 1) {
            kill = 2;
        } else if (v == 2) {
            kill = 1;
        } else {
            throw new RuntimeException("invalid info");
        }
        if (genFS != preFS) {
            preFS.remove(this.getKRefIntPair(r, (int)var5_5), preFS);
        }
        genFS.remove(this.getKRefIntPair(r, (int)var5_5), genFS);
        genFS.add(this.getKRefIntPair(r, v), genFS);
    }

    private final void uAddInfoToFlowSet(Value r, int v, FlowSet genF, FlowSet preF) {
        this.uAddInfoToFlowSet(this.getEquivalentValue(r), v, genF, preF);
    }

    private final void uAddInfoToFlowSet(Value r, int v, FlowSet fs) {
        this.uAddInfoToFlowSet(this.getEquivalentValue(r), v, fs, fs);
    }

    private final void uAddInfoToFlowSet(EquivalentValue r, int v, FlowSet fs) {
        this.uAddInfoToFlowSet(r, v, fs, fs);
    }

    private final void uListAddTopToFlowSet(List refs, FlowSet genFS, FlowSet preFS) {
        Iterator it = refs.iterator();
        while (it.hasNext()) {
            this.uAddTopToFlowSet((EquivalentValue)it.next(), genFS, preFS);
        }
    }

    public BranchedRefVarsAnalysis(UnitGraph g) {
        super(g);
        this.initRefTypeLists();
        this.initUniverseSets();
        this.initUnitSets();
        this.doAnalysis();
    }

    private void initRefTypeLists() {
        this.refTypeLocals = new ArrayList();
        this.refTypeInstFields = new ArrayList();
        this.refTypeInstFieldBases = new ArrayList();
        this.refTypeStaticFields = new ArrayList();
        this.refTypeValues = new ArrayList();
        Iterator it = ((UnitGraph)this.graph).getBody().getLocals().iterator();
        while (it.hasNext()) {
            Local l = (Local)it.next();
            if (!(l.getType() instanceof RefType) && !(l.getType() instanceof ArrayType)) continue;
            this.refTypeLocals.add(this.getEquivalentValue(l));
        }
        if (this.isNotConservative) {
            Iterator unitIt = this.graph.iterator();
            while (unitIt.hasNext()) {
                Unit s = (Unit)unitIt.next();
                Iterator boxIt = s.getUseBoxes().iterator();
                while (boxIt.hasNext()) {
                    this.initRefTypeLists((ValueBox)boxIt.next());
                }
                boxIt = s.getDefBoxes().iterator();
                while (boxIt.hasNext()) {
                    this.initRefTypeLists((ValueBox)boxIt.next());
                }
            }
        }
        this.refTypeValues.addAll(this.refTypeLocals);
        this.refTypeValues.addAll(this.refTypeInstFields);
        this.refTypeValues.addAll(this.refTypeStaticFields);
    }

    private void initRefTypeLists(ValueBox box) {
        EquivalentValue esr;
        StaticFieldRef sr;
        Value val = box.getValue();
        Type opType = null;
        if (val instanceof InstanceFieldRef) {
            EquivalentValue eir;
            InstanceFieldRef ir = (InstanceFieldRef)val;
            opType = ir.getType();
            if ((opType instanceof RefType || opType instanceof ArrayType) && !this.refTypeInstFields.contains(eir = this.getEquivalentValue(ir))) {
                this.refTypeInstFields.add(eir);
                EquivalentValue eirbase = this.getEquivalentValue(ir.getBase());
                if (!this.refTypeInstFieldBases.contains(eirbase)) {
                    this.refTypeInstFieldBases.add(eirbase);
                }
            }
        } else if (val instanceof StaticFieldRef && ((opType = (sr = (StaticFieldRef)val).getType()) instanceof RefType || opType instanceof ArrayType) && !this.refTypeStaticFields.contains(esr = this.getEquivalentValue(sr))) {
            this.refTypeStaticFields.add(esr);
        }
    }

    private void initUniverseSets() {
        Object[] refTypeValuesArray = this.refTypeValues.toArray();
        int len = refTypeValuesArray.length;
        Object[] universeArray = new Object[2 * len];
        for (int i = 0; i < len; ++i) {
            int j = i * 2;
            EquivalentValue r = (EquivalentValue)refTypeValuesArray[i];
            universeArray[j] = this.getKRefIntPair(r, 1);
            universeArray[j + 1] = this.getKRefIntPair(r, 2);
        }
        ArrayFlowUniverse localUniverse = new ArrayFlowUniverse(universeArray);
        this.emptySet = new ArrayPackedSet(localUniverse);
        this.fullSet = (FlowSet)this.emptySet.clone();
        ((ArrayPackedSet)this.emptySet).complement(this.fullSet);
        this.tempFlowSet = (FlowSet)this.newInitialFlow();
    }

    private void initUnitSets() {
        int cap = this.graph.size() * 2 + 1;
        float load = 0.7f;
        this.unitToGenerateSet = new HashMap(cap, load);
        this.unitToPreserveSet = new HashMap(cap, load);
        this.unitToAnalyzedChecksSet = new HashMap(cap, load);
        this.unitToArrayRefChecksSet = new HashMap(cap, load);
        this.unitToInstanceFieldRefChecksSet = new HashMap(cap, load);
        this.unitToInstanceInvokeExprChecksSet = new HashMap(cap, load);
        this.unitToLengthExprChecksSet = new HashMap(cap, load);
        Iterator unitIt = this.graph.iterator();
        while (unitIt.hasNext()) {
            Value base;
            Value boxValue;
            DefinitionStmt as;
            Unit s = (Unit)unitIt.next();
            FlowSet genSet = (FlowSet)this.emptySet.clone();
            FlowSet preSet = (FlowSet)this.fullSet.clone();
            HashSet<Value> analyzedChecksSet = new HashSet<Value>(5, load);
            HashSet<Value> arrayRefChecksSet = new HashSet<Value>(5, load);
            HashSet<Value> instanceFieldRefChecksSet = new HashSet<Value>(5, load);
            HashSet<Value> instanceInvokeExprChecksSet = new HashSet<Value>(5, load);
            HashSet<Value> lengthExprChecksSet = new HashSet<Value>(5, load);
            if (this.careForMethodCalls && ((Stmt)s).containsInvokeExpr()) {
                this.uListAddTopToFlowSet(this.refTypeInstFields, genSet, preSet);
                this.uListAddTopToFlowSet(this.refTypeStaticFields, genSet, preSet);
            }
            if (this.careForAliases && s instanceof AssignStmt) {
                as = (AssignStmt)s;
                Value lhs = as.getLeftOp();
                if (this.refTypeInstFieldBases.contains(lhs)) {
                    Iterator refTypeInstFieldsIt = this.refTypeInstFields.iterator();
                    while (refTypeInstFieldsIt.hasNext()) {
                        EquivalentValue eifr = (EquivalentValue)refTypeInstFieldsIt.next();
                        InstanceFieldRef ifr = (InstanceFieldRef)eifr.getValue();
                        if (ifr.getBase() != lhs) continue;
                        this.uAddTopToFlowSet(eifr, genSet, preSet);
                    }
                }
                if (lhs instanceof InstanceFieldRef) {
                    String lhsName = ((InstanceFieldRef)lhs).getField().getName();
                    Iterator refTypeInstFieldsIt = this.refTypeInstFields.iterator();
                    while (refTypeInstFieldsIt.hasNext()) {
                        EquivalentValue eifr = (EquivalentValue)refTypeInstFieldsIt.next();
                        InstanceFieldRef ifr = (InstanceFieldRef)eifr.getValue();
                        String name = ifr.getField().getName();
                        if (!name.equals(lhsName)) continue;
                        this.uAddTopToFlowSet(eifr, genSet, preSet);
                    }
                }
            }
            Iterator boxIt = s.getDefBoxes().iterator();
            while (boxIt.hasNext()) {
                ValueBox box = (ValueBox)boxIt.next();
                Value boxValue2 = box.getValue();
                if (!this.isAnalyzedRef(boxValue2)) continue;
                this.uAddTopToFlowSet(boxValue2, genSet, preSet);
            }
            if (s instanceof DefinitionStmt) {
                as = (DefinitionStmt)s;
                Value ro = as.getRightOp();
                Value lo = as.getLeftOp();
                if (ro instanceof CastExpr) {
                    ro = ((CastExpr)ro).getOp();
                }
                if (this.isAnalyzedRef(lo)) {
                    if (this.isAlwaysNonNull(ro)) {
                        this.uAddInfoToFlowSet(lo, 2, genSet, preSet);
                    } else if (this.isAlwaysNull(ro)) {
                        this.uAddInfoToFlowSet(lo, 1, genSet, preSet);
                    } else if (this.isAlwaysTop(ro)) {
                        this.uAddTopToFlowSet(lo, genSet, preSet);
                    }
                }
            }
            boxIt = s.getUseBoxes().iterator();
            while (boxIt.hasNext()) {
                boxValue = ((ValueBox)boxIt.next()).getValue();
                base = null;
                if (boxValue instanceof InstanceFieldRef) {
                    base = ((InstanceFieldRef)boxValue).getBase();
                    instanceFieldRefChecksSet.add(base);
                } else if (boxValue instanceof ArrayRef) {
                    base = ((ArrayRef)boxValue).getBase();
                    arrayRefChecksSet.add(base);
                } else if (boxValue instanceof InstanceInvokeExpr) {
                    base = ((InstanceInvokeExpr)boxValue).getBase();
                    instanceInvokeExprChecksSet.add(base);
                } else if (boxValue instanceof LengthExpr) {
                    base = ((LengthExpr)boxValue).getOp();
                    lengthExprChecksSet.add(base);
                } else if (s instanceof ThrowStmt) {
                    base = ((ThrowStmt)s).getOp();
                } else if (s instanceof MonitorStmt) {
                    base = ((MonitorStmt)s).getOp();
                }
                if (base == null || !this.isAnalyzedRef(base)) continue;
                this.uAddInfoToFlowSet(base, 2, genSet, preSet);
                analyzedChecksSet.add(base);
            }
            boxIt = s.getDefBoxes().iterator();
            while (boxIt.hasNext()) {
                boxValue = ((ValueBox)boxIt.next()).getValue();
                base = null;
                if (boxValue instanceof InstanceFieldRef) {
                    base = ((InstanceFieldRef)boxValue).getBase();
                    instanceFieldRefChecksSet.add(base);
                } else if (boxValue instanceof ArrayRef) {
                    base = ((ArrayRef)boxValue).getBase();
                    arrayRefChecksSet.add(base);
                } else if (boxValue instanceof InstanceInvokeExpr) {
                    base = ((InstanceInvokeExpr)boxValue).getBase();
                    instanceInvokeExprChecksSet.add(base);
                } else if (boxValue instanceof LengthExpr) {
                    base = ((LengthExpr)boxValue).getOp();
                    lengthExprChecksSet.add(base);
                } else if (s instanceof ThrowStmt) {
                    base = ((ThrowStmt)s).getOp();
                } else if (s instanceof MonitorStmt) {
                    base = ((MonitorStmt)s).getOp();
                }
                if (base == null || !this.isAnalyzedRef(base)) continue;
                this.uAddInfoToFlowSet(base, 2, genSet, preSet);
                analyzedChecksSet.add(base);
            }
            this.unitToGenerateSet.put(s, genSet);
            this.unitToPreserveSet.put(s, preSet);
            this.unitToAnalyzedChecksSet.put(s, analyzedChecksSet);
            this.unitToArrayRefChecksSet.put(s, arrayRefChecksSet);
            this.unitToInstanceFieldRefChecksSet.put(s, instanceFieldRefChecksSet);
            this.unitToInstanceInvokeExprChecksSet.put(s, instanceInvokeExprChecksSet);
            this.unitToLengthExprChecksSet.put(s, lengthExprChecksSet);
        }
    }

    protected void flowThrough(Object inValue, Unit stmt, List outFallValue, List outBranchValues) {
        FlowSet fs;
        FlowSet in = (FlowSet)inValue;
        FlowSet out = this.tempFlowSet;
        FlowSet pre = (FlowSet)this.unitToPreserveSet.get(stmt);
        FlowSet gen = (FlowSet)this.unitToGenerateSet.get(stmt);
        in.intersection(pre, out);
        out.union(gen, out);
        if (stmt instanceof AssignStmt) {
            AssignStmt as = (AssignStmt)stmt;
            Value rightOp = as.getRightOp();
            Value leftOp = as.getLeftOp();
            if (rightOp instanceof CastExpr) {
                rightOp = ((CastExpr)rightOp).getOp();
            }
            if (this.isAnalyzedRef(leftOp) && this.isAnalyzedRef(rightOp)) {
                int roInfo = this.refInfo(rightOp, in);
                if (roInfo == 99) {
                    this.uAddTopToFlowSet(leftOp, out);
                } else if (roInfo != 0) {
                    this.uAddInfoToFlowSet(leftOp, roInfo, out);
                }
            }
        }
        Iterator it = outBranchValues.iterator();
        while (it.hasNext()) {
            fs = (FlowSet)it.next();
            this.copy(out, fs);
        }
        it = outFallValue.iterator();
        while (it.hasNext()) {
            fs = (FlowSet)it.next();
            this.copy(out, fs);
        }
        if (this.isBranched && stmt instanceof IfStmt) {
            Value cond = ((IfStmt)stmt).getCondition();
            Value op1 = ((BinopExpr)cond).getOp1();
            Value op2 = ((BinopExpr)cond).getOp2();
            if (!this.isAlwaysTop(op1) && !this.isAlwaysTop(op2) && (this.isAnalyzedRef(op1) || this.isAnalyzedRef(op2))) {
                boolean op2isKnown;
                Value toGen = null;
                int toGenInfo = 0;
                int op1Info = this.anyRefInfo(op1, in);
                int op2Info = this.anyRefInfo(op2, in);
                boolean op1isKnown = op1Info == 1 || op1Info == 2;
                boolean bl = op2isKnown = op2Info == 1 || op2Info == 2;
                if (op1isKnown) {
                    if (!op2isKnown) {
                        toGen = op2;
                        toGenInfo = op1Info;
                    }
                } else if (op2isKnown) {
                    toGen = op1;
                    toGenInfo = op2Info;
                }
                if (toGen != null && this.isAnalyzedRef(toGen)) {
                    FlowSet fs2;
                    Iterator it2;
                    int fInfo = 0;
                    int bInfo = 0;
                    if (cond instanceof EqExpr) {
                        bInfo = toGenInfo;
                        if (toGenInfo == 1) {
                            fInfo = 2;
                        }
                    } else if (cond instanceof NeExpr) {
                        fInfo = toGenInfo;
                        if (toGenInfo == 1) {
                            bInfo = 2;
                        }
                    } else {
                        throw new RuntimeException("invalid condition");
                    }
                    if (fInfo != 0) {
                        it2 = outFallValue.iterator();
                        while (it2.hasNext()) {
                            fs2 = (FlowSet)it2.next();
                            this.copy(out, fs2);
                            this.uAddInfoToFlowSet(toGen, fInfo, fs2);
                        }
                    }
                    if (bInfo != 0) {
                        it2 = outBranchValues.iterator();
                        while (it2.hasNext()) {
                            fs2 = (FlowSet)it2.next();
                            this.copy(out, fs2);
                            this.uAddInfoToFlowSet(toGen, bInfo, fs2);
                        }
                    }
                }
            }
        }
    }

    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet inSet1Copy = (FlowSet)inSet1.clone();
        FlowSet inSet2Copy = (FlowSet)inSet2.clone();
        FlowSet outSet = (FlowSet)out;
        inSet1.intersection(inSet2, outSet);
        Iterator it = this.refTypeValues.iterator();
        while (it.hasNext()) {
            int refInfoIn2;
            EquivalentValue r = (EquivalentValue)it.next();
            int refInfoIn1 = this.refInfo(r, inSet1Copy);
            if (refInfoIn1 == (refInfoIn2 = this.refInfo(r, inSet2Copy))) continue;
            if (refInfoIn1 == 99 || refInfoIn2 == 99) {
                this.uAddTopToFlowSet(r, outSet);
                continue;
            }
            if (refInfoIn1 == 0) {
                this.uAddInfoToFlowSet(r, refInfoIn2, outSet);
                continue;
            }
            if (refInfoIn2 == 0) {
                this.uAddInfoToFlowSet(r, refInfoIn1, outSet);
                continue;
            }
            this.uAddTopToFlowSet(r, outSet);
        }
    }

    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }

    protected Object newInitialFlow() {
        return this.emptySet.clone();
    }

    protected Object entryInitialFlow() {
        return this.fullSet.clone();
    }

    public boolean treatTrapHandlersAsEntries() {
        return true;
    }
}

