/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.arraycheck;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.ArrayType;
import soot.Body;
import soot.G;
import soot.Local;
import soot.PatchingChain;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.internal.JArrayRef;
import soot.jimple.internal.JNewMultiArrayExpr;
import soot.jimple.toolkits.annotation.arraycheck.ArrayReferenceNode;
import soot.jimple.toolkits.annotation.arraycheck.BoolValue;
import soot.jimple.toolkits.annotation.arraycheck.ExtendedHashMutableDirectedGraph;
import soot.jimple.toolkits.annotation.arraycheck.MethodLocal;
import soot.jimple.toolkits.annotation.arraycheck.MethodParameter;
import soot.jimple.toolkits.annotation.arraycheck.MethodReturn;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Targets;
import soot.options.Options;
import soot.util.Chain;

public class RectangularArrayFinder
extends SceneTransformer {
    private ExtendedHashMutableDirectedGraph agraph = new ExtendedHashMutableDirectedGraph();
    private Set falseSet = new HashSet();
    private Set trueSet = new HashSet();
    private CallGraph cg;

    public RectangularArrayFinder(Singletons.Global g) {
    }

    public static RectangularArrayFinder v() {
        return G.v().RectangularArrayFinder();
    }

    protected void internalTransform(String phaseName, Map opts) {
        List startNodes;
        ArrayList changedNodeList;
        Scene sc = Scene.v();
        this.cg = sc.getCallGraph();
        Date start = new Date();
        if (Options.v().verbose()) {
            G.v().out.println("[ra] Finding rectangular arrays, start on " + start);
        }
        Chain appClasses = sc.getApplicationClasses();
        Iterator classIt = appClasses.iterator();
        while (classIt.hasNext()) {
            SootClass c = (SootClass)classIt.next();
            Iterator methodIt = c.methodIterator();
            while (methodIt.hasNext()) {
                SootMethod method = (SootMethod)methodIt.next();
                if (!method.isConcrete() || !sc.getReachableMethods().contains(method)) continue;
                this.recoverRectArray(method);
                this.addInfoFromMethod(method);
            }
        }
        if (this.agraph.containsNode(BoolValue.v(false))) {
            changedNodeList = new ArrayList();
            startNodes = this.agraph.getSuccsOf(BoolValue.v(false));
            this.falseSet.addAll(startNodes);
            changedNodeList.addAll(startNodes);
            while (!changedNodeList.isEmpty()) {
                Object node = changedNodeList.remove(0);
                List succs = this.agraph.getSuccsOf(node);
                Iterator succsIt = succs.iterator();
                while (succsIt.hasNext()) {
                    Object succ = succsIt.next();
                    if (this.falseSet.contains(succ)) continue;
                    this.falseSet.add(succ);
                    changedNodeList.add(succ);
                }
            }
        }
        if (this.agraph.containsNode(BoolValue.v(true))) {
            Object node;
            changedNodeList = new ArrayList();
            startNodes = this.agraph.getSuccsOf(BoolValue.v(true));
            Iterator nodesIt = startNodes.iterator();
            while (nodesIt.hasNext()) {
                node = nodesIt.next();
                if (this.falseSet.contains(node)) continue;
                changedNodeList.add(node);
                this.trueSet.add(node);
            }
            while (!changedNodeList.isEmpty()) {
                node = changedNodeList.remove(0);
                List succs = this.agraph.getSuccsOf(node);
                Iterator succsIt = succs.iterator();
                while (succsIt.hasNext()) {
                    Object succ = succsIt.next();
                    if (this.falseSet.contains(succ) || this.trueSet.contains(succ)) continue;
                    this.trueSet.add(succ);
                    changedNodeList.add(succ);
                }
            }
        }
        if (Options.v().debug()) {
            Object node;
            G.v().out.println("Rectangular Array :");
            Iterator nodeIt = this.trueSet.iterator();
            while (nodeIt.hasNext()) {
                node = nodeIt.next();
                G.v().out.println(node);
            }
            G.v().out.println("\nNon-rectangular Array :");
            nodeIt = this.falseSet.iterator();
            while (nodeIt.hasNext()) {
                node = nodeIt.next();
                G.v().out.println(node);
            }
        }
        Date finish = new Date();
        if (Options.v().verbose()) {
            long runtime = finish.getTime() - start.getTime();
            long mins = runtime / 60000L;
            long secs = runtime % 60000L / 1000L;
            G.v().out.println("[ra] Rectangular array finder finishes. It took " + mins + " mins and " + secs + " secs.");
        }
    }

    private void addInfoFromMethod(SootMethod method) {
        if (Options.v().verbose()) {
            G.v().out.println("[ra] Operating " + method.getSignature());
        }
        boolean needTransfer = true;
        Body body = method.getActiveBody();
        HashSet<Object> tmpNode = new HashSet<Object>();
        boolean trackReturn = false;
        Type rtnType = method.getReturnType();
        if (rtnType instanceof ArrayType && ((ArrayType)rtnType).numDimensions > 1) {
            trackReturn = true;
            needTransfer = true;
        }
        HashSet<Local> arrayLocal = new HashSet<Local>();
        Chain locals = body.getLocals();
        Iterator localIt = locals.iterator();
        while (localIt.hasNext()) {
            Local local = (Local)localIt.next();
            Type type = local.getType();
            if (!(type instanceof ArrayType)) continue;
            if (((ArrayType)type).numDimensions > 1) {
                arrayLocal.add(local);
                continue;
            }
            tmpNode.add(new MethodLocal(method, local));
        }
        ExtendedHashMutableDirectedGraph ehmdg = new ExtendedHashMutableDirectedGraph();
        Iterator unitIt = body.getUnits().snapshotIterator();
        while (unitIt.hasNext()) {
            Type ltype;
            Type ftype;
            Local base;
            Value op;
            Stmt s = (Stmt)unitIt.next();
            if (s.containsInvokeExpr()) {
                InvokeExpr iexpr = s.getInvokeExpr();
                int argnum = iexpr.getArgCount();
                for (int i = 0; i < argnum; ++i) {
                    Value arg = iexpr.getArg(i);
                    if (!arrayLocal.contains(arg)) continue;
                    needTransfer = true;
                    MethodLocal ml = new MethodLocal(method, (Local)arg);
                    Targets targetIt = new Targets(this.cg.edgesOutOf(s));
                    while (targetIt.hasNext()) {
                        SootMethod target = (SootMethod)targetIt.next();
                        MethodParameter mp = new MethodParameter(target, i);
                        ehmdg.addMutualEdge(ml, mp);
                    }
                }
            }
            if (trackReturn && s instanceof ReturnStmt && (op = ((ReturnStmt)s).getOp()) instanceof Local) {
                ehmdg.addMutualEdge(new MethodLocal(method, (Local)op), new MethodReturn(method));
            }
            if (!(s instanceof DefinitionStmt)) continue;
            Value leftOp = ((DefinitionStmt)s).getLeftOp();
            Value rightOp = ((DefinitionStmt)s).getRightOp();
            if (!(leftOp.getType() instanceof ArrayType) && !(rightOp.getType() instanceof ArrayType)) continue;
            Object from = null;
            Object to = null;
            if (leftOp instanceof Local && rightOp instanceof Local) {
                if (arrayLocal.contains(leftOp) && arrayLocal.contains(rightOp)) {
                    int leftDims = ((ArrayType)((Local)leftOp).getType()).numDimensions;
                    int rightDims = ((ArrayType)((Local)rightOp).getType()).numDimensions;
                    to = new MethodLocal(method, (Local)leftOp);
                    from = new MethodLocal(method, (Local)rightOp);
                    ehmdg.addMutualEdge(from, to);
                    if (leftDims == rightDims) continue;
                    ehmdg.addEdge(BoolValue.v(false), from);
                    continue;
                }
                if (arrayLocal.contains(leftOp)) continue;
                ehmdg.addEdge(BoolValue.v(false), new MethodLocal(method, (Local)rightOp));
                continue;
            }
            if (leftOp instanceof Local && rightOp instanceof ParameterRef) {
                if (!arrayLocal.contains(leftOp)) continue;
                to = new MethodLocal(method, (Local)leftOp);
                int index = ((ParameterRef)rightOp).getIndex();
                from = new MethodParameter(method, index);
                ehmdg.addMutualEdge(from, to);
                needTransfer = true;
                continue;
            }
            if (leftOp instanceof Local && rightOp instanceof ArrayRef) {
                base = (Local)((ArrayRef)rightOp).getBase();
                if (!arrayLocal.contains(base)) continue;
                to = new ArrayReferenceNode(method, base);
                from = new MethodLocal(method, base);
                ehmdg.addMutualEdge(from, to);
                tmpNode.add(to);
                from = to;
                to = new MethodLocal(method, (Local)leftOp);
                ehmdg.addMutualEdge(from, to);
                continue;
            }
            if (leftOp instanceof ArrayRef && rightOp instanceof Local) {
                base = (Local)((ArrayRef)leftOp).getBase();
                if (!arrayLocal.contains(base)) continue;
                MethodLocal suspect = new MethodLocal(method, (Local)rightOp);
                ArrayReferenceNode arrRef = new ArrayReferenceNode(method, base);
                boolean doNothing = false;
                if (ehmdg.containsNode(suspect)) {
                    Object neighborOne;
                    List succs = ehmdg.getSuccsOf(suspect);
                    List preds = ehmdg.getSuccsOf(suspect);
                    HashSet neighbor = new HashSet();
                    neighbor.addAll(succs);
                    neighbor.addAll(preds);
                    if (neighbor.size() == 1 && ((Object)arrRef).equals(neighborOne = neighbor.toArray()[0])) {
                        doNothing = true;
                    }
                }
                if (doNothing) continue;
                ehmdg.addEdge(BoolValue.v(false), new MethodLocal(method, base));
                continue;
            }
            if (leftOp instanceof Local && rightOp instanceof InvokeExpr) {
                if (!arrayLocal.contains(leftOp)) continue;
                to = new MethodLocal(method, (Local)leftOp);
                Targets targetIt = new Targets(this.cg.edgesOutOf(s));
                while (targetIt.hasNext()) {
                    SootMethod target = (SootMethod)targetIt.next();
                    ehmdg.addMutualEdge(new MethodReturn(target), to);
                }
                continue;
            }
            if (leftOp instanceof FieldRef && rightOp instanceof Local) {
                if (!arrayLocal.contains(rightOp)) continue;
                ftype = ((FieldRef)leftOp).getType();
                ltype = ((Local)rightOp).getType();
                to = ((FieldRef)leftOp).getField();
                from = new MethodLocal(method, (Local)rightOp);
                ehmdg.addMutualEdge(from, to);
                if (!ftype.equals(ltype)) {
                    ehmdg.addEdge(BoolValue.v(false), to);
                }
                needTransfer = true;
                continue;
            }
            if (leftOp instanceof Local && rightOp instanceof FieldRef) {
                if (!arrayLocal.contains(leftOp)) continue;
                ftype = ((FieldRef)rightOp).getType();
                ltype = ((Local)leftOp).getType();
                to = new MethodLocal(method, (Local)leftOp);
                from = ((FieldRef)rightOp).getField();
                ehmdg.addMutualEdge(from, to);
                if (!ftype.equals(ltype)) {
                    ehmdg.addEdge(BoolValue.v(false), to);
                }
                needTransfer = true;
                continue;
            }
            if (leftOp instanceof Local && (rightOp instanceof NewArrayExpr || rightOp instanceof NewMultiArrayExpr)) {
                if (!arrayLocal.contains(leftOp)) continue;
                ehmdg.addEdge(BoolValue.v(true), new MethodLocal(method, (Local)leftOp));
                continue;
            }
            if (!(leftOp instanceof Local) || !(rightOp instanceof CastExpr)) continue;
            Local rOp = (Local)((CastExpr)rightOp).getOp();
            to = new MethodLocal(method, (Local)leftOp);
            from = new MethodLocal(method, rOp);
            if (arrayLocal.contains(leftOp) && arrayLocal.contains(rOp)) {
                ArrayType lat = (ArrayType)leftOp.getType();
                ArrayType rat = (ArrayType)rOp.getType();
                if (lat.numDimensions == rat.numDimensions) {
                    ehmdg.addMutualEdge(from, to);
                    continue;
                }
                ehmdg.addEdge(BoolValue.v(false), from);
                ehmdg.addEdge(BoolValue.v(false), to);
                continue;
            }
            if (arrayLocal.contains(leftOp)) {
                ehmdg.addEdge(BoolValue.v(false), to);
                continue;
            }
            if (!arrayLocal.contains(rOp)) continue;
            ehmdg.addEdge(BoolValue.v(false), from);
        }
        if (needTransfer) {
            Iterator tmpNodeIt = tmpNode.iterator();
            while (tmpNodeIt.hasNext()) {
                ehmdg.skipNode(tmpNodeIt.next());
            }
            this.agraph.mergeWith(ehmdg);
        }
    }

    private void recoverRectArray(SootMethod method) {
        Body body = method.getActiveBody();
        HashSet<Local> malocal = new HashSet<Local>();
        Chain locals = body.getLocals();
        Iterator localsIt = locals.iterator();
        while (localsIt.hasNext()) {
            Local local = (Local)localsIt.next();
            Type type = local.getType();
            if (!(type instanceof ArrayType) || ((ArrayType)type).numDimensions != 2) continue;
            malocal.add(local);
        }
        if (malocal.size() == 0) {
            return;
        }
        PatchingChain units = body.getUnits();
        Stmt stmt = (Stmt)units.getFirst();
        while (stmt != null && stmt.fallsThrough()) {
            if (stmt instanceof AssignStmt) {
                Value leftOp = ((AssignStmt)stmt).getLeftOp();
                Value rightOp = ((AssignStmt)stmt).getRightOp();
                if (malocal.contains(leftOp) && rightOp instanceof NewArrayExpr) {
                    int firstdim;
                    Local local = (Local)leftOp;
                    NewArrayExpr naexpr = (NewArrayExpr)rightOp;
                    Value size = naexpr.getSize();
                    if (size instanceof IntConstant && (firstdim = ((IntConstant)size).value) <= 100) {
                        ArrayType localtype = (ArrayType)local.getType();
                        Type basetype = localtype.baseType;
                        Local[] tmplocals = new Local[firstdim];
                        int seconddim = this.lookforPattern(units, stmt, firstdim, local, basetype, tmplocals);
                        if (seconddim >= 0) {
                            this.transferPattern(units, stmt, firstdim, seconddim, local, basetype, tmplocals);
                        }
                    }
                }
            }
            stmt = (Stmt)units.getSuccOf(stmt);
        }
    }

    private int lookforPattern(Chain units, Stmt startpoint, int firstdim, Local local, Type basetype, Local[] tmplocals) {
        int seconddim = -1;
        int curdim = 0;
        Value curtmp = local;
        Stmt curstmt = startpoint;
        int fault = 99;
        int state = 1;
        block6: while ((curstmt = (Stmt)units.getSuccOf(curstmt)) != null) {
            if (!(curstmt instanceof AssignStmt)) {
                return -1;
            }
            Value leftOp = ((AssignStmt)curstmt).getLeftOp();
            Value rightOp = ((AssignStmt)curstmt).getRightOp();
            switch (state) {
                case 0: {
                    break;
                }
                case 1: {
                    state = fault;
                    if (!(rightOp instanceof NewArrayExpr)) continue block6;
                    NewArrayExpr naexpr = (NewArrayExpr)rightOp;
                    Type type = naexpr.getBaseType();
                    Value size = naexpr.getSize();
                    if (!type.equals(basetype) || !(size instanceof IntConstant)) continue block6;
                    if (curdim == 0) {
                        seconddim = ((IntConstant)size).value;
                    } else if (((IntConstant)size).value != seconddim) continue block6;
                    curtmp = leftOp;
                    state = 2;
                    break;
                }
                case 2: {
                    state = fault;
                    if (!(leftOp instanceof ArrayRef)) continue block6;
                    Value base = ((ArrayRef)leftOp).getBase();
                    Value idx = ((ArrayRef)leftOp).getIndex();
                    if (base.equals(curtmp)) {
                        state = 2;
                        break;
                    }
                    if (!base.equals(local)) continue block6;
                    if (!(idx instanceof IntConstant) || curdim != ((IntConstant)idx).value || !rightOp.equals(curtmp)) continue block6;
                    tmplocals[curdim] = curtmp;
                    if (++curdim >= firstdim) {
                        state = 3;
                        break;
                    }
                    state = 1;
                    break;
                }
                case 3: {
                    return seconddim;
                }
                default: {
                    return -1;
                }
            }
        }
        return -1;
    }

    private void transferPattern(Chain units, Stmt startpoint, int firstdim, int seconddim, Local local, Type basetype, Local[] tmplocals) {
        ArrayType atype = (ArrayType)local.getType();
        ArrayList<IntConstant> sizes = new ArrayList<IntConstant>(2);
        sizes.add(IntConstant.v(firstdim));
        sizes.add(IntConstant.v(seconddim));
        JNewMultiArrayExpr nmexpr = new JNewMultiArrayExpr(atype, sizes);
        ((AssignStmt)startpoint).setRightOp(nmexpr);
        boolean pos = false;
        int curdim = 0;
        Local tmpcur = local;
        Stmt curstmt = (Stmt)units.getSuccOf(startpoint);
        while (curdim < firstdim) {
            Value leftOp = ((AssignStmt)curstmt).getLeftOp();
            Value rightOp = ((AssignStmt)curstmt).getRightOp();
            if (tmplocals[curdim].equals(leftOp) && rightOp instanceof NewArrayExpr) {
                JArrayRef arexpr = new JArrayRef(local, IntConstant.v(curdim));
                ((AssignStmt)curstmt).setRightOp(arexpr);
                tmpcur = (Local)leftOp;
                continue;
            }
            if (leftOp instanceof ArrayRef && rightOp.equals(tmpcur)) {
                Stmt tmpstmt = curstmt;
                curstmt = (Stmt)units.getSuccOf(curstmt);
                units.remove(tmpstmt);
                ++curdim;
                continue;
            }
            curstmt = (Stmt)units.getSuccOf(curstmt);
        }
    }

    public boolean isRectangular(Object obj) {
        return this.trueSet.contains(obj);
    }
}

