/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import soot.G;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.OnFlyCallGraph;
import soot.jimple.spark.solver.Propagator;
import soot.jimple.spark.solver.TopoSorter;
import soot.util.queue.QueueReader;

public final class PropWorklist
extends Propagator {
    protected final Set varNodeWorkList = new TreeSet();
    protected PAG pag;
    protected OnFlyCallGraph ofcg;

    public PropWorklist(PAG pag) {
        this.pag = pag;
    }

    public final void propagate() {
        this.ofcg = this.pag.getOnFlyCallGraph();
        new TopoSorter(this.pag, false).sort();
        Iterator it = this.pag.allocSources().iterator();
        while (it.hasNext()) {
            this.handleAllocNode((AllocNode)it.next());
        }
        boolean verbose = this.pag.getOpts().verbose();
        do {
            if (verbose) {
                G.v().out.println("Worklist has " + this.varNodeWorkList.size() + " nodes.");
            }
            while (!this.varNodeWorkList.isEmpty()) {
                VarNode src = (VarNode)this.varNodeWorkList.iterator().next();
                this.varNodeWorkList.remove(src);
                this.handleVarNode(src);
            }
            if (verbose) {
                G.v().out.println("Now handling field references");
            }
            Iterator srcIt = this.pag.storeSources().iterator();
            while (srcIt.hasNext()) {
                final VarNode src = (VarNode)srcIt.next();
                Node[] targets = this.pag.storeLookup(src);
                for (int i = 0; i < targets.length; ++i) {
                    final FieldRefNode target = (FieldRefNode)targets[i];
                    target.getBase().makeP2Set().forall(new P2SetVisitor(){

                        public final void visit(Node n) {
                            AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, target.getField());
                            nDotF.makeP2Set().addAll(src.getP2Set(), null);
                        }
                    });
                }
            }
            HashSet edgesToPropagate = new HashSet();
            Iterator it2 = this.pag.loadSources().iterator();
            while (it2.hasNext()) {
                this.handleFieldRefNode((FieldRefNode)it2.next(), edgesToPropagate);
            }
            HashSet<PointsToSetInternal> nodesToFlush = new HashSet<PointsToSetInternal>();
            Iterator pairIt = edgesToPropagate.iterator();
            while (pairIt.hasNext()) {
                Object[] pair = (Object[])pairIt.next();
                PointsToSetInternal nDotF = (PointsToSetInternal)pair[0];
                PointsToSetInternal newP2Set = nDotF.getNewSet();
                VarNode loadTarget = (VarNode)pair[1];
                if (loadTarget.makeP2Set().addAll(newP2Set, null)) {
                    this.varNodeWorkList.add(loadTarget);
                }
                nodesToFlush.add(nDotF);
            }
            Iterator nDotFIt = nodesToFlush.iterator();
            while (nDotFIt.hasNext()) {
                PointsToSetInternal nDotF = (PointsToSetInternal)nDotFIt.next();
                nDotF.flushNew();
            }
        } while (!this.varNodeWorkList.isEmpty());
    }

    protected final boolean handleAllocNode(AllocNode src) {
        boolean ret = false;
        Node[] targets = this.pag.allocLookup(src);
        for (int i = 0; i < targets.length; ++i) {
            if (!targets[i].makeP2Set().add(src)) continue;
            this.varNodeWorkList.add((VarNode)targets[i]);
            ret = true;
        }
        return ret;
    }

    protected final boolean handleVarNode(VarNode src) {
        Node[] p;
        boolean ret = false;
        if (src.getReplacement() != src) {
            throw new RuntimeException("Got bad node " + src + " with rep " + src.getReplacement());
        }
        final PointsToSetInternal newP2Set = src.getP2Set().getNewSet();
        if (newP2Set.isEmpty()) {
            return false;
        }
        if (this.ofcg != null) {
            Node addedSrc;
            QueueReader addedEdges = this.pag.edgeReader();
            this.ofcg.updatedNode(src);
            this.ofcg.build();
            while ((addedSrc = (Node)addedEdges.next()) != null) {
                VarNode edgeTgt;
                Node edgeSrc;
                Node addedTgt = (Node)addedEdges.next();
                ret = true;
                if (addedSrc instanceof VarNode) {
                    if (!(addedTgt instanceof VarNode)) continue;
                    edgeSrc = (VarNode)addedSrc.getReplacement();
                    edgeTgt = (VarNode)addedTgt.getReplacement();
                    if (!edgeTgt.makeP2Set().addAll(edgeSrc.getP2Set(), null)) continue;
                    this.varNodeWorkList.add(edgeTgt);
                    continue;
                }
                if (!(addedSrc instanceof AllocNode)) continue;
                edgeSrc = (AllocNode)addedSrc;
                edgeTgt = (VarNode)addedTgt.getReplacement();
                if (!edgeTgt.makeP2Set().add(edgeSrc)) continue;
                this.varNodeWorkList.add(edgeTgt);
            }
        }
        Node[] simpleTargets = this.pag.simpleLookup(src);
        for (int i = 0; i < simpleTargets.length; ++i) {
            if (!simpleTargets[i].makeP2Set().addAll(newP2Set, null)) continue;
            this.varNodeWorkList.add((VarNode)simpleTargets[i]);
            ret = true;
        }
        Node[] storeTargets = this.pag.storeLookup(src);
        for (int i = 0; i < storeTargets.length; ++i) {
            FieldRefNode fr = (FieldRefNode)storeTargets[i];
            final SparkField f = fr.getField();
            ret = fr.getBase().getP2Set().forall(new P2SetVisitor(){

                public final void visit(Node n) {
                    AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, f);
                    if (nDotF.makeP2Set().addAll(newP2Set, null)) {
                        this.returnValue = true;
                    }
                }
            }) | ret;
        }
        final HashSet storesToPropagate = new HashSet();
        final HashSet loadsToPropagate = new HashSet();
        Collection fieldRefs = src.getAllFieldRefs();
        Iterator frIt = fieldRefs.iterator();
        while (frIt.hasNext()) {
            Node[] loadTargets;
            FieldRefNode fr = (FieldRefNode)frIt.next();
            final SparkField field = fr.getField();
            final Node[] storeSources = this.pag.storeInvLookup(fr);
            if (storeSources.length > 0) {
                newP2Set.forall(new P2SetVisitor(){

                    public final void visit(Node n) {
                        AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, field);
                        for (int i = 0; i < storeSources.length; ++i) {
                            Node[] pair = new Node[]{storeSources[i], nDotF.getReplacement()};
                            storesToPropagate.add(pair);
                        }
                    }
                });
            }
            if ((loadTargets = this.pag.loadLookup(fr)).length <= 0) continue;
            newP2Set.forall(new P2SetVisitor(){

                public final void visit(Node n) {
                    AllocDotField nDotF = PropWorklist.this.pag.findAllocDotField((AllocNode)n, field);
                    if (nDotF != null) {
                        for (int i = 0; i < loadTargets.length; ++i) {
                            Node[] pair = new Node[]{nDotF.getReplacement(), loadTargets[i]};
                            loadsToPropagate.add(pair);
                        }
                    }
                }
            });
        }
        src.getP2Set().flushNew();
        Iterator pIt = storesToPropagate.iterator();
        while (pIt.hasNext()) {
            p = (Node[])pIt.next();
            VarNode storeSource = (VarNode)p[0];
            AllocDotField nDotF = (AllocDotField)p[1];
            if (!nDotF.makeP2Set().addAll(storeSource.getP2Set(), null)) continue;
            ret = true;
        }
        pIt = loadsToPropagate.iterator();
        while (pIt.hasNext()) {
            p = (Node[])pIt.next();
            AllocDotField nDotF = (AllocDotField)p[0];
            VarNode loadTarget = (VarNode)p[1];
            if (!loadTarget.makeP2Set().addAll(nDotF.getP2Set(), null)) continue;
            this.varNodeWorkList.add(loadTarget);
            ret = true;
        }
        return ret;
    }

    protected final void handleFieldRefNode(FieldRefNode src, final HashSet edgesToPropagate) {
        final Node[] loadTargets = this.pag.loadLookup(src);
        if (loadTargets.length == 0) {
            return;
        }
        final SparkField field = src.getField();
        src.getBase().getP2Set().forall(new P2SetVisitor(){

            public final void visit(Node n) {
                PointsToSetInternal p2Set;
                AllocDotField nDotF = PropWorklist.this.pag.findAllocDotField((AllocNode)n, field);
                if (nDotF != null && !(p2Set = nDotF.getP2Set()).getNewSet().isEmpty()) {
                    for (int i = 0; i < loadTargets.length; ++i) {
                        Object[] pair = new Object[]{p2Set, loadTargets[i]};
                        edgesToPropagate.add(pair);
                    }
                }
            }
        });
    }
}

