/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.sets;

import java.util.HashSet;
import java.util.Set;
import soot.G;
import soot.PointsToSet;
import soot.RefType;
import soot.Type;
import soot.jimple.spark.pag.ClassConstantNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.StringConstantNode;
import soot.jimple.spark.sets.DoublePointsToSet;
import soot.jimple.spark.sets.EmptyPointsToSet;
import soot.jimple.spark.sets.P2SetVisitor;

public abstract class PointsToSetInternal
implements PointsToSet {
    protected Type type;

    public boolean addAll(PointsToSetInternal other, final PointsToSetInternal exclude) {
        if (other instanceof DoublePointsToSet) {
            return this.addAll(other.getNewSet(), exclude) | this.addAll(other.getOldSet(), exclude);
        }
        if (other instanceof EmptyPointsToSet) {
            return false;
        }
        if (exclude instanceof EmptyPointsToSet) {
            return this.addAll(other, null);
        }
        if (!G.v().PointsToSetInternal_warnedAlready) {
            G.v().out.println("Warning: using default implementation of addAll. You should implement a faster specialized implementation.");
            G.v().out.println("this is of type " + this.getClass().getName());
            G.v().out.println("other is of type " + other.getClass().getName());
            if (exclude == null) {
                G.v().out.println("exclude is null");
            } else {
                G.v().out.println("exclude is of type " + exclude.getClass().getName());
            }
            G.v().PointsToSetInternal_warnedAlready = true;
        }
        return other.forall(new P2SetVisitor(){

            public final void visit(Node n) {
                if (exclude == null || !exclude.contains(n)) {
                    this.returnValue = PointsToSetInternal.this.add(n) | this.returnValue;
                }
            }
        });
    }

    public abstract boolean forall(P2SetVisitor var1);

    public abstract boolean add(Node var1);

    public PointsToSetInternal getNewSet() {
        return this;
    }

    public PointsToSetInternal getOldSet() {
        return EmptyPointsToSet.v();
    }

    public void flushNew() {
    }

    public void unFlushNew() {
    }

    public void mergeWith(PointsToSetInternal other) {
        this.addAll(other, null);
    }

    public abstract boolean contains(Node var1);

    public PointsToSetInternal(Type type) {
        this.type = type;
    }

    public boolean hasNonEmptyIntersection(PointsToSet other) {
        final PointsToSetInternal o = (PointsToSetInternal)other;
        return this.forall(new P2SetVisitor(){

            public void visit(Node n) {
                if (o.contains(n)) {
                    this.returnValue = true;
                }
            }
        });
    }

    public Set possibleTypes() {
        final HashSet ret = new HashSet();
        this.forall(new P2SetVisitor(){

            public void visit(Node n) {
                RefType rt;
                Type t = n.getType();
                if (t instanceof RefType && (rt = (RefType)t).getSootClass().isAbstract()) {
                    return;
                }
                ret.add(t);
            }
        });
        return ret;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int size() {
        final int[] ret = new int[1];
        this.forall(new P2SetVisitor(){

            public void visit(Node n) {
                ret[0] = ret[0] + 1;
            }
        });
        return ret[0];
    }

    public String toString() {
        final StringBuffer ret = new StringBuffer();
        this.forall(new P2SetVisitor(){

            public final void visit(Node n) {
                ret.append("" + n + ",");
            }
        });
        return ret.toString();
    }

    public Set possibleStringConstants() {
        final HashSet ret = new HashSet();
        return this.forall(new P2SetVisitor(){

            public final void visit(Node n) {
                if (n instanceof StringConstantNode) {
                    ret.add(((StringConstantNode)n).getString());
                } else {
                    this.returnValue = true;
                }
            }
        }) ? null : ret;
    }

    public Set possibleClassConstants() {
        final HashSet ret = new HashSet();
        return this.forall(new P2SetVisitor(){

            public final void visit(Node n) {
                if (n instanceof ClassConstantNode) {
                    ret.add(((ClassConstantNode)n).getString());
                } else {
                    this.returnValue = true;
                }
            }
        }) ? null : ret;
    }
}

