/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.pag;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.FastHierarchy;
import soot.Local;
import soot.PointsToAnalysis;
import soot.PointsToSet;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.spark.builder.GlobalNodeFactory;
import soot.jimple.spark.builder.MethodNodeFactory;
import soot.jimple.spark.internal.AbstractTypeManager;
import soot.jimple.spark.pag.AbstractMethodPAG;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.ClassConstantNode;
import soot.jimple.spark.pag.ContextVarNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.GlobalVarNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.StringConstantNode;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetFactory;
import soot.jimple.spark.solver.OnFlyCallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.options.AbstractSparkOptions;
import soot.tagkit.LinkTag;
import soot.tagkit.StringTag;
import soot.util.LargeNumberedMap;
import soot.util.Numberer;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public abstract class AbstractPAG
implements PointsToAnalysis {
    ChunkedQueue newAllocNodes = new ChunkedQueue();
    protected ChunkedQueue edgeQueue = new ChunkedQueue();
    private Numberer allocNodeNumberer = new Numberer();
    private Numberer varNodeNumberer = new Numberer();
    private Numberer fieldRefNodeNumberer = new Numberer();
    private Numberer allocDotFieldNodeNumberer = new Numberer();
    protected AbstractSparkOptions opts;
    protected Map simple = new HashMap();
    protected Map load = new HashMap();
    protected Map store = new HashMap();
    protected Map alloc = new HashMap();
    protected Map simpleInv = new HashMap();
    protected Map loadInv = new HashMap();
    protected Map storeInv = new HashMap();
    protected Map allocInv = new HashMap();
    private Map valToLocalVarNode = new HashMap(1000);
    private Map valToGlobalVarNode = new HashMap(1000);
    private Map valToAllocNode = new HashMap(1000);
    private OnFlyCallGraph ofcg;
    private ArrayList dereferences = new ArrayList();
    protected AbstractTypeManager typeManager;
    private LargeNumberedMap localToNodeMap = new LargeNumberedMap(Scene.v().getLocalNumberer());
    public int maxFinishNumber = 0;
    private Map nodeToTag;
    private GlobalNodeFactory nodeFactory = new GlobalNodeFactory(this);

    public AbstractPAG(AbstractSparkOptions opts) {
        this.opts = opts;
        if (opts.add_tags()) {
            this.nodeToTag = new HashMap();
        }
    }

    public PointsToSet reachingObjects(Local l, SootField f) {
        return this.reachingObjects(this.reachingObjects(l), f);
    }

    private void addNodeTag(Node node, SootMethod m) {
        if (this.nodeToTag != null) {
            StringTag tag = m == null ? new StringTag(node.toString()) : new LinkTag(node.toString(), m, m.getDeclaringClass().getName());
            this.nodeToTag.put(node, tag);
        }
    }

    public AllocNode makeAllocNode(Object newExpr, Type type, SootMethod m) {
        AllocNode ret;
        if (this.opts.types_for_sites() || this.opts.vta()) {
            newExpr = type;
        }
        if ((ret = (AllocNode)this.valToAllocNode.get(newExpr)) == null) {
            ret = new AllocNode(this, newExpr, type, m);
            this.valToAllocNode.put(newExpr, ret);
            this.newAllocNodes.add(ret);
            this.addNodeTag(ret, m);
        } else if (!ret.getType().equals(type)) {
            throw new RuntimeException("NewExpr " + newExpr + " of type " + type + " previously had type " + ret.getType());
        }
        return ret;
    }

    public AllocNode makeStringConstantNode(String s) {
        if (this.opts.types_for_sites() || this.opts.vta()) {
            return this.makeAllocNode(RefType.v("java.lang.String"), RefType.v("java.lang.String"), null);
        }
        StringConstantNode ret = (StringConstantNode)this.valToAllocNode.get(s);
        if (ret == null) {
            ret = new StringConstantNode(this, s);
            this.valToAllocNode.put(s, ret);
            this.newAllocNodes.add(ret);
            this.addNodeTag(ret, null);
        }
        return ret;
    }

    public AllocNode makeClassConstantNode(String s) {
        if (this.opts.types_for_sites() || this.opts.vta()) {
            return this.makeAllocNode(RefType.v("java.lang.Class"), RefType.v("java.lang.Class"), null);
        }
        ClassConstantNode ret = (ClassConstantNode)this.valToAllocNode.get("$$" + s);
        if (ret == null) {
            ret = new ClassConstantNode(this, s);
            this.valToAllocNode.put("$$" + s, ret);
            this.newAllocNodes.add(ret);
            this.addNodeTag(ret, null);
        }
        return ret;
    }

    public QueueReader allocNodeListener() {
        return this.newAllocNodes.reader();
    }

    public GlobalVarNode findGlobalVarNode(Object value) {
        if (this.opts.rta()) {
            value = null;
        }
        return (GlobalVarNode)this.valToGlobalVarNode.get(value);
    }

    public LocalVarNode findLocalVarNode(Object value) {
        if (this.opts.rta()) {
            value = null;
        } else if (value instanceof Local) {
            return (LocalVarNode)this.localToNodeMap.get((Local)value);
        }
        return (LocalVarNode)this.valToLocalVarNode.get(value);
    }

    public GlobalVarNode makeGlobalVarNode(Object value, Type type) {
        GlobalVarNode ret;
        if (this.opts.rta()) {
            value = null;
            type = RefType.v("java.lang.Object");
        }
        if ((ret = (GlobalVarNode)this.valToGlobalVarNode.get(value)) == null) {
            ret = new GlobalVarNode(this, value, type);
            this.valToGlobalVarNode.put(value, ret);
            this.addNodeTag(ret, null);
        } else if (!ret.getType().equals(type)) {
            throw new RuntimeException("Value " + value + " of type " + type + " previously had type " + ret.getType());
        }
        return ret;
    }

    public LocalVarNode makeLocalVarNode(Object value, Type type, SootMethod method) {
        if (this.opts.rta()) {
            value = null;
            type = RefType.v("java.lang.Object");
            method = null;
        } else if (value instanceof Local) {
            LocalVarNode ret;
            Local val = (Local)value;
            if (val.getNumber() == 0) {
                Scene.v().getLocalNumberer().add(val);
            }
            if ((ret = (LocalVarNode)this.localToNodeMap.get(val)) == null) {
                ret = new LocalVarNode(this, value, type, method);
                this.localToNodeMap.put((Local)value, ret);
                this.addNodeTag(ret, method);
            } else if (!ret.getType().equals(type)) {
                throw new RuntimeException("Value " + value + " of type " + type + " previously had type " + ret.getType());
            }
            return ret;
        }
        LocalVarNode ret = (LocalVarNode)this.valToLocalVarNode.get(value);
        if (ret == null) {
            ret = new LocalVarNode(this, value, type, method);
            this.valToLocalVarNode.put(value, ret);
            this.addNodeTag(ret, method);
        } else if (!ret.getType().equals(type)) {
            throw new RuntimeException("Value " + value + " of type " + type + " previously had type " + ret.getType());
        }
        return ret;
    }

    public ContextVarNode findContextVarNode(Object baseValue, Object context) {
        LocalVarNode base = this.findLocalVarNode(baseValue);
        if (base == null) {
            return null;
        }
        return base.context(context);
    }

    public ContextVarNode makeContextVarNode(Object baseValue, Type baseType, Object context, SootMethod method) {
        LocalVarNode base = this.makeLocalVarNode(baseValue, baseType, method);
        return this.makeContextVarNode(base, context);
    }

    public ContextVarNode makeContextVarNode(LocalVarNode base, Object context) {
        ContextVarNode ret = base.context(context);
        if (ret == null) {
            ret = new ContextVarNode(this, base, context);
            this.addNodeTag(ret, base.getMethod());
        }
        return ret;
    }

    public FieldRefNode findLocalFieldRefNode(Object baseValue, SparkField field) {
        LocalVarNode base = this.findLocalVarNode(baseValue);
        if (base == null) {
            return null;
        }
        return base.dot(field);
    }

    public FieldRefNode findGlobalFieldRefNode(Object baseValue, SparkField field) {
        GlobalVarNode base = this.findGlobalVarNode(baseValue);
        if (base == null) {
            return null;
        }
        return base.dot(field);
    }

    public FieldRefNode makeLocalFieldRefNode(Object baseValue, Type baseType, SparkField field, SootMethod method) {
        LocalVarNode base = this.makeLocalVarNode(baseValue, baseType, method);
        return this.makeFieldRefNode(base, field);
    }

    public FieldRefNode makeGlobalFieldRefNode(Object baseValue, Type baseType, SparkField field) {
        GlobalVarNode base = this.makeGlobalVarNode(baseValue, baseType);
        return this.makeFieldRefNode(base, field);
    }

    public FieldRefNode makeFieldRefNode(VarNode base, SparkField field) {
        FieldRefNode ret = base.dot(field);
        if (ret == null) {
            ret = new FieldRefNode(this, base, field);
            if (base instanceof LocalVarNode) {
                this.addNodeTag(ret, ((LocalVarNode)base).getMethod());
            } else {
                this.addNodeTag(ret, null);
            }
        }
        return ret;
    }

    public AllocDotField findAllocDotField(AllocNode an, SparkField field) {
        return an.dot(field);
    }

    public AllocDotField makeAllocDotField(AllocNode an, SparkField field) {
        AllocDotField ret = an.dot(field);
        if (ret == null) {
            ret = new AllocDotField(this, an, field);
        }
        return ret;
    }

    public abstract boolean doAddSimpleEdge(VarNode var1, VarNode var2);

    public boolean addSimpleEdge(VarNode from, VarNode to) {
        boolean ret = false;
        if (this.doAddSimpleEdge(from, to)) {
            this.edgeQueue.add(from);
            this.edgeQueue.add(to);
            ret = true;
        }
        if (this.opts.simple_edges_bidirectional() && this.doAddSimpleEdge(to, from)) {
            this.edgeQueue.add(to);
            this.edgeQueue.add(from);
            ret = true;
        }
        return ret;
    }

    public abstract boolean doAddStoreEdge(VarNode var1, FieldRefNode var2);

    public boolean addStoreEdge(VarNode from, FieldRefNode to) {
        if (!this.opts.rta() && this.doAddStoreEdge(from, to)) {
            this.edgeQueue.add(from);
            this.edgeQueue.add(to);
            return true;
        }
        return false;
    }

    public abstract boolean doAddLoadEdge(FieldRefNode var1, VarNode var2);

    public boolean addLoadEdge(FieldRefNode from, VarNode to) {
        if (!this.opts.rta() && this.doAddLoadEdge(from, to)) {
            this.edgeQueue.add(from);
            this.edgeQueue.add(to);
            return true;
        }
        return false;
    }

    public abstract boolean doAddAllocEdge(AllocNode var1, VarNode var2);

    public boolean addAllocEdge(AllocNode from, VarNode to) {
        FastHierarchy fh = this.typeManager.getFastHierarchy();
        if ((fh == null || to.getType() == null || fh.canStoreType(from.getType(), to.getType())) && this.doAddAllocEdge(from, to)) {
            this.edgeQueue.add(from);
            this.edgeQueue.add(to);
            return true;
        }
        return false;
    }

    public final boolean addEdge(Node from, Node to) {
        from = from.getReplacement();
        to = to.getReplacement();
        if (from instanceof VarNode) {
            if (to instanceof VarNode) {
                return this.addSimpleEdge((VarNode)from, (VarNode)to);
            }
            return this.addStoreEdge((VarNode)from, (FieldRefNode)to);
        }
        if (from instanceof FieldRefNode) {
            return this.addLoadEdge((FieldRefNode)from, (VarNode)to);
        }
        return this.addAllocEdge((AllocNode)from, (VarNode)to);
    }

    public QueueReader edgeReader() {
        return this.edgeQueue.reader();
    }

    public int getNumAllocNodes() {
        return this.allocNodeNumberer.size();
    }

    public AbstractTypeManager getTypeManager() {
        return this.typeManager;
    }

    public void setOnFlyCallGraph(OnFlyCallGraph ofcg) {
        this.ofcg = ofcg;
    }

    public OnFlyCallGraph getOnFlyCallGraph() {
        return this.ofcg;
    }

    public OnFlyCallGraph ofcg() {
        return this.ofcg;
    }

    public void addDereference(VarNode base) {
        this.dereferences.add(base);
    }

    public List getDereferences() {
        return this.dereferences;
    }

    public Map getNodeTags() {
        return this.nodeToTag;
    }

    public P2SetFactory getSetFactory() {
        throw new RuntimeException();
    }

    public abstract Iterator simpleSourcesIterator();

    public abstract Iterator allocSourcesIterator();

    public abstract Iterator storeSourcesIterator();

    public abstract Iterator loadSourcesIterator();

    public abstract Iterator simpleInvSourcesIterator();

    public abstract Iterator allocInvSourcesIterator();

    public abstract Iterator storeInvSourcesIterator();

    public abstract Iterator loadInvSourcesIterator();

    public Numberer getAllocNodeNumberer() {
        return this.allocNodeNumberer;
    }

    public Numberer getVarNodeNumberer() {
        return this.varNodeNumberer;
    }

    public Numberer getFieldRefNodeNumberer() {
        return this.fieldRefNodeNumberer;
    }

    public Numberer getAllocDotFieldNodeNumberer() {
        return this.allocDotFieldNodeNumberer;
    }

    public AbstractSparkOptions getOpts() {
        return this.opts;
    }

    public final void addCallTarget(Edge e) {
        if (!e.passesParameters()) {
            return;
        }
        AbstractMethodPAG srcmpag = AbstractMethodPAG.v(this, e.src());
        AbstractMethodPAG tgtmpag = AbstractMethodPAG.v(this, e.tgt());
        if (e.isExplicit() || e.kind() == 6) {
            this.addCallTarget(srcmpag, tgtmpag, (Stmt)e.srcUnit(), e.srcCtxt(), e.tgtCtxt());
        } else {
            switch (e.kind()) {
                case 9: {
                    InvokeExpr ie = e.srcStmt().getInvokeExpr();
                    Node parm = srcmpag.nodeFactory().getNode(ie.getArg(0));
                    parm = srcmpag.parameterize(parm, e.srcCtxt());
                    parm = parm.getReplacement();
                    Node thiz = tgtmpag.nodeFactory().caseThis();
                    thiz = tgtmpag.parameterize(thiz, e.tgtCtxt());
                    thiz = thiz.getReplacement();
                    this.addEdge(parm, thiz);
                    if (!(e.srcUnit() instanceof AssignStmt)) break;
                    AssignStmt as = (AssignStmt)e.srcUnit();
                    Node ret = tgtmpag.nodeFactory().caseRet();
                    ret = tgtmpag.parameterize(ret, e.tgtCtxt());
                    ret = ret.getReplacement();
                    Node lhs = srcmpag.nodeFactory().getNode(as.getLeftOp());
                    lhs = srcmpag.parameterize(lhs, e.srcCtxt());
                    lhs = lhs.getReplacement();
                    this.addEdge(ret, lhs);
                    break;
                }
                case 7: 
                case 8: {
                    Node srcThis = srcmpag.nodeFactory().caseThis();
                    srcThis = srcmpag.parameterize(srcThis, e.srcCtxt());
                    srcThis = srcThis.getReplacement();
                    Node tgtThis = tgtmpag.nodeFactory().caseThis();
                    tgtThis = tgtmpag.parameterize(tgtThis, e.tgtCtxt());
                    tgtThis = tgtThis.getReplacement();
                    this.addEdge(srcThis, tgtThis);
                    break;
                }
                case 10: {
                    Stmt s = (Stmt)e.srcUnit();
                    InstanceInvokeExpr iie = (InstanceInvokeExpr)s.getInvokeExpr();
                    Node cls = srcmpag.nodeFactory().getNode(iie.getBase());
                    cls = srcmpag.parameterize(cls, e.srcCtxt());
                    cls = cls.getReplacement();
                    Node newObject = this.nodeFactory.caseNewInstance((VarNode)cls);
                    Node initThis = tgtmpag.nodeFactory().caseThis();
                    initThis = tgtmpag.parameterize(initThis, e.tgtCtxt());
                    initThis = initThis.getReplacement();
                    this.addEdge(newObject, initThis);
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled edge " + e);
                }
            }
        }
    }

    public final void addCallTarget(AbstractMethodPAG srcmpag, AbstractMethodPAG tgtmpag, Stmt s, Object srcContext, Object tgtContext) {
        Value dest;
        MethodNodeFactory srcnf = srcmpag.nodeFactory();
        MethodNodeFactory tgtnf = tgtmpag.nodeFactory();
        InvokeExpr ie = s.getInvokeExpr();
        int numArgs = ie.getArgCount();
        for (int i = 0; i < numArgs; ++i) {
            Value arg = ie.getArg(i);
            if (!(arg.getType() instanceof RefLikeType) || arg instanceof NullConstant) continue;
            Node argNode = srcnf.getNode(arg);
            argNode = srcmpag.parameterize(argNode, srcContext);
            argNode = argNode.getReplacement();
            Node parm = tgtnf.caseParm(i);
            parm = tgtmpag.parameterize(parm, tgtContext);
            parm = parm.getReplacement();
            this.addEdge(argNode, parm);
        }
        if (ie instanceof InstanceInvokeExpr) {
            InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
            Node baseNode = srcnf.getNode(iie.getBase());
            baseNode = srcmpag.parameterize(baseNode, srcContext);
            baseNode = baseNode.getReplacement();
            Node thisRef = tgtnf.caseThis();
            thisRef = tgtmpag.parameterize(thisRef, tgtContext);
            thisRef = thisRef.getReplacement();
            this.addEdge(baseNode, thisRef);
        }
        if (s instanceof AssignStmt && (dest = ((AssignStmt)s).getLeftOp()).getType() instanceof RefLikeType && !(dest instanceof NullConstant)) {
            Node destNode = srcnf.getNode(dest);
            destNode = srcmpag.parameterize(destNode, srcContext);
            destNode = destNode.getReplacement();
            Node retNode = tgtnf.caseRet();
            retNode = tgtmpag.parameterize(retNode, tgtContext);
            retNode = retNode.getReplacement();
            this.addEdge(retNode, destNode);
        }
    }

    void mergedWith(Node n1, Node n2) {
        throw new RuntimeException();
    }

    protected boolean addToMap(Map m, Node key, Node value) {
        Object valueList = m.get(key);
        if (valueList == null) {
            valueList = new HashSet(4);
            m.put(key, valueList);
        } else if (!(valueList instanceof Set)) {
            Node[] ar = (Node[])valueList;
            HashSet<Node> vl = new HashSet<Node>(ar.length + 4);
            m.put(key, vl);
            for (int i = 0; i < ar.length; ++i) {
                vl.add(ar[i]);
            }
            return vl.add(value);
        }
        return ((Set)valueList).add(value);
    }

    public GlobalNodeFactory nodeFactory() {
        return this.nodeFactory;
    }
}

