/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark;

import java.util.Date;
import java.util.Map;
import soot.G;
import soot.Scene;
import soot.Singletons;
import soot.jimple.spark.AbstractSparkTransformer;
import soot.jimple.spark.builder.ContextInsensitiveBuilder;
import soot.jimple.spark.pag.BDDPAG;
import soot.jimple.spark.solver.BDDPropagator;
import soot.jimple.toolkits.callgraph.CallGraphBuilder;
import soot.options.BDDSparkOptions;
import soot.relations.JBuddyProfiler;

public class BDDSparkTransformer
extends AbstractSparkTransformer {
    public BDDSparkTransformer(Singletons.Global g) {
    }

    public static BDDSparkTransformer v() {
        return G.v().BDDSparkTransformer();
    }

    protected void internalTransform(String phaseName, Map options) {
        BDDSparkOptions opts = new BDDSparkOptions(options);
        ContextInsensitiveBuilder b = new ContextInsensitiveBuilder();
        if (opts.pre_jimplify()) {
            b.preJimplify();
        }
        if (opts.force_gc()) {
            BDDSparkTransformer.doGC();
        }
        Date startBuild = new Date();
        BDDPAG pag = (BDDPAG)b.setup(opts);
        b.build();
        Date endBuild = new Date();
        BDDSparkTransformer.reportTime("Pointer Assignment Graph", startBuild, endBuild);
        if (opts.force_gc()) {
            BDDSparkTransformer.doGC();
        }
        Date startTM = new Date();
        pag.getTypeManager().makeTypeMask();
        Date endTM = new Date();
        BDDSparkTransformer.reportTime("Type masks", startTM, endTM);
        if (opts.force_gc()) {
            BDDSparkTransformer.doGC();
        }
        if (opts.verbose()) {
            G.v().out.println("VarNodes: " + pag.getVarNodeNumberer().size());
            G.v().out.println("FieldRefNodes: " + pag.getFieldRefNodeNumberer().size());
            G.v().out.println("AllocNodes: " + pag.getAllocNodeNumberer().size());
        }
        Date startProp = new Date();
        BDDPropagator propagator = new BDDPropagator(pag);
        propagator.propagate();
        Date endProp = new Date();
        BDDSparkTransformer.reportTime("Propagation", startProp, endProp);
        if (opts.force_gc()) {
            BDDSparkTransformer.doGC();
        }
        if (!opts.on_fly_cg() || opts.vta()) {
            CallGraphBuilder cgb = new CallGraphBuilder(pag);
            cgb.build();
        }
        if (opts.verbose()) {
            G.v().out.println("[Spark] Number of reachable methods: " + Scene.v().getReachableMethods().size());
        }
        if (opts.set_mass()) {
            this.findSetMass(pag, b);
        }
        Scene.v().setPointsToAnalysis(pag);
        if (opts.add_tags()) {
            this.addTags(pag);
        }
        if (opts.verbose()) {
            JBuddyProfiler.v().printInfo();
        }
    }

    private void addTags(BDDPAG pag) {
        throw new RuntimeException("NYI");
    }

    private void findSetMass(BDDPAG pag, ContextInsensitiveBuilder b) {
        throw new RuntimeException("NYI");
    }
}

