/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import soot.G;
import soot.SceneTransformer;
import soot.jimple.spark.pag.AbstractPAG;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.tagkit.Host;
import soot.tagkit.Tag;
import soot.util.Numberer;

public abstract class AbstractSparkTransformer
extends SceneTransformer {
    protected static void reportTime(String desc, Date start, Date end) {
        long time = end.getTime() - start.getTime();
        G.v().out.println("[Spark] " + desc + " in " + time / 1000L + "." + time / 100L % 10L + " seconds.");
    }

    protected static void doGC() {
        System.gc();
        System.gc();
        System.gc();
        System.gc();
        System.gc();
    }

    protected void addTag(Host h, Node n, Map nodeToTag, Tag unknown) {
        if (nodeToTag.containsKey(n)) {
            h.addTag((Tag)nodeToTag.get(n));
        } else {
            h.addTag(unknown);
        }
    }

    protected void findSetMass(AbstractPAG pag) {
        int i;
        int mass = 0;
        int varMass = 0;
        int adfs = 0;
        int scalars = 0;
        Numberer.NumbererIterator vIt = pag.getVarNodeNumberer().iterator();
        while (vIt.hasNext()) {
            VarNode v = (VarNode)vIt.next();
            ++scalars;
            PointsToSetInternal set = v.getP2Set();
            if (set != null) {
                mass += set.size();
            }
            if (set != null) {
                varMass += set.size();
            }
            if (set != null && set.size() <= 0) continue;
        }
        Iterator anIt = pag.allocSourcesIterator();
        while (anIt.hasNext()) {
            AllocNode an = (AllocNode)anIt.next();
            Iterator adfIt = an.getFields().iterator();
            while (adfIt.hasNext()) {
                AllocDotField adf = (AllocDotField)adfIt.next();
                PointsToSetInternal set = adf.getP2Set();
                if (set != null) {
                    mass += set.size();
                }
                if (set == null || set.size() <= 0) continue;
                ++adfs;
            }
        }
        G.v().out.println("Set mass: " + mass);
        G.v().out.println("Variable mass: " + varMass);
        G.v().out.println("Scalars: " + scalars);
        G.v().out.println("adfs: " + adfs);
        int[] deRefCounts = new int[30001];
        Iterator vIt2 = pag.getDereferences().iterator();
        while (vIt2.hasNext()) {
            VarNode v = (VarNode)vIt2.next();
            PointsToSetInternal set = v.getP2Set();
            int size = 0;
            if (set != null) {
                size = set.size();
            }
            int n = size;
            deRefCounts[n] = deRefCounts[n] + 1;
        }
        int total = 0;
        for (i = 0; i < deRefCounts.length; ++i) {
            total += deRefCounts[i];
        }
        G.v().out.println("Dereference counts BEFORE trimming (total = " + total + "):");
        for (i = 0; i < deRefCounts.length; ++i) {
            if (deRefCounts[i] <= 0) continue;
            G.v().out.println("" + i + " " + deRefCounts[i] + " " + (double)deRefCounts[i] * 100.0 / (double)total + "%");
        }
    }
}

