/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.util.HashMap;
import java.util.Set;
import soot.Body;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.SootResolver;
import soot.jimple.parser.BodyExtractorWalker;
import soot.jimple.parser.CstPoolExtractor;
import soot.jimple.parser.SkeletonExtractorWalker;
import soot.jimple.parser.Walker;
import soot.jimple.parser.lexer.Lexer;
import soot.jimple.parser.lexer.LexerException;
import soot.jimple.parser.node.Start;
import soot.jimple.parser.parser.Parser;
import soot.jimple.parser.parser.ParserException;
import soot.util.JimpleInputStream;

public class JimpleAST {
    private Start mTree = null;
    private HashMap methodToParsedBodyMap = null;
    private SootResolver mResolver;

    public JimpleAST(JimpleInputStream aJIS, SootResolver resolver) {
        this.mResolver = resolver;
        Parser p = new Parser(new Lexer(new PushbackReader(new BufferedReader(new InputStreamReader(aJIS)), 1024)));
        try {
            this.mTree = p.parse();
        }
        catch (ParserException e) {
            throw new RuntimeException("Parser exception occurred: " + e);
        }
        catch (LexerException e) {
            throw new RuntimeException("Lexer exception occurred: " + e);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred: " + e);
        }
    }

    public SootClass createSootClass() {
        Walker w = new Walker(this.mResolver);
        this.mTree.apply(w);
        return w.getSootClass();
    }

    public void getSkeleton(SootClass sc) {
        SkeletonExtractorWalker w = new SkeletonExtractorWalker(this.mResolver, sc);
        this.mTree.apply(w);
    }

    public Body getBody(SootMethod m) {
        if (this.methodToParsedBodyMap == null) {
            this.stashBodiesForClass(m.getDeclaringClass());
        }
        return (Body)this.methodToParsedBodyMap.get(m);
    }

    public Set getCstPool() {
        CstPoolExtractor cpe = new CstPoolExtractor(this.mTree);
        return cpe.getCstPool();
    }

    public SootResolver getResolver() {
        return this.mResolver;
    }

    public void setResolver(SootResolver resolver) {
        this.mResolver = resolver;
    }

    private void stashBodiesForClass(SootClass sc) {
        this.methodToParsedBodyMap = new HashMap();
        BodyExtractorWalker w = new BodyExtractorWalker(sc, this.mResolver, this.methodToParsedBodyMap);
        boolean oldPhantomValue = Scene.v().getPhantomRefs();
        Scene.v().setPhantomRefs(true);
        this.mTree.apply(w);
        Scene.v().setPhantomRefs(oldPhantomValue);
    }
}

