/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.Iterator;
import java.util.List;
import soot.SootMethod;
import soot.Unit;
import soot.UnitPrinter;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.SpecialInvokeInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.ExprSwitch;
import soot.jimple.JimpleToBafContext;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.internal.AbstractInstanceInvokeExpr;
import soot.tagkit.Tag;
import soot.util.Switch;

public abstract class AbstractSpecialInvokeExpr
extends AbstractInstanceInvokeExpr
implements SpecialInvokeExpr,
ConvertToBaf {
    protected AbstractSpecialInvokeExpr(ValueBox baseBox, SootMethod method, ValueBox[] argBoxes) {
        this.baseBox = baseBox;
        this.method = method;
        this.argBoxes = argBoxes;
    }

    public boolean equivTo(Object o) {
        if (o instanceof AbstractSpecialInvokeExpr) {
            AbstractSpecialInvokeExpr ie = (AbstractSpecialInvokeExpr)o;
            if (!this.baseBox.getValue().equivTo(ie.baseBox.getValue()) || !this.method.equals(ie.method) || this.argBoxes.length != ie.argBoxes.length) {
                return false;
            }
            for (int i = 0; i < this.argBoxes.length; ++i) {
                if (this.argBoxes[i].getValue().equivTo(ie.argBoxes[i].getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int equivHashCode() {
        return this.baseBox.getValue().equivHashCode() * 101 + this.method.equivHashCode() * 17;
    }

    public abstract Object clone();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("specialinvoke " + this.baseBox.getValue().toString() + "." + this.method.getSignature() + "(");
        for (int i = 0; i < this.argBoxes.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.argBoxes[i].getValue().toString());
        }
        buffer.append(")");
        return buffer.toString();
    }

    public void toString(UnitPrinter up) {
        up.literal("specialinvoke");
        up.literal(" ");
        this.baseBox.toString(up);
        up.literal(".");
        up.method(this.method);
        up.literal("(");
        for (int i = 0; i < this.argBoxes.length; ++i) {
            if (i != 0) {
                up.literal(", ");
            }
            this.argBoxes[i].toString(up);
        }
        up.literal(")");
    }

    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseSpecialInvokeExpr(this);
    }

    public void convertToBaf(JimpleToBafContext context, List out) {
        ((ConvertToBaf)((Object)this.getBase())).convertToBaf(context, out);
        for (int i = 0; i < this.argBoxes.length; ++i) {
            ((ConvertToBaf)((Object)this.argBoxes[i].getValue())).convertToBaf(context, out);
        }
        SpecialInvokeInst u = Baf.v().newSpecialInvokeInst(this.method);
        out.add(u);
        Unit currentUnit = context.getCurrentUnit();
        Iterator it = currentUnit.getTags().iterator();
        while (it.hasNext()) {
            u.addTag((Tag)it.next());
        }
    }
}

