/*
 * Decompiled with CFR 0.152.
 */
package soot.javaToJimple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import polyglot.ast.ArrayAccess;
import polyglot.ast.ArrayInit;
import polyglot.ast.Assert;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Block;
import polyglot.ast.BooleanLit;
import polyglot.ast.Branch;
import polyglot.ast.Call;
import polyglot.ast.Case;
import polyglot.ast.Cast;
import polyglot.ast.Catch;
import polyglot.ast.CharLit;
import polyglot.ast.ClassDecl;
import polyglot.ast.Conditional;
import polyglot.ast.ConstructorCall;
import polyglot.ast.Do;
import polyglot.ast.Empty;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldDecl;
import polyglot.ast.FloatLit;
import polyglot.ast.For;
import polyglot.ast.Formal;
import polyglot.ast.If;
import polyglot.ast.Instanceof;
import polyglot.ast.IntLit;
import polyglot.ast.Labeled;
import polyglot.ast.Lit;
import polyglot.ast.LocalClassDecl;
import polyglot.ast.LocalDecl;
import polyglot.ast.New;
import polyglot.ast.NewArray;
import polyglot.ast.Node;
import polyglot.ast.NullLit;
import polyglot.ast.NumLit;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Receiver;
import polyglot.ast.Return;
import polyglot.ast.Special;
import polyglot.ast.StringLit;
import polyglot.ast.Switch;
import polyglot.ast.SwitchBlock;
import polyglot.ast.Synchronized;
import polyglot.ast.Throw;
import polyglot.ast.Try;
import polyglot.ast.TypeNode;
import polyglot.ast.Unary;
import polyglot.ast.While;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.LocalInstance;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.NullType;
import polyglot.util.IdentityKey;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.Modifier;
import soot.PrimType;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Value;
import soot.VoidType;
import soot.javaToJimple.PolyglotMethodSource;
import soot.javaToJimple.Util;
import soot.javaToJimple.jj.DPosition;
import soot.jimple.AddExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ConditionExpr;
import soot.jimple.Constant;
import soot.jimple.DoubleConstant;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FieldRef;
import soot.jimple.FloatConstant;
import soot.jimple.GeExpr;
import soot.jimple.GotoStmt;
import soot.jimple.GtExpr;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.LtExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.SubExpr;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.VirtualInvokeExpr;

public class JimpleBodyBuilder {
    JimpleBody body;
    ArrayList exceptionTable;
    Stack endControlNoop = new Stack();
    Stack condControlNoop = new Stack();
    HashMap labelBreakMap;
    HashMap labelContinueMap;
    HashMap localsMap = new HashMap();
    Local specialThisLocal;
    Local outerClassParamLocal;
    HashMap realLocalClassNameMap;
    private int tempInt = -1;
    private int tempVoid = -1;
    private int tempBoolean = -1;
    private int tempLong = -1;
    private int tempDouble = -1;
    private int tempFloat = -1;
    private int tempRefLikeType = -1;
    private int tempByte = -1;
    private int tempShort = -1;

    public JimpleBody createJimpleBody(Block block, List formals, SootMethod sootMethod) {
        this.createBody(sootMethod);
        if (!Modifier.isStatic(sootMethod.getModifiers())) {
            RefType type = sootMethod.getDeclaringClass().getType();
            this.specialThisLocal = Jimple.v().newLocal("this", type);
            this.body.getLocals().add(this.specialThisLocal);
            ThisRef thisRef = Jimple.v().newThisRef(type);
            IdentityStmt thisStmt = Jimple.v().newIdentityStmt(this.specialThisLocal, thisRef);
            this.body.getUnits().add(thisStmt);
        }
        int formalsCounter = 0;
        int outerIndex = sootMethod.getDeclaringClass().getName().indexOf("$");
        int classMod = sootMethod.getDeclaringClass().getModifiers();
        if (outerIndex != -1 && sootMethod.getName().equals("<init>") && !Modifier.isStatic(classMod)) {
            String outerClassName = sootMethod.getDeclaringClass().getName().substring(0, outerIndex);
            SootClass outerClass = Scene.v().getSootClass(outerClassName);
            Local outerLocal = this.generateLocal(outerClass.getType());
            ParameterRef paramRef = Jimple.v().newParameterRef(outerClass.getType(), formalsCounter);
            IdentityStmt stmt = Jimple.v().newIdentityStmt(outerLocal, paramRef);
            this.body.getUnits().add(stmt);
            ((PolyglotMethodSource)sootMethod.getSource()).setOuterClassThisInit(outerLocal);
            this.outerClassParamLocal = outerLocal;
            ++formalsCounter;
        }
        if (formals != null) {
            Iterator formalsIt = formals.iterator();
            while (formalsIt.hasNext()) {
                Formal formal = (Formal)formalsIt.next();
                this.createFormal(formal, formalsCounter);
                ++formalsCounter;
            }
        }
        this.createBlock(block);
        if (sootMethod.getName().equals("<clinit>")) {
            this.handleAssert(sootMethod);
            this.handleStaticFieldInits(sootMethod);
            this.handleStaticInitializerBlocks(sootMethod);
        }
        boolean hasReturn = false;
        if (block != null) {
            Iterator it = block.statements().iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (!(next instanceof Return)) continue;
                hasReturn = true;
            }
        }
        Type retType = this.body.getMethod().getReturnType();
        if (!hasReturn && retType instanceof VoidType) {
            ReturnVoidStmt retStmt = Jimple.v().newReturnVoidStmt();
            this.body.getUnits().add(retStmt);
        }
        if (this.exceptionTable != null) {
            Iterator trapsIt = this.exceptionTable.iterator();
            while (trapsIt.hasNext()) {
                this.body.getTraps().add((Trap)trapsIt.next());
            }
        }
        return this.body;
    }

    private void handleAssert(SootMethod sootMethod) {
        if (!((PolyglotMethodSource)sootMethod.getSource()).hasAssert()) {
            return;
        }
        ((PolyglotMethodSource)sootMethod.getSource()).addAssertInits(this.body);
    }

    private void handleFieldInits(SootMethod sootMethod) {
        ArrayList fieldInits = ((PolyglotMethodSource)sootMethod.getSource()).getFieldInits();
        if (fieldInits != null) {
            Iterator fieldInitsIt = fieldInits.iterator();
            while (fieldInitsIt.hasNext()) {
                FieldDecl field = (FieldDecl)fieldInitsIt.next();
                String fieldName = field.name();
                Expr initExpr = field.init();
                SootClass currentClass = this.body.getMethod().getDeclaringClass();
                SootField sootField = currentClass.getField(fieldName, Util.getSootType(field.type().type()));
                Local base = this.specialThisLocal;
                InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef(base, sootField);
                Value sootExpr = initExpr instanceof ArrayInit ? this.getArrayInitLocal((ArrayInit)initExpr, field.type().type()) : this.createExpr(initExpr);
                AssignStmt assign = Jimple.v().newAssignStmt(fieldRef, sootExpr);
                this.body.getUnits().add(assign);
                Util.addLnPosTags(assign, initExpr.position());
                Util.addLnPosTags(assign.getRightOpBox(), initExpr.position());
            }
        }
    }

    private void handleOuterClassThisInit(SootMethod sootMethod) {
        if (Modifier.isStatic(this.body.getMethod().getDeclaringClass().getModifiers())) {
            return;
        }
        Local local = ((PolyglotMethodSource)sootMethod.getSource()).getOuterClassThisInit();
        if (local != null) {
            InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef(this.specialThisLocal, this.body.getMethod().getDeclaringClass().getField("this$0", local.getType()));
            AssignStmt stmt = Jimple.v().newAssignStmt(fieldRef, local);
            this.body.getUnits().add(stmt);
        }
    }

    private void handleStaticFieldInits(SootMethod sootMethod) {
        ArrayList staticFieldInits = ((PolyglotMethodSource)sootMethod.getSource()).getStaticFieldInits();
        if (staticFieldInits != null) {
            Iterator staticFieldInitsIt = staticFieldInits.iterator();
            while (staticFieldInitsIt.hasNext()) {
                FieldDecl field = (FieldDecl)staticFieldInitsIt.next();
                String fieldName = field.name();
                Expr initExpr = field.init();
                SootClass currentClass = this.body.getMethod().getDeclaringClass();
                SootField sootField = currentClass.getField(fieldName, Util.getSootType(field.type().type()));
                StaticFieldRef fieldRef = Jimple.v().newStaticFieldRef(sootField);
                Value sootExpr = initExpr instanceof ArrayInit ? this.getArrayInitLocal((ArrayInit)initExpr, field.type().type()) : this.createExpr(initExpr);
                AssignStmt assign = Jimple.v().newAssignStmt(fieldRef, sootExpr);
                this.body.getUnits().add(assign);
                Util.addLnPosTags(assign, initExpr.position());
            }
        }
    }

    private void handleInitializerBlocks(SootMethod sootMethod) {
        ArrayList initializerBlocks = ((PolyglotMethodSource)sootMethod.getSource()).getInitializerBlocks();
        if (initializerBlocks != null) {
            Iterator initBlocksIt = initializerBlocks.iterator();
            while (initBlocksIt.hasNext()) {
                this.createBlock((Block)initBlocksIt.next());
            }
        }
    }

    private void handleStaticInitializerBlocks(SootMethod sootMethod) {
        ArrayList staticInitializerBlocks = ((PolyglotMethodSource)sootMethod.getSource()).getStaticInitializerBlocks();
        if (staticInitializerBlocks != null) {
            Iterator staticInitBlocksIt = staticInitializerBlocks.iterator();
            while (staticInitBlocksIt.hasNext()) {
                this.createBlock((Block)staticInitBlocksIt.next());
            }
        }
    }

    private void createBody(SootMethod sootMethod) {
        this.body = Jimple.v().newBody(sootMethod);
        sootMethod.setActiveBody(this.body);
    }

    private void createBlock(Block block) {
        if (block == null) {
            return;
        }
        Iterator it = block.statements().iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (next instanceof polyglot.ast.Stmt) {
                this.createStmt((polyglot.ast.Stmt)next);
                continue;
            }
            throw new RuntimeException("Unexpected - Unhandled Node");
        }
    }

    private Local createCatchFormal(Formal formal) {
        Type sootType = Util.getSootType(formal.type().type());
        Local formalLocal = this.createLocal(formal.localInstance());
        CaughtExceptionRef exceptRef = Jimple.v().newCaughtExceptionRef();
        IdentityStmt stmt = Jimple.v().newIdentityStmt(formalLocal, exceptRef);
        this.body.getUnits().add(stmt);
        Util.addLnPosTags(stmt, formal.position());
        Util.addLnPosTags(stmt.getRightOpBox(), formal.position());
        return formalLocal;
    }

    private void createFormal(Formal formal, int counter) {
        Type sootType = Util.getSootType(formal.type().type());
        Local formalLocal = this.createLocal(formal.localInstance());
        ParameterRef paramRef = Jimple.v().newParameterRef(sootType, counter);
        IdentityStmt stmt = Jimple.v().newIdentityStmt(formalLocal, paramRef);
        this.body.getUnits().add(stmt);
        Util.addLnPosTags(stmt.getRightOpBox(), formal.position());
        Util.addLnPosTags(stmt, formal.position());
    }

    private Constant createLiteral(Lit lit) {
        if (lit instanceof IntLit) {
            IntLit intLit = (IntLit)lit;
            long litValue = intLit.value();
            if (intLit.kind() == IntLit.INT) {
                return IntConstant.v((int)litValue);
            }
            return LongConstant.v(litValue);
        }
        if (lit instanceof StringLit) {
            String litValue = ((StringLit)lit).value();
            return StringConstant.v(litValue);
        }
        if (lit instanceof NullLit) {
            return NullConstant.v();
        }
        if (lit instanceof FloatLit) {
            FloatLit floatLit = (FloatLit)lit;
            double litValue = floatLit.value();
            if (floatLit.kind() == FloatLit.DOUBLE) {
                return DoubleConstant.v(floatLit.value());
            }
            return FloatConstant.v((float)floatLit.value());
        }
        if (lit instanceof CharLit) {
            char litValue = ((CharLit)lit).value();
            return IntConstant.v(litValue);
        }
        if (lit instanceof BooleanLit) {
            boolean litValue = ((BooleanLit)lit).value();
            if (litValue) {
                return IntConstant.v(1);
            }
            return IntConstant.v(0);
        }
        throw new RuntimeException("Unknown Literal - Unhandled");
    }

    private Local createLocal(LocalInstance localInst) {
        Type sootType = Util.getSootType(localInst.type());
        String name = localInst.name();
        Local sootLocal = this.createLocal(name, sootType);
        this.localsMap.put(new IdentityKey((Object)localInst), sootLocal);
        return sootLocal;
    }

    private Local createLocal(String name, Type sootType) {
        if (sootType instanceof CharType) {
            sootType = IntType.v();
        }
        Local sootLocal = Jimple.v().newLocal(name, sootType);
        this.body.getLocals().add(sootLocal);
        return sootLocal;
    }

    private Local getLocal(polyglot.ast.Local local) {
        return this.getLocal(local.localInstance());
    }

    private Local getLocal(LocalInstance li) {
        if (this.localsMap.containsKey(new IdentityKey((Object)li))) {
            Local sootLocal = (Local)this.localsMap.get(new IdentityKey((Object)li));
            return sootLocal;
        }
        Local fieldLocal = this.generateLocal(li.type());
        SootField field = this.body.getMethod().getDeclaringClass().getField("val$" + li.name(), Util.getSootType(li.type()));
        InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef(this.specialThisLocal, field);
        AssignStmt assign = Jimple.v().newAssignStmt(fieldLocal, fieldRef);
        this.body.getUnits().add(assign);
        return fieldLocal;
    }

    private void createStmt(polyglot.ast.Stmt stmt) {
        if (stmt instanceof Eval) {
            this.createExpr(((Eval)stmt).expr());
        } else if (stmt instanceof If) {
            this.createIf((If)stmt);
        } else if (stmt instanceof LocalDecl) {
            this.createLocalDecl((LocalDecl)stmt);
        } else if (stmt instanceof Block) {
            this.createBlock((Block)stmt);
        } else if (stmt instanceof While) {
            this.createWhile((While)stmt);
        } else if (stmt instanceof Do) {
            this.createDo((Do)stmt);
        } else if (stmt instanceof For) {
            this.createForLoop((For)stmt);
        } else if (stmt instanceof Switch) {
            this.createSwitch((Switch)stmt);
        } else if (stmt instanceof Return) {
            this.createReturn((Return)stmt);
        } else if (stmt instanceof Branch) {
            this.createBranch((Branch)stmt);
        } else if (stmt instanceof ConstructorCall) {
            this.createConstructorCall((ConstructorCall)stmt);
        } else if (!(stmt instanceof Empty)) {
            if (stmt instanceof Throw) {
                this.createThrow((Throw)stmt);
            } else if (stmt instanceof Try) {
                this.createTry((Try)stmt);
            } else if (stmt instanceof Labeled) {
                this.createLabeled((Labeled)stmt);
            } else if (stmt instanceof Synchronized) {
                this.createSynchronized((Synchronized)stmt);
            } else if (stmt instanceof Assert) {
                this.createAssert((Assert)stmt);
            } else if (stmt instanceof LocalClassDecl) {
                this.createLocalClassDecl((LocalClassDecl)stmt);
            } else {
                System.out.println("Unhandled Stmt: " + stmt.getClass().toString());
                throw new RuntimeException("Unhandled Stmt");
            }
        }
    }

    private boolean needSootIf(Value sootCond) {
        return !(sootCond instanceof IntConstant) || ((IntConstant)sootCond).value != 1;
    }

    private void createIf(If ifExpr) {
        Expr condition = ifExpr.cond();
        Value sootCond = this.createExpr(condition);
        boolean needIf = this.needSootIf(sootCond);
        if (!(sootCond instanceof ConditionExpr)) {
            sootCond = Jimple.v().newEqExpr(sootCond, IntConstant.v(0));
        } else {
            sootCond = this.reverseCondition((ConditionExpr)sootCond);
            sootCond = this.handleDFLCond((ConditionExpr)sootCond);
        }
        NopStmt noop1 = Jimple.v().newNopStmt();
        if (needIf) {
            IfStmt ifStmt = Jimple.v().newIfStmt(sootCond, noop1);
            this.body.getUnits().add(ifStmt);
            Util.addLnPosTags(ifStmt.getConditionBox(), condition.position());
            Util.addLnPosTags(ifStmt, condition.position());
        }
        polyglot.ast.Stmt consequence = ifExpr.consequent();
        this.createStmt(consequence);
        NopStmt noop2 = Jimple.v().newNopStmt();
        GotoStmt goto1 = Jimple.v().newGotoStmt(noop2);
        this.body.getUnits().add(goto1);
        this.body.getUnits().add(noop1);
        polyglot.ast.Stmt alternative = ifExpr.alternative();
        if (alternative != null) {
            this.createStmt(alternative);
        }
        this.body.getUnits().add(noop2);
    }

    private void createWhile(While whileStmt) {
        NopStmt noop1 = Jimple.v().newNopStmt();
        this.endControlNoop.push(Jimple.v().newNopStmt());
        this.condControlNoop.push(Jimple.v().newNopStmt());
        NopStmt noop2 = Jimple.v().newNopStmt();
        GotoStmt goto1 = Jimple.v().newGotoStmt(noop2);
        this.body.getUnits().add(goto1);
        this.body.getUnits().add(noop1);
        this.createStmt(whileStmt.body());
        this.body.getUnits().add(noop2);
        this.body.getUnits().add((Stmt)this.condControlNoop.pop());
        Expr condition = whileStmt.cond();
        Value sootCond = this.createExpr(condition);
        boolean needIf = this.needSootIf(sootCond);
        sootCond = !(sootCond instanceof ConditionExpr) ? Jimple.v().newNeExpr(sootCond, IntConstant.v(0)) : this.handleDFLCond((ConditionExpr)sootCond);
        if (needIf) {
            IfStmt ifStmt = Jimple.v().newIfStmt(sootCond, noop1);
            this.body.getUnits().add(ifStmt);
            Util.addLnPosTags(ifStmt.getConditionBox(), condition.position());
            Util.addLnPosTags(ifStmt, condition.position());
        } else {
            GotoStmt gotoIf = Jimple.v().newGotoStmt(noop1);
            this.body.getUnits().add(gotoIf);
        }
        this.body.getUnits().add((Stmt)this.endControlNoop.pop());
    }

    private void createDo(Do doStmt) {
        NopStmt noop1 = Jimple.v().newNopStmt();
        this.body.getUnits().add(noop1);
        this.endControlNoop.push(Jimple.v().newNopStmt());
        this.condControlNoop.push(Jimple.v().newNopStmt());
        this.createStmt(doStmt.body());
        this.body.getUnits().add((Stmt)this.condControlNoop.pop());
        Expr condition = doStmt.cond();
        Value sootCond = this.createExpr(condition);
        boolean needIf = this.needSootIf(sootCond);
        sootCond = !(sootCond instanceof ConditionExpr) ? Jimple.v().newNeExpr(sootCond, IntConstant.v(0)) : this.handleDFLCond((ConditionExpr)sootCond);
        if (needIf) {
            IfStmt ifStmt = Jimple.v().newIfStmt(sootCond, noop1);
            this.body.getUnits().add(ifStmt);
            Util.addPosTag(ifStmt.getConditionBox(), condition.position());
            Util.addLnPosTags(ifStmt, condition.position());
        } else {
            GotoStmt gotoIf = Jimple.v().newGotoStmt(noop1);
            this.body.getUnits().add(gotoIf);
        }
        this.body.getUnits().add((Stmt)this.endControlNoop.pop());
    }

    private void createForLoop(For forStmt) {
        this.endControlNoop.push(Jimple.v().newNopStmt());
        this.condControlNoop.push(Jimple.v().newNopStmt());
        Iterator initsIt = forStmt.inits().iterator();
        while (initsIt.hasNext()) {
            this.createStmt((polyglot.ast.Stmt)initsIt.next());
        }
        NopStmt noop1 = Jimple.v().newNopStmt();
        NopStmt noop2 = Jimple.v().newNopStmt();
        GotoStmt goto1 = Jimple.v().newGotoStmt(noop2);
        this.body.getUnits().add(goto1);
        this.body.getUnits().add(noop1);
        this.createStmt(forStmt.body());
        this.body.getUnits().add((Stmt)this.condControlNoop.pop());
        Iterator itersIt = forStmt.iters().iterator();
        while (itersIt.hasNext()) {
            this.createStmt((polyglot.ast.Stmt)itersIt.next());
        }
        this.body.getUnits().add(noop2);
        Expr condition = forStmt.cond();
        if (condition != null) {
            Value sootCond = this.createExpr(condition);
            boolean needIf = this.needSootIf(sootCond);
            sootCond = !(sootCond instanceof ConditionExpr) ? Jimple.v().newNeExpr(sootCond, IntConstant.v(0)) : this.handleDFLCond((ConditionExpr)sootCond);
            if (needIf) {
                IfStmt ifStmt = Jimple.v().newIfStmt(sootCond, noop1);
                this.body.getUnits().add(ifStmt);
                Util.addLnPosTags(ifStmt.getConditionBox(), condition.position());
                Util.addLnPosTags(ifStmt, condition.position());
            } else {
                GotoStmt gotoIf = Jimple.v().newGotoStmt(noop1);
                this.body.getUnits().add(gotoIf);
            }
        } else {
            GotoStmt goto2 = Jimple.v().newGotoStmt(noop1);
            this.body.getUnits().add(goto2);
        }
        this.body.getUnits().add((Stmt)this.endControlNoop.pop());
    }

    private void createLocalDecl(LocalDecl localDecl) {
        String name = localDecl.name();
        LocalInstance localInst = localDecl.localInstance();
        Local lhs = this.createLocal(localInst);
        Expr expr = localDecl.init();
        if (expr != null) {
            Value rhs = expr instanceof ArrayInit ? this.getArrayInitLocal((ArrayInit)expr, localInst.type()) : this.createExpr(expr);
            if (rhs instanceof ConditionExpr) {
                rhs = this.handleCondBinExpr((ConditionExpr)rhs);
            }
            AssignStmt stmt = Jimple.v().newAssignStmt(lhs, rhs);
            this.body.getUnits().add(stmt);
            Util.addLineTag(stmt, (Node)localDecl);
            Util.addLnPosTags(stmt, localDecl.position());
            if (localDecl.position() != null && localDecl.position() instanceof DPosition) {
                DPosition dpos = (DPosition)localDecl.position();
                Util.addLnPosTags(stmt.getLeftOpBox(), dpos.line(), dpos.endLine(), dpos.endCol() - name.length(), dpos.endCol());
                if (expr != null) {
                    DPosition epos = (DPosition)expr.position();
                    if (epos != null) {
                        Util.addLnPosTags(stmt, dpos.line(), epos.endLine(), dpos.column(), epos.endCol());
                    }
                } else {
                    Util.addLnPosTags(stmt, dpos.line(), dpos.endLine(), dpos.column(), dpos.endCol());
                }
            }
            if (expr != null) {
                Util.addLnPosTags(stmt.getRightOpBox(), expr.position());
            }
        }
    }

    private void createSwitch(Switch switchStmt) {
        Stmt sootSwitchStmt;
        Expr value = switchStmt.expr();
        Value sootValue = this.createExpr(value);
        NopStmt defaultTarget = null;
        Case[] caseArray = new Case[switchStmt.elements().size()];
        Stmt[] targetsArray = new Stmt[switchStmt.elements().size()];
        ArrayList<NopStmt> targets = new ArrayList<NopStmt>();
        HashMap targetsMap = new HashMap();
        int counter = 0;
        Iterator it = switchStmt.elements().iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof Case)) continue;
            NopStmt noop = Jimple.v().newNopStmt();
            if (!((Case)next).isDefault()) {
                targets.add(noop);
                caseArray[counter] = (Case)next;
                targetsArray[counter] = noop;
                ++counter;
                targetsMap.put(next, noop);
                continue;
            }
            defaultTarget = noop;
        }
        boolean lowIndex = false;
        boolean highIndex = false;
        for (int i = 0; i < counter; ++i) {
            for (int j = i + 1; j < counter; ++j) {
                if (caseArray[j].value() >= caseArray[i].value()) continue;
                Case tempCase = caseArray[i];
                Stmt tempTarget = targetsArray[i];
                caseArray[i] = caseArray[j];
                targetsArray[i] = targetsArray[j];
                caseArray[j] = tempCase;
                targetsArray[j] = tempTarget;
            }
        }
        ArrayList<Stmt> sortedTargets = new ArrayList<Stmt>();
        for (int i = 0; i < counter; ++i) {
            sortedTargets.add(targetsArray[i]);
        }
        boolean hasDefaultTarget = true;
        if (defaultTarget == null) {
            NopStmt noop;
            defaultTarget = noop = Jimple.v().newNopStmt();
            hasDefaultTarget = false;
        }
        if (this.isLookupSwitch(switchStmt)) {
            ArrayList<IntConstant> values = new ArrayList<IntConstant>();
            for (int i = 0; i < counter; ++i) {
                if (caseArray[i].isDefault()) continue;
                values.add(IntConstant.v((int)caseArray[i].value()));
            }
            LookupSwitchStmt lookupStmt = Jimple.v().newLookupSwitchStmt(sootValue, values, sortedTargets, defaultTarget);
            Util.addLnPosTags(lookupStmt.getKeyBox(), value.position());
            sootSwitchStmt = lookupStmt;
        } else {
            long lowVal = 0L;
            long highVal = 0L;
            boolean unknown = true;
            it = switchStmt.elements().iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (!(next instanceof Case) || ((Case)next).isDefault()) continue;
                long temp = ((Case)next).value();
                if (unknown) {
                    highVal = temp;
                    lowVal = temp;
                    unknown = false;
                }
                if (temp > highVal) {
                    highVal = temp;
                }
                if (temp >= lowVal) continue;
                lowVal = temp;
            }
            TableSwitchStmt tableStmt = Jimple.v().newTableSwitchStmt(sootValue, (int)lowVal, (int)highVal, sortedTargets, defaultTarget);
            Util.addLnPosTags(tableStmt.getKeyBox(), value.position());
            sootSwitchStmt = tableStmt;
        }
        this.body.getUnits().add(sootSwitchStmt);
        Util.addLnPosTags(sootSwitchStmt, switchStmt.position());
        this.endControlNoop.push(Jimple.v().newNopStmt());
        it = switchStmt.elements().iterator();
        Iterator targetsIt = targets.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (next instanceof Case) {
                if (!((Case)next).isDefault()) {
                    this.body.getUnits().add((Stmt)targetsMap.get(next));
                    continue;
                }
                this.body.getUnits().add(defaultTarget);
                continue;
            }
            SwitchBlock blockStmt = (SwitchBlock)next;
            this.createBlock((Block)blockStmt);
        }
        if (!hasDefaultTarget) {
            this.body.getUnits().add(defaultTarget);
        }
        this.body.getUnits().add((Stmt)this.endControlNoop.pop());
    }

    private boolean isLookupSwitch(Switch switchStmt) {
        int lowest = 0;
        int highest = 0;
        int counter = 0;
        Iterator it = switchStmt.elements().iterator();
        while (it.hasNext()) {
            Case caseStmt;
            Object next = it.next();
            if (!(next instanceof Case) || (caseStmt = (Case)next).isDefault()) continue;
            int caseValue = (int)caseStmt.value();
            if (caseValue <= lowest || counter == 0) {
                lowest = caseValue;
            }
            if (caseValue >= highest || counter == 0) {
                highest = caseValue;
            }
            ++counter;
        }
        return counter - 1 != highest - lowest;
    }

    private void createBranch(Branch branchStmt) {
        this.body.getUnits().add(Jimple.v().newNopStmt());
        if (branchStmt.kind() == Branch.BREAK) {
            if (branchStmt.label() == null) {
                Stmt gotoEndNoop = (Stmt)this.endControlNoop.pop();
                GotoStmt gotoEnd = Jimple.v().newGotoStmt(gotoEndNoop);
                this.endControlNoop.push(gotoEndNoop);
                this.body.getUnits().add(gotoEnd);
                Util.addLnPosTags(gotoEnd, branchStmt.position());
            } else {
                GotoStmt gotoLabel = Jimple.v().newGotoStmt((Stmt)this.labelBreakMap.get(branchStmt.label()));
                this.body.getUnits().add(gotoLabel);
                Util.addLnPosTags(gotoLabel, branchStmt.position());
            }
        } else if (branchStmt.kind() == Branch.CONTINUE) {
            if (branchStmt.label() == null) {
                Stmt gotoCondNoop = (Stmt)this.condControlNoop.pop();
                GotoStmt gotoCond = Jimple.v().newGotoStmt(gotoCondNoop);
                this.condControlNoop.push(gotoCondNoop);
                this.body.getUnits().add(gotoCond);
                Util.addLnPosTags(gotoCond, branchStmt.position());
            } else {
                GotoStmt gotoLabel = Jimple.v().newGotoStmt((Stmt)this.labelContinueMap.get(branchStmt.label()));
                this.body.getUnits().add(gotoLabel);
                Util.addLnPosTags(gotoLabel, branchStmt.position());
            }
        }
    }

    private void createLabeled(Labeled labeledStmt) {
        String label = labeledStmt.label();
        polyglot.ast.Stmt stmt = labeledStmt.statement();
        NopStmt noop = Jimple.v().newNopStmt();
        this.body.getUnits().add(noop);
        if (this.labelBreakMap == null) {
            this.labelBreakMap = new HashMap();
        }
        if (this.labelContinueMap == null) {
            this.labelContinueMap = new HashMap();
        }
        this.labelContinueMap.put(label, noop);
        NopStmt noop2 = Jimple.v().newNopStmt();
        this.labelBreakMap.put(label, noop2);
        this.createStmt(stmt);
        this.body.getUnits().add(noop2);
    }

    private void createAssert(Assert assertStmt) {
        Local testLocal = this.generateLocal(BooleanType.v());
        SootField assertField = this.body.getMethod().getDeclaringClass().getField("$assertionsDisabled", BooleanType.v());
        StaticFieldRef assertFieldRef = Jimple.v().newStaticFieldRef(assertField);
        AssignStmt fieldAssign = Jimple.v().newAssignStmt(testLocal, assertFieldRef);
        this.body.getUnits().add(fieldAssign);
        NopStmt nop1 = Jimple.v().newNopStmt();
        NeExpr cond1 = Jimple.v().newNeExpr(testLocal, IntConstant.v(0));
        IfStmt testIf = Jimple.v().newIfStmt((Value)cond1, nop1);
        this.body.getUnits().add(testIf);
        Value sootCond = this.createExpr(assertStmt.cond());
        boolean needIf = this.needSootIf(sootCond);
        sootCond = !(sootCond instanceof ConditionExpr) ? Jimple.v().newEqExpr(sootCond, IntConstant.v(0)) : this.handleDFLCond((ConditionExpr)sootCond);
        if (needIf) {
            IfStmt ifStmt = Jimple.v().newIfStmt(sootCond, nop1);
            this.body.getUnits().add(ifStmt);
            Util.addLnPosTags(ifStmt.getConditionBox(), assertStmt.cond().position());
            Util.addLnPosTags(ifStmt, assertStmt.position());
        }
        Local failureLocal = this.generateLocal(RefType.v("java.lang.AssertionError"));
        NewExpr newExpr = Jimple.v().newNewExpr(RefType.v("java.lang.AssertionError"));
        AssignStmt newAssign = Jimple.v().newAssignStmt(failureLocal, newExpr);
        this.body.getUnits().add(newAssign);
        ArrayList<Type> paramTypes = new ArrayList<Type>();
        ArrayList<Value> params = new ArrayList<Value>();
        if (assertStmt.errorMessage() != null) {
            Value errorExpr = this.createExpr(assertStmt.errorMessage());
            Type errorType = errorExpr.getType();
            if (errorType instanceof IntType) {
                paramTypes.add(IntType.v());
            } else if (errorType instanceof LongType) {
                paramTypes.add(LongType.v());
            } else if (errorType instanceof FloatType) {
                paramTypes.add(FloatType.v());
            } else if (errorType instanceof DoubleType) {
                paramTypes.add(DoubleType.v());
            } else if (errorType instanceof CharType) {
                paramTypes.add(CharType.v());
            } else if (errorType instanceof BooleanType) {
                paramTypes.add(BooleanType.v());
            } else if (errorType instanceof ShortType) {
                paramTypes.add(IntType.v());
            } else if (errorType instanceof ByteType) {
                paramTypes.add(IntType.v());
            } else {
                paramTypes.add(RefType.v());
            }
            params.add(errorExpr);
        }
        SootMethod methToInvoke = Scene.v().getSootClass("java.lang.AssertionError").getMethod("<init>", paramTypes, VoidType.v());
        SpecialInvokeExpr invokeExpr = Jimple.v().newSpecialInvokeExpr(failureLocal, methToInvoke, params);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(invokeExpr);
        this.body.getUnits().add(invokeStmt);
        ThrowStmt throwStmt = Jimple.v().newThrowStmt(failureLocal);
        this.body.getUnits().add(throwStmt);
        this.body.getUnits().add(nop1);
    }

    private void createSynchronized(Synchronized synchStmt) {
        Value sootExpr = this.createExpr(synchStmt.expr());
        EnterMonitorStmt enterMon = Jimple.v().newEnterMonitorStmt(sootExpr);
        this.body.getUnits().add(enterMon);
        Util.addLnPosTags(enterMon.getOpBox(), synchStmt.expr().position());
        Util.addLnPosTags(enterMon, synchStmt.expr().position());
        NopStmt startNoop = Jimple.v().newNopStmt();
        this.body.getUnits().add(startNoop);
        this.createBlock(synchStmt.body());
        ExitMonitorStmt exitMon = Jimple.v().newExitMonitorStmt(sootExpr);
        this.body.getUnits().add(exitMon);
        Util.addLnPosTags(exitMon.getOpBox(), synchStmt.expr().position());
        Util.addLnPosTags(exitMon, synchStmt.expr().position());
        NopStmt endSynchNoop = Jimple.v().newNopStmt();
        GotoStmt gotoEnd = Jimple.v().newGotoStmt(endSynchNoop);
        NopStmt endNoop = Jimple.v().newNopStmt();
        this.body.getUnits().add(endNoop);
        this.body.getUnits().add(gotoEnd);
        NopStmt catchAllBeforeNoop = Jimple.v().newNopStmt();
        this.body.getUnits().add(catchAllBeforeNoop);
        Local formalLocal = this.generateLocal(RefType.v("java.lang.Throwable"));
        CaughtExceptionRef exceptRef = Jimple.v().newCaughtExceptionRef();
        IdentityStmt stmt = Jimple.v().newIdentityStmt(formalLocal, exceptRef);
        this.body.getUnits().add(stmt);
        NopStmt catchBeforeNoop = Jimple.v().newNopStmt();
        this.body.getUnits().add(catchBeforeNoop);
        Local local = this.generateLocal(RefType.v("java.lang.Throwable"));
        AssignStmt assign = Jimple.v().newAssignStmt(local, formalLocal);
        this.body.getUnits().add(assign);
        ExitMonitorStmt catchExitMon = Jimple.v().newExitMonitorStmt(sootExpr);
        this.body.getUnits().add(catchExitMon);
        Util.addLnPosTags(catchExitMon.getOpBox(), synchStmt.expr().position());
        NopStmt catchAfterNoop = Jimple.v().newNopStmt();
        this.body.getUnits().add(catchAfterNoop);
        ThrowStmt throwStmt = Jimple.v().newThrowStmt(local);
        this.body.getUnits().add(throwStmt);
        this.body.getUnits().add(endSynchNoop);
        this.addToExceptionList(startNoop, endNoop, catchAllBeforeNoop, Scene.v().getSootClass("java.lang.Throwable"));
        this.addToExceptionList(catchBeforeNoop, catchAfterNoop, catchAllBeforeNoop, Scene.v().getSootClass("java.lang.Throwable"));
    }

    private void createReturn(Return retStmt) {
        Expr expr = retStmt.expr();
        if (expr == null) {
            ReturnVoidStmt retStmtVoid = Jimple.v().newReturnVoidStmt();
            this.body.getUnits().add(retStmtVoid);
            Util.addLnPosTags(retStmtVoid, retStmt.position());
        } else {
            Value sootLocal = this.createExpr(expr);
            if (sootLocal instanceof ConditionExpr) {
                sootLocal = this.handleCondBinExpr((ConditionExpr)sootLocal);
            }
            ReturnStmt retStmtLocal = Jimple.v().newReturnStmt(sootLocal);
            this.body.getUnits().add(retStmtLocal);
            Util.addLnPosTags(retStmtLocal.getOpBox(), expr.position());
            Util.addLnPosTags(retStmtLocal, retStmt.position());
        }
    }

    private void createThrow(Throw throwStmt) {
        Value toThrow = this.createExpr(throwStmt.expr());
        ThrowStmt throwSt = Jimple.v().newThrowStmt(toThrow);
        this.body.getUnits().add(throwSt);
        Util.addLnPosTags(throwSt, throwStmt.position());
        Util.addLnPosTags(throwSt.getOpBox(), throwStmt.expr().position());
    }

    private void createTry(Try tryStmt) {
        Block finallyBlock = tryStmt.finallyBlock();
        if (finallyBlock == null) {
            this.createTryCatch(tryStmt);
        } else {
            this.createTryCatchFinally(tryStmt);
        }
    }

    private void createTryCatch(Try tryStmt) {
        Block tryBlock = tryStmt.tryBlock();
        NopStmt noop1 = Jimple.v().newNopStmt();
        this.body.getUnits().add(noop1);
        this.createBlock(tryBlock);
        NopStmt noop2 = Jimple.v().newNopStmt();
        this.body.getUnits().add(noop2);
        NopStmt endNoop = Jimple.v().newNopStmt();
        GotoStmt tryEndGoto = Jimple.v().newGotoStmt(endNoop);
        this.body.getUnits().add(tryEndGoto);
        Iterator it = tryStmt.catchBlocks().iterator();
        while (it.hasNext()) {
            NopStmt noop3 = Jimple.v().newNopStmt();
            this.body.getUnits().add(noop3);
            Catch catchBlock = (Catch)it.next();
            this.createCatchFormal(catchBlock.formal());
            this.createBlock(catchBlock.body());
            GotoStmt catchEndGoto = Jimple.v().newGotoStmt(endNoop);
            this.body.getUnits().add(catchEndGoto);
            Type sootType = Util.getSootType(catchBlock.catchType());
            this.addToExceptionList(noop1, noop2, noop3, Scene.v().getSootClass(sootType.toString()));
        }
        this.body.getUnits().add(endNoop);
    }

    private void createTryCatchFinally(Try tryStmt) {
        HashMap<NopStmt, NopStmt> gotoMap = new HashMap<NopStmt, NopStmt>();
        Block tryBlock = tryStmt.tryBlock();
        NopStmt noop1 = Jimple.v().newNopStmt();
        this.body.getUnits().add(noop1);
        this.createBlock(tryBlock);
        NopStmt noop2 = Jimple.v().newNopStmt();
        this.body.getUnits().add(noop2);
        NopStmt endNoop = Jimple.v().newNopStmt();
        NopStmt tryGotoFinallyNoop = Jimple.v().newNopStmt();
        this.body.getUnits().add(tryGotoFinallyNoop);
        NopStmt tryFinallyNoop = Jimple.v().newNopStmt();
        GotoStmt tryGotoFinally = Jimple.v().newGotoStmt(tryFinallyNoop);
        this.body.getUnits().add(tryGotoFinally);
        NopStmt beforeEndGotoNoop = Jimple.v().newNopStmt();
        this.body.getUnits().add(beforeEndGotoNoop);
        GotoStmt tryEndGoto = Jimple.v().newGotoStmt(endNoop);
        this.body.getUnits().add(tryEndGoto);
        gotoMap.put(tryFinallyNoop, beforeEndGotoNoop);
        NopStmt catchAllBeforeNoop = Jimple.v().newNopStmt();
        Iterator it = tryStmt.catchBlocks().iterator();
        while (it.hasNext()) {
            NopStmt noop3 = Jimple.v().newNopStmt();
            this.body.getUnits().add(noop3);
            Catch catchBlock = (Catch)it.next();
            NopStmt catchRefNoop = Jimple.v().newNopStmt();
            this.body.getUnits().add(catchRefNoop);
            this.createCatchFormal(catchBlock.formal());
            NopStmt catchStmtsNoop = Jimple.v().newNopStmt();
            this.body.getUnits().add(catchStmtsNoop);
            this.createBlock(catchBlock.body());
            NopStmt catchGotoFinallyNoop = Jimple.v().newNopStmt();
            this.body.getUnits().add(catchGotoFinallyNoop);
            NopStmt catchFinallyNoop = Jimple.v().newNopStmt();
            GotoStmt catchGotoFinally = Jimple.v().newGotoStmt(catchFinallyNoop);
            this.body.getUnits().add(catchGotoFinally);
            NopStmt beforeCatchEndGotoNoop = Jimple.v().newNopStmt();
            this.body.getUnits().add(beforeCatchEndGotoNoop);
            GotoStmt catchEndGoto = Jimple.v().newGotoStmt(endNoop);
            this.body.getUnits().add(catchEndGoto);
            gotoMap.put(catchFinallyNoop, beforeCatchEndGotoNoop);
            Type sootType = Util.getSootType(catchBlock.catchType());
            this.addToExceptionList(noop1, noop2, noop3, Scene.v().getSootClass(sootType.toString()));
            this.addToExceptionList(catchStmtsNoop, beforeCatchEndGotoNoop, catchAllBeforeNoop, Scene.v().getSootClass("java.lang.Throwable"));
        }
        Local formalLocal = this.generateLocal(RefType.v("java.lang.Throwable"));
        this.body.getUnits().add(catchAllBeforeNoop);
        CaughtExceptionRef exceptRef = Jimple.v().newCaughtExceptionRef();
        IdentityStmt stmt = Jimple.v().newIdentityStmt(formalLocal, exceptRef);
        this.body.getUnits().add(stmt);
        NopStmt beforeCatchAllAssignNoop = Jimple.v().newNopStmt();
        this.body.getUnits().add(beforeCatchAllAssignNoop);
        Local catchAllAssignLocal = this.generateLocal(RefType.v("java.lang.Throwable"));
        AssignStmt catchAllAssign = Jimple.v().newAssignStmt(catchAllAssignLocal, formalLocal);
        this.body.getUnits().add(catchAllAssign);
        NopStmt catchAllFinallyNoop = Jimple.v().newNopStmt();
        GotoStmt catchAllGotoFinally = Jimple.v().newGotoStmt(catchAllFinallyNoop);
        this.body.getUnits().add(catchAllGotoFinally);
        NopStmt catchAllBeforeThrowNoop = Jimple.v().newNopStmt();
        this.body.getUnits().add(catchAllBeforeThrowNoop);
        ThrowStmt throwStmt = Jimple.v().newThrowStmt(catchAllAssignLocal);
        this.body.getUnits().add(throwStmt);
        gotoMap.put(catchAllFinallyNoop, catchAllBeforeThrowNoop);
        GotoStmt catchAllGotoEnd = Jimple.v().newGotoStmt(endNoop);
        this.body.getUnits().add(catchAllGotoEnd);
        this.addToExceptionList(beforeCatchAllAssignNoop, catchAllBeforeThrowNoop, catchAllBeforeNoop, Scene.v().getSootClass("java.lang.Throwable"));
        Iterator finallyIt = gotoMap.keySet().iterator();
        while (finallyIt.hasNext()) {
            Stmt noopStmt = (Stmt)finallyIt.next();
            this.body.getUnits().add(noopStmt);
            this.createBlock(tryStmt.finallyBlock());
            Stmt backToStmt = (Stmt)gotoMap.get(noopStmt);
            GotoStmt backToGoto = Jimple.v().newGotoStmt(backToStmt);
            this.body.getUnits().add(backToGoto);
        }
        this.body.getUnits().add(endNoop);
        this.addToExceptionList(noop1, beforeEndGotoNoop, catchAllBeforeNoop, Scene.v().getSootClass("java.lang.Throwable"));
    }

    private void addToExceptionList(Stmt from, Stmt to, Stmt with, SootClass exceptionClass) {
        if (this.exceptionTable == null) {
            this.exceptionTable = new ArrayList();
        }
        Trap trap = Jimple.v().newTrap(exceptionClass, from, to, with);
        this.exceptionTable.add(trap);
    }

    private Value createExpr(Expr expr) {
        if (expr instanceof Assign) {
            return this.getAssignLocal((Assign)expr);
        }
        if (expr instanceof Lit) {
            return this.createLiteral((Lit)expr);
        }
        if (expr instanceof polyglot.ast.Local) {
            return this.getLocal((polyglot.ast.Local)expr);
        }
        if (expr instanceof Binary) {
            return this.getBinaryLocal((Binary)expr);
        }
        if (expr instanceof Unary) {
            return this.getUnaryLocal((Unary)expr);
        }
        if (expr instanceof Cast) {
            return this.getCastLocal((Cast)expr);
        }
        if (expr instanceof ArrayAccess) {
            return this.getArrayRefLocal((ArrayAccess)expr);
        }
        if (expr instanceof NewArray) {
            return this.getNewArrayLocal((NewArray)expr);
        }
        if (expr instanceof Call) {
            return this.getCallLocal((Call)expr);
        }
        if (expr instanceof New) {
            return this.getNewLocal((New)expr);
        }
        if (expr instanceof Special) {
            return this.getSpecialLocal((Special)expr);
        }
        if (expr instanceof Instanceof) {
            return this.getInstanceOfLocal((Instanceof)expr);
        }
        if (expr instanceof Conditional) {
            return this.getConditionalLocal((Conditional)expr);
        }
        if (expr instanceof Field) {
            return this.getFieldLocal((Field)expr);
        }
        throw new RuntimeException("Unhandled Expression");
    }

    private Value getAssignLocal(Assign assign) {
        AssignStmt stmt;
        Value left = this.createLHS(assign.left());
        Value right = this.createExpr(assign.right());
        if (right instanceof ConditionExpr) {
            right = this.handleCondBinExpr((ConditionExpr)right);
        }
        Local leftLocal = left instanceof Local ? (Local)left : this.generateLocal(left.getType());
        BinopExpr binop = null;
        Assign.Operator op = assign.operator();
        if (op == Assign.ASSIGN) {
            stmt = Jimple.v().newAssignStmt(leftLocal, right);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
        } else if (op == Assign.ADD_ASSIGN) {
            stmt = Jimple.v().newAssignStmt(leftLocal, left);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
            if (leftLocal instanceof StringConstant || right instanceof StringConstant || leftLocal.getType().toString().equals("java.lang.String") || right.getType().toString().equals("java.lang.String")) {
                Local rValue = this.getStringConcatLocal(leftLocal, right);
                stmt = Jimple.v().newAssignStmt(leftLocal, rValue);
                this.body.getUnits().add(stmt);
                Util.addLnPosTags(stmt, assign.position());
            } else {
                binop = Jimple.v().newAddExpr(leftLocal, right);
                stmt = Jimple.v().newAssignStmt(leftLocal, binop);
                this.body.getUnits().add(stmt);
                Util.addLnPosTags(stmt, assign.position());
            }
        } else if (op == Assign.SUB_ASSIGN) {
            stmt = Jimple.v().newAssignStmt(leftLocal, left);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
            binop = Jimple.v().newSubExpr(leftLocal, right);
            stmt = Jimple.v().newAssignStmt(leftLocal, binop);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
        } else if (op == Assign.MUL_ASSIGN) {
            stmt = Jimple.v().newAssignStmt(leftLocal, left);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
            binop = Jimple.v().newMulExpr(leftLocal, right);
            stmt = Jimple.v().newAssignStmt(leftLocal, binop);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
        } else if (op == Assign.DIV_ASSIGN) {
            stmt = Jimple.v().newAssignStmt(leftLocal, left);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
            binop = Jimple.v().newDivExpr(leftLocal, right);
            stmt = Jimple.v().newAssignStmt(leftLocal, binop);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
        } else if (op == Assign.MOD_ASSIGN) {
            stmt = Jimple.v().newAssignStmt(leftLocal, left);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
            binop = Jimple.v().newRemExpr(leftLocal, right);
            stmt = Jimple.v().newAssignStmt(leftLocal, binop);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
        } else if (op == Assign.SHL_ASSIGN) {
            stmt = Jimple.v().newAssignStmt(leftLocal, left);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
            binop = Jimple.v().newShlExpr(leftLocal, right);
            stmt = Jimple.v().newAssignStmt(leftLocal, binop);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
        } else if (op == Assign.SHR_ASSIGN) {
            stmt = Jimple.v().newAssignStmt(leftLocal, left);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
            binop = Jimple.v().newShrExpr(leftLocal, right);
            stmt = Jimple.v().newAssignStmt(leftLocal, binop);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
        } else if (op == Assign.USHR_ASSIGN) {
            stmt = Jimple.v().newAssignStmt(leftLocal, left);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
            binop = Jimple.v().newUshrExpr(leftLocal, right);
            stmt = Jimple.v().newAssignStmt(leftLocal, binop);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
        } else if (op == Assign.BIT_AND_ASSIGN) {
            stmt = Jimple.v().newAssignStmt(leftLocal, left);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
            binop = Jimple.v().newAndExpr(leftLocal, right);
            stmt = Jimple.v().newAssignStmt(leftLocal, binop);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
        } else if (op == Assign.BIT_OR_ASSIGN) {
            stmt = Jimple.v().newAssignStmt(leftLocal, left);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
            binop = Jimple.v().newOrExpr(leftLocal, right);
            stmt = Jimple.v().newAssignStmt(leftLocal, binop);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
        } else if (op == Assign.BIT_XOR_ASSIGN) {
            stmt = Jimple.v().newAssignStmt(leftLocal, left);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
            binop = Jimple.v().newXorExpr(leftLocal, right);
            stmt = Jimple.v().newAssignStmt(leftLocal, binop);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
        } else {
            throw new RuntimeException("Unhandled Assign Operator");
        }
        if (binop != null) {
            Util.addLnPosTags(binop.getOp1Box(), assign.left().position());
            Util.addLnPosTags(binop.getOp2Box(), assign.right().position());
        }
        Util.addLnPosTags(stmt.getRightOpBox(), assign.right().position());
        Util.addLnPosTags(stmt.getLeftOpBox(), assign.left().position());
        Util.addLnPosTags(stmt, assign.position());
        if (!(left instanceof Local)) {
            stmt = Jimple.v().newAssignStmt(left, leftLocal);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, assign.position());
            Util.addLnPosTags(stmt.getLeftOpBox(), assign.left().position());
            Util.addLnPosTags(stmt.getRightOpBox(), assign.right().position());
        }
        return leftLocal;
    }

    private Value getFieldLocalLeft(Field field) {
        Receiver receiver = field.target();
        if (field.name().equals("length") && receiver.type() instanceof polyglot.types.ArrayType) {
            return this.getSpecialArrayLengthLocal(field);
        }
        return this.getFieldRef(field);
    }

    private Value getFieldLocal(Field field) {
        Receiver receiver = field.target();
        PolyglotMethodSource ms = (PolyglotMethodSource)this.body.getMethod().getSource();
        if (field.name().equals("length") && receiver.type() instanceof polyglot.types.ArrayType) {
            return this.getSpecialArrayLengthLocal(field);
        }
        if (field.name().equals("class")) {
            return this.getSpecialClassLitLocal(field);
        }
        if (ms.getPrivateAccessMap() != null && ms.getPrivateAccessMap().containsKey(field.fieldInstance())) {
            return this.getPrivateAccessFieldLocal(field);
        }
        FieldRef fieldRef = this.getFieldRef(field);
        Local baseLocal = this.generateLocal(field.type());
        AssignStmt fieldAssignStmt = Jimple.v().newAssignStmt(baseLocal, fieldRef);
        this.body.getUnits().add(fieldAssignStmt);
        Util.addLnPosTags(fieldAssignStmt, field.position());
        Util.addLnPosTags(fieldAssignStmt.getLeftOpBox(), field.position());
        return baseLocal;
    }

    private FieldRef getFieldRef(Field field) {
        FieldRef fieldRef;
        SootClass receiverClass = Scene.v().getSootClass(this.getReceiverClassName((MemberInstance)field.fieldInstance()));
        SootField receiverField = receiverClass.getField(field.name(), Util.getSootType(field.type()));
        if (field.fieldInstance().flags().isStatic()) {
            fieldRef = Jimple.v().newStaticFieldRef(receiverField);
        } else {
            Local base = (Local)this.getBaseLocal(field.target());
            fieldRef = Jimple.v().newInstanceFieldRef(base, receiverField);
        }
        if (field.target() instanceof polyglot.ast.Local && fieldRef instanceof InstanceFieldRef) {
            Util.addLnPosTags(((InstanceFieldRef)fieldRef).getBaseBox(), field.target().position());
        }
        return fieldRef;
    }

    private Local getPrivateAccessFieldLocal(Field field) {
        HashMap paMap = ((PolyglotMethodSource)this.body.getMethod().getSource()).getPrivateAccessMap();
        SootMethod toInvoke = (SootMethod)paMap.get(field.fieldInstance());
        ArrayList<Local> params = new ArrayList<Local>();
        if (!field.fieldInstance().flags().isStatic()) {
            params.add((Local)this.getBaseLocal(field.target()));
        }
        StaticInvokeExpr invoke = Jimple.v().newStaticInvokeExpr(toInvoke, params);
        Local retLocal = this.generateLocal(field.type());
        AssignStmt stmt = Jimple.v().newAssignStmt(retLocal, invoke);
        this.body.getUnits().add(stmt);
        return retLocal;
    }

    private Local getSpecialClassLitLocal(Field field) {
        String type;
        SootClass thisClass = this.body.getMethod().getDeclaringClass();
        String fieldName = "class$";
        String typeName = null;
        if (!(field.target() instanceof TypeNode)) {
            throw new RuntimeException("class literal only valid on type nodes");
        }
        typeName = type = ((TypeNode)field.target()).type().toString();
        type = type.replace('.', '$');
        fieldName = fieldName + type;
        RefType fieldType = RefType.v("java.lang.Class");
        Local fieldLocal = this.generateLocal(RefType.v("java.lang.Class"));
        StaticFieldRef fieldRef = Jimple.v().newStaticFieldRef(thisClass.getField(fieldName, fieldType));
        AssignStmt fieldAssign = Jimple.v().newAssignStmt(fieldLocal, fieldRef);
        this.body.getUnits().add(fieldAssign);
        NopStmt noop1 = Jimple.v().newNopStmt();
        NeExpr neExpr = Jimple.v().newNeExpr(fieldLocal, NullConstant.v());
        IfStmt ifStmt = Jimple.v().newIfStmt((Value)neExpr, noop1);
        this.body.getUnits().add(ifStmt);
        ArrayList<RefType> paramTypes = new ArrayList<RefType>();
        paramTypes.add(RefType.v("java.lang.String"));
        SootMethod invokeMeth = thisClass.getMethod("class$", paramTypes, RefType.v("java.lang.Class"));
        ArrayList<StringConstant> params = new ArrayList<StringConstant>();
        params.add(StringConstant.v(typeName));
        StaticInvokeExpr classInvoke = Jimple.v().newStaticInvokeExpr(invokeMeth, params);
        Local methLocal = this.generateLocal(RefType.v("java.lang.Class"));
        AssignStmt invokeAssign = Jimple.v().newAssignStmt(methLocal, classInvoke);
        this.body.getUnits().add(invokeAssign);
        AssignStmt assignField = Jimple.v().newAssignStmt(fieldRef, methLocal);
        this.body.getUnits().add(assignField);
        NopStmt noop2 = Jimple.v().newNopStmt();
        GotoStmt goto1 = Jimple.v().newGotoStmt(noop2);
        this.body.getUnits().add(goto1);
        this.body.getUnits().add(noop1);
        fieldAssign = Jimple.v().newAssignStmt(methLocal, fieldRef);
        this.body.getUnits().add(fieldAssign);
        this.body.getUnits().add(noop2);
        return methLocal;
    }

    private Local getSpecialArrayLengthLocal(Field field) {
        Receiver receiver = field.target();
        Local localField = receiver instanceof polyglot.ast.Local ? this.getLocal((polyglot.ast.Local)receiver) : (receiver instanceof Expr ? (Local)this.createExpr((Expr)receiver) : this.generateLocal(receiver.type()));
        LengthExpr lengthExpr = Jimple.v().newLengthExpr(localField);
        Local retLocal = this.generateLocal(IntType.v());
        AssignStmt assign = Jimple.v().newAssignStmt(retLocal, lengthExpr);
        this.body.getUnits().add(assign);
        Util.addLnPosTags(assign, field.position());
        Util.addLnPosTags(lengthExpr.getOpBox(), field.target().position());
        return retLocal;
    }

    private String getReceiverClassName(MemberInstance mi) {
        if (mi.container() instanceof polyglot.types.ArrayType) {
            return "java.lang.String";
        }
        if (mi.container() instanceof ClassType && ((ClassType)mi.container()).isNested()) {
            return this.fixInnerClassName((ClassType)mi.container());
        }
        return mi.container().toString();
    }

    private Value getBinaryLocal(Binary binary) {
        if (binary.operator() == Binary.COND_AND) {
            return this.createCondAnd(binary);
        }
        if (binary.operator() == Binary.COND_OR) {
            return this.createCondOr(binary);
        }
        Value lVal = this.createExpr(binary.left());
        Value rVal = this.createExpr(binary.right());
        Value rhs = this.isComparisonBinary(binary.operator()) ? this.getBinaryComparisonExpr(lVal, rVal, binary.operator()) : this.getBinaryExpr(lVal, rVal, binary.operator());
        if (rhs instanceof BinopExpr) {
            Util.addLnPosTags(((BinopExpr)rhs).getOp1Box(), binary.left().position());
            Util.addLnPosTags(((BinopExpr)rhs).getOp2Box(), binary.right().position());
        }
        if (rhs instanceof ConditionExpr) {
            return rhs;
        }
        Local lhs = this.generateLocal(binary.type());
        AssignStmt assignStmt = Jimple.v().newAssignStmt(lhs, rhs);
        this.body.getUnits().add(assignStmt);
        Util.addLnPosTags(assignStmt.getRightOpBox(), binary.position());
        return lhs;
    }

    private boolean isComparisonBinary(Binary.Operator op) {
        return op == Binary.EQ || op == Binary.NE || op == Binary.GE || op == Binary.GT || op == Binary.LE || op == Binary.LT;
    }

    private Value getBinaryExpr(Value lVal, Value rVal, Binary.Operator operator) {
        Value rValue = null;
        if (lVal instanceof ConditionExpr) {
            lVal = this.handleCondBinExpr((ConditionExpr)lVal);
        }
        if (rVal instanceof ConditionExpr) {
            rVal = this.handleCondBinExpr((ConditionExpr)rVal);
        }
        if (operator == Binary.ADD) {
            rValue = lVal instanceof StringConstant || rVal instanceof StringConstant || lVal.getType().toString().equals("java.lang.String") || rVal.getType().toString().equals("java.lang.String") ? this.getStringConcatLocal(lVal, rVal) : Jimple.v().newAddExpr(lVal, rVal);
        } else if (operator == Binary.SUB) {
            rValue = Jimple.v().newSubExpr(lVal, rVal);
        } else if (operator == Binary.MUL) {
            rValue = Jimple.v().newMulExpr(lVal, rVal);
        } else if (operator == Binary.DIV) {
            rValue = Jimple.v().newDivExpr(lVal, rVal);
        } else if (operator == Binary.SHR) {
            rValue = Jimple.v().newShrExpr(lVal, rVal);
        } else if (operator == Binary.USHR) {
            rValue = Jimple.v().newUshrExpr(lVal, rVal);
        } else if (operator == Binary.SHL) {
            rValue = Jimple.v().newShlExpr(lVal, rVal);
        } else if (operator == Binary.BIT_AND) {
            rValue = Jimple.v().newAndExpr(lVal, rVal);
        } else if (operator == Binary.BIT_OR) {
            rValue = Jimple.v().newOrExpr(lVal, rVal);
        } else if (operator == Binary.BIT_XOR) {
            rValue = Jimple.v().newXorExpr(lVal, rVal);
        } else if (operator == Binary.MOD) {
            rValue = Jimple.v().newRemExpr(lVal, rVal);
        } else {
            throw new RuntimeException("Binary not yet handled!");
        }
        return rValue;
    }

    /*
     * WARNING - void declaration
     */
    private Value getBinaryComparisonExpr(Value lVal, Value rVal, Binary.Operator operator) {
        void var4_4;
        ConditionExpr rValue;
        if (operator == Binary.EQ) {
            rValue = Jimple.v().newEqExpr(lVal, rVal);
        } else if (operator == Binary.GE) {
            rValue = Jimple.v().newGeExpr(lVal, rVal);
        } else if (operator == Binary.GT) {
            rValue = Jimple.v().newGtExpr(lVal, rVal);
        } else if (operator == Binary.LE) {
            rValue = Jimple.v().newLeExpr(lVal, rVal);
        } else if (operator == Binary.LT) {
            rValue = Jimple.v().newLtExpr(lVal, rVal);
        } else if (operator == Binary.NE) {
            rValue = Jimple.v().newNeExpr(lVal, rVal);
        } else {
            throw new RuntimeException("Unknown Comparison Expr");
        }
        return var4_4;
    }

    /*
     * WARNING - void declaration
     */
    private Value reverseCondition(ConditionExpr cond) {
        void var2_2;
        ConditionExpr newExpr;
        if (cond instanceof EqExpr) {
            newExpr = Jimple.v().newNeExpr(cond.getOp1(), cond.getOp2());
        } else if (cond instanceof NeExpr) {
            newExpr = Jimple.v().newEqExpr(cond.getOp1(), cond.getOp2());
        } else if (cond instanceof GtExpr) {
            newExpr = Jimple.v().newLeExpr(cond.getOp1(), cond.getOp2());
        } else if (cond instanceof GeExpr) {
            newExpr = Jimple.v().newLtExpr(cond.getOp1(), cond.getOp2());
        } else if (cond instanceof LtExpr) {
            newExpr = Jimple.v().newGeExpr(cond.getOp1(), cond.getOp2());
        } else if (cond instanceof LeExpr) {
            newExpr = Jimple.v().newGtExpr(cond.getOp1(), cond.getOp2());
        } else {
            throw new RuntimeException("Unknown Condition Expr");
        }
        var2_2.getOp1Box().addAllTagsOf(cond.getOp1Box());
        var2_2.getOp2Box().addAllTagsOf(cond.getOp2Box());
        return var2_2;
    }

    private Value handleDFLCond(ConditionExpr cond) {
        Local result = this.generateLocal(ByteType.v());
        BinopExpr cmExpr = null;
        if (this.isDouble(cond.getOp1()) || this.isDouble(cond.getOp2()) || this.isFloat(cond.getOp1()) || this.isFloat(cond.getOp2())) {
            cmExpr = cond instanceof GeExpr || cond instanceof GtExpr ? Jimple.v().newCmpgExpr(cond.getOp1(), cond.getOp2()) : Jimple.v().newCmplExpr(cond.getOp1(), cond.getOp2());
        } else if (this.isLong(cond.getOp1()) || this.isLong(cond.getOp2())) {
            cmExpr = Jimple.v().newCmpExpr(cond.getOp1(), cond.getOp2());
        } else {
            return cond;
        }
        AssignStmt assign = Jimple.v().newAssignStmt(result, cmExpr);
        this.body.getUnits().add(assign);
        if (cond instanceof EqExpr) {
            cond = Jimple.v().newEqExpr(result, IntConstant.v(0));
        } else if (cond instanceof GeExpr) {
            cond = Jimple.v().newGeExpr(result, IntConstant.v(0));
        } else if (cond instanceof GtExpr) {
            cond = Jimple.v().newGtExpr(result, IntConstant.v(0));
        } else if (cond instanceof LeExpr) {
            cond = Jimple.v().newLeExpr(result, IntConstant.v(0));
        } else if (cond instanceof LtExpr) {
            cond = Jimple.v().newLtExpr(result, IntConstant.v(0));
        } else if (cond instanceof NeExpr) {
            cond = Jimple.v().newNeExpr(result, IntConstant.v(0));
        } else {
            throw new RuntimeException("Unknown Comparison Expr");
        }
        return cond;
    }

    private boolean isDouble(Value val) {
        return val.getType() instanceof DoubleType;
    }

    private boolean isFloat(Value val) {
        return val.getType() instanceof FloatType;
    }

    private boolean isLong(Value val) {
        return val.getType() instanceof LongType;
    }

    private Local createCondAnd(Binary binary) {
        Local retLocal = this.generateLocal(BooleanType.v());
        NopStmt noop1 = Jimple.v().newNopStmt();
        Value lVal = this.createExpr(binary.left());
        boolean leftNeedIf = this.needSootIf(lVal);
        if (!(lVal instanceof ConditionExpr)) {
            lVal = Jimple.v().newEqExpr(lVal, IntConstant.v(0));
        } else {
            lVal = this.reverseCondition((ConditionExpr)lVal);
            lVal = this.handleDFLCond((ConditionExpr)lVal);
        }
        if (leftNeedIf) {
            IfStmt ifLeft = Jimple.v().newIfStmt(lVal, noop1);
            this.body.getUnits().add(ifLeft);
            Util.addLnPosTags(ifLeft.getConditionBox(), binary.left().position());
        }
        NopStmt endNoop = Jimple.v().newNopStmt();
        Value rVal = this.createExpr(binary.right());
        boolean rightNeedIf = this.needSootIf(rVal);
        if (!(rVal instanceof ConditionExpr)) {
            rVal = Jimple.v().newEqExpr(rVal, IntConstant.v(0));
        } else {
            rVal = this.reverseCondition((ConditionExpr)rVal);
            rVal = this.handleDFLCond((ConditionExpr)rVal);
        }
        if (rightNeedIf) {
            IfStmt ifRight = Jimple.v().newIfStmt(rVal, noop1);
            this.body.getUnits().add(ifRight);
            Util.addLnPosTags(ifRight.getConditionBox(), binary.right().position());
        }
        AssignStmt assign1 = Jimple.v().newAssignStmt(retLocal, IntConstant.v(1));
        this.body.getUnits().add(assign1);
        GotoStmt gotoEnd1 = Jimple.v().newGotoStmt(endNoop);
        this.body.getUnits().add(gotoEnd1);
        this.body.getUnits().add(noop1);
        AssignStmt assign2 = Jimple.v().newAssignStmt(retLocal, IntConstant.v(0));
        this.body.getUnits().add(assign2);
        this.body.getUnits().add(endNoop);
        return retLocal;
    }

    private Local createCondOr(Binary binary) {
        Local retLocal = this.generateLocal(BooleanType.v());
        NopStmt endNoop = Jimple.v().newNopStmt();
        NopStmt noop1 = Jimple.v().newNopStmt();
        Value lVal = this.createExpr(binary.left());
        boolean leftNeedIf = this.needSootIf(lVal);
        lVal = !(lVal instanceof ConditionExpr) ? Jimple.v().newEqExpr(lVal, IntConstant.v(1)) : this.handleDFLCond((ConditionExpr)lVal);
        if (leftNeedIf) {
            IfStmt ifLeft = Jimple.v().newIfStmt(lVal, noop1);
            this.body.getUnits().add(ifLeft);
            Util.addLnPosTags(ifLeft, binary.left().position());
            Util.addLnPosTags(ifLeft.getConditionBox(), binary.left().position());
        }
        Value rVal = this.createExpr(binary.right());
        boolean rightNeedIf = this.needSootIf(rVal);
        rVal = !(rVal instanceof ConditionExpr) ? Jimple.v().newEqExpr(rVal, IntConstant.v(1)) : this.handleDFLCond((ConditionExpr)rVal);
        if (rightNeedIf) {
            IfStmt ifRight = Jimple.v().newIfStmt(rVal, noop1);
            this.body.getUnits().add(ifRight);
            Util.addLnPosTags(ifRight, binary.right().position());
            Util.addLnPosTags(ifRight.getConditionBox(), binary.right().position());
        }
        AssignStmt assign2 = Jimple.v().newAssignStmt(retLocal, IntConstant.v(0));
        this.body.getUnits().add(assign2);
        Util.addLnPosTags(assign2, binary.position());
        GotoStmt gotoEnd2 = Jimple.v().newGotoStmt(endNoop);
        this.body.getUnits().add(gotoEnd2);
        this.body.getUnits().add(noop1);
        AssignStmt assign3 = Jimple.v().newAssignStmt(retLocal, IntConstant.v(1));
        this.body.getUnits().add(assign3);
        Util.addLnPosTags(assign3, binary.position());
        this.body.getUnits().add(endNoop);
        return retLocal;
    }

    private Local handleCondBinExpr(ConditionExpr condExpr) {
        Local boolLocal = this.generateLocal(BooleanType.v());
        NopStmt noop1 = Jimple.v().newNopStmt();
        IfStmt ifStmt = Jimple.v().newIfStmt((Value)condExpr, noop1);
        this.body.getUnits().add(ifStmt);
        this.body.getUnits().add(Jimple.v().newAssignStmt(boolLocal, IntConstant.v(0)));
        NopStmt noop2 = Jimple.v().newNopStmt();
        GotoStmt goto1 = Jimple.v().newGotoStmt(noop2);
        this.body.getUnits().add(goto1);
        this.body.getUnits().add(noop1);
        this.body.getUnits().add(Jimple.v().newAssignStmt(boolLocal, IntConstant.v(1)));
        this.body.getUnits().add(noop2);
        return boolLocal;
    }

    private Local getStringConcatLocal(Value lVal, Value rVal) {
        Local local = this.generateLocal(RefType.v("java.lang.StringBuffer"));
        NewExpr newExpr = Jimple.v().newNewExpr(RefType.v("java.lang.StringBuffer"));
        AssignStmt assign = Jimple.v().newAssignStmt(local, newExpr);
        this.body.getUnits().add(assign);
        SootClass classToInvoke1 = Scene.v().getSootClass("java.lang.StringBuffer");
        SootMethod methodToInvoke1 = this.getMethodFromClass(classToInvoke1, "<init>", new ArrayList(), VoidType.v());
        SpecialInvokeExpr invoke = Jimple.v().newSpecialInvokeExpr(local, methodToInvoke1);
        this.body.getUnits().add(Jimple.v().newInvokeStmt(invoke));
        local = this.generateAppendStmts(lVal, local);
        local = this.generateAppendStmts(rVal, local);
        Local newString = this.generateLocal(RefType.v("java.lang.String"));
        SootClass classToInvoke2 = Scene.v().getSootClass("java.lang.StringBuffer");
        SootMethod methodToInvoke2 = this.getMethodFromClass(classToInvoke2, "toString", new ArrayList(), RefType.v("java.lang.String"));
        VirtualInvokeExpr toStringInvoke = Jimple.v().newVirtualInvokeExpr(local, methodToInvoke2);
        AssignStmt lastAssign = Jimple.v().newAssignStmt(newString, toStringInvoke);
        this.body.getUnits().add(lastAssign);
        return newString;
    }

    private Local generateAppendStmts(Value toApp, Local base) {
        Type appendType = null;
        if (toApp instanceof StringConstant) {
            appendType = RefType.v("java.lang.String");
        } else if (toApp instanceof Constant) {
            appendType = toApp.getType();
        } else if (toApp instanceof Local) {
            if (((Local)toApp).getType() instanceof PrimType) {
                appendType = ((Local)toApp).getType();
            } else if (((Local)toApp).getType() instanceof RefType) {
                appendType = ((Local)toApp).getType().toString().equals("java.lang.String") ? RefType.v("java.lang.String") : (((Local)toApp).getType().toString().equals("java.lang.StringBuffer") ? RefType.v("java.lang.StringBuffer") : RefType.v("java.lang.Object"));
            }
        } else if (toApp instanceof ConditionExpr) {
            toApp = this.handleCondBinExpr((ConditionExpr)toApp);
            appendType = BooleanType.v();
        }
        if (appendType instanceof ShortType || appendType instanceof ByteType) {
            Local intLocal = this.generateLocal(IntType.v());
            CastExpr cast = Jimple.v().newCastExpr(toApp, IntType.v());
            AssignStmt castAssign = Jimple.v().newAssignStmt(intLocal, cast);
            this.body.getUnits().add(castAssign);
            toApp = intLocal;
            appendType = IntType.v();
        }
        ArrayList<RefType> paramsTypes = new ArrayList<RefType>();
        paramsTypes.add((RefType)appendType);
        ArrayList<Value> params = new ArrayList<Value>();
        params.add(toApp);
        SootClass classToInvoke = Scene.v().getSootClass("java.lang.StringBuffer");
        SootMethod methodToInvoke = this.getMethodFromClass(classToInvoke, "append", paramsTypes, RefType.v("java.lang.StringBuffer"));
        VirtualInvokeExpr appendInvoke = Jimple.v().newVirtualInvokeExpr(base, methodToInvoke, params);
        Local nextSB = this.generateLocal(RefType.v("java.lang.StringBuffer"));
        AssignStmt appendAssign = Jimple.v().newAssignStmt(nextSB, appendInvoke);
        this.body.getUnits().add(appendAssign);
        return nextSB;
    }

    private Local getUnaryLocal(Unary unary) {
        Expr expr = unary.expr();
        Unary.Operator op = unary.operator();
        if (op == Unary.POST_INC) {
            Local retLocal = this.generateLocal(expr.type());
            Value sootExpr = this.createExpr(expr);
            AssignStmt preStmt = Jimple.v().newAssignStmt(retLocal, sootExpr);
            this.body.getUnits().add(preStmt);
            AddExpr addExpr = Jimple.v().newAddExpr(sootExpr, this.getConstant(retLocal.getType(), 1));
            Util.addLnPosTags(addExpr.getOp1Box(), expr.position());
            Local local = this.generateLocal(expr.type());
            AssignStmt stmt = Jimple.v().newAssignStmt(local, addExpr);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, expr.position());
            AssignStmt aStmt = Jimple.v().newAssignStmt(sootExpr, local);
            this.body.getUnits().add(aStmt);
            Util.addLnPosTags(aStmt, expr.position());
            Util.addLnPosTags(aStmt, unary.position());
            if (expr instanceof Field || expr instanceof ArrayAccess) {
                Value actualUnaryExpr = this.createLHS(expr);
                AssignStmt s = Jimple.v().newAssignStmt(actualUnaryExpr, local);
                this.body.getUnits().add(s);
                Util.addLnPosTags(s, expr.position());
                Util.addLnPosTags(s.getLeftOpBox(), expr.position());
            }
            return retLocal;
        }
        if (op == Unary.POST_DEC) {
            Local retLocal = this.generateLocal(expr.type());
            Value sootExpr = this.createExpr(expr);
            AssignStmt preStmt = Jimple.v().newAssignStmt(retLocal, sootExpr);
            this.body.getUnits().add(preStmt);
            SubExpr subExpr = Jimple.v().newSubExpr(sootExpr, this.getConstant(retLocal.getType(), 1));
            Util.addLnPosTags(subExpr.getOp1Box(), expr.position());
            Local local = this.generateLocal(expr.type());
            AssignStmt stmt = Jimple.v().newAssignStmt(local, subExpr);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, expr.position());
            AssignStmt aStmt = Jimple.v().newAssignStmt(sootExpr, local);
            this.body.getUnits().add(aStmt);
            Util.addLnPosTags(aStmt, expr.position());
            Util.addLnPosTags(aStmt, unary.position());
            if (expr instanceof Field || expr instanceof ArrayAccess) {
                Value actualUnaryExpr = this.createLHS(expr);
                AssignStmt s = Jimple.v().newAssignStmt(actualUnaryExpr, local);
                this.body.getUnits().add(s);
                Util.addLnPosTags(s, expr.position());
                Util.addLnPosTags(s.getLeftOpBox(), expr.position());
            }
            return retLocal;
        }
        if (op == Unary.PRE_INC) {
            Value sootExpr = this.createExpr(expr);
            AddExpr addExpr = Jimple.v().newAddExpr(sootExpr, this.getConstant(sootExpr.getType(), 1));
            Util.addLnPosTags(addExpr.getOp1Box(), expr.position());
            Local local = this.generateLocal(expr.type());
            AssignStmt stmt = Jimple.v().newAssignStmt(local, addExpr);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, expr.position());
            if (expr instanceof Field || expr instanceof ArrayAccess || expr instanceof polyglot.ast.Local) {
                Value actualUnaryExpr = this.createLHS(expr);
                this.body.getUnits().add(Jimple.v().newAssignStmt(actualUnaryExpr, local));
            }
            return local;
        }
        if (op == Unary.PRE_DEC) {
            Value sootExpr = this.createExpr(expr);
            SubExpr subExpr = Jimple.v().newSubExpr(sootExpr, this.getConstant(sootExpr.getType(), 1));
            Util.addLnPosTags(subExpr.getOp1Box(), expr.position());
            Local local = this.generateLocal(expr.type());
            AssignStmt stmt = Jimple.v().newAssignStmt(local, subExpr);
            this.body.getUnits().add(stmt);
            Util.addLnPosTags(stmt, expr.position());
            if (expr instanceof Field || expr instanceof ArrayAccess || expr instanceof polyglot.ast.Local) {
                Value actualUnaryExpr = this.createLHS(expr);
                this.body.getUnits().add(Jimple.v().newAssignStmt(actualUnaryExpr, local));
            }
            return local;
        }
        if (op == Unary.BIT_NOT) {
            IntConstant int1 = IntConstant.v(-1);
            Local retLocal = this.generateLocal(expr.type());
            Value sootExpr = this.createExpr(expr);
            AssignStmt assign1 = Jimple.v().newAssignStmt(retLocal, Jimple.v().newXorExpr(sootExpr, this.getConstant(sootExpr.getType(), -1)));
            this.body.getUnits().add(assign1);
            Util.addLnPosTags(assign1, expr.position());
            return retLocal;
        }
        if (op == Unary.NEG) {
            Value sootExpr;
            if (expr instanceof NumLit) {
                int intVal = (int)((NumLit)expr).longValue();
                sootExpr = IntConstant.v(-intVal);
            } else if (expr instanceof FloatLit) {
                double doubleVal = ((FloatLit)expr).value();
                sootExpr = DoubleConstant.v(-doubleVal);
            } else {
                Value local = this.createExpr(expr);
                NegExpr negExpr = Jimple.v().newNegExpr(local);
                sootExpr = negExpr;
                Util.addLnPosTags(negExpr.getOpBox(), expr.position());
            }
            Local retLocal = this.generateLocal(expr.type());
            AssignStmt assign = Jimple.v().newAssignStmt(retLocal, sootExpr);
            this.body.getUnits().add(assign);
            Util.addLnPosTags(assign, expr.position());
            return retLocal;
        }
        if (op == Unary.POS) {
            Local retLocal = this.generateLocal(expr.type());
            Value sootExpr = this.createExpr(expr);
            AssignStmt assign = Jimple.v().newAssignStmt(retLocal, sootExpr);
            this.body.getUnits().add(assign);
            Util.addLnPosTags(assign, expr.position());
            return retLocal;
        }
        if (op == Unary.NOT) {
            Value local = this.createExpr(expr);
            if (local instanceof ConditionExpr) {
                local = this.handleCondBinExpr((ConditionExpr)local);
            }
            NeExpr neExpr = Jimple.v().newNeExpr(local, this.getConstant(local.getType(), 0));
            NopStmt noop1 = Jimple.v().newNopStmt();
            IfStmt ifStmt = Jimple.v().newIfStmt((Value)neExpr, noop1);
            this.body.getUnits().add(ifStmt);
            Util.addLnPosTags(ifStmt, expr.position());
            Local retLocal = this.generateLocal(local.getType());
            AssignStmt assign1 = Jimple.v().newAssignStmt(retLocal, this.getConstant(retLocal.getType(), 1));
            this.body.getUnits().add(assign1);
            Util.addLnPosTags(assign1, expr.position());
            NopStmt noop2 = Jimple.v().newNopStmt();
            GotoStmt goto1 = Jimple.v().newGotoStmt(noop2);
            this.body.getUnits().add(goto1);
            this.body.getUnits().add(noop1);
            AssignStmt assign2 = Jimple.v().newAssignStmt(retLocal, this.getConstant(retLocal.getType(), 0));
            this.body.getUnits().add(assign2);
            Util.addLnPosTags(assign2, expr.position());
            this.body.getUnits().add(noop2);
            return retLocal;
        }
        throw new RuntimeException("Unhandled Unary Expr");
    }

    private Constant getConstant(Type type, int val) {
        if (type instanceof DoubleType) {
            return DoubleConstant.v(val);
        }
        if (type instanceof FloatType) {
            return FloatConstant.v(val);
        }
        if (type instanceof LongType) {
            return LongConstant.v(val);
        }
        return IntConstant.v(val);
    }

    private Local getCastLocal(Cast castExpr) {
        Value val = castExpr.expr() instanceof Cast ? this.createExpr(((Cast)castExpr.expr()).expr()) : this.createExpr(castExpr.expr());
        Type type = Util.getSootType(castExpr.type());
        CastExpr cast = Jimple.v().newCastExpr(val, type);
        if (castExpr.position() instanceof DPosition) {
            DPosition dpos = (DPosition)castExpr.position();
            Util.addLnPosTags(cast.getOpBox(), dpos.line(), dpos.line(), dpos.column() + castExpr.toString().indexOf(41), dpos.endCol());
        }
        Local retLocal = this.generateLocal(cast.getCastType());
        AssignStmt castAssign = Jimple.v().newAssignStmt(retLocal, cast);
        this.body.getUnits().add(castAssign);
        Util.addLnPosTags(castAssign, castExpr.position());
        return retLocal;
    }

    private ArrayList getSootParams(ProcedureCall call) {
        ArrayList<Value> sootParams = new ArrayList<Value>();
        Iterator it = call.arguments().iterator();
        while (it.hasNext()) {
            Expr next = (Expr)it.next();
            Value nextExpr = this.createExpr(next);
            if (nextExpr instanceof ConditionExpr) {
                nextExpr = this.handleCondBinExpr((ConditionExpr)nextExpr);
            }
            sootParams.add(nextExpr);
        }
        return sootParams;
    }

    private ArrayList getSootParamsTypes(ProcedureCall call) {
        ArrayList<Type> sootParamsTypes = new ArrayList<Type>();
        Iterator it = call.procedureInstance().formalTypes().iterator();
        while (it.hasNext()) {
            Object next = it.next();
            sootParamsTypes.add(Util.getSootType((polyglot.types.Type)next));
        }
        return sootParamsTypes;
    }

    private SootMethod getMethodFromClass(SootClass sootClass, String name, ArrayList paramTypes, Type returnType) {
        return sootClass.getMethod(name, paramTypes, returnType);
    }

    private void handleFinalLocalParams(ArrayList sootParams, ArrayList sootParamTypes, SootClass classToInvoke, ProcedureCall call) {
        ArrayList finals;
        HashMap finalsMap = ((PolyglotMethodSource)this.body.getMethod().getSource()).getFinalsMap();
        if (finalsMap != null && finalsMap.containsKey(call) && (finals = (ArrayList)finalsMap.get(call)) != null) {
            Iterator it = finals.iterator();
            while (it.hasNext()) {
                LocalInstance li = (LocalInstance)((IdentityKey)it.next()).object();
                sootParamTypes.add(Util.getSootType(li.type()));
                sootParams.add(this.getLocal(li));
            }
        }
    }

    private void handleOuterClassParams(ArrayList sootParams, ArrayList sootParamsTypes, SootClass classToInvoke, int index, New newExpr) {
        SootClass outerClass = Scene.v().getSootClass(classToInvoke.getName().substring(0, index));
        if (this.body.getMethod().getDeclaringClass().getName().indexOf("$") == -1) {
            if (!this.body.getMethod().isStatic()) {
                sootParamsTypes.add(outerClass.getType());
                sootParams.add(this.specialThisLocal);
            }
        } else if (this.body.getMethod().getDeclaringClass().getName().equals(classToInvoke.getName())) {
            sootParamsTypes.add(outerClass.getType());
            if (this.outerClassParamLocal == null) {
                SootField outerThisField = this.body.getMethod().getDeclaringClass().getFieldByName("this$0");
                this.outerClassParamLocal = this.generateLocal(outerThisField.getType());
                InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef(this.specialThisLocal, outerThisField);
                AssignStmt stmt = Jimple.v().newAssignStmt(this.outerClassParamLocal, fieldRef);
                this.body.getUnits().add(stmt);
            }
            sootParams.add(this.outerClassParamLocal);
        } else {
            if (this.outerClassParamLocal == null) {
                SootField outerThisField = this.body.getMethod().getDeclaringClass().getFieldByName("this$0");
                this.outerClassParamLocal = this.generateLocal(outerThisField.getType());
                InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef(this.specialThisLocal, outerThisField);
                AssignStmt stmt = Jimple.v().newAssignStmt(this.outerClassParamLocal, fieldRef);
                this.body.getUnits().add(stmt);
            }
            Local forParam = this.outerClassParamLocal;
            HashMap newToOuterMap = ((PolyglotMethodSource)this.body.getMethod().getSource()).getNewToOuterMap();
            if (newToOuterMap != null && newToOuterMap.containsKey(newExpr)) {
                forParam = this.generateLocal(Scene.v().getSootClass((String)newToOuterMap.get(newExpr)).getType());
            }
            sootParamsTypes.add(forParam.getType());
            sootParams.add(forParam);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createConstructorCall(ConstructorCall cCall) {
        void var6_6;
        SootClass classToInvoke;
        ArrayList<Local> sootParams = new ArrayList<Local>();
        ArrayList<RefType> sootParamsTypes = new ArrayList<RefType>();
        ConstructorInstance cInst = cCall.constructorInstance();
        String containerName = null;
        if (cInst.container() instanceof ClassType) {
            containerName = ((ClassType)cInst.container()).fullName();
            if (((ClassType)cInst.container()).isNested()) {
                containerName = this.fixInnerClassName((ClassType)cInst.container());
            }
        }
        if (cCall.kind() == ConstructorCall.SUPER) {
            classToInvoke = Scene.v().getSootClass(containerName);
        } else if (cCall.kind() == ConstructorCall.THIS) {
            classToInvoke = this.body.getMethod().getDeclaringClass();
        } else {
            throw new RuntimeException("Unknown kind of Constructor Call");
        }
        Local base = this.specialThisLocal;
        int index = var6_6.getName().lastIndexOf("$");
        if (index != -1 && !Modifier.isStatic(var6_6.getModifiers())) {
            SootClass outerClass = Scene.v().getSootClass(var6_6.getName().substring(0, index));
            Local fieldRefLocal = this.generateLocal(outerClass.getType());
            sootParamsTypes.add(outerClass.getType());
            if (this.outerClassParamLocal == null) {
                SootField outerThisField = this.body.getMethod().getDeclaringClass().getFieldByName("this$0");
                this.outerClassParamLocal = this.generateLocal(outerThisField.getType());
                InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef(this.specialThisLocal, outerThisField);
                AssignStmt stmt = Jimple.v().newAssignStmt(this.outerClassParamLocal, fieldRef);
                this.body.getUnits().add(stmt);
            }
            sootParams.add(this.outerClassParamLocal);
        }
        sootParams.addAll(this.getSootParams((ProcedureCall)cCall));
        sootParamsTypes.addAll(this.getSootParamsTypes((ProcedureCall)cCall));
        if (index != -1) {
            this.handleFinalLocalParams(sootParams, sootParamsTypes, (SootClass)var6_6, (ProcedureCall)cCall);
        }
        SootMethod methodToInvoke = this.getMethodFromClass((SootClass)var6_6, "<init>", sootParamsTypes, VoidType.v());
        SpecialInvokeExpr specialInvokeExpr = Jimple.v().newSpecialInvokeExpr(base, methodToInvoke, sootParams);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(specialInvokeExpr);
        this.body.getUnits().add(invokeStmt);
        Util.addLnPosTags(invokeStmt, cCall.position());
        int numParams = 0;
        Iterator invokeParamsIt = cCall.arguments().iterator();
        while (invokeParamsIt.hasNext()) {
            Util.addLnPosTags(specialInvokeExpr.getArgBox(numParams), ((Expr)invokeParamsIt.next()).position());
            ++numParams;
        }
        if (this.body.getMethod().getName().equals("<init>") && cCall.kind() == ConstructorCall.SUPER) {
            this.handleOuterClassThisInit(this.body.getMethod());
            this.handleFieldInits(this.body.getMethod());
            this.handleInitializerBlocks(this.body.getMethod());
        }
    }

    private void createLocalClassDecl(LocalClassDecl cDecl) {
        HashMap lcMap;
        if (this.realLocalClassNameMap == null) {
            this.realLocalClassNameMap = new HashMap();
        }
        if ((lcMap = ((PolyglotMethodSource)this.body.getMethod().getSource()).getLocalClassMap()) != null) {
            Iterator it = lcMap.keySet().iterator();
            while (it.hasNext()) {
                String realName = (String)it.next();
                ClassDecl next = (ClassDecl)lcMap.get(realName);
                if (!next.equals(cDecl.decl())) continue;
                this.realLocalClassNameMap.put(cDecl.decl().name(), realName);
            }
        }
    }

    private Local getNewLocal(New newExpr) {
        SootClass classToInvoke;
        int index;
        ClassType classType;
        RefType sootType;
        ArrayList sootParams = new ArrayList();
        ArrayList sootParamsTypes = new ArrayList();
        ClassType objType = (ClassType)newExpr.objectType().type();
        if (objType.isLocal()) {
            sootType = RefType.v((String)this.realLocalClassNameMap.get(objType.toString()));
        } else if (newExpr.anonType() != null) {
            sootType = (RefType)Util.getSootType(newExpr.objectType().type());
            HashMap anonClassMap = ((PolyglotMethodSource)this.body.getMethod().getSource()).getAnonClassMap();
            if (anonClassMap != null && anonClassMap.containsKey(newExpr.body())) {
                sootType = RefType.v((String)anonClassMap.get(newExpr.body()));
            }
        } else {
            sootType = (RefType)Util.getSootType(newExpr.objectType().type());
        }
        Local retLocal = this.generateLocal(sootType);
        NewExpr sootNew = Jimple.v().newNewExpr(sootType);
        AssignStmt stmt = Jimple.v().newAssignStmt(retLocal, sootNew);
        this.body.getUnits().add(stmt);
        Util.addLnPosTags(stmt, newExpr.position());
        String className = sootType.toString();
        if (sootType instanceof ClassType && (classType = (ClassType)newExpr.objectType().type()).isNested()) {
            className = classType.isLocal() ? (String)this.realLocalClassNameMap.get(classType.toString()) : this.fixInnerClassName(classType);
        }
        if ((index = (classToInvoke = Scene.v().getSootClass(className)).getName().indexOf("$")) != -1 && !Modifier.isStatic(classToInvoke.getModifiers())) {
            this.handleOuterClassParams(sootParams, sootParamsTypes, classToInvoke, index, newExpr);
        }
        sootParams.addAll(this.getSootParams((ProcedureCall)newExpr));
        sootParamsTypes.addAll(this.getSootParamsTypes((ProcedureCall)newExpr));
        if (index != -1) {
            this.handleFinalLocalParams(sootParams, sootParamsTypes, classToInvoke, (ProcedureCall)newExpr);
        }
        SootMethod methodToInvoke = this.getMethodFromClass(classToInvoke, "<init>", sootParamsTypes, VoidType.v());
        SpecialInvokeExpr specialInvokeExpr = Jimple.v().newSpecialInvokeExpr(retLocal, methodToInvoke, sootParams);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(specialInvokeExpr);
        this.body.getUnits().add(invokeStmt);
        Util.addLnPosTags(invokeStmt, newExpr.position());
        int numParams = 0;
        Iterator invokeParamsIt = newExpr.arguments().iterator();
        while (invokeParamsIt.hasNext()) {
            Util.addLnPosTags(specialInvokeExpr.getArgBox(numParams), ((Expr)invokeParamsIt.next()).position());
            ++numParams;
        }
        return retLocal;
    }

    private Local getCallLocal(Call call) {
        ClassType ct;
        String name = call.name();
        Receiver receiver = call.target();
        Local baseLocal = (Local)this.getBaseLocal(receiver);
        String receiverTypeClassName = receiver.type() instanceof ClassType ? ((ct = (ClassType)receiver.type()).isNested() ? (ct.isAnonymous() ? this.body.getMethod().getDeclaringClass().getName() : this.fixInnerClassName(ct)) : receiver.type().toString()) : (receiver.type() instanceof polyglot.types.ArrayType ? "java.lang.Object" : receiver.type().toString());
        SootClass receiverTypeClass = Scene.v().getSootClass(receiverTypeClassName);
        MethodInstance methodInstance = call.methodInstance();
        Type sootRetType = Util.getSootType(methodInstance.returnType());
        ArrayList sootParamsTypes = this.getSootParamsTypes((ProcedureCall)call);
        ArrayList sootParams = this.getSootParams((ProcedureCall)call);
        SootMethod callMethod = this.getMethodFromClass(receiverTypeClass, methodInstance.name(), sootParamsTypes, sootRetType);
        boolean isPrivateAccess = false;
        PolyglotMethodSource ms = (PolyglotMethodSource)this.body.getMethod().getSource();
        if (ms.getPrivateAccessMap() != null && ms.getPrivateAccessMap().containsKey(call.methodInstance())) {
            callMethod = (SootMethod)ms.getPrivateAccessMap().get(call.methodInstance());
            if (!call.methodInstance().flags().isStatic()) {
                sootParams.add(baseLocal);
            }
            isPrivateAccess = true;
        }
        InvokeExpr invokeExpr = isPrivateAccess ? Jimple.v().newStaticInvokeExpr(callMethod, sootParams) : (Modifier.isInterface(receiverTypeClass.getModifiers()) ? Jimple.v().newInterfaceInvokeExpr(baseLocal, callMethod, sootParams) : (methodInstance.flags().isStatic() ? Jimple.v().newStaticInvokeExpr(callMethod, sootParams) : (methodInstance.flags().isPrivate() ? Jimple.v().newSpecialInvokeExpr(baseLocal, callMethod, sootParams) : (receiver instanceof Special && ((Special)receiver).kind() == Special.SUPER ? Jimple.v().newSpecialInvokeExpr(baseLocal, callMethod, sootParams) : Jimple.v().newVirtualInvokeExpr(baseLocal, callMethod, sootParams)))));
        int numParams = 0;
        Iterator callParamsIt = call.arguments().iterator();
        while (callParamsIt.hasNext()) {
            Util.addLnPosTags(invokeExpr.getArgBox(numParams), ((Expr)callParamsIt.next()).position());
            ++numParams;
        }
        if (invokeExpr instanceof InstanceInvokeExpr) {
            Util.addLnPosTags(((InstanceInvokeExpr)invokeExpr).getBaseBox(), call.target().position());
        }
        if (invokeExpr.getMethod().getReturnType().equals(VoidType.v())) {
            InvokeStmt invoke = Jimple.v().newInvokeStmt(invokeExpr);
            this.body.getUnits().add(invoke);
            Util.addLnPosTags(invoke, call.position());
            return null;
        }
        Local retLocal = this.generateLocal(invokeExpr.getMethod().getReturnType());
        AssignStmt assignStmt = Jimple.v().newAssignStmt(retLocal, invokeExpr);
        this.body.getUnits().add(assignStmt);
        Util.addLnPosTags(assignStmt, call.position());
        return retLocal;
    }

    private String getClassNameForField(String f) {
        return f.substring(0, f.lastIndexOf("."));
    }

    private String getClassName(Receiver receiver) {
        if (receiver instanceof Field) {
            String result = this.getClassNameForField(receiver.toString());
            if (result.equals("this")) {
                Local local = this.specialThisLocal;
                return local.getType().toString();
            }
            return receiver.type().toString();
        }
        if (receiver.type() instanceof ClassType) {
            ClassType ct = (ClassType)receiver.type();
            if (ct.isNested()) {
                return this.fixInnerClassName(ct);
            }
            return receiver.type().toString();
        }
        if (receiver.type() instanceof polyglot.types.ArrayType) {
            return "java.lang.Object";
        }
        return receiver.type().toString();
    }

    private String fixInnerClassName(ClassType innerClass) {
        String fullName = innerClass.fullName();
        while (innerClass.isNested()) {
            StringBuffer sb = new StringBuffer(fullName);
            int lastDot = fullName.lastIndexOf(".");
            if (lastDot != -1) {
                sb.replace(lastDot, lastDot + 1, "$");
                fullName = sb.toString();
            }
            innerClass = innerClass.outer();
        }
        return fullName;
    }

    private Value getBaseLocal(Receiver receiver) {
        if (receiver instanceof TypeNode) {
            return this.generateLocal(((TypeNode)receiver).type());
        }
        Value val = this.createExpr((Expr)receiver);
        if (val instanceof Constant) {
            Local retLocal = this.generateLocal(val.getType());
            AssignStmt stmt = Jimple.v().newAssignStmt(retLocal, val);
            this.body.getUnits().add(stmt);
            return retLocal;
        }
        return val;
    }

    private Local getNewArrayLocal(NewArray newArrExpr) {
        soot.jimple.Expr expr;
        Type sootType = Util.getSootType(newArrExpr.type());
        if (newArrExpr.numDims() == 1) {
            NewArrayExpr newArrayExpr;
            Value dimLocal = newArrExpr.additionalDims() == 1 ? IntConstant.v(1) : this.createExpr((Expr)newArrExpr.dims().get(0));
            expr = newArrayExpr = Jimple.v().newNewArrayExpr(((ArrayType)sootType).getElementType(), dimLocal);
            if (newArrExpr.additionalDims() != 1) {
                Util.addLnPosTags(newArrayExpr.getSizeBox(), ((Expr)newArrExpr.dims().get(0)).position());
            }
        } else {
            ArrayList<Value> valuesList = new ArrayList<Value>();
            Iterator it = newArrExpr.dims().iterator();
            while (it.hasNext()) {
                valuesList.add(this.createExpr((Expr)it.next()));
            }
            if (newArrExpr.additionalDims() != 0) {
                valuesList.add(IntConstant.v(newArrExpr.additionalDims()));
            }
            NewMultiArrayExpr newMultiArrayExpr = Jimple.v().newNewMultiArrayExpr((ArrayType)sootType, valuesList);
            expr = newMultiArrayExpr;
            Iterator sizeBoxIt = newArrExpr.dims().iterator();
            int counter = 0;
            while (sizeBoxIt.hasNext()) {
                Util.addLnPosTags(newMultiArrayExpr.getSizeBox(counter), ((Expr)sizeBoxIt.next()).position());
                ++counter;
            }
        }
        Local retLocal = this.generateLocal(sootType);
        AssignStmt stmt = Jimple.v().newAssignStmt(retLocal, expr);
        this.body.getUnits().add(stmt);
        Util.addLnPosTags(stmt, newArrExpr.position());
        Util.addLnPosTags(stmt.getRightOpBox(), newArrExpr.position());
        if (newArrExpr.init() != null) {
            Local initVal = this.getArrayInitLocal(newArrExpr.init(), newArrExpr.type());
            AssignStmt initStmt = Jimple.v().newAssignStmt(retLocal, initVal);
            this.body.getUnits().add(initStmt);
        }
        return retLocal;
    }

    private Local getArrayInitLocal(ArrayInit arrInit, polyglot.types.Type lhsType) {
        Local local = this.generateLocal(lhsType);
        NewArrayExpr arrExpr = Jimple.v().newNewArrayExpr(((ArrayType)local.getType()).getElementType(), IntConstant.v(arrInit.elements().size()));
        AssignStmt assign = Jimple.v().newAssignStmt(local, arrExpr);
        this.body.getUnits().add(assign);
        Util.addLnPosTags(assign, arrInit.position());
        Iterator it = arrInit.elements().iterator();
        int index = 0;
        while (it.hasNext()) {
            Expr elemExpr = (Expr)it.next();
            Value elem = elemExpr instanceof ArrayInit ? (((ArrayInit)elemExpr).type() instanceof NullType ? (lhsType instanceof polyglot.types.ArrayType ? this.getArrayInitLocal((ArrayInit)elemExpr, ((polyglot.types.ArrayType)lhsType).base()) : this.getArrayInitLocal((ArrayInit)elemExpr, lhsType)) : this.getArrayInitLocal((ArrayInit)elemExpr, ((ArrayInit)elemExpr).type())) : this.createExpr(elemExpr);
            ArrayRef arrRef = Jimple.v().newArrayRef(local, IntConstant.v(index));
            AssignStmt elemAssign = Jimple.v().newAssignStmt(arrRef, elem);
            this.body.getUnits().add(elemAssign);
            Util.addLnPosTags(elemAssign, elemExpr.position());
            Util.addLnPosTags(elemAssign.getRightOpBox(), elemExpr.position());
            ++index;
        }
        return local;
    }

    private Value createLHS(Expr expr) {
        if (expr instanceof polyglot.ast.Local) {
            return this.getLocal((polyglot.ast.Local)expr);
        }
        if (expr instanceof ArrayAccess) {
            return this.getArrayRefLocalLeft((ArrayAccess)expr);
        }
        if (expr instanceof Field) {
            return this.getFieldLocalLeft((Field)expr);
        }
        throw new RuntimeException("Unhandled LHS");
    }

    private Value getArrayRefLocalLeft(ArrayAccess arrayRefExpr) {
        Expr array = arrayRefExpr.array();
        Expr access = arrayRefExpr.index();
        Local arrLocal = (Local)this.createExpr(array);
        Value arrAccess = this.createExpr(access);
        Local retLocal = this.generateLocal(arrayRefExpr.type());
        ArrayRef ref = Jimple.v().newArrayRef(arrLocal, arrAccess);
        Util.addLnPosTags(ref.getBaseBox(), arrayRefExpr.array().position());
        Util.addLnPosTags(ref.getIndexBox(), arrayRefExpr.index().position());
        return ref;
    }

    private Value getArrayRefLocal(ArrayAccess arrayRefExpr) {
        Expr array = arrayRefExpr.array();
        Expr access = arrayRefExpr.index();
        Local arrLocal = (Local)this.createExpr(array);
        Value arrAccess = this.createExpr(access);
        Local retLocal = this.generateLocal(arrayRefExpr.type());
        ArrayRef ref = Jimple.v().newArrayRef(arrLocal, arrAccess);
        Util.addLnPosTags(ref.getBaseBox(), arrayRefExpr.array().position());
        Util.addLnPosTags(ref.getIndexBox(), arrayRefExpr.index().position());
        AssignStmt stmt = Jimple.v().newAssignStmt(retLocal, ref);
        this.body.getUnits().add(stmt);
        Util.addLnPosTags(stmt, arrayRefExpr.position());
        return retLocal;
    }

    private Local getSpecialLocal(Special specialExpr) {
        if (specialExpr.kind() == Special.SUPER) {
            return this.specialThisLocal;
        }
        if (specialExpr.kind() == Special.THIS) {
            if (specialExpr.qualifier() == null) {
                return this.specialThisLocal;
            }
            if (this.outerClassParamLocal == null) {
                SootField outerThisField = this.body.getMethod().getDeclaringClass().getFieldByName("this$0");
                Local fieldLocal = this.generateLocal(outerThisField.getType());
                InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef(this.specialThisLocal, outerThisField);
                AssignStmt stmt = Jimple.v().newAssignStmt(fieldLocal, fieldRef);
                this.body.getUnits().add(stmt);
                return fieldLocal;
            }
            return this.outerClassParamLocal;
        }
        throw new RuntimeException("Unknown Special");
    }

    private Local getInstanceOfLocal(Instanceof instExpr) {
        Type sootType = Util.getSootType(instExpr.compareType().type());
        Value local = this.createExpr(instExpr.expr());
        InstanceOfExpr instOfExpr = Jimple.v().newInstanceOfExpr(local, sootType);
        Local lhs = this.generateLocal(BooleanType.v());
        AssignStmt instAssign = Jimple.v().newAssignStmt(lhs, instOfExpr);
        this.body.getUnits().add(instAssign);
        Util.addLnPosTags(instAssign, instExpr.position());
        Util.addLnPosTags(instOfExpr.getOpBox(), instExpr.expr().position());
        return lhs;
    }

    private Local getConditionalLocal(Conditional condExpr) {
        Expr condition = condExpr.cond();
        Value sootCond = this.createExpr(condition);
        boolean needIf = this.needSootIf(sootCond);
        if (!(sootCond instanceof ConditionExpr)) {
            sootCond = Jimple.v().newEqExpr(sootCond, IntConstant.v(0));
        } else {
            sootCond = this.reverseCondition((ConditionExpr)sootCond);
            sootCond = this.handleDFLCond((ConditionExpr)sootCond);
        }
        NopStmt noop1 = Jimple.v().newNopStmt();
        if (needIf) {
            IfStmt ifStmt = Jimple.v().newIfStmt(sootCond, noop1);
            this.body.getUnits().add(ifStmt);
            Util.addLnPosTags(ifStmt, condExpr.position());
            Util.addLnPosTags(ifStmt.getConditionBox(), condition.position());
        }
        Local retLocal = this.generateLocal(condExpr.alternative().type());
        Expr consequence = condExpr.consequent();
        Value conseqVal = this.createExpr(consequence);
        AssignStmt conseqAssignStmt = Jimple.v().newAssignStmt(retLocal, conseqVal);
        this.body.getUnits().add(conseqAssignStmt);
        Util.addLnPosTags(conseqAssignStmt, condExpr.position());
        Util.addLnPosTags(conseqAssignStmt.getRightOpBox(), consequence.position());
        NopStmt noop2 = Jimple.v().newNopStmt();
        GotoStmt goto1 = Jimple.v().newGotoStmt(noop2);
        this.body.getUnits().add(goto1);
        this.body.getUnits().add(noop1);
        Expr alternative = condExpr.alternative();
        if (alternative != null) {
            Value altVal = this.createExpr(alternative);
            AssignStmt altAssignStmt = Jimple.v().newAssignStmt(retLocal, altVal);
            this.body.getUnits().add(altAssignStmt);
            Util.addLnPosTags(altAssignStmt, condExpr.position());
            Util.addLnPosTags(altAssignStmt, alternative.position());
            Util.addLnPosTags(altAssignStmt.getRightOpBox(), alternative.position());
        }
        this.body.getUnits().add(noop2);
        return retLocal;
    }

    private boolean isLitOrLocal(Expr exp) {
        if (exp instanceof Lit) {
            return true;
        }
        return exp instanceof polyglot.ast.Local;
    }

    private Local generateLocal(polyglot.types.Type polyglotType) {
        Type type = Util.getSootType(polyglotType);
        return this.generateLocal(type);
    }

    private Local generateLocal(Type type) {
        String name = "v";
        if (type instanceof IntType) {
            name = this.nextIntName();
        } else if (type instanceof ByteType) {
            name = this.nextByteName();
        } else if (type instanceof ShortType) {
            name = this.nextShortName();
        } else if (type instanceof BooleanType) {
            name = this.nextBooleanName();
        } else if (type instanceof VoidType) {
            name = this.nextVoidName();
        } else if (type instanceof CharType) {
            name = this.nextIntName();
            type = IntType.v();
        } else if (type instanceof DoubleType) {
            name = this.nextDoubleName();
        } else if (type instanceof FloatType) {
            name = this.nextFloatName();
        } else if (type instanceof LongType) {
            name = this.nextLongName();
        } else if (type instanceof RefLikeType) {
            name = this.nextRefLikeTypeName();
        } else {
            throw new RuntimeException("Unhandled Type of Local variable to Generate - Not Implemented");
        }
        return this.createLocal(name, type);
    }

    private String nextIntName() {
        ++this.tempInt;
        return "$i" + this.tempInt;
    }

    private String nextVoidName() {
        ++this.tempVoid;
        return "$v" + this.tempVoid;
    }

    private String nextByteName() {
        ++this.tempByte;
        return "$b" + this.tempByte;
    }

    private String nextShortName() {
        ++this.tempShort;
        return "$s" + this.tempShort;
    }

    private String nextBooleanName() {
        ++this.tempBoolean;
        return "$z" + this.tempBoolean;
    }

    private String nextDoubleName() {
        ++this.tempDouble;
        return "$d" + this.tempDouble;
    }

    private String nextFloatName() {
        ++this.tempFloat;
        return "$f" + this.tempFloat;
    }

    private String nextLongName() {
        ++this.tempLong;
        return "$l" + this.tempLong;
    }

    private String nextRefLikeTypeName() {
        ++this.tempRefLikeType;
        return "$r" + this.tempRefLikeType;
    }
}

