/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.misc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import soot.Body;
import soot.G;
import soot.PatchingChain;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.CallGraphBuilder;
import soot.jimple.toolkits.callgraph.Edge;
import soot.util.IterableSet;

public class ThrowFinder {
    private HashSet registeredMethods;
    private HashMap protectionSet;

    public ThrowFinder(Singletons.Global g) {
    }

    public static ThrowFinder v() {
        return G.v().ThrowFinder();
    }

    public void find() {
        SootMethod m;
        CallGraph cg;
        G.v().out.print("Verifying exception handling.. ");
        this.registeredMethods = new HashSet();
        this.protectionSet = new HashMap();
        if (Scene.v().hasCallGraph()) {
            cg = Scene.v().getCallGraph();
        } else {
            new CallGraphBuilder().build();
            cg = Scene.v().getCallGraph();
            Scene.v().releaseCallGraph();
        }
        IterableSet worklist = new IterableSet();
        G.v().out.print("\b. ");
        G.v().out.flush();
        Iterator classIt = Scene.v().getApplicationClasses().iterator();
        while (classIt.hasNext()) {
            Iterator methodIt = ((SootClass)classIt.next()).methodIterator();
            while (methodIt.hasNext()) {
                SootMethod m2 = (SootMethod)methodIt.next();
                this.register_AreasOfProtection(m2);
                worklist.add(m2);
            }
        }
        HashMap<SootClass, IterableSet> subClassSet = new HashMap<SootClass, IterableSet>();
        HashMap<SootClass, IterableSet> superClassSet = new HashMap<SootClass, IterableSet>();
        HashSet applicationClasses = new HashSet();
        applicationClasses.addAll(Scene.v().getApplicationClasses());
        classIt = Scene.v().getApplicationClasses().iterator();
        while (classIt.hasNext()) {
            IterableSet subClasses;
            SootClass c = (SootClass)classIt.next();
            IterableSet superClasses = (IterableSet)superClassSet.get(c);
            if (superClasses == null) {
                superClasses = new IterableSet();
                superClassSet.put(c, superClasses);
            }
            if ((subClasses = (IterableSet)subClassSet.get(c)) == null) {
                subClasses = new IterableSet();
                subClassSet.put(c, subClasses);
            }
            if (c.hasSuperclass()) {
                SootClass superClass = c.getSuperclass();
                IterableSet superClassSubClasses = (IterableSet)subClassSet.get(superClass);
                if (superClassSubClasses == null) {
                    superClassSubClasses = new IterableSet();
                    subClassSet.put(superClass, superClassSubClasses);
                }
                superClassSubClasses.add(c);
                superClasses.add(superClass);
            }
            Iterator interfaceIt = c.getInterfaces().iterator();
            while (interfaceIt.hasNext()) {
                SootClass interfaceClass = (SootClass)interfaceIt.next();
                IterableSet interfaceClassSubClasses = (IterableSet)subClassSet.get(interfaceClass);
                if (interfaceClassSubClasses == null) {
                    interfaceClassSubClasses = new IterableSet();
                    subClassSet.put(interfaceClass, interfaceClassSubClasses);
                }
                interfaceClassSubClasses.add(c);
                superClasses.add(interfaceClass);
            }
        }
        HashMap agreementMethodSet = new HashMap();
        Iterator worklistIt = worklist.iterator();
        while (worklistIt.hasNext()) {
            m = (SootMethod)worklistIt.next();
            if (!m.isAbstract() && !m.isNative()) {
                List exceptionList = m.getExceptions();
                IterableSet exceptionSet = new IterableSet(exceptionList);
                boolean changed = false;
                Iterator it = m.retrieveActiveBody().getUnits().iterator();
                while (it.hasNext()) {
                    SootClass c;
                    Type t;
                    Unit u = (Unit)it.next();
                    HashSet handled = (HashSet)this.protectionSet.get(u);
                    if (!(u instanceof ThrowStmt) || !((t = ((ThrowStmt)u).getOp().getType()) instanceof RefType) || this.handled_Exception(handled, c = ((RefType)t).getSootClass()) || exceptionSet.contains(c)) continue;
                    exceptionSet.add(c);
                    changed = true;
                }
                it = cg.edgesOutOf(m);
                while (it.hasNext()) {
                    Edge e = (Edge)it.next();
                    Stmt callSite = e.srcStmt();
                    if (callSite == null) continue;
                    HashSet handled = (HashSet)this.protectionSet.get(callSite);
                    SootMethod target = e.tgt();
                    Iterator exceptionIt = target.getExceptions().iterator();
                    while (exceptionIt.hasNext()) {
                        SootClass exception = (SootClass)exceptionIt.next();
                        if (this.handled_Exception(handled, exception) || exceptionSet.contains(exception)) continue;
                        exceptionSet.add(exception);
                        changed = true;
                    }
                }
                if (changed) {
                    exceptionList.clear();
                    exceptionList.addAll(exceptionSet);
                }
            }
            this.find_OtherMethods(m, agreementMethodSet, subClassSet, applicationClasses);
            this.find_OtherMethods(m, agreementMethodSet, superClassSet, applicationClasses);
        }
        while (!worklist.isEmpty()) {
            m = (SootMethod)worklist.getFirst();
            worklist.removeFirst();
            IterableSet agreementMethods = (IterableSet)agreementMethodSet.get(m);
            if (agreementMethods != null) {
                Iterator amit = agreementMethods.iterator();
                while (amit.hasNext()) {
                    SootMethod otherMethod = (SootMethod)amit.next();
                    List otherExceptionsList = otherMethod.getExceptions();
                    IterableSet otherExceptionSet = new IterableSet(otherExceptionsList);
                    boolean changed = false;
                    Iterator exceptionIt = m.getExceptions().iterator();
                    while (exceptionIt.hasNext()) {
                        SootClass exception = (SootClass)exceptionIt.next();
                        if (otherExceptionSet.contains(exception)) continue;
                        otherExceptionSet.add(exception);
                        changed = true;
                    }
                    if (!changed) continue;
                    otherExceptionsList.clear();
                    otherExceptionsList.addAll(otherExceptionSet);
                    if (worklist.contains(otherMethod)) continue;
                    worklist.addLast(otherMethod);
                }
            }
            Iterator it = cg.edgesOutOf(m);
            while (it.hasNext()) {
                Edge e = (Edge)it.next();
                Stmt callingSite = e.srcStmt();
                if (callingSite == null) continue;
                SootMethod callingMethod = e.src();
                List exceptionList = callingMethod.getExceptions();
                IterableSet exceptionSet = new IterableSet(exceptionList);
                HashSet handled = (HashSet)this.protectionSet.get(callingSite);
                boolean changed = false;
                Iterator exceptionIt = m.getExceptions().iterator();
                while (exceptionIt.hasNext()) {
                    SootClass exception = (SootClass)exceptionIt.next();
                    if (this.handled_Exception(handled, exception) || exceptionSet.contains(exception)) continue;
                    exceptionSet.add(exception);
                    changed = true;
                }
                if (!changed) continue;
                exceptionList.clear();
                exceptionList.addAll(exceptionSet);
                if (worklist.contains(callingMethod)) continue;
                worklist.addLast(callingMethod);
            }
        }
        G.v().out.println();
        G.v().out.flush();
    }

    private void find_OtherMethods(SootMethod startingMethod, HashMap methodMapping, HashMap classMapping, HashSet applicationClasses) {
        IterableSet worklist = (IterableSet)((IterableSet)classMapping.get(startingMethod.getDeclaringClass())).clone();
        HashSet<SootClass> touchSet = new HashSet<SootClass>();
        touchSet.addAll(worklist);
        String signature = startingMethod.getSubSignature();
        while (!worklist.isEmpty()) {
            SootClass currentClass = (SootClass)worklist.getFirst();
            worklist.removeFirst();
            if (!applicationClasses.contains(currentClass)) continue;
            if (currentClass.declaresMethod(signature)) {
                IterableSet otherMethods = (IterableSet)methodMapping.get(startingMethod);
                if (otherMethods == null) {
                    otherMethods = new IterableSet();
                    methodMapping.put(startingMethod, otherMethods);
                }
                otherMethods.add(currentClass.getMethod(signature));
                continue;
            }
            IterableSet otherClasses = (IterableSet)classMapping.get(currentClass);
            if (otherClasses == null) continue;
            Iterator ocit = otherClasses.iterator();
            while (ocit.hasNext()) {
                SootClass otherClass = (SootClass)ocit.next();
                if (touchSet.contains(otherClass)) continue;
                worklist.addLast(otherClass);
                touchSet.add(otherClass);
            }
        }
    }

    private void register_AreasOfProtection(SootMethod m) {
        if (this.registeredMethods.contains(m)) {
            return;
        }
        this.registeredMethods.add(m);
        if (!m.hasActiveBody()) {
            return;
        }
        Body b = m.getActiveBody();
        PatchingChain stmts = b.getUnits();
        Iterator trapIt = b.getTraps().iterator();
        while (trapIt.hasNext()) {
            Trap t = (Trap)trapIt.next();
            SootClass exception = t.getException();
            Iterator sit = stmts.iterator(t.getBeginUnit(), stmts.getPredOf(t.getEndUnit()));
            while (sit.hasNext()) {
                Stmt s = (Stmt)sit.next();
                HashSet<SootClass> handled = null;
                handled = (HashSet<SootClass>)this.protectionSet.get(s);
                if (handled == null) {
                    handled = new HashSet<SootClass>();
                    this.protectionSet.put(s, handled);
                }
                if (handled.contains(exception)) continue;
                handled.add(exception);
            }
        }
    }

    private boolean handled_Exception(HashSet handledExceptions, SootClass c) {
        SootClass thrownException = c;
        if (this.is_HandledByRuntime(thrownException)) {
            return true;
        }
        if (handledExceptions == null) {
            return false;
        }
        while (!handledExceptions.contains(thrownException)) {
            if (!thrownException.hasSuperclass()) {
                return false;
            }
            thrownException = thrownException.getSuperclass();
        }
        return true;
    }

    private boolean is_HandledByRuntime(SootClass c) {
        SootClass thrownException = c;
        SootClass runtimeException = Scene.v().getSootClass("java.lang.RuntimeException");
        SootClass error = Scene.v().getSootClass("java.lang.Error");
        while (thrownException != runtimeException && thrownException != error) {
            if (!thrownException.hasSuperclass()) {
                return false;
            }
            thrownException = thrownException.getSuperclass();
        }
        return true;
    }
}

