/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.finders;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import soot.G;
import soot.Singletons;
import soot.dava.Dava;
import soot.dava.DavaBody;
import soot.dava.RetriggerAnalysisException;
import soot.dava.internal.SET.SETBasicBlock;
import soot.dava.internal.SET.SETLabeledBlockNode;
import soot.dava.internal.SET.SETNode;
import soot.dava.internal.SET.SETStatementSequenceNode;
import soot.dava.internal.SET.SETTryNode;
import soot.dava.internal.SET.SETUnconditionalWhileNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.internal.asg.AugmentedStmtGraph;
import soot.dava.toolkits.base.finders.FactFinder;
import soot.util.IterableSet;

public class LabeledBlockFinder
implements FactFinder {
    private HashMap orderNumber = new HashMap();

    public LabeledBlockFinder(Singletons.Global g) {
    }

    public static LabeledBlockFinder v() {
        return G.v().LabeledBlockFinder();
    }

    public void find(DavaBody body, AugmentedStmtGraph asg, SETNode SET) throws RetriggerAnalysisException {
        Dava.v().log("LabeledBlockFinder::find()");
        Iterator bit = SET.get_Body().iterator();
        while (bit.hasNext()) {
            SET.find_SmallestSETNode((AugmentedStmt)bit.next());
        }
        SET.find_LabeledBlocks(this);
    }

    public void perform_ChildOrder(SETNode SETParent) {
        Dava.v().log("LabeledBlockFinder::perform_ChildOrder()");
        if (SETParent instanceof SETStatementSequenceNode) {
            return;
        }
        Iterator sbit = SETParent.get_SubBodies().iterator();
        while (sbit.hasNext()) {
            Iterator bit;
            SETNode startSETNode;
            IterableSet body = (IterableSet)sbit.next();
            IterableSet children = (IterableSet)SETParent.get_Body2ChildChain().get(body);
            HashSet<SETBasicBlock> touchSet = new HashSet<SETBasicBlock>();
            IterableSet childOrdering = new IterableSet();
            LinkedList<SETBasicBlock> worklist = new LinkedList<SETBasicBlock>();
            List SETBasicBlocks = null;
            if (SETParent instanceof SETUnconditionalWhileNode) {
                startSETNode = ((SETUnconditionalWhileNode)SETParent).get_CharacterizingStmt().myNode;
                while (!children.contains(startSETNode)) {
                    startSETNode = startSETNode.get_Parent();
                }
                SETBasicBlocks = this.build_Connectivity(SETParent, body, startSETNode);
                worklist.add(SETBasicBlock.get_SETBasicBlock(startSETNode));
            } else if (SETParent instanceof SETTryNode) {
                startSETNode = null;
                bit = body.iterator();
                block2: while (bit.hasNext()) {
                    AugmentedStmt as = (AugmentedStmt)bit.next();
                    Iterator pbit = as.cpreds.iterator();
                    while (pbit.hasNext()) {
                        if (body.contains(pbit.next())) continue;
                        startSETNode = as.myNode;
                        break block2;
                    }
                }
                if (startSETNode == null) {
                    startSETNode = ((SETTryNode)SETParent).get_EntryStmt().myNode;
                }
                while (!children.contains(startSETNode)) {
                    startSETNode = startSETNode.get_Parent();
                }
                SETBasicBlocks = this.build_Connectivity(SETParent, body, startSETNode);
                worklist.add(SETBasicBlock.get_SETBasicBlock(startSETNode));
            } else {
                SETBasicBlocks = this.build_Connectivity(SETParent, body, null);
                Iterator cit = children.iterator();
                while (cit.hasNext()) {
                    SETNode child = (SETNode)cit.next();
                    if (!child.get_Predecessors().isEmpty()) continue;
                    worklist.add(SETBasicBlock.get_SETBasicBlock(child));
                }
            }
            while (!worklist.isEmpty()) {
                SETBasicBlock sbb = (SETBasicBlock)worklist.removeFirst();
                bit = sbb.get_Body().iterator();
                while (bit.hasNext()) {
                    childOrdering.addLast(bit.next());
                }
                touchSet.add(sbb);
                TreeSet<SETBasicBlock> sortedSuccessors = new TreeSet<SETBasicBlock>();
                Iterator sit = sbb.get_Successors().iterator();
                block8: while (sit.hasNext()) {
                    SETBasicBlock ssbb = (SETBasicBlock)sit.next();
                    if (touchSet.contains(ssbb)) continue;
                    Iterator psit = ssbb.get_Predecessors().iterator();
                    while (psit.hasNext()) {
                        if (touchSet.contains(psit.next())) continue;
                        continue block8;
                    }
                    sortedSuccessors.add(ssbb);
                }
                sit = sortedSuccessors.iterator();
                while (sit.hasNext()) {
                    worklist.addFirst((SETBasicBlock)sit.next());
                }
            }
            int count = 0;
            Iterator it = childOrdering.iterator();
            while (it.hasNext()) {
                this.orderNumber.put(it.next(), new Integer(count++));
            }
            children.clear();
            children.addAll(childOrdering);
        }
    }

    private List build_Connectivity(SETNode SETParent, IterableSet body, SETNode startSETNode) {
        Dava.v().log("LabeledBlockFinder::build_Connectivity()");
        IterableSet children = (IterableSet)SETParent.get_Body2ChildChain().get(body);
        Iterator it = body.iterator();
        while (it.hasNext()) {
            AugmentedStmt as = (AugmentedStmt)it.next();
            Iterator sit = as.csuccs.iterator();
            while (sit.hasNext()) {
                AugmentedStmt sas = (AugmentedStmt)sit.next();
                if (!body.contains(sas)) continue;
                SETNode srcNode = as.myNode;
                SETNode dstNode = sas.myNode;
                while (!children.contains(srcNode)) {
                    srcNode = srcNode.get_Parent();
                }
                while (!children.contains(dstNode)) {
                    dstNode = dstNode.get_Parent();
                }
                if (srcNode == dstNode) continue;
                if (!srcNode.get_Successors().contains(dstNode)) {
                    srcNode.get_Successors().add(dstNode);
                }
                if (dstNode.get_Predecessors().contains(srcNode)) continue;
                dstNode.get_Predecessors().add(srcNode);
            }
        }
        Dava.v().log("LabeledBlockFinder::build_Connectivity() - built connectivity");
        LinkedList<SETBasicBlock> basicBlockList = new LinkedList<SETBasicBlock>();
        Iterator cit = children.iterator();
        while (cit.hasNext()) {
            SETNode prev;
            SETNode child = (SETNode)cit.next();
            if (SETBasicBlock.get_SETBasicBlock(child) != null) continue;
            SETBasicBlock basicBlock = new SETBasicBlock();
            while (child.get_Predecessors().size() == 1 && (startSETNode == null || child != startSETNode) && SETBasicBlock.get_SETBasicBlock(prev = (SETNode)child.get_Predecessors().getFirst()) == null && prev.get_Successors().size() == 1) {
                child = prev;
            }
            basicBlock.add(child);
            while (child.get_Successors().size() == 1 && SETBasicBlock.get_SETBasicBlock(child = (SETNode)child.get_Successors().getFirst()) == null && child.get_Predecessors().size() == 1) {
                basicBlock.add(child);
            }
            basicBlockList.add(basicBlock);
        }
        Dava.v().log("LabeledBlockFinder::build_Connectivity() - created basic blocks");
        Iterator bblit = basicBlockList.iterator();
        while (bblit.hasNext()) {
            SETBasicBlock sbb = (SETBasicBlock)bblit.next();
            SETNode entryNode = sbb.get_EntryNode();
            Iterator pit = entryNode.get_Predecessors().iterator();
            while (pit.hasNext()) {
                SETNode psn = (SETNode)pit.next();
                SETBasicBlock psbb = SETBasicBlock.get_SETBasicBlock(psn);
                if (!sbb.get_Predecessors().contains(psbb)) {
                    sbb.get_Predecessors().add(psbb);
                }
                if (psbb.get_Successors().contains(sbb)) continue;
                psbb.get_Successors().add(sbb);
            }
        }
        Dava.v().log("LabeledBlockFinder::build_Connectivity() - done");
        return basicBlockList;
    }

    public void find_LabeledBlocks(SETNode SETParent) {
        Dava.v().log("LabeledBlockFinder::find_LabeledBlocks()");
        Iterator sbit = SETParent.get_SubBodies().iterator();
        while (sbit.hasNext()) {
            IterableSet curBody = (IterableSet)sbit.next();
            IterableSet children = (IterableSet)SETParent.get_Body2ChildChain().get(curBody);
            Iterator it = children.snapshotIterator();
            if (!it.hasNext()) continue;
            SETNode curNode = (SETNode)it.next();
            SETNode prevNode = null;
            while (it.hasNext()) {
                SETNode child;
                SETNode child2;
                prevNode = curNode;
                curNode = (SETNode)it.next();
                AugmentedStmt entryStmt = curNode.get_EntryStmt();
                SETNode minNode = null;
                boolean build = false;
                Iterator pit = entryStmt.cpreds.iterator();
                while (pit.hasNext()) {
                    AugmentedStmt pas = (AugmentedStmt)pit.next();
                    if (!curBody.contains(pas)) continue;
                    SETNode srcNode = pas.myNode;
                    while (!children.contains(srcNode)) {
                        srcNode = srcNode.get_Parent();
                    }
                    if (srcNode == curNode || srcNode == prevNode) continue;
                    build = true;
                    if (minNode != null && (Integer)this.orderNumber.get(srcNode) >= (Integer)this.orderNumber.get(minNode)) continue;
                    minNode = srcNode;
                }
                if (!build) continue;
                IterableSet labeledBlockBody = new IterableSet();
                Iterator cit = children.iterator(minNode);
                while (cit.hasNext() && (child2 = (SETNode)cit.next()) != curNode) {
                    labeledBlockBody.addAll(child2.get_Body());
                }
                SETLabeledBlockNode slbn = new SETLabeledBlockNode(labeledBlockBody);
                this.orderNumber.put(slbn, this.orderNumber.get(minNode));
                cit = children.snapshotIterator(minNode);
                while (cit.hasNext() && (child = (SETNode)cit.next()) != curNode) {
                    SETParent.remove_Child(child, children);
                    slbn.add_Child(child, (IterableSet)slbn.get_Body2ChildChain().get(slbn.get_SubBodies().get(0)));
                }
                SETParent.insert_ChildBefore(slbn, curNode, children);
            }
        }
    }
}

