/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.internal.asg;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.Unit;
import soot.dava.Dava;
import soot.dava.internal.asg.AugmentedStmt;
import soot.jimple.IfStmt;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.PseudoTopologicalOrderer;
import soot.toolkits.graph.TrapUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.util.IterableSet;

public class AugmentedStmtGraph
implements DirectedGraph {
    private HashMap binding = new HashMap();
    private HashMap original2clone = new HashMap();
    private IterableSet aug_list = new IterableSet();
    private IterableSet stmt_list = new IterableSet();
    private List bheads = new LinkedList();
    private List btails = new LinkedList();
    private List cheads = new LinkedList();
    private List ctails = new LinkedList();

    public AugmentedStmtGraph(AugmentedStmtGraph other) {
        this();
        AugmentedStmt oas;
        HashMap<AugmentedStmt, AugmentedStmt> old2new = new HashMap<AugmentedStmt, AugmentedStmt>();
        Iterator it = other.aug_list.iterator();
        while (it.hasNext()) {
            oas = (AugmentedStmt)it.next();
            Stmt s = oas.get_Stmt();
            AugmentedStmt nas = new AugmentedStmt(s);
            this.aug_list.add(nas);
            this.stmt_list.add(s);
            this.binding.put(s, nas);
            old2new.put(oas, nas);
        }
        it = other.aug_list.iterator();
        while (it.hasNext()) {
            oas = (AugmentedStmt)it.next();
            AugmentedStmt nas = (AugmentedStmt)old2new.get(oas);
            Iterator pit = oas.bpreds.iterator();
            while (pit.hasNext()) {
                nas.bpreds.add(old2new.get(pit.next()));
            }
            if (nas.bpreds.isEmpty()) {
                this.bheads.add(nas);
            }
            pit = oas.cpreds.iterator();
            while (pit.hasNext()) {
                nas.cpreds.add(old2new.get(pit.next()));
            }
            if (nas.cpreds.isEmpty()) {
                this.cheads.add(nas);
            }
            Iterator sit = oas.bsuccs.iterator();
            while (sit.hasNext()) {
                nas.bsuccs.add(old2new.get(sit.next()));
            }
            if (nas.bsuccs.isEmpty()) {
                this.btails.add(nas);
            }
            sit = oas.csuccs.iterator();
            while (sit.hasNext()) {
                nas.csuccs.add(old2new.get(sit.next()));
            }
            if (!nas.csuccs.isEmpty()) continue;
            this.ctails.add(nas);
        }
        this.find_Dominators();
    }

    public AugmentedStmtGraph(BriefUnitGraph bug, TrapUnitGraph cug) {
        this();
        Stmt s;
        Dava.v().log("AugmentedStmtGraph::AugmentedStmtGraph() - cug.size() = " + cug.size());
        Iterator it = cug.iterator();
        while (it.hasNext()) {
            s = (Stmt)it.next();
            this.add_StmtBinding(s, new AugmentedStmt(s));
        }
        it = new PseudoTopologicalOrderer().newList(cug).iterator();
        while (it.hasNext()) {
            s = (Stmt)it.next();
            this.aug_list.add(this.get_AugStmt(s));
            this.stmt_list.add(s);
        }
        it = this.aug_list.iterator();
        while (it.hasNext()) {
            AugmentedStmt as = (AugmentedStmt)it.next();
            this.mirror_PredsSuccs(as, bug);
            this.mirror_PredsSuccs(as, cug);
        }
        this.find_Dominators();
    }

    public AugmentedStmtGraph() {
    }

    public void add_AugmentedStmt(AugmentedStmt as) {
        Stmt s = as.get_Stmt();
        this.aug_list.add(as);
        this.stmt_list.add(s);
        this.add_StmtBinding(s, as);
        if (as.bpreds.isEmpty()) {
            this.bheads.add(as);
        }
        if (as.cpreds.isEmpty()) {
            this.cheads.add(as);
        }
        if (as.bsuccs.isEmpty()) {
            this.btails.add(as);
        }
        if (as.csuccs.isEmpty()) {
            this.ctails.add(as);
        }
        this.check_List(as.bpreds, this.btails);
        this.check_List(as.bsuccs, this.bheads);
        this.check_List(as.cpreds, this.ctails);
        this.check_List(as.csuccs, this.cheads);
    }

    public boolean contains(Object o) {
        return this.aug_list.contains(o);
    }

    public AugmentedStmt get_CloneOf(AugmentedStmt as) {
        return (AugmentedStmt)this.original2clone.get(as);
    }

    public int size() {
        return this.aug_list.size();
    }

    private void check_List(List psList, List htList) {
        Iterator it = psList.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!htList.contains(o)) continue;
            htList.remove(o);
        }
    }

    public void calculate_Reachability(AugmentedStmt source, HashSet blockers, AugmentedStmt dominator) {
        if (blockers == null) {
            throw new RuntimeException("Tried to call AugmentedStmtGraph:calculate_Reachability() with null blockers.");
        }
        if (source == null) {
            return;
        }
        LinkedList<AugmentedStmt> worklist = new LinkedList<AugmentedStmt>();
        HashSet<AugmentedStmt> touchSet = new HashSet<AugmentedStmt>();
        worklist.addLast(source);
        touchSet.add(source);
        while (!worklist.isEmpty()) {
            AugmentedStmt as = (AugmentedStmt)worklist.removeFirst();
            Iterator sit = as.csuccs.iterator();
            while (sit.hasNext()) {
                AugmentedStmt sas = (AugmentedStmt)sit.next();
                if (touchSet.contains(sas) || !sas.get_Dominators().contains(dominator)) continue;
                touchSet.add(sas);
                IterableSet reachers = sas.get_Reachers();
                if (!reachers.contains(source)) {
                    reachers.add(source);
                }
                if (blockers.contains(sas)) continue;
                worklist.addLast(sas);
            }
        }
    }

    public void calculate_Reachability(Collection sources, HashSet blockers, AugmentedStmt dominator) {
        Iterator srcIt = sources.iterator();
        while (srcIt.hasNext()) {
            this.calculate_Reachability((AugmentedStmt)srcIt.next(), blockers, dominator);
        }
    }

    public void calculate_Reachability(AugmentedStmt source, AugmentedStmt blocker, AugmentedStmt dominator) {
        HashSet<AugmentedStmt> h = new HashSet<AugmentedStmt>();
        h.add(blocker);
        this.calculate_Reachability(source, h, dominator);
    }

    public void calculate_Reachability(Collection sources, AugmentedStmt blocker, AugmentedStmt dominator) {
        HashSet<AugmentedStmt> h = new HashSet<AugmentedStmt>();
        h.add(blocker);
        this.calculate_Reachability(sources, h, dominator);
    }

    public void calculate_Reachability(AugmentedStmt source, AugmentedStmt dominator) {
        this.calculate_Reachability(source, new HashSet(), dominator);
    }

    public void calculate_Reachability(Collection sources, AugmentedStmt dominator) {
        this.calculate_Reachability(sources, new HashSet(), dominator);
    }

    public void calculate_Reachability(AugmentedStmt source) {
        this.calculate_Reachability(source, null);
    }

    public void calculate_Reachability(Collection sources) {
        this.calculate_Reachability(sources, null);
    }

    public void add_StmtBinding(Stmt s, AugmentedStmt as) {
        this.binding.put(s, as);
    }

    public AugmentedStmt get_AugStmt(Stmt s) {
        AugmentedStmt as = (AugmentedStmt)this.binding.get(s);
        if (as == null) {
            throw new RuntimeException("Could not find augmented statement for: " + s.toString());
        }
        return as;
    }

    public List getHeads() {
        return this.cheads;
    }

    public List getTails() {
        return this.ctails;
    }

    public Iterator iterator() {
        return this.aug_list.iterator();
    }

    public List getPredsOf(Object s) {
        if (s instanceof AugmentedStmt) {
            return ((AugmentedStmt)s).cpreds;
        }
        if (s instanceof Stmt) {
            return this.get_AugStmt((Stmt)((Stmt)s)).cpreds;
        }
        throw new RuntimeException("Object " + s + " class: " + s.getClass() + " not a member of this AugmentedStmtGraph");
    }

    public List getSuccsOf(Object s) {
        if (s instanceof AugmentedStmt) {
            return ((AugmentedStmt)s).csuccs;
        }
        if (s instanceof Stmt) {
            return this.get_AugStmt((Stmt)((Stmt)s)).csuccs;
        }
        throw new RuntimeException("Object " + s + " class: " + s.getClass() + " not a member of this AugmentedStmtGraph");
    }

    public List get_BriefHeads() {
        return this.bheads;
    }

    public List get_BriefTails() {
        return this.btails;
    }

    public IterableSet get_ChainView() {
        IterableSet c = new IterableSet();
        c.addAll(this.aug_list);
        return c;
    }

    public Object clone() {
        return new AugmentedStmtGraph(this);
    }

    public boolean remove_AugmentedStmt(AugmentedStmt toRemove) {
        AugmentedStmt sas;
        AugmentedStmt pas;
        if (!this.aug_list.contains(toRemove)) {
            return false;
        }
        Iterator pit = toRemove.bpreds.iterator();
        while (pit.hasNext()) {
            pas = (AugmentedStmt)pit.next();
            if (!pas.bsuccs.contains(toRemove)) continue;
            pas.bsuccs.remove(toRemove);
        }
        pit = toRemove.cpreds.iterator();
        while (pit.hasNext()) {
            pas = (AugmentedStmt)pit.next();
            if (!pas.csuccs.contains(toRemove)) continue;
            pas.csuccs.remove(toRemove);
        }
        Iterator sit = toRemove.bsuccs.iterator();
        while (sit.hasNext()) {
            sas = (AugmentedStmt)sit.next();
            if (!sas.bpreds.contains(toRemove)) continue;
            sas.bpreds.remove(toRemove);
        }
        sit = toRemove.csuccs.iterator();
        while (sit.hasNext()) {
            sas = (AugmentedStmt)sit.next();
            if (!sas.cpreds.contains(toRemove)) continue;
            sas.cpreds.remove(toRemove);
        }
        this.aug_list.remove(toRemove);
        this.stmt_list.remove(toRemove.get_Stmt());
        if (this.bheads.contains(toRemove)) {
            this.bheads.remove(toRemove);
        }
        if (this.btails.contains(toRemove)) {
            this.btails.remove(toRemove);
        }
        if (this.cheads.contains(toRemove)) {
            this.cheads.remove(toRemove);
        }
        if (this.ctails.contains(toRemove)) {
            this.ctails.remove(toRemove);
        }
        this.binding.remove(toRemove.get_Stmt());
        return true;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        String cr = "\n";
        b.append("AugmentedStmtGraph (size: " + this.size() + " stmts)" + cr);
        Iterator it = this.aug_list.iterator();
        while (it.hasNext()) {
            AugmentedStmt as = (AugmentedStmt)it.next();
            b.append("| .---" + cr + "| | AugmentedStmt " + as.toString() + cr + "| |" + cr + "| |  preds:");
            Iterator pit = as.cpreds.iterator();
            while (pit.hasNext()) {
                AugmentedStmt pas = (AugmentedStmt)pit.next();
                b.append(" " + pas.toString());
            }
            b.append(cr + "| |" + cr + "| |  succs:");
            Iterator sit = as.csuccs.iterator();
            while (sit.hasNext()) {
                AugmentedStmt sas = (AugmentedStmt)sit.next();
                b.append(" " + sas.toString());
            }
            b.append(cr + "| |" + cr + "| |  doms:");
            Iterator dit = as.get_Dominators().iterator();
            while (dit.hasNext()) {
                AugmentedStmt das = (AugmentedStmt)dit.next();
                b.append(" " + das.toString());
            }
            b.append(cr + "| `---" + cr);
        }
        b.append("-" + cr);
        return b.toString();
    }

    private void mirror_PredsSuccs(AugmentedStmt as, UnitGraph ug) {
        Stmt s = as.get_Stmt();
        LinkedList<AugmentedStmt> preds = new LinkedList<AugmentedStmt>();
        LinkedList<AugmentedStmt> succs = new LinkedList<AugmentedStmt>();
        Iterator pit = ug.getPredsOf(s).iterator();
        while (pit.hasNext()) {
            AugmentedStmt po = this.get_AugStmt((Stmt)pit.next());
            if (preds.contains(po)) continue;
            preds.add(po);
        }
        Iterator sit = ug.getSuccsOf(s).iterator();
        while (sit.hasNext()) {
            AugmentedStmt so = this.get_AugStmt((Stmt)sit.next());
            if (succs.contains(so)) continue;
            succs.add(so);
        }
        if (ug instanceof BriefUnitGraph) {
            as.bpreds = preds;
            as.bsuccs = succs;
            if (preds.size() == 0) {
                this.bheads.add(as);
            }
            if (succs.size() == 0) {
                this.btails.add(as);
            }
        } else if (ug instanceof TrapUnitGraph) {
            as.cpreds = preds;
            as.csuccs = succs;
            if (preds.size() == 0) {
                this.cheads.add(as);
            }
            if (succs.size() == 0) {
                this.ctails.add(as);
            }
        } else {
            throw new RuntimeException("Unknown UnitGraph type: " + ug.getClass());
        }
    }

    public IterableSet clone_Body(IterableSet oldBody) {
        Stmt ns;
        HashMap<AugmentedStmt, AugmentedStmt> old2new = new HashMap<AugmentedStmt, AugmentedStmt>();
        HashMap<AugmentedStmt, AugmentedStmt> new2old = new HashMap<AugmentedStmt, AugmentedStmt>();
        IterableSet newBody = new IterableSet();
        Iterator it = oldBody.iterator();
        while (it.hasNext()) {
            AugmentedStmt as = (AugmentedStmt)it.next();
            AugmentedStmt clone = (AugmentedStmt)as.clone();
            this.original2clone.put(as, clone);
            old2new.put(as, clone);
            new2old.put(clone, as);
            newBody.add(clone);
        }
        it = newBody.iterator();
        while (it.hasNext()) {
            AugmentedStmt newAs = (AugmentedStmt)it.next();
            AugmentedStmt oldAs = (AugmentedStmt)new2old.get(newAs);
            this.mirror_PredsSuccs(oldAs, oldAs.bpreds, newAs.bpreds, old2new);
            this.mirror_PredsSuccs(oldAs, oldAs.cpreds, newAs.cpreds, old2new);
            this.mirror_PredsSuccs(oldAs, oldAs.bsuccs, newAs.bsuccs, old2new);
            this.mirror_PredsSuccs(oldAs, oldAs.csuccs, newAs.csuccs, old2new);
        }
        it = newBody.iterator();
        while (it.hasNext()) {
            this.add_AugmentedStmt((AugmentedStmt)it.next());
        }
        HashMap<Stmt, Stmt> so2n = new HashMap<Stmt, Stmt>();
        it = oldBody.iterator();
        while (it.hasNext()) {
            AugmentedStmt as = (AugmentedStmt)it.next();
            Stmt os = as.get_Stmt();
            ns = ((AugmentedStmt)old2new.get(as)).get_Stmt();
            so2n.put(os, ns);
        }
        it = newBody.iterator();
        while (it.hasNext()) {
            Unit[] new_target_list;
            Unit newTgt;
            Unit target;
            AugmentedStmt nas = (AugmentedStmt)it.next();
            AugmentedStmt oas = (AugmentedStmt)new2old.get(nas);
            ns = nas.get_Stmt();
            Stmt os = oas.get_Stmt();
            if (os instanceof IfStmt) {
                Stmt target2 = ((IfStmt)os).getTarget();
                Unit newTgt2 = null;
                newTgt2 = (Unit)so2n.get(target2);
                if (newTgt2 != null) {
                    ((IfStmt)ns).setTarget(newTgt2);
                    continue;
                }
                ((IfStmt)ns).setTarget(target2);
                continue;
            }
            if (os instanceof TableSwitchStmt) {
                TableSwitchStmt otss = (TableSwitchStmt)os;
                TableSwitchStmt ntss = (TableSwitchStmt)ns;
                target = otss.getDefaultTarget();
                newTgt = null;
                newTgt = (Unit)so2n.get(target);
                if (newTgt != null) {
                    ntss.setDefaultTarget(newTgt);
                } else {
                    ntss.setDefaultTarget(target);
                }
                new_target_list = new LinkedList();
                int target_count = otss.getHighIndex() - otss.getLowIndex() + 1;
                for (int i = 0; i < target_count; ++i) {
                    target = otss.getTarget(i);
                    newTgt = null;
                    newTgt = (Unit)so2n.get(target);
                    if (newTgt != null) {
                        new_target_list.add(newTgt);
                        continue;
                    }
                    new_target_list.add(target);
                }
                ntss.setTargets((List)new_target_list);
                continue;
            }
            if (!(os instanceof LookupSwitchStmt)) continue;
            LookupSwitchStmt olss = (LookupSwitchStmt)os;
            LookupSwitchStmt nlss = (LookupSwitchStmt)ns;
            target = olss.getDefaultTarget();
            newTgt = null;
            newTgt = (Unit)so2n.get(target);
            if (newTgt != null) {
                nlss.setDefaultTarget(newTgt);
            } else {
                nlss.setDefaultTarget(target);
            }
            new_target_list = new Unit[olss.getTargetCount()];
            for (int i = 0; i < new_target_list.length; ++i) {
                target = olss.getTarget(i);
                newTgt = null;
                newTgt = (Unit)so2n.get(target);
                new_target_list[i] = newTgt != null ? newTgt : target;
            }
            nlss.setTargets(new_target_list);
            nlss.setLookupValues(olss.getLookupValues());
        }
        return newBody;
    }

    private void mirror_PredsSuccs(AugmentedStmt originalAs, List oldList, List newList, Map old2new) {
        Iterator it = oldList.iterator();
        while (it.hasNext()) {
            AugmentedStmt oldAs = (AugmentedStmt)it.next();
            AugmentedStmt newAs = (AugmentedStmt)old2new.get(oldAs);
            if (newAs != null) {
                newList.add(newAs);
                continue;
            }
            newList.add(oldAs);
            AugmentedStmt clonedAs = (AugmentedStmt)old2new.get(originalAs);
            if (oldList == originalAs.bpreds) {
                oldAs.bsuccs.add(clonedAs);
                continue;
            }
            if (oldList == originalAs.cpreds) {
                oldAs.csuccs.add(clonedAs);
                continue;
            }
            if (oldList == originalAs.bsuccs) {
                oldAs.bpreds.add(clonedAs);
                continue;
            }
            if (oldList == originalAs.csuccs) {
                oldAs.cpreds.add(clonedAs);
                continue;
            }
            throw new RuntimeException("Error mirroring preds and succs in Try block splitting.");
        }
    }

    public void find_Dominators() {
        Iterator asgit = this.aug_list.iterator();
        while (asgit.hasNext()) {
            AugmentedStmt as = (AugmentedStmt)asgit.next();
            if (as.cpreds.size() != 0) {
                if (!as.get_Dominators().isEmpty()) {
                    as.get_Dominators().clear();
                }
                as.get_Dominators().addAll(this.aug_list);
                continue;
            }
            as.get_Dominators().clear();
        }
        IterableSet worklist = new IterableSet();
        worklist.addAll(this.aug_list);
        while (!worklist.isEmpty()) {
            AugmentedStmt as = (AugmentedStmt)worklist.getFirst();
            worklist.removeFirst();
            IterableSet pred_intersection = new IterableSet();
            boolean first_pred = true;
            Iterator pit = as.cpreds.iterator();
            while (pit.hasNext()) {
                AugmentedStmt pas = (AugmentedStmt)pit.next();
                if (first_pred) {
                    pred_intersection.addAll(pas.get_Dominators());
                    if (!pred_intersection.contains(pas)) {
                        pred_intersection.add(pas);
                    }
                    first_pred = false;
                    continue;
                }
                Iterator piit = pred_intersection.snapshotIterator();
                while (piit.hasNext()) {
                    AugmentedStmt pid = (AugmentedStmt)piit.next();
                    if (pas.get_Dominators().contains(pid) || pas == pid) continue;
                    pred_intersection.remove(pid);
                }
            }
            if (as.get_Dominators().equals(pred_intersection)) continue;
            Iterator sit = as.csuccs.iterator();
            while (sit.hasNext()) {
                Object o = sit.next();
                if (worklist.contains(o)) continue;
                worklist.add(o);
            }
            as.get_Dominators().clear();
            as.get_Dominators().addAll(pred_intersection);
        }
    }
}

