/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.internal.SET;

import java.util.Iterator;
import java.util.LinkedList;
import soot.Value;
import soot.dava.DavaBody;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.SET.SETNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.internal.javaRep.DAbruptStmt;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.MonitorStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.util.IterableSet;

public class SETStatementSequenceNode
extends SETNode {
    private DavaBody davaBody;
    private boolean hasContinue;

    public SETStatementSequenceNode(IterableSet body, DavaBody davaBody) {
        super(body);
        this.add_SubBody(body);
        this.davaBody = davaBody;
        this.hasContinue = false;
    }

    public SETStatementSequenceNode(IterableSet body) {
        this(body, null);
    }

    public boolean has_Continue() {
        return this.hasContinue;
    }

    public IterableSet get_NaturalExits() {
        IterableSet c = new IterableSet();
        AugmentedStmt last = (AugmentedStmt)this.get_Body().getLast();
        if (last.csuccs != null && !last.csuccs.isEmpty()) {
            c.add(last);
        }
        return c;
    }

    public ASTNode emit_AST() {
        LinkedList<AugmentedStmt> l = new LinkedList<AugmentedStmt>();
        boolean isStaticInitializer = this.davaBody.getMethod().getName().equals("<clinit>");
        Iterator it = this.get_Body().iterator();
        while (it.hasNext()) {
            AugmentedStmt as = (AugmentedStmt)it.next();
            Stmt s = as.get_Stmt();
            if (this.davaBody != null) {
                if (s instanceof ReturnVoidStmt && isStaticInitializer || s instanceof GotoStmt || s instanceof MonitorStmt || s == this.davaBody.get_ConstructorUnit()) continue;
                if (s instanceof IdentityStmt) {
                    IdentityStmt ids = (IdentityStmt)s;
                    Value rightOp = ids.getRightOp();
                    Value leftOp = ids.getLeftOp();
                    if (this.davaBody.get_ThisLocals().contains(leftOp) || rightOp instanceof ParameterRef || rightOp instanceof CaughtExceptionRef) continue;
                }
            }
            l.add(as);
        }
        if (l.isEmpty()) {
            return null;
        }
        return new ASTStatementSequenceNode(l);
    }

    public AugmentedStmt get_EntryStmt() {
        return (AugmentedStmt)this.get_Body().getFirst();
    }

    public void insert_AbruptStmt(DAbruptStmt stmt) {
        if (this.hasContinue) {
            return;
        }
        this.get_Body().addLast(new AugmentedStmt(stmt));
        this.hasContinue = stmt.is_Continue();
    }

    protected boolean resolve(SETNode parent) {
        throw new RuntimeException("Attempting auto-nest a SETStatementSequenceNode.");
    }
}

