/*
 * Decompiled with CFR 0.152.
 */
package soot.dava;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import soot.Body;
import soot.G;
import soot.Local;
import soot.Modifier;
import soot.PatchingChain;
import soot.RefType;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.dava.Dava;
import soot.dava.DavaBody;
import soot.dava.DavaUnitPrinter;
import soot.dava.internal.AST.ASTNode;
import soot.jimple.InstanceInvokeExpr;
import soot.options.Options;
import soot.tagkit.Tag;
import soot.util.DeterministicHashMap;
import soot.util.IterableSet;

public class DavaPrinter {
    public DavaPrinter(Singletons.Global g) {
    }

    public static DavaPrinter v() {
        return G.v().DavaPrinter();
    }

    private void printLocalsInBody(Body body, PrintWriter out) {
        if (!(body instanceof DavaBody)) {
            throw new RuntimeException("Only DavaBodies should use the DavaLocalPrinter");
        }
        DavaBody davaBody = (DavaBody)body;
        DeterministicHashMap typeToLocals = new DeterministicHashMap(body.getLocalCount() * 2 + 1, 0.7f);
        HashSet params = new HashSet();
        params.addAll(davaBody.get_ParamMap().values());
        params.addAll(davaBody.get_CaughtRefs());
        HashSet thisLocals = davaBody.get_ThisLocals();
        Iterator localIt = body.getLocals().iterator();
        while (localIt.hasNext()) {
            List<Local> localList;
            Local local = (Local)localIt.next();
            if (params.contains(local) || thisLocals.contains(local)) continue;
            Type t = local.getType();
            String typeName = t.toString();
            if (typeToLocals.containsKey(typeName)) {
                localList = (List)typeToLocals.get(typeName);
            } else {
                localList = new ArrayList();
                typeToLocals.put(typeName, localList);
            }
            localList.add(local);
        }
        InstanceInvokeExpr constructorExpr = davaBody.get_ConstructorExpr();
        if (constructorExpr != null) {
            if (davaBody.getMethod().getDeclaringClass().getName().equals(constructorExpr.getMethod().getDeclaringClass().toString())) {
                out.print("        this(");
            } else {
                out.print("        super(");
            }
            Iterator ait = constructorExpr.getArgs().iterator();
            while (ait.hasNext()) {
                out.print(ait.next().toString());
                if (!ait.hasNext()) continue;
                out.print(", ");
            }
            out.print(");\n\n");
        }
        Iterator typeIt = typeToLocals.keySet().iterator();
        while (typeIt.hasNext()) {
            String type = (String)typeIt.next();
            List localList = (List)typeToLocals.get(type);
            Object[] locals = localList.toArray();
            out.print("        ");
            if (type.equals("null_type")) {
                out.print("Object");
            } else {
                out.print(type);
            }
            out.print(" ");
            for (int k = 0; k < locals.length; ++k) {
                if (k != 0) {
                    out.print(", ");
                }
                out.print(((Local)locals[k]).getName());
            }
            out.println(";");
        }
        if (!typeToLocals.isEmpty()) {
            out.println();
        }
    }

    private void printStatementsInBody(Body body, PrintWriter out) {
        PatchingChain units = ((DavaBody)body).getUnits();
        if (units.size() != 1) {
            throw new RuntimeException("DavaBody AST doesn't have single root.");
        }
        DavaUnitPrinter up = new DavaUnitPrinter();
        ((ASTNode)units.getFirst()).toString(up);
        out.print(((Object)up).toString());
    }

    public void printTo(SootClass cl, PrintWriter out) {
        Iterator methodIt;
        Iterator interfaceIt;
        String curPackage = cl.getJavaPackageName();
        if (!curPackage.equals("")) {
            out.println("package " + curPackage + ";");
            out.println();
        }
        IterableSet packagesUsed = new IterableSet();
        if (cl.hasSuperclass()) {
            SootClass superClass = cl.getSuperclass();
            packagesUsed.add(superClass.getJavaPackageName());
        }
        Iterator interfaceIt2 = cl.getInterfaces().iterator();
        while (interfaceIt2.hasNext()) {
            String interfacePackage = ((SootClass)interfaceIt2.next()).getJavaPackageName();
            if (packagesUsed.contains(interfacePackage)) continue;
            packagesUsed.add(interfacePackage);
        }
        Iterator methodIt2 = cl.methodIterator();
        while (methodIt2.hasNext()) {
            String returnPackage;
            Type t;
            SootMethod dm = (SootMethod)methodIt2.next();
            if (dm.hasActiveBody()) {
                packagesUsed = packagesUsed.union(((DavaBody)dm.getActiveBody()).get_PackagesUsed());
            }
            Iterator eit = dm.getExceptions().iterator();
            while (eit.hasNext()) {
                String thrownPackage = ((SootClass)eit.next()).getJavaPackageName();
                if (packagesUsed.contains(thrownPackage)) continue;
                packagesUsed.add(thrownPackage);
            }
            Iterator pit = dm.getParameterTypes().iterator();
            while (pit.hasNext()) {
                String paramPackage;
                t = (Type)pit.next();
                if (!(t instanceof RefType) || packagesUsed.contains(paramPackage = ((RefType)t).getSootClass().getJavaPackageName())) continue;
                packagesUsed.add(paramPackage);
            }
            t = dm.getReturnType();
            if (!(t instanceof RefType) || packagesUsed.contains(returnPackage = ((RefType)t).getSootClass().getJavaPackageName())) continue;
            packagesUsed.add(returnPackage);
        }
        Iterator fieldIt = cl.getFields().iterator();
        while (fieldIt.hasNext()) {
            String fieldPackage;
            Type t;
            SootField f = (SootField)fieldIt.next();
            if (f.isPhantom() || !((t = f.getType()) instanceof RefType) || packagesUsed.contains(fieldPackage = ((RefType)t).getSootClass().getJavaPackageName())) continue;
            packagesUsed.add(fieldPackage);
        }
        if (packagesUsed.contains(curPackage)) {
            packagesUsed.remove(curPackage);
        }
        if (packagesUsed.contains("java.lang")) {
            packagesUsed.remove("java.lang");
        }
        Iterator pit = packagesUsed.iterator();
        while (pit.hasNext()) {
            out.println("import " + (String)pit.next() + ".*;");
        }
        if (!packagesUsed.isEmpty()) {
            out.println();
        }
        packagesUsed.add("java.lang");
        packagesUsed.add(curPackage);
        Dava.v().set_CurrentPackageContext(packagesUsed);
        Dava.v().set_CurrentPackage(curPackage);
        String classPrefix = "";
        classPrefix = classPrefix + " " + Modifier.toString(cl.getModifiers());
        classPrefix = classPrefix.trim();
        if (!cl.isInterface()) {
            classPrefix = classPrefix + " class";
            classPrefix = classPrefix.trim();
        }
        out.print(classPrefix + " " + cl.getShortJavaStyleName());
        if (cl.hasSuperclass() && !cl.getSuperclass().getName().equals("java.lang.Object")) {
            out.print(" extends " + cl.getSuperclass().getName() + "");
        }
        if ((interfaceIt = cl.getInterfaces().iterator()).hasNext()) {
            if (cl.isInterface()) {
                out.print(" extends ");
            } else {
                out.print(" implements ");
            }
            out.print("" + ((SootClass)interfaceIt.next()).getName() + "");
            while (interfaceIt.hasNext()) {
                out.print(", " + ((SootClass)interfaceIt.next()).getName() + "");
            }
        }
        out.println();
        out.println("{");
        Iterator fieldIt2 = cl.getFields().iterator();
        if (fieldIt2.hasNext()) {
            while (fieldIt2.hasNext()) {
                SootField f = (SootField)fieldIt2.next();
                if (f.isPhantom()) continue;
                out.println("    " + f.getDeclaration() + ";");
            }
        }
        if ((methodIt = cl.methodIterator()).hasNext()) {
            if (cl.getMethodCount() != 0) {
                out.println();
            }
            while (methodIt.hasNext()) {
                SootMethod method = (SootMethod)methodIt.next();
                if (method.isPhantom()) continue;
                if (!Modifier.isAbstract(method.getModifiers()) && !Modifier.isNative(method.getModifiers())) {
                    if (!method.hasActiveBody()) {
                        throw new RuntimeException("method " + method.getName() + " has no active body!");
                    }
                    this.printTo(method.getActiveBody(), out);
                    if (!methodIt.hasNext()) continue;
                    out.println();
                    continue;
                }
                out.print("    ");
                out.print(method.getDavaDeclaration());
                out.println(";");
                if (!methodIt.hasNext()) continue;
                out.println();
            }
        }
        out.println("}");
    }

    private void printTo(Body b, PrintWriter out) {
        b.validate();
        String decl = b.getMethod().getDavaDeclaration();
        out.println("    " + decl);
        Iterator tIt = b.getMethod().getTags().iterator();
        while (tIt.hasNext()) {
            Tag t = (Tag)tIt.next();
            if (Options.v().xml_attributes()) continue;
            out.println(t);
        }
        out.println("    {");
        this.printLocalsInBody(b, out);
        this.printStatementsInBody(b, out);
        out.println("    }");
    }
}

