/*
 * Decompiled with CFR 0.152.
 */
package soot.coffi;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootResolver;
import soot.Timer;
import soot.Timers;
import soot.Type;
import soot.UnknownType;
import soot.VoidType;
import soot.coffi.CONSTANT_Class_info;
import soot.coffi.CONSTANT_Double_info;
import soot.coffi.CONSTANT_Float_info;
import soot.coffi.CONSTANT_Integer_info;
import soot.coffi.CONSTANT_Long_info;
import soot.coffi.CONSTANT_String_info;
import soot.coffi.CONSTANT_Utf8_info;
import soot.coffi.ClassFile;
import soot.coffi.CoffiMethodSource;
import soot.coffi.ConstantValue_attribute;
import soot.coffi.Double2ndHalfType;
import soot.coffi.Exception_attribute;
import soot.coffi.InnerClasses_attribute;
import soot.coffi.LocalVariableTable_attribute;
import soot.coffi.Long2ndHalfType;
import soot.coffi.SourceFile_attribute;
import soot.coffi.TypeStack;
import soot.coffi.attribute_info;
import soot.coffi.cp_info;
import soot.coffi.field_info;
import soot.coffi.inner_class_entry;
import soot.coffi.method_info;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NoSuchLocalException;
import soot.options.Options;
import soot.tagkit.ConstantValueTag;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.InnerClassTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.SourceFileTag;
import soot.tagkit.StringConstantValueTag;

public class Util {
    Map classNameToAbbreviation;
    Scene scene;
    Set markedClasses;
    LinkedList classesToResolve;
    int activeOriginalIndex = -1;
    cp_info[] activeConstantPool = null;
    LocalVariableTable_attribute activeVariableTable;
    boolean useFaithfulNaming = false;
    boolean isLocalStore = false;
    boolean isWideLocalStore = false;
    private ArrayList conversionTypes = new ArrayList();
    int nextEasyNameIndex;

    public Util(Singletons.Global g) {
    }

    public static Util v() {
        return G.v().Util();
    }

    public void setFaithfulNaming(boolean v) {
        this.useFaithfulNaming = v;
    }

    void setActiveClassManager(Scene manager) {
        this.scene = manager;
    }

    public void assertResolvedClass(String className) {
        if (!this.scene.containsClass(className)) {
            SootClass newClass = new SootClass(className);
            this.scene.addClass(newClass);
            this.markedClasses.add(newClass);
            this.classesToResolve.addLast(newClass);
        }
    }

    public void assertResolvedClassForType(Type type) {
        if (type instanceof RefType) {
            this.assertResolvedClass(((RefType)type).getClassName());
        } else if (type instanceof ArrayType) {
            this.assertResolvedClassForType(((ArrayType)type).baseType);
        }
    }

    public SootClass getResolvedClass(String className) {
        if (this.scene.containsClass(className)) {
            return this.scene.getSootClass(className);
        }
        SootClass newClass = new SootClass(className);
        this.scene.addClass(newClass);
        this.markedClasses.add(newClass);
        this.classesToResolve.addLast(newClass);
        return newClass;
    }

    public SootClass getResolvedClass2(String className) {
        if (this.scene.containsClass(className)) {
            return this.scene.getSootClass(className);
        }
        SootClass newClass = new SootClass(className);
        this.scene.addClass(newClass);
        return newClass;
    }

    public SootClass resolveClassAndSupportClasses2(String className, InputStream is) {
        method_info methodInfo;
        int i;
        ClassFile coffiClass;
        boolean success;
        Scene cm;
        SootClass newClass = null;
        this.scene = cm = Scene.v();
        if (this.scene.containsClass(className)) {
            newClass = this.scene.getSootClass(className);
        } else {
            newClass = new SootClass(className);
            this.scene.addClass(newClass);
        }
        SootClass bclass = newClass;
        className = bclass.getName();
        if (Options.v().verbose()) {
            G.v().out.println("Resolving " + className + "...");
        }
        if (!(success = (coffiClass = new ClassFile(className)).loadClassFile(is))) {
            if (!Scene.v().allowsPhantomRefs()) {
                throw new RuntimeException("Could not load classfile: " + bclass.getName());
            }
            G.v().out.println("Warning: " + className + " is a phantom class!");
            bclass.setPhantom(true);
            return newClass;
        }
        CONSTANT_Class_info c = (CONSTANT_Class_info)coffiClass.constant_pool[coffiClass.this_class];
        String name = ((CONSTANT_Utf8_info)coffiClass.constant_pool[c.name_index]).convert();
        if (!(name = name.replace('/', '.')).equals(bclass.getName())) {
            throw new RuntimeException("Error: class " + name + " read in from a classfile in which " + bclass.getName() + " was expected.");
        }
        bclass.setModifiers(coffiClass.access_flags & 0xFFFFFFDF);
        if (coffiClass.super_class != 0) {
            CONSTANT_Class_info c2 = (CONSTANT_Class_info)coffiClass.constant_pool[coffiClass.super_class];
            String superName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[c2.name_index]).convert();
            superName = superName.replace('/', '.');
            bclass.setSuperclass(this.getResolvedClass2(superName));
        }
        for (i = 0; i < coffiClass.interfaces_count; ++i) {
            c = (CONSTANT_Class_info)coffiClass.constant_pool[coffiClass.interfaces[i]];
            String interfaceName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[c.name_index]).convert();
            interfaceName = interfaceName.replace('/', '.');
            SootClass interfaceClass = this.getResolvedClass2(interfaceName);
            bclass.addInterface(interfaceClass);
        }
        for (i = 0; i < coffiClass.fields_count; ++i) {
            field_info fieldInfo = coffiClass.fields[i];
            String fieldName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[fieldInfo.name_index]).convert();
            String fieldDescriptor = ((CONSTANT_Utf8_info)coffiClass.constant_pool[fieldInfo.descriptor_index]).convert();
            int modifiers = fieldInfo.access_flags;
            Type fieldType = this.jimpleTypeOfFieldDescriptor(cm, fieldDescriptor);
            bclass.addField(new SootField(fieldName, fieldType, modifiers));
        }
        for (i = 0; i < coffiClass.methods_count; ++i) {
            methodInfo = coffiClass.methods[i];
            String methodName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[methodInfo.name_index]).convert();
            String methodDescriptor = ((CONSTANT_Utf8_info)coffiClass.constant_pool[methodInfo.descriptor_index]).convert();
            Type[] types = this.jimpleTypesOfFieldOrMethodDescriptor(cm, methodDescriptor);
            ArrayList<Type> parameterTypes = new ArrayList<Type>();
            for (int j = 0; j < types.length - 1; ++j) {
                parameterTypes.add(types[j]);
            }
            Type returnType = types[types.length - 1];
            int modifiers = methodInfo.access_flags;
            SootMethod method = new SootMethod(methodName, parameterTypes, returnType, modifiers);
            bclass.addMethod(method);
            methodInfo.jmethod = method;
            for (int j = 0; j < methodInfo.attributes_count; ++j) {
                if (!(methodInfo.attributes[j] instanceof Exception_attribute)) continue;
                Exception_attribute exceptions = (Exception_attribute)methodInfo.attributes[j];
                for (int k = 0; k < exceptions.number_of_exceptions; ++k) {
                    CONSTANT_Class_info c3 = (CONSTANT_Class_info)coffiClass.constant_pool[exceptions.exception_index_table[k]];
                    String exceptionName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[c3.name_index]).convert();
                    exceptionName = exceptionName.replace('/', '.');
                    method.addExceptionIfAbsent(this.getResolvedClass2(exceptionName));
                }
            }
        }
        for (i = 0; i < coffiClass.methods_count; ++i) {
            methodInfo = coffiClass.methods[i];
            methodInfo.jmethod.setSource(new CoffiMethodSource(coffiClass, methodInfo));
        }
        return newClass;
    }

    public void resolveFromClassFile(SootClass aClass, InputStream is, SootResolver sootResolver, Scene cm) {
        attribute_info attr;
        method_info methodInfo;
        int i;
        SootClass bclass = aClass;
        String className = bclass.getName();
        this.setActiveClassManager(cm);
        ClassFile coffiClass = new ClassFile(className);
        boolean success = coffiClass.loadClassFile(is);
        if (!success) {
            if (!Scene.v().allowsPhantomRefs()) {
                throw new RuntimeException("Could not load classfile: " + bclass.getName());
            }
            G.v().out.println("Warning: " + className + " is a phantom class!");
            bclass.setPhantom(true);
            return;
        }
        CONSTANT_Class_info c = (CONSTANT_Class_info)coffiClass.constant_pool[coffiClass.this_class];
        String name = ((CONSTANT_Utf8_info)coffiClass.constant_pool[c.name_index]).convert();
        if (!(name = name.replace('/', '.')).equals(bclass.getName())) {
            throw new RuntimeException("Error: class " + name + " read in from a classfile in which " + bclass.getName() + " was expected.");
        }
        bclass.setModifiers(coffiClass.access_flags & 0xFFFFFFDF);
        if (coffiClass.super_class != 0) {
            CONSTANT_Class_info c2 = (CONSTANT_Class_info)coffiClass.constant_pool[coffiClass.super_class];
            String superName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[c2.name_index]).convert();
            superName = superName.replace('/', '.');
            bclass.setSuperclass(sootResolver.getResolvedClass(superName));
        }
        for (i = 0; i < coffiClass.interfaces_count; ++i) {
            c = (CONSTANT_Class_info)coffiClass.constant_pool[coffiClass.interfaces[i]];
            String interfaceName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[c.name_index]).convert();
            interfaceName = interfaceName.replace('/', '.');
            SootClass interfaceClass = sootResolver.getResolvedClass(interfaceName);
            bclass.addInterface(interfaceClass);
        }
        block8: for (i = 0; i < coffiClass.fields_count; ++i) {
            field_info fieldInfo = coffiClass.fields[i];
            String fieldName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[fieldInfo.name_index]).convert();
            String fieldDescriptor = ((CONSTANT_Utf8_info)coffiClass.constant_pool[fieldInfo.descriptor_index]).convert();
            int modifiers = fieldInfo.access_flags;
            Type fieldType = this.jimpleTypeOfFieldDescriptor(cm, fieldDescriptor);
            SootField field = new SootField(fieldName, fieldType, modifiers);
            bclass.addField(field);
            sootResolver.assertResolvedClassForType(fieldType);
            for (int j = 0; j < fieldInfo.attributes_count; ++j) {
                ConstantValueTag tag;
                if (!(fieldInfo.attributes[j] instanceof ConstantValue_attribute)) continue;
                ConstantValue_attribute attr2 = (ConstantValue_attribute)fieldInfo.attributes[j];
                cp_info cval = coffiClass.constant_pool[attr2.constantvalue_index];
                switch (cval.tag) {
                    case 3: {
                        tag = new IntegerConstantValueTag((int)((CONSTANT_Integer_info)cval).bytes);
                        break;
                    }
                    case 4: {
                        tag = new FloatConstantValueTag((int)((CONSTANT_Float_info)cval).bytes);
                        break;
                    }
                    case 5: {
                        CONSTANT_Long_info lcval = (CONSTANT_Long_info)cval;
                        tag = new LongConstantValueTag((lcval.high << 32) + lcval.low);
                        break;
                    }
                    case 6: {
                        CONSTANT_Double_info dcval = (CONSTANT_Double_info)cval;
                        tag = new DoubleConstantValueTag((dcval.high << 32) + dcval.low);
                        break;
                    }
                    case 8: {
                        CONSTANT_String_info scval = (CONSTANT_String_info)cval;
                        CONSTANT_Utf8_info ucval = (CONSTANT_Utf8_info)coffiClass.constant_pool[scval.string_index];
                        tag = new StringConstantValueTag(ucval.convert());
                        break;
                    }
                    default: {
                        throw new RuntimeException("unexpected ConstantValue: " + cval);
                    }
                }
                field.addTag(tag);
                continue block8;
            }
        }
        for (i = 0; i < coffiClass.methods_count; ++i) {
            methodInfo = coffiClass.methods[i];
            if (coffiClass.constant_pool[methodInfo.name_index] == null) {
                G.v().out.println("method index: " + methodInfo.toName(coffiClass.constant_pool));
                throw new RuntimeException("method has no name");
            }
            String methodName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[methodInfo.name_index]).convert();
            String methodDescriptor = ((CONSTANT_Utf8_info)coffiClass.constant_pool[methodInfo.descriptor_index]).convert();
            Type[] types = this.jimpleTypesOfFieldOrMethodDescriptor(cm, methodDescriptor);
            ArrayList<Type> parameterTypes = new ArrayList<Type>();
            for (int j = 0; j < types.length - 1; ++j) {
                sootResolver.assertResolvedClassForType(types[j]);
                parameterTypes.add(types[j]);
            }
            Type returnType = types[types.length - 1];
            sootResolver.assertResolvedClassForType(returnType);
            int modifiers = methodInfo.access_flags;
            SootMethod method = new SootMethod(methodName, parameterTypes, returnType, modifiers);
            bclass.addMethod(method);
            methodInfo.jmethod = method;
            for (int j = 0; j < methodInfo.attributes_count; ++j) {
                if (!(methodInfo.attributes[j] instanceof Exception_attribute)) continue;
                Exception_attribute exceptions = (Exception_attribute)methodInfo.attributes[j];
                for (int k = 0; k < exceptions.number_of_exceptions; ++k) {
                    CONSTANT_Class_info c3 = (CONSTANT_Class_info)coffiClass.constant_pool[exceptions.exception_index_table[k]];
                    String exceptionName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[c3.name_index]).convert();
                    exceptionName = exceptionName.replace('/', '.');
                    method.addExceptionIfAbsent(sootResolver.getResolvedClass(exceptionName));
                }
            }
            for (int k = 0; k < coffiClass.constant_pool_count; ++k) {
                if (!(coffiClass.constant_pool[k] instanceof CONSTANT_Class_info)) continue;
                CONSTANT_Class_info c4 = (CONSTANT_Class_info)coffiClass.constant_pool[k];
                String desc = ((CONSTANT_Utf8_info)coffiClass.constant_pool[c4.name_index]).convert();
                String name2 = desc.replace('/', '.');
                if (name2.startsWith("[")) {
                    sootResolver.assertResolvedClassForType(this.jimpleTypeOfFieldDescriptor(cm, desc));
                    continue;
                }
                sootResolver.assertResolvedClass(name2);
            }
        }
        for (i = 0; i < coffiClass.methods_count; ++i) {
            methodInfo = coffiClass.methods[i];
            methodInfo.jmethod.setSource(new CoffiMethodSource(coffiClass, methodInfo));
        }
        for (i = 0; i < coffiClass.attributes_count; ++i) {
            if (!(coffiClass.attributes[i] instanceof SourceFile_attribute)) continue;
            attr = (SourceFile_attribute)coffiClass.attributes[i];
            bclass.addTag(new SourceFileTag(((CONSTANT_Utf8_info)coffiClass.constant_pool[attr.sourcefile_index]).convert()));
            break;
        }
        for (i = 0; i < coffiClass.attributes_count; ++i) {
            if (!(coffiClass.attributes[i] instanceof InnerClasses_attribute)) continue;
            attr = (InnerClasses_attribute)coffiClass.attributes[i];
            for (int j = 0; j < ((InnerClasses_attribute)attr).inner_classes_length; ++j) {
                inner_class_entry e = ((InnerClasses_attribute)attr).inner_classes[j];
                String inner = null;
                String outer = null;
                String name3 = null;
                if (e.inner_class_index != 0) {
                    inner = ((CONSTANT_Utf8_info)coffiClass.constant_pool[((CONSTANT_Class_info)coffiClass.constant_pool[e.inner_class_index]).name_index]).convert();
                }
                if (e.outer_class_index != 0) {
                    outer = ((CONSTANT_Utf8_info)coffiClass.constant_pool[((CONSTANT_Class_info)coffiClass.constant_pool[e.outer_class_index]).name_index]).convert();
                }
                if (e.name_index != 0) {
                    name3 = ((CONSTANT_Utf8_info)coffiClass.constant_pool[e.name_index]).convert();
                }
                bclass.addTag(new InnerClassTag(inner, outer, name3, e.access_flags));
            }
            break;
        }
    }

    public SootClass resolveClassAndSupportClasses(String className, Scene cm) {
        Timer timer = new Timer("timer");
        Timer buildTimer = new Timer("build");
        Timers.v().resolverTimer.start();
        this.setActiveClassManager(cm);
        this.classesToResolve = new LinkedList();
        this.markedClasses = new HashSet();
        SootClass newClass = this.getResolvedClass(className);
        while (!this.classesToResolve.isEmpty()) {
            method_info methodInfo;
            int i;
            SootClass bclass = (SootClass)this.classesToResolve.removeFirst();
            className = bclass.getName();
            timer.start();
            if (Options.v().verbose()) {
                G.v().out.println("Resolving " + className + "...");
            }
            ClassFile coffiClass = new ClassFile(className);
            boolean success = coffiClass.loadClassFile();
            timer.end();
            if (!success) {
                if (!Scene.v().allowsPhantomRefs()) {
                    throw new RuntimeException("Could not load classfile: " + bclass.getName());
                }
                G.v().out.println("Warning: " + className + " is a phantom class!");
                bclass.setPhantom(true);
                continue;
            }
            buildTimer.start();
            CONSTANT_Class_info c = (CONSTANT_Class_info)coffiClass.constant_pool[coffiClass.this_class];
            String name = ((CONSTANT_Utf8_info)coffiClass.constant_pool[c.name_index]).convert();
            name = name.replace('/', '.');
            if (!name.equals(bclass.getName())) {
                throw new RuntimeException("Error: class " + name + " read in from a classfile in which " + bclass.getName() + " was expected.");
            }
            bclass.setModifiers(coffiClass.access_flags & 0xFFFFFFDF);
            if (coffiClass.super_class != 0) {
                CONSTANT_Class_info c2 = (CONSTANT_Class_info)coffiClass.constant_pool[coffiClass.super_class];
                String superName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[c2.name_index]).convert();
                superName = superName.replace('/', '.');
                bclass.setSuperclass(this.getResolvedClass(superName));
            }
            for (i = 0; i < coffiClass.interfaces_count; ++i) {
                c = (CONSTANT_Class_info)coffiClass.constant_pool[coffiClass.interfaces[i]];
                String interfaceName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[c.name_index]).convert();
                interfaceName = interfaceName.replace('/', '.');
                SootClass interfaceClass = this.getResolvedClass(interfaceName);
                bclass.addInterface(interfaceClass);
            }
            for (i = 0; i < coffiClass.fields_count; ++i) {
                field_info fieldInfo = coffiClass.fields[i];
                String fieldName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[fieldInfo.name_index]).convert();
                String fieldDescriptor = ((CONSTANT_Utf8_info)coffiClass.constant_pool[fieldInfo.descriptor_index]).convert();
                int modifiers = fieldInfo.access_flags;
                Type fieldType = this.jimpleTypeOfFieldDescriptor(cm, fieldDescriptor);
                bclass.addField(new SootField(fieldName, fieldType, modifiers));
                this.assertResolvedClassForType(fieldType);
            }
            for (i = 0; i < coffiClass.methods_count; ++i) {
                methodInfo = coffiClass.methods[i];
                String methodName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[methodInfo.name_index]).convert();
                String methodDescriptor = ((CONSTANT_Utf8_info)coffiClass.constant_pool[methodInfo.descriptor_index]).convert();
                Type[] types = this.jimpleTypesOfFieldOrMethodDescriptor(cm, methodDescriptor);
                ArrayList<Type> parameterTypes = new ArrayList<Type>();
                for (int j = 0; j < types.length - 1; ++j) {
                    this.assertResolvedClassForType(types[j]);
                    parameterTypes.add(types[j]);
                }
                Type returnType = types[types.length - 1];
                this.assertResolvedClassForType(returnType);
                int modifiers = methodInfo.access_flags;
                SootMethod method = new SootMethod(methodName, parameterTypes, returnType, modifiers);
                bclass.addMethod(method);
                methodInfo.jmethod = method;
                for (int j = 0; j < methodInfo.attributes_count; ++j) {
                    if (!(methodInfo.attributes[j] instanceof Exception_attribute)) continue;
                    Exception_attribute exceptions = (Exception_attribute)methodInfo.attributes[j];
                    for (int k = 0; k < exceptions.number_of_exceptions; ++k) {
                        CONSTANT_Class_info c3 = (CONSTANT_Class_info)coffiClass.constant_pool[exceptions.exception_index_table[k]];
                        String exceptionName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[c3.name_index]).convert();
                        exceptionName = exceptionName.replace('/', '.');
                        method.addExceptionIfAbsent(this.getResolvedClass(exceptionName));
                    }
                }
                for (int k = 0; k < coffiClass.constant_pool_count; ++k) {
                    if (!(coffiClass.constant_pool[k] instanceof CONSTANT_Class_info)) continue;
                    CONSTANT_Class_info c4 = (CONSTANT_Class_info)coffiClass.constant_pool[k];
                    String desc = ((CONSTANT_Utf8_info)coffiClass.constant_pool[c4.name_index]).convert();
                    String name2 = desc.replace('/', '.');
                    if (name2.startsWith("[")) {
                        this.assertResolvedClassForType(this.jimpleTypeOfFieldDescriptor(cm, desc));
                        continue;
                    }
                    this.assertResolvedClass(name2);
                }
            }
            for (i = 0; i < coffiClass.methods_count; ++i) {
                methodInfo = coffiClass.methods[i];
                methodInfo.jmethod.setSource(new CoffiMethodSource(coffiClass, methodInfo));
            }
            buildTimer.end();
        }
        Timers.v().resolverTimer.end();
        return newClass;
    }

    Type jimpleReturnTypeOfMethodDescriptor(Scene cm, String descriptor) {
        Type[] types = this.jimpleTypesOfFieldOrMethodDescriptor(cm, descriptor);
        return types[types.length - 1];
    }

    /*
     * WARNING - void declaration
     */
    public Type[] jimpleTypesOfFieldOrMethodDescriptor(Scene cm, String descriptor) {
        this.conversionTypes.clear();
        while (descriptor.length() != 0) {
            void var5_5;
            Type baseType;
            boolean isArray = false;
            int numDimensions = 0;
            if (descriptor.startsWith("(") || descriptor.startsWith(")")) {
                descriptor = descriptor.substring(1);
                continue;
            }
            while (descriptor.startsWith("[")) {
                isArray = true;
                ++numDimensions;
                descriptor = descriptor.substring(1);
            }
            if (descriptor.startsWith("B")) {
                baseType = ByteType.v();
                descriptor = descriptor.substring(1);
            } else if (descriptor.startsWith("C")) {
                baseType = CharType.v();
                descriptor = descriptor.substring(1);
            } else if (descriptor.startsWith("D")) {
                baseType = DoubleType.v();
                descriptor = descriptor.substring(1);
            } else if (descriptor.startsWith("F")) {
                baseType = FloatType.v();
                descriptor = descriptor.substring(1);
            } else if (descriptor.startsWith("I")) {
                baseType = IntType.v();
                descriptor = descriptor.substring(1);
            } else if (descriptor.startsWith("J")) {
                baseType = LongType.v();
                descriptor = descriptor.substring(1);
            } else if (descriptor.startsWith("L")) {
                int index = descriptor.indexOf(59);
                if (index == -1) {
                    throw new RuntimeException("Class reference has no ending ;");
                }
                String className = descriptor.substring(1, index);
                baseType = RefType.v(className.replace('/', '.'));
                descriptor = descriptor.substring(index + 1);
            } else if (descriptor.startsWith("S")) {
                baseType = ShortType.v();
                descriptor = descriptor.substring(1);
            } else if (descriptor.startsWith("Z")) {
                baseType = BooleanType.v();
                descriptor = descriptor.substring(1);
            } else if (descriptor.startsWith("V")) {
                baseType = VoidType.v();
                descriptor = descriptor.substring(1);
            } else {
                throw new RuntimeException("Unknown field type!");
            }
            Object t = isArray ? ArrayType.v((Type)var5_5, numDimensions) : var5_5;
            this.conversionTypes.add(t);
        }
        return this.conversionTypes.toArray(new Type[0]);
    }

    /*
     * WARNING - void declaration
     */
    public Type jimpleTypeOfFieldDescriptor(Scene cm, String descriptor) {
        void var5_5;
        Type baseType;
        boolean isArray = false;
        int numDimensions = 0;
        while (descriptor.startsWith("[")) {
            isArray = true;
            ++numDimensions;
            descriptor = descriptor.substring(1);
        }
        if (descriptor.equals("B")) {
            baseType = ByteType.v();
        } else if (descriptor.equals("C")) {
            baseType = CharType.v();
        } else if (descriptor.equals("D")) {
            baseType = DoubleType.v();
        } else if (descriptor.equals("F")) {
            baseType = FloatType.v();
        } else if (descriptor.equals("I")) {
            baseType = IntType.v();
        } else if (descriptor.equals("J")) {
            baseType = LongType.v();
        } else if (descriptor.equals("V")) {
            baseType = VoidType.v();
        } else if (descriptor.startsWith("L")) {
            if (!descriptor.endsWith(";")) {
                throw new RuntimeException("Class reference does not end with ;");
            }
            String className = descriptor.substring(1, descriptor.length() - 1);
            baseType = RefType.v(className.replace('/', '.'));
        } else if (descriptor.equals("S")) {
            baseType = ShortType.v();
        } else if (descriptor.equals("Z")) {
            baseType = BooleanType.v();
        } else {
            throw new RuntimeException("Unknown field type: " + descriptor);
        }
        if (isArray) {
            return ArrayType.v((Type)var5_5, numDimensions);
        }
        return var5_5;
    }

    void resetEasyNames() {
        this.nextEasyNameIndex = 0;
    }

    String getNextEasyName() {
        int justifiedIndex;
        String[] easyNames = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        if ((justifiedIndex = this.nextEasyNameIndex++) >= easyNames.length) {
            return "local" + (justifiedIndex - easyNames.length);
        }
        return easyNames[justifiedIndex];
    }

    void setClassNameToAbbreviation(Map map) {
        this.classNameToAbbreviation = map;
    }

    Local getLocalForStackOp(JimpleBody listBody, TypeStack typeStack, int index) {
        if (typeStack.get(index).equals(Double2ndHalfType.v()) || typeStack.get(index).equals(Long2ndHalfType.v())) {
            --index;
        }
        return this.getLocalCreatingIfNecessary(listBody, "$stack" + index, UnknownType.v());
    }

    String getAbbreviationOfClassName(String className) {
        StringBuffer buffer = new StringBuffer(new Character(className.charAt(0)).toString());
        int periodIndex = 0;
        while ((periodIndex = className.indexOf(46, periodIndex + 1)) != -1) {
            buffer.append(Character.toLowerCase(className.charAt(periodIndex + 1)));
        }
        return buffer.toString();
    }

    String getNormalizedClassName(String className) {
        if ((className = className.replace('/', '.')).endsWith(";")) {
            className = className.substring(0, className.length() - 1);
        }
        int numDimensions = 0;
        while (className.startsWith("[")) {
            ++numDimensions;
            className = className.substring(1, className.length());
            className = className + "[]";
        }
        if (numDimensions != 0) {
            if (!className.startsWith("L")) {
                throw new RuntimeException("For some reason an array reference does not start with L");
            }
            className = className.substring(1, className.length());
        }
        return className;
    }

    public Local getLocal(Body b, String name) throws NoSuchLocalException {
        Iterator localIt = b.getLocals().iterator();
        while (localIt.hasNext()) {
            Local local = (Local)localIt.next();
            if (!local.getName().equals(name)) continue;
            return local;
        }
        throw new NoSuchLocalException();
    }

    public boolean declaresLocal(Body b, String localName) {
        Iterator localIt = b.getLocals().iterator();
        while (localIt.hasNext()) {
            Local local = (Local)localIt.next();
            if (!local.getName().equals(localName)) continue;
            return true;
        }
        return false;
    }

    Local getLocalCreatingIfNecessary(JimpleBody listBody, String name, Type type) {
        if (this.declaresLocal(listBody, name)) {
            return this.getLocal(listBody, name);
        }
        Local l = Jimple.v().newLocal(name, type);
        listBody.getLocals().add(l);
        return l;
    }

    Local getLocalForIndex(JimpleBody listBody, int index) {
        String name = null;
        boolean assignedName = false;
        if (this.useFaithfulNaming && this.activeVariableTable != null && this.activeOriginalIndex != -1) {
            if (this.isLocalStore) {
                ++this.activeOriginalIndex;
            }
            if (this.isWideLocalStore) {
                ++this.activeOriginalIndex;
            }
            if ((name = this.activeVariableTable.getLocalVariableName(this.activeConstantPool, index, this.activeOriginalIndex)) != null) {
                assignedName = true;
            }
        }
        if (!assignedName) {
            name = "l" + index;
        }
        if (this.declaresLocal(listBody, name)) {
            return this.getLocal(listBody, name);
        }
        Local l = Jimple.v().newLocal(name, UnknownType.v());
        listBody.getLocals().add(l);
        return l;
    }

    boolean isValidJimpleName(String prospectiveName) {
        for (int i = 0; i < prospectiveName.length(); ++i) {
            char c = prospectiveName.charAt(i);
            if (i == 0 && c >= '0' && c <= '9') {
                return false;
            }
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '$') continue;
            return false;
        }
        return true;
    }
}

