/*
 * Decompiled with CFR 0.152.
 */
package soot.coffi;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import soot.G;
import soot.Scene;
import soot.Timers;
import soot.coffi.ByteCode;
import soot.coffi.CONSTANT_Class_info;
import soot.coffi.CONSTANT_Double_info;
import soot.coffi.CONSTANT_Fieldref_info;
import soot.coffi.CONSTANT_Float_info;
import soot.coffi.CONSTANT_Integer_info;
import soot.coffi.CONSTANT_InterfaceMethodref_info;
import soot.coffi.CONSTANT_Long_info;
import soot.coffi.CONSTANT_Methodref_info;
import soot.coffi.CONSTANT_NameAndType_info;
import soot.coffi.CONSTANT_String_info;
import soot.coffi.CONSTANT_Utf8_info;
import soot.coffi.Code_attribute;
import soot.coffi.ConstantValue_attribute;
import soot.coffi.Exception_attribute;
import soot.coffi.Generic_attribute;
import soot.coffi.InnerClasses_attribute;
import soot.coffi.Instruction;
import soot.coffi.Instruction_Unknown;
import soot.coffi.LineNumberTable_attribute;
import soot.coffi.LocalVariableTable_attribute;
import soot.coffi.SourceFile_attribute;
import soot.coffi.attribute_info;
import soot.coffi.cp_info;
import soot.coffi.exception_table_entry;
import soot.coffi.field_info;
import soot.coffi.inner_class_entry;
import soot.coffi.line_number_table_entry;
import soot.coffi.local_variable_table_entry;
import soot.coffi.method_info;
import soot.util.SourceLocator;

public class ClassFile {
    static final long MAGIC = 3405691582L;
    static final short ACC_PUBLIC = 1;
    static final short ACC_PRIVATE = 2;
    static final short ACC_PROTECTED = 4;
    static final short ACC_STATIC = 8;
    static final short ACC_FINAL = 16;
    static final short ACC_SUPER = 32;
    static final short ACC_VOLATILE = 64;
    static final short ACC_TRANSIENT = 128;
    static final short ACC_INTERFACE = 512;
    static final short ACC_ABSTRACT = 1024;
    static final short ACC_STRICT = 2048;
    static final short ACC_UNKNOWN = 28672;
    static final String DESC_BYTE = "B";
    static final String DESC_CHAR = "C";
    static final String DESC_DOUBLE = "D";
    static final String DESC_FLOAT = "F";
    static final String DESC_INT = "I";
    static final String DESC_LONG = "J";
    static final String DESC_OBJECT = "L";
    static final String DESC_SHORT = "S";
    static final String DESC_BOOLEAN = "Z";
    static final String DESC_VOID = "V";
    static final String DESC_ARRAY = "[";
    boolean debug;
    String fn;
    long magic;
    int minor_version;
    int major_version;
    public int constant_pool_count;
    public cp_info[] constant_pool;
    public int access_flags;
    public int this_class;
    public int super_class;
    public int interfaces_count;
    public int[] interfaces;
    public int fields_count;
    public field_info[] fields;
    public int methods_count;
    public method_info[] methods;
    public int attributes_count;
    attribute_info[] attributes;

    public ClassFile(String nfn) {
        this.fn = nfn;
    }

    public String toString() {
        return this.constant_pool[this.this_class].toString(this.constant_pool);
    }

    public boolean loadClassFile() {
        InputStream classFileStream;
        Object f = null;
        Timers.v().locatorTimer.start();
        try {
            String cp = Scene.v().getSootClassPath();
            classFileStream = cp != null ? SourceLocator.v().getInputStreamOf(cp, this.fn) : SourceLocator.v().getInputStreamOf(this.fn);
        }
        catch (ClassNotFoundException e) {
            Timers.v().locatorTimer.end();
            return false;
        }
        Timers.v().locatorTimer.end();
        return this.loadClassFile(classFileStream);
    }

    public boolean loadClassFile(InputStream is) {
        ByteArrayInputStream f = null;
        InputStream classFileStream = is;
        Timers.v().readTimer.start();
        try {
            byte[] data = new byte[classFileStream.available()];
            classFileStream.read(data);
            f = new ByteArrayInputStream(data);
        }
        catch (IOException e) {
            // empty catch block
        }
        Timers.v().readTimer.end();
        DataInputStream d = new DataInputStream(f);
        boolean b = this.readClass(d);
        try {
            classFileStream.close();
            d.close();
            ((InputStream)f).close();
        }
        catch (IOException e) {
            G.v().out.println("IOException with " + this.fn + ": " + e.getMessage());
            return false;
        }
        return b;
    }

    /*
     * WARNING - void declaration
     */
    boolean saveClassFile() {
        void var1_1;
        FileOutputStream f;
        try {
            f = new FileOutputStream(this.fn);
        }
        catch (FileNotFoundException e) {
            if (this.fn.indexOf(".class") >= 0) {
                G.v().out.println("Can't find " + this.fn);
                return false;
            }
            this.fn = this.fn + ".class";
            try {
                f = new FileOutputStream(this.fn);
            }
            catch (FileNotFoundException ee) {
                G.v().out.println("Can't find " + this.fn);
                return false;
            }
            catch (IOException ee) {
                G.v().out.println("IOException with " + this.fn + ": " + ee.getMessage());
                return false;
            }
        }
        catch (IOException e) {
            G.v().out.println("IOException with " + this.fn + ": " + e.getMessage());
            return false;
        }
        DataOutputStream d = new DataOutputStream((OutputStream)var1_1);
        if (d == null) {
            try {
                var1_1.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return false;
        }
        boolean b = this.writeClass(d);
        try {
            d.close();
            var1_1.close();
        }
        catch (IOException e) {
            G.v().out.println("IOException with " + this.fn + ": " + e.getMessage());
            return false;
        }
        return b;
    }

    static String access_string(int af, String separator) {
        boolean hasone = false;
        String s = "";
        if ((af & 1) != 0) {
            s = "public";
            hasone = true;
        }
        if ((af & 2) != 0) {
            if (hasone) {
                s = s + separator;
            } else {
                hasone = true;
            }
            s = s + "private";
        }
        if ((af & 4) != 0) {
            if (hasone) {
                s = s + separator;
            } else {
                hasone = true;
            }
            s = s + "protected";
        }
        if ((af & 8) != 0) {
            if (hasone) {
                s = s + separator;
            } else {
                hasone = true;
            }
            s = s + "static";
        }
        if ((af & 0x10) != 0) {
            if (hasone) {
                s = s + separator;
            } else {
                hasone = true;
            }
            s = s + "final";
        }
        if ((af & 0x20) != 0) {
            if (hasone) {
                s = s + separator;
            } else {
                hasone = true;
            }
            s = s + "super";
        }
        if ((af & 0x40) != 0) {
            if (hasone) {
                s = s + separator;
            } else {
                hasone = true;
            }
            s = s + "volatile";
        }
        if ((af & 0x80) != 0) {
            if (hasone) {
                s = s + separator;
            } else {
                hasone = true;
            }
            s = s + "transient";
        }
        if ((af & 0x200) != 0) {
            if (hasone) {
                s = s + separator;
            } else {
                hasone = true;
            }
            s = s + "interface";
        }
        if ((af & 0x400) != 0) {
            if (hasone) {
                s = s + separator;
            } else {
                hasone = true;
            }
            s = s + "abstract";
        }
        if ((af & 0x800) != 0) {
            if (hasone) {
                s = s + separator;
            } else {
                hasone = true;
            }
            s = s + "strict";
        }
        if ((af & 0x7000) != 0) {
            if (hasone) {
                s = s + separator;
            } else {
                hasone = true;
            }
            s = s + "unknown";
        }
        return s;
    }

    public boolean readClass(DataInputStream d) {
        try {
            this.magic = (long)d.readInt() & 0xFFFFFFFFL;
            if (this.magic != 3405691582L) {
                G.v().out.println("Wrong magic number in " + this.fn + ": " + this.magic);
                return false;
            }
            this.minor_version = d.readUnsignedShort();
            this.major_version = d.readUnsignedShort();
            this.constant_pool_count = d.readUnsignedShort();
            if (!this.readConstantPool(d)) {
                return false;
            }
            this.access_flags = d.readUnsignedShort();
            this.this_class = d.readUnsignedShort();
            this.super_class = d.readUnsignedShort();
            this.interfaces_count = d.readUnsignedShort();
            if (this.interfaces_count > 0) {
                this.interfaces = new int[this.interfaces_count];
                for (int j = 0; j < this.interfaces_count; ++j) {
                    this.interfaces[j] = d.readUnsignedShort();
                }
            }
            Timers.v().fieldTimer.start();
            this.fields_count = d.readUnsignedShort();
            this.readFields(d);
            Timers.v().fieldTimer.end();
            Timers.v().methodTimer.start();
            this.methods_count = d.readUnsignedShort();
            this.readMethods(d);
            Timers.v().methodTimer.end();
            Timers.v().attributeTimer.start();
            this.attributes_count = d.readUnsignedShort();
            if (this.attributes_count > 0) {
                this.attributes = new attribute_info[this.attributes_count];
                this.readAttributes(d, this.attributes_count, this.attributes);
            }
            Timers.v().attributeTimer.end();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException with " + this.fn + ": " + e.getMessage());
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean readConstantPool(DataInputStream d) throws IOException {
        this.constant_pool = new cp_info[this.constant_pool_count];
        boolean skipone = false;
        for (int i = 1; i < this.constant_pool_count; ++i) {
            void var3_5;
            if (skipone) {
                skipone = false;
                continue;
            }
            byte tag = (byte)d.readUnsignedByte();
            switch (tag) {
                case 7: {
                    cp_info cp = new CONSTANT_Class_info();
                    ((CONSTANT_Class_info)cp).name_index = d.readUnsignedShort();
                    if (!this.debug) break;
                    G.v().out.println("Constant pool[" + i + "]: Class");
                    break;
                }
                case 9: {
                    cp_info cp = new CONSTANT_Fieldref_info();
                    ((CONSTANT_Fieldref_info)cp).class_index = d.readUnsignedShort();
                    ((CONSTANT_Fieldref_info)cp).name_and_type_index = d.readUnsignedShort();
                    if (!this.debug) break;
                    G.v().out.println("Constant pool[" + i + "]: Fieldref");
                    break;
                }
                case 10: {
                    cp_info cp = new CONSTANT_Methodref_info();
                    ((CONSTANT_Methodref_info)cp).class_index = d.readUnsignedShort();
                    ((CONSTANT_Methodref_info)cp).name_and_type_index = d.readUnsignedShort();
                    if (!this.debug) break;
                    G.v().out.println("Constant pool[" + i + "]: Methodref");
                    break;
                }
                case 11: {
                    cp_info cp = new CONSTANT_InterfaceMethodref_info();
                    ((CONSTANT_InterfaceMethodref_info)cp).class_index = d.readUnsignedShort();
                    ((CONSTANT_InterfaceMethodref_info)cp).name_and_type_index = d.readUnsignedShort();
                    if (!this.debug) break;
                    G.v().out.println("Constant pool[" + i + "]: InterfaceMethodref");
                    break;
                }
                case 8: {
                    cp_info cp = new CONSTANT_String_info();
                    ((CONSTANT_String_info)cp).string_index = d.readUnsignedShort();
                    if (!this.debug) break;
                    G.v().out.println("Constant pool[" + i + "]: String");
                    break;
                }
                case 3: {
                    cp_info cp = new CONSTANT_Integer_info();
                    ((CONSTANT_Integer_info)cp).bytes = d.readInt();
                    if (!this.debug) break;
                    G.v().out.println("Constant pool[" + i + "]: Integer = " + ((CONSTANT_Integer_info)cp).bytes);
                    break;
                }
                case 4: {
                    cp_info cp = new CONSTANT_Float_info();
                    ((CONSTANT_Float_info)cp).bytes = d.readInt();
                    if (!this.debug) break;
                    G.v().out.println("Constant pool[" + i + "]: Float = " + ((CONSTANT_Float_info)cp).convert());
                    break;
                }
                case 5: {
                    cp_info cp = new CONSTANT_Long_info();
                    ((CONSTANT_Long_info)cp).high = (long)d.readInt() & 0xFFFFFFFFL;
                    ((CONSTANT_Long_info)cp).low = (long)d.readInt() & 0xFFFFFFFFL;
                    if (this.debug) {
                        String temp = cp.toString(this.constant_pool);
                        G.v().out.println("Constant pool[" + i + "]: Long = " + temp);
                    }
                    skipone = true;
                    break;
                }
                case 6: {
                    cp_info cp = new CONSTANT_Double_info();
                    ((CONSTANT_Double_info)cp).high = (long)d.readInt() & 0xFFFFFFFFL;
                    ((CONSTANT_Double_info)cp).low = (long)d.readInt() & 0xFFFFFFFFL;
                    if (this.debug) {
                        G.v().out.println("Constant pool[" + i + "]: Double = " + ((CONSTANT_Double_info)cp).convert());
                    }
                    skipone = true;
                    break;
                }
                case 12: {
                    cp_info cp = new CONSTANT_NameAndType_info();
                    ((CONSTANT_NameAndType_info)cp).name_index = d.readUnsignedShort();
                    ((CONSTANT_NameAndType_info)cp).descriptor_index = d.readUnsignedShort();
                    if (!this.debug) break;
                    G.v().out.println("Constant pool[" + i + "]: Name and Type");
                    break;
                }
                case 1: {
                    CONSTANT_Utf8_info cputf8 = new CONSTANT_Utf8_info(d);
                    cp_info cp = G.v().CONSTANT_Utf8_collector().add(cputf8);
                    if (!this.debug) break;
                    G.v().out.println("Constant pool[" + i + "]: Utf8 = \"" + cputf8.convert() + "\"");
                    break;
                }
                default: {
                    G.v().out.println("Unknown tag in constant pool: " + tag + " at entry " + i);
                    return false;
                }
            }
            var3_5.tag = tag;
            this.constant_pool[i] = var3_5;
        }
        return true;
    }

    protected boolean readAttributes(DataInputStream d, int attributes_count, attribute_info[] ai) throws IOException {
        attribute_info a = null;
        for (int i = 0; i < attributes_count; ++i) {
            attribute_info la;
            Object e;
            int k;
            attribute_info ca;
            int j = d.readUnsignedShort();
            long len = (long)d.readInt() & 0xFFFFFFFFL;
            String s = ((CONSTANT_Utf8_info)this.constant_pool[j]).convert();
            if (s.compareTo("SourceFile") == 0) {
                SourceFile_attribute sa = new SourceFile_attribute();
                sa.sourcefile_index = d.readUnsignedShort();
                a = sa;
            } else if (s.compareTo("ConstantValue") == 0) {
                ca = new ConstantValue_attribute();
                ca.constantvalue_index = d.readUnsignedShort();
                a = ca;
            } else if (s.compareTo("Code") == 0) {
                ca = new Code_attribute();
                ((Code_attribute)ca).max_stack = d.readUnsignedShort();
                ((Code_attribute)ca).max_locals = d.readUnsignedShort();
                ((Code_attribute)ca).code_length = (long)d.readInt() & 0xFFFFFFFFL;
                ((Code_attribute)ca).code = new byte[(int)((Code_attribute)ca).code_length];
                d.read(((Code_attribute)ca).code);
                ((Code_attribute)ca).exception_table_length = d.readUnsignedShort();
                ((Code_attribute)ca).exception_table = new exception_table_entry[((Code_attribute)ca).exception_table_length];
                for (k = 0; k < ((Code_attribute)ca).exception_table_length; ++k) {
                    e = new exception_table_entry();
                    ((exception_table_entry)e).start_pc = d.readUnsignedShort();
                    ((exception_table_entry)e).end_pc = d.readUnsignedShort();
                    ((exception_table_entry)e).handler_pc = d.readUnsignedShort();
                    ((exception_table_entry)e).catch_type = d.readUnsignedShort();
                    ((Code_attribute)ca).exception_table[k] = e;
                }
                ((Code_attribute)ca).attributes_count = d.readUnsignedShort();
                ((Code_attribute)ca).attributes = new attribute_info[((Code_attribute)ca).attributes_count];
                this.readAttributes(d, ((Code_attribute)ca).attributes_count, ((Code_attribute)ca).attributes);
                a = ca;
            } else if (s.compareTo("Exceptions") == 0) {
                Exception_attribute ea = new Exception_attribute();
                ea.number_of_exceptions = d.readUnsignedShort();
                if (ea.number_of_exceptions > 0) {
                    ea.exception_index_table = new int[ea.number_of_exceptions];
                    for (k = 0; k < ea.number_of_exceptions; ++k) {
                        ea.exception_index_table[k] = d.readUnsignedShort();
                    }
                }
                a = ea;
            } else if (s.compareTo("LineNumberTable") == 0) {
                la = new LineNumberTable_attribute();
                la.line_number_table_length = d.readUnsignedShort();
                la.line_number_table = new line_number_table_entry[la.line_number_table_length];
                for (k = 0; k < la.line_number_table_length; ++k) {
                    e = new line_number_table_entry();
                    ((line_number_table_entry)e).start_pc = d.readUnsignedShort();
                    ((line_number_table_entry)e).line_number = d.readUnsignedShort();
                    la.line_number_table[k] = e;
                }
                a = la;
            } else if (s.compareTo("LocalVariableTable") == 0) {
                la = new LocalVariableTable_attribute();
                ((LocalVariableTable_attribute)la).local_variable_table_length = d.readUnsignedShort();
                ((LocalVariableTable_attribute)la).local_variable_table = new local_variable_table_entry[((LocalVariableTable_attribute)la).local_variable_table_length];
                for (k = 0; k < ((LocalVariableTable_attribute)la).local_variable_table_length; ++k) {
                    e = new local_variable_table_entry();
                    ((local_variable_table_entry)e).start_pc = d.readUnsignedShort();
                    ((local_variable_table_entry)e).length = d.readUnsignedShort();
                    ((local_variable_table_entry)e).name_index = d.readUnsignedShort();
                    ((local_variable_table_entry)e).descriptor_index = d.readUnsignedShort();
                    ((local_variable_table_entry)e).index = d.readUnsignedShort();
                    ((LocalVariableTable_attribute)la).local_variable_table[k] = e;
                }
                a = la;
            } else if (s.compareTo("InnerClasses") == 0) {
                InnerClasses_attribute ia = new InnerClasses_attribute();
                ia.inner_classes_length = d.readUnsignedShort();
                ia.inner_classes = new inner_class_entry[ia.inner_classes_length];
                for (k = 0; k < ia.inner_classes_length; ++k) {
                    e = new inner_class_entry();
                    ((inner_class_entry)e).inner_class_index = d.readUnsignedShort();
                    ((inner_class_entry)e).outer_class_index = d.readUnsignedShort();
                    ((inner_class_entry)e).name_index = d.readUnsignedShort();
                    ((inner_class_entry)e).access_flags = d.readUnsignedShort();
                    ia.inner_classes[k] = e;
                }
                a = ia;
            } else {
                Generic_attribute ga = new Generic_attribute();
                if (len > 0L) {
                    ga.info = new byte[(int)len];
                    d.read(ga.info);
                }
                a = ga;
            }
            a.attribute_name = j;
            a.attribute_length = len;
            ai[i] = a;
        }
        return true;
    }

    protected boolean readFields(DataInputStream d) throws IOException {
        this.fields = new field_info[this.fields_count];
        for (int i = 0; i < this.fields_count; ++i) {
            field_info fi = new field_info();
            fi.access_flags = d.readUnsignedShort();
            fi.name_index = d.readUnsignedShort();
            fi.descriptor_index = d.readUnsignedShort();
            fi.attributes_count = d.readUnsignedShort();
            if (fi.attributes_count > 0) {
                fi.attributes = new attribute_info[fi.attributes_count];
                this.readAttributes(d, fi.attributes_count, fi.attributes);
            }
            this.fields[i] = fi;
        }
        return true;
    }

    protected boolean readMethods(DataInputStream d) throws IOException {
        this.methods = new method_info[this.methods_count];
        for (int i = 0; i < this.methods_count; ++i) {
            method_info mi = new method_info();
            mi.access_flags = d.readUnsignedShort();
            mi.name_index = d.readUnsignedShort();
            mi.descriptor_index = d.readUnsignedShort();
            mi.attributes_count = d.readUnsignedShort();
            CONSTANT_Utf8_info ci = (CONSTANT_Utf8_info)this.constant_pool[mi.name_index];
            if (mi.attributes_count > 0) {
                mi.attributes = new attribute_info[mi.attributes_count];
                this.readAttributes(d, mi.attributes_count, mi.attributes);
                for (int j = 0; j < mi.attributes_count; ++j) {
                    if (!(mi.attributes[j] instanceof Code_attribute)) continue;
                    mi.code_attr = (Code_attribute)mi.attributes[j];
                    break;
                }
            }
            this.methods[i] = mi;
        }
        return true;
    }

    protected boolean writeConstantPool(DataOutputStream dd) throws IOException {
        boolean skipone = false;
        block13: for (int i = 1; i < this.constant_pool_count; ++i) {
            if (skipone) {
                skipone = false;
                continue;
            }
            cp_info cp = this.constant_pool[i];
            dd.writeByte(cp.tag);
            switch (cp.tag) {
                case 7: {
                    dd.writeShort(((CONSTANT_Class_info)cp).name_index);
                    continue block13;
                }
                case 9: {
                    dd.writeShort(((CONSTANT_Fieldref_info)cp).class_index);
                    dd.writeShort(((CONSTANT_Fieldref_info)cp).name_and_type_index);
                    continue block13;
                }
                case 10: {
                    dd.writeShort(((CONSTANT_Methodref_info)cp).class_index);
                    dd.writeShort(((CONSTANT_Methodref_info)cp).name_and_type_index);
                    continue block13;
                }
                case 11: {
                    dd.writeShort(((CONSTANT_InterfaceMethodref_info)cp).class_index);
                    dd.writeShort(((CONSTANT_InterfaceMethodref_info)cp).name_and_type_index);
                    continue block13;
                }
                case 8: {
                    dd.writeShort(((CONSTANT_String_info)cp).string_index);
                    continue block13;
                }
                case 3: {
                    dd.writeInt((int)((CONSTANT_Integer_info)cp).bytes);
                    continue block13;
                }
                case 4: {
                    dd.writeInt((int)((CONSTANT_Float_info)cp).bytes);
                    continue block13;
                }
                case 5: {
                    dd.writeInt((int)((CONSTANT_Long_info)cp).high);
                    dd.writeInt((int)((CONSTANT_Long_info)cp).low);
                    skipone = true;
                    continue block13;
                }
                case 6: {
                    dd.writeInt((int)((CONSTANT_Double_info)cp).high);
                    dd.writeInt((int)((CONSTANT_Double_info)cp).low);
                    skipone = true;
                    continue block13;
                }
                case 12: {
                    dd.writeShort(((CONSTANT_NameAndType_info)cp).name_index);
                    dd.writeShort(((CONSTANT_NameAndType_info)cp).descriptor_index);
                    continue block13;
                }
                case 1: {
                    ((CONSTANT_Utf8_info)cp).writeBytes(dd);
                    continue block13;
                }
                default: {
                    G.v().out.println("Unknown tag in constant pool: " + cp.tag);
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean writeAttributes(DataOutputStream dd, int attributes_count, attribute_info[] ai) throws IOException {
        attribute_info a = null;
        for (int i = 0; i < attributes_count; ++i) {
            attribute_info la;
            Object e;
            int k;
            attribute_info ca;
            a = ai[i];
            dd.writeShort(a.attribute_name);
            dd.writeInt((int)a.attribute_length);
            if (a instanceof SourceFile_attribute) {
                SourceFile_attribute sa = (SourceFile_attribute)a;
                dd.writeShort(sa.sourcefile_index);
                continue;
            }
            if (a instanceof ConstantValue_attribute) {
                ca = (ConstantValue_attribute)a;
                dd.writeShort(ca.constantvalue_index);
                continue;
            }
            if (a instanceof Code_attribute) {
                ca = (Code_attribute)a;
                dd.writeShort(((Code_attribute)ca).max_stack);
                dd.writeShort(((Code_attribute)ca).max_locals);
                dd.writeInt((int)((Code_attribute)ca).code_length);
                dd.write(((Code_attribute)ca).code, 0, (int)((Code_attribute)ca).code_length);
                dd.writeShort(((Code_attribute)ca).exception_table_length);
                for (k = 0; k < ((Code_attribute)ca).exception_table_length; ++k) {
                    e = ((Code_attribute)ca).exception_table[k];
                    dd.writeShort(((exception_table_entry)e).start_pc);
                    dd.writeShort(((exception_table_entry)e).end_pc);
                    dd.writeShort(((exception_table_entry)e).handler_pc);
                    dd.writeShort(((exception_table_entry)e).catch_type);
                }
                dd.writeShort(((Code_attribute)ca).attributes_count);
                if (((Code_attribute)ca).attributes_count <= 0) continue;
                this.writeAttributes(dd, ((Code_attribute)ca).attributes_count, ((Code_attribute)ca).attributes);
                continue;
            }
            if (a instanceof Exception_attribute) {
                Exception_attribute ea = (Exception_attribute)a;
                dd.writeShort(ea.number_of_exceptions);
                if (ea.number_of_exceptions <= 0) continue;
                for (k = 0; k < ea.number_of_exceptions; ++k) {
                    dd.writeShort(ea.exception_index_table[k]);
                }
                continue;
            }
            if (a instanceof LineNumberTable_attribute) {
                la = (LineNumberTable_attribute)a;
                dd.writeShort(la.line_number_table_length);
                for (k = 0; k < la.line_number_table_length; ++k) {
                    e = la.line_number_table[k];
                    dd.writeShort(((line_number_table_entry)e).start_pc);
                    dd.writeShort(((line_number_table_entry)e).line_number);
                }
                continue;
            }
            if (a instanceof LocalVariableTable_attribute) {
                la = (LocalVariableTable_attribute)a;
                dd.writeShort(((LocalVariableTable_attribute)la).local_variable_table_length);
                for (k = 0; k < ((LocalVariableTable_attribute)la).local_variable_table_length; ++k) {
                    e = ((LocalVariableTable_attribute)la).local_variable_table[k];
                    dd.writeShort(((local_variable_table_entry)e).start_pc);
                    dd.writeShort(((local_variable_table_entry)e).length);
                    dd.writeShort(((local_variable_table_entry)e).name_index);
                    dd.writeShort(((local_variable_table_entry)e).descriptor_index);
                    dd.writeShort(((local_variable_table_entry)e).index);
                }
                continue;
            }
            G.v().out.println("Generic/Unknown Attribute in output");
            Generic_attribute ga = (Generic_attribute)a;
            if (ga.attribute_length <= 0L) continue;
            dd.write(ga.info, 0, (int)ga.attribute_length);
        }
        return true;
    }

    protected boolean writeFields(DataOutputStream dd) throws IOException {
        for (int i = 0; i < this.fields_count; ++i) {
            field_info fi = this.fields[i];
            dd.writeShort(fi.access_flags);
            dd.writeShort(fi.name_index);
            dd.writeShort(fi.descriptor_index);
            dd.writeShort(fi.attributes_count);
            if (fi.attributes_count <= 0) continue;
            this.writeAttributes(dd, fi.attributes_count, fi.attributes);
        }
        return true;
    }

    protected boolean writeMethods(DataOutputStream dd) throws IOException {
        for (int i = 0; i < this.methods_count; ++i) {
            method_info mi = this.methods[i];
            dd.writeShort(mi.access_flags);
            dd.writeShort(mi.name_index);
            dd.writeShort(mi.descriptor_index);
            dd.writeShort(mi.attributes_count);
            if (mi.attributes_count <= 0) continue;
            this.writeAttributes(dd, mi.attributes_count, mi.attributes);
        }
        return true;
    }

    boolean writeClass(DataOutputStream dd) {
        try {
            dd.writeInt((int)this.magic);
            dd.writeShort(this.minor_version);
            dd.writeShort(this.major_version);
            dd.writeShort(this.constant_pool_count);
            if (!this.writeConstantPool(dd)) {
                return false;
            }
            dd.writeShort(this.access_flags);
            dd.writeShort(this.this_class);
            dd.writeShort(this.super_class);
            dd.writeShort(this.interfaces_count);
            if (this.interfaces_count > 0) {
                for (int j = 0; j < this.interfaces_count; ++j) {
                    dd.writeShort(this.interfaces[j]);
                }
            }
            dd.writeShort(this.fields_count);
            this.writeFields(dd);
            dd.writeShort(this.methods_count);
            this.writeMethods(dd);
            dd.writeShort(this.attributes_count);
            if (this.attributes_count > 0) {
                this.writeAttributes(dd, this.attributes_count, this.attributes);
            }
        }
        catch (IOException e) {
            G.v().out.println("IOException with " + this.fn + ": " + e.getMessage());
            return false;
        }
        return true;
    }

    public Instruction parseMethod(method_info m) {
        Instruction head = null;
        Instruction tail = null;
        ByteCode bc = new ByteCode();
        Code_attribute ca = m.locate_code_attribute();
        if (ca == null) {
            return null;
        }
        int j = 0;
        while ((long)j < ca.code_length) {
            Instruction inst = bc.disassemble_bytecode(ca.code, j);
            inst.originalIndex = j;
            if (inst instanceof Instruction_Unknown) {
                G.v().out.println("Unknown instruction in \"" + m.toName(this.constant_pool) + "\" at offset " + j);
                G.v().out.println(" bytecode = " + (inst.code & 0xFF));
            }
            j = inst.nextOffset(j);
            if (head == null) {
                head = inst;
            } else {
                tail.next = inst;
                inst.prev = tail;
            }
            tail = inst;
        }
        bc.build(head);
        for (j = 0; j < ca.exception_table_length; ++j) {
            exception_table_entry e = ca.exception_table[j];
            e.start_inst = bc.locateInst(e.start_pc);
            e.end_inst = (long)e.end_pc == ca.code_length ? null : bc.locateInst(e.end_pc);
            e.handler_inst = bc.locateInst(e.handler_pc);
            if (e.handler_inst == null) continue;
            e.handler_inst.labelled = true;
        }
        m.instructions = head;
        for (int k = 0; k < ca.attributes.length; ++k) {
            if (!(ca.attributes[k] instanceof LineNumberTable_attribute)) continue;
            LineNumberTable_attribute lntattr = (LineNumberTable_attribute)ca.attributes[k];
            for (int l = 0; l < lntattr.line_number_table.length; ++l) {
                lntattr.line_number_table[l].start_inst = bc.locateInst(lntattr.line_number_table[l].start_pc);
            }
        }
        return head;
    }

    public void parse() {
        for (int i = 0; i < this.methods_count; ++i) {
            method_info mi = this.methods[i];
            mi.instructions = this.parseMethod(mi);
        }
    }

    int relabel(Instruction i) {
        int index = 0;
        while (i != null) {
            i.label = index;
            index = i.nextOffset(index);
            i = i.next;
        }
        return index;
    }

    byte[] unparseMethod(method_info m) {
        m.cfg.reconstructInstructions();
        int codesize = this.relabel(m.instructions);
        byte[] bc = new byte[codesize];
        if (bc == null) {
            G.v().out.println("Warning: can't allocate memory for recompile");
            return null;
        }
        Instruction i = m.instructions;
        codesize = 0;
        while (i != null) {
            codesize = i.compile(bc, codesize);
            i = i.next;
        }
        if (codesize != bc.length) {
            G.v().out.println("Warning: code size doesn't match array length!");
        }
        return bc;
    }

    void unparse() {
        for (int i = 0; i < this.methods_count; ++i) {
            method_info mi = this.methods[i];
            Code_attribute ca = mi.locate_code_attribute();
            if (ca == null) continue;
            byte[] bc = this.unparseMethod(mi);
            if (bc == null) {
                G.v().out.println("Recompile of " + mi.toName(this.constant_pool) + " failed!");
                continue;
            }
            ca.code_length = bc.length;
            ca.code = bc;
            for (int j = 0; j < ca.exception_table_length; ++j) {
                exception_table_entry e = ca.exception_table[j];
                e.start_pc = e.start_inst.label;
                e.end_pc = e.end_inst != null ? e.end_inst.label : (int)ca.code_length;
                e.handler_pc = e.handler_inst.label;
            }
        }
    }

    static String parseMethodDesc_return(String s) {
        int j = s.lastIndexOf(41);
        if (j >= 0) {
            return ClassFile.parseDesc(s.substring(j + 1), ",");
        }
        return ClassFile.parseDesc(s, ",");
    }

    static String parseMethodDesc_params(String s) {
        int j;
        int i = s.indexOf(40);
        if (i >= 0 && (j = s.indexOf(41, i + 1)) >= 0) {
            return ClassFile.parseDesc(s.substring(i + 1, j), ",");
        }
        return "<parse error>";
    }

    static String parseDesc(String desc, String sep) {
        String params = "";
        int arraylevel = 0;
        boolean didone = false;
        int len = desc.length();
        for (int i = 0; i < len; ++i) {
            String param;
            char c = desc.charAt(i);
            if (c == DESC_BYTE.charAt(0)) {
                param = "byte";
            } else if (c == DESC_CHAR.charAt(0)) {
                param = "char";
            } else if (c == DESC_DOUBLE.charAt(0)) {
                param = "double";
            } else if (c == DESC_FLOAT.charAt(0)) {
                param = "float";
            } else if (c == DESC_INT.charAt(0)) {
                param = "int";
            } else if (c == DESC_LONG.charAt(0)) {
                param = "long";
            } else if (c == DESC_SHORT.charAt(0)) {
                param = "short";
            } else if (c == DESC_BOOLEAN.charAt(0)) {
                param = "boolean";
            } else if (c == DESC_VOID.charAt(0)) {
                param = "void";
            } else {
                if (c == DESC_ARRAY.charAt(0)) {
                    ++arraylevel;
                    continue;
                }
                if (c == DESC_OBJECT.charAt(0)) {
                    int j = desc.indexOf(59, i + 1);
                    if (j < 0) {
                        G.v().out.println("Warning: Parse error -- can't find a ; in " + desc.substring(i + 1));
                        param = "<error>";
                    } else {
                        if (j - i > 10 && desc.substring(i + 1, i + 11).compareTo("java/lang/") == 0) {
                            i += 10;
                        }
                        param = desc.substring(i + 1, j);
                        param = param.replace('/', '.');
                        i = j;
                    }
                } else {
                    param = "???";
                }
            }
            if (didone) {
                params = params + sep;
            }
            params = params + param;
            while (arraylevel > 0) {
                params = params + "[]";
                --arraylevel;
            }
            didone = true;
        }
        return params;
    }

    method_info findMethod(String s) {
        for (int i = 0; i < this.methods_count; ++i) {
            method_info m = this.methods[i];
            if (!s.equals(m.toName(this.constant_pool))) continue;
            return m;
        }
        return null;
    }

    void listMethods() {
        for (int i = 0; i < this.methods_count; ++i) {
            G.v().out.println(this.methods[i].prototype(this.constant_pool));
        }
    }

    void listConstantPool() {
        for (int i = 1; i < this.constant_pool_count; ++i) {
            cp_info c = this.constant_pool[i];
            G.v().out.println(DESC_ARRAY + i + "] " + c.typeName() + "=" + c.toString(this.constant_pool));
            if (this.constant_pool[i].tag != 5 && this.constant_pool[i].tag != 6) continue;
            ++i;
        }
    }

    void listFields() {
        for (int i = 0; i < this.fields_count; ++i) {
            field_info fi = this.fields[i];
            G.v().out.print(fi.prototype(this.constant_pool));
            for (int j = 0; j < fi.attributes_count; ++j) {
                CONSTANT_Utf8_info cm = (CONSTANT_Utf8_info)this.constant_pool[fi.attributes[j].attribute_name];
                if (cm.convert().compareTo("ConstantValue") != 0) continue;
                ConstantValue_attribute cva = (ConstantValue_attribute)fi.attributes[j];
                G.v().out.print(" = " + this.constant_pool[cva.constantvalue_index].toString(this.constant_pool));
                break;
            }
            G.v().out.println(";");
        }
    }

    void moveMethod(String m, int pos) {
        G.v().out.println("Moving " + m + " to position " + pos + " of " + this.methods_count);
        for (int i = 0; i < this.methods_count; ++i) {
            if (m.compareTo(this.methods[i].toName(this.constant_pool)) != 0) continue;
            method_info mthd = this.methods[i];
            if (i > pos) {
                for (int j = i; j > pos && j > 0; --j) {
                    this.methods[j] = this.methods[j - 1];
                }
                this.methods[pos] = mthd;
            } else if (i < pos) {
                for (int j = i; j < pos && j < this.methods_count - 1; ++j) {
                    this.methods[j] = this.methods[j + 1];
                }
                this.methods[pos] = mthd;
            }
            return;
        }
    }

    boolean descendsFrom(ClassFile cf) {
        return this.descendsFrom(cf.toString());
    }

    boolean descendsFrom(String cname) {
        cp_info cf = this.constant_pool[this.super_class];
        if (cf.toString(this.constant_pool).compareTo(cname) == 0) {
            return true;
        }
        for (int i = 0; i < this.interfaces_count; ++i) {
            cf = this.constant_pool[this.interfaces[i]];
            if (cf.toString(this.constant_pool).compareTo(cname) != 0) continue;
            return true;
        }
        return false;
    }

    boolean isSterile() {
        return (this.access_flags & 1) == 0 || (this.access_flags & 0x10) != 0;
    }

    boolean sameClass(String cfn) {
        String s = cfn;
        int i = s.lastIndexOf(".class");
        if (i > 0) {
            s = s.substring(0, i);
        }
        return s.compareTo(this.toString()) == 0;
    }

    String fieldName(int i) {
        return this.fields[i].toName(this.constant_pool);
    }
}

