/*
 * Decompiled with CFR 0.152.
 */
package soot;

public class Modifier {
    public static final int ABSTRACT = 1024;
    public static final int FINAL = 16;
    public static final int INTERFACE = 512;
    public static final int NATIVE = 256;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int PUBLIC = 1;
    public static final int STATIC = 8;
    public static final int SYNCHRONIZED = 32;
    public static final int TRANSIENT = 128;
    public static final int VOLATILE = 64;

    private Modifier() {
    }

    public static boolean isAbstract(int m) {
        return (m & 0x400) != 0;
    }

    public static boolean isFinal(int m) {
        return (m & 0x10) != 0;
    }

    public static boolean isInterface(int m) {
        return (m & 0x200) != 0;
    }

    public static boolean isNative(int m) {
        return (m & 0x100) != 0;
    }

    public static boolean isPrivate(int m) {
        return (m & 2) != 0;
    }

    public static boolean isProtected(int m) {
        return (m & 4) != 0;
    }

    public static boolean isPublic(int m) {
        return (m & 1) != 0;
    }

    public static boolean isStatic(int m) {
        return (m & 8) != 0;
    }

    public static boolean isSynchronized(int m) {
        return (m & 0x20) != 0;
    }

    public static boolean isTransient(int m) {
        return (m & 0x80) != 0;
    }

    public static boolean isVolatile(int m) {
        return (m & 0x40) != 0;
    }

    public static String toString(int m) {
        StringBuffer buffer = new StringBuffer();
        if (Modifier.isPublic(m)) {
            buffer.append("public ");
        } else if (Modifier.isPrivate(m)) {
            buffer.append("private ");
        } else if (Modifier.isProtected(m)) {
            buffer.append("protected ");
        }
        if (Modifier.isAbstract(m)) {
            buffer.append("abstract ");
        }
        if (Modifier.isInterface(m)) {
            buffer.append("interface ");
        }
        if (Modifier.isStatic(m)) {
            buffer.append("static ");
        }
        if (Modifier.isFinal(m)) {
            buffer.append("final ");
        }
        if (Modifier.isSynchronized(m)) {
            buffer.append("synchronized ");
        }
        if (Modifier.isNative(m)) {
            buffer.append("native ");
        }
        if (Modifier.isTransient(m)) {
            buffer.append("transient ");
        }
        if (Modifier.isVolatile(m)) {
            buffer.append("volatile ");
        }
        return buffer.toString().trim();
    }
}

