/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import soot.ArrayType;
import soot.Modifier;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.SpecialInvokeExpr;
import soot.util.ArraySet;
import soot.util.Chain;

public class Hierarchy {
    HashMap classToSubclasses;
    HashMap interfaceToSubinterfaces;
    HashMap classToDirSubclasses;
    HashMap interfaceToDirSubinterfaces;
    HashMap interfaceToDirImplementers;
    int state;
    Scene sc = Scene.v();

    public Hierarchy() {
        SootClass c;
        this.state = this.sc.getState();
        Chain allClasses = this.sc.getClasses();
        this.classToSubclasses = new HashMap(allClasses.size() * 2 + 1, 0.7f);
        this.interfaceToSubinterfaces = new HashMap(allClasses.size() * 2 + 1, 0.7f);
        this.classToDirSubclasses = new HashMap(allClasses.size() * 2 + 1, 0.7f);
        this.interfaceToDirSubinterfaces = new HashMap(allClasses.size() * 2 + 1, 0.7f);
        this.interfaceToDirImplementers = new HashMap(allClasses.size() * 2 + 1, 0.7f);
        Iterator classesIt = allClasses.iterator();
        while (classesIt.hasNext()) {
            c = (SootClass)classesIt.next();
            if (c.isInterface()) {
                this.interfaceToDirSubinterfaces.put(c, new ArrayList());
                this.interfaceToDirImplementers.put(c, new ArrayList());
                continue;
            }
            this.classToDirSubclasses.put(c, new ArrayList());
        }
        classesIt = allClasses.iterator();
        while (classesIt.hasNext()) {
            c = (SootClass)classesIt.next();
            if (!c.hasSuperclass()) continue;
            if (c.isInterface()) {
                Iterator subIt = c.getInterfaces().iterator();
                while (subIt.hasNext()) {
                    SootClass i = (SootClass)subIt.next();
                    List l = (List)this.interfaceToDirSubinterfaces.get(i);
                    l.add(c);
                }
                continue;
            }
            List l = (List)this.classToDirSubclasses.get(c.getSuperclass());
            l.add(c);
            Iterator subIt = c.getInterfaces().iterator();
            while (subIt.hasNext()) {
                SootClass i = (SootClass)subIt.next();
                l = (List)this.interfaceToDirImplementers.get(i);
                l.add(c);
            }
        }
        classesIt = allClasses.iterator();
        while (classesIt.hasNext()) {
            c = (SootClass)classesIt.next();
            if (!c.isInterface()) continue;
            List imp = (List)this.interfaceToDirImplementers.get(c);
            ArraySet s = new ArraySet();
            Iterator impIt = imp.iterator();
            while (impIt.hasNext()) {
                SootClass c0 = (SootClass)impIt.next();
                s.addAll(this.getSubclassesOfIncluding(c0));
            }
            imp.clear();
            imp.addAll(s);
        }
        classesIt = allClasses.iterator();
        while (classesIt.hasNext()) {
            c = (SootClass)classesIt.next();
            if (c.isInterface()) {
                this.interfaceToDirSubinterfaces.put(c, Collections.unmodifiableList((List)this.interfaceToDirSubinterfaces.get(c)));
                this.interfaceToDirImplementers.put(c, Collections.unmodifiableList((List)this.interfaceToDirImplementers.get(c)));
                continue;
            }
            this.classToDirSubclasses.put(c, Collections.unmodifiableList((List)this.classToDirSubclasses.get(c)));
        }
    }

    private void checkState() {
        if (this.state != this.sc.getState()) {
            throw new ConcurrentModificationException("Scene changed for Hierarchy!");
        }
    }

    public List getSubclassesOfIncluding(SootClass c) {
        if (c.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        l.addAll(this.getSubclassesOf(c));
        l.add(c);
        return Collections.unmodifiableList(l);
    }

    public List getSubclassesOf(SootClass c) {
        if (c.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        this.checkState();
        if (this.classToSubclasses.get(c) != null) {
            return (List)this.classToSubclasses.get(c);
        }
        List l = new ArrayList();
        ListIterator it = ((List)this.classToDirSubclasses.get(c)).listIterator();
        while (it.hasNext()) {
            l.addAll(this.getSubclassesOfIncluding((SootClass)it.next()));
        }
        l = Collections.unmodifiableList(l);
        this.classToSubclasses.put(c, l);
        return l;
    }

    public List getSuperclassesOfIncluding(SootClass c) {
        List l = this.getSuperclassesOf(c);
        ArrayList<SootClass> al = new ArrayList<SootClass>();
        al.add(c);
        al.addAll(l);
        return Collections.unmodifiableList(al);
    }

    public List getSuperclassesOf(SootClass c) {
        if (c.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        this.checkState();
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        SootClass cl = c;
        while (cl.hasSuperclass()) {
            l.add(cl.getSuperclass());
            cl = cl.getSuperclass();
        }
        return Collections.unmodifiableList(l);
    }

    public List getSubinterfacesOfIncluding(SootClass c) {
        if (!c.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        l.addAll(this.getSubinterfacesOf(c));
        l.add(c);
        return Collections.unmodifiableList(l);
    }

    public List getSubinterfacesOf(SootClass c) {
        if (!c.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        this.checkState();
        if (this.interfaceToSubinterfaces.get(c) != null) {
            return (List)this.interfaceToSubinterfaces.get(c);
        }
        ArrayList l = new ArrayList();
        ListIterator it = ((List)this.interfaceToDirSubinterfaces.get(c)).listIterator();
        while (it.hasNext()) {
            l.addAll(this.getSubinterfacesOfIncluding((SootClass)it.next()));
        }
        this.interfaceToSubinterfaces.put(c, Collections.unmodifiableList(l));
        return Collections.unmodifiableList(l);
    }

    public List getSuperinterfacesOf(SootClass c) {
        throw new RuntimeException("Not implemented yet!");
    }

    public List getDirectSuperclassesOf(SootClass c) {
        throw new RuntimeException("Not implemented yet!");
    }

    public List getDirectSubclassesOf(SootClass c) {
        if (c.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        this.checkState();
        return Collections.unmodifiableList((List)this.classToDirSubclasses.get(c));
    }

    public List getDirectSubclassesOfIncluding(SootClass c) {
        if (c.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        this.checkState();
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        l.addAll((List)this.classToDirSubclasses.get(c));
        l.add(c);
        return Collections.unmodifiableList(l);
    }

    public List getDirectSuperinterfacesOf(SootClass c) {
        throw new RuntimeException("Not implemented yet!");
    }

    public List getDirectSubinterfacesOf(SootClass c) {
        if (!c.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        this.checkState();
        return (List)this.interfaceToDirSubinterfaces.get(c);
    }

    public List getDirectSubinterfacesOfIncluding(SootClass c) {
        if (!c.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        this.checkState();
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        l.addAll((List)this.interfaceToDirSubinterfaces.get(c));
        l.add(c);
        return Collections.unmodifiableList(l);
    }

    public List getDirectImplementersOf(SootClass i) {
        if (!i.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        this.checkState();
        return Collections.unmodifiableList((List)this.interfaceToDirImplementers.get(i));
    }

    public List getImplementersOf(SootClass i) {
        if (!i.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        this.checkState();
        Iterator it = this.getSubinterfacesOfIncluding(i).iterator();
        ArraySet set = new ArraySet();
        while (it.hasNext()) {
            SootClass c = (SootClass)it.next();
            set.addAll((Collection)this.getDirectImplementersOf(c));
        }
        ArrayList l = new ArrayList();
        l.addAll(set);
        return Collections.unmodifiableList(l);
    }

    public boolean isClassSubclassOf(SootClass child, SootClass possibleParent) {
        return this.getSuperclassesOf(child).contains(possibleParent);
    }

    public boolean isClassSubclassOfIncluding(SootClass child, SootClass possibleParent) {
        return this.getSuperclassesOfIncluding(child).contains(possibleParent);
    }

    public boolean isClassDirectSubclassOf(SootClass c, SootClass c2) {
        throw new RuntimeException("Not implemented yet!");
    }

    public boolean isClassSuperclassOf(SootClass parent, SootClass possibleChild) {
        return this.getSubclassesOf(parent).contains(possibleChild);
    }

    public boolean isClassSuperclassOfIncluding(SootClass parent, SootClass possibleChild) {
        return this.getSubclassesOfIncluding(parent).contains(possibleChild);
    }

    public boolean isInterfaceSubinterfaceOf(SootClass child, SootClass possibleParent) {
        return this.getSubinterfacesOf(possibleParent).contains(child);
    }

    public boolean isInterfaceDirectSubinterfaceOf(SootClass child, SootClass possibleParent) {
        return this.getDirectSubinterfacesOf(possibleParent).contains(child);
    }

    public SootClass getLeastCommonSuperclassOf(SootClass c1, SootClass c2) {
        throw new RuntimeException("Not implemented yet!");
    }

    private boolean isVisible(SootClass from, SootMethod m) {
        if (m.isPublic()) {
            return true;
        }
        if (m.isPrivate()) {
            return from.equals(m.getDeclaringClass());
        }
        if (m.isProtected()) {
            return this.isClassSubclassOfIncluding(from, m.getDeclaringClass());
        }
        return from.getJavaPackageName().equals(m.getDeclaringClass().getJavaPackageName());
    }

    public SootMethod resolveConcreteDispatch(SootClass concreteType, SootMethod m) {
        this.checkState();
        if (concreteType.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        Iterator it = this.getSuperclassesOfIncluding(concreteType).iterator();
        String methodSig = m.getSubSignature();
        while (it.hasNext()) {
            SootClass c = (SootClass)it.next();
            if (!c.declaresMethod(methodSig) || !this.isVisible(c, m)) continue;
            return c.getMethod(methodSig);
        }
        throw new RuntimeException("could not resolve concrete dispatch!\nType: " + concreteType + "\nMethod: " + m);
    }

    public List resolveConcreteDispatch(List classes, SootMethod m) {
        this.checkState();
        ArraySet s = new ArraySet();
        Iterator classesIt = classes.iterator();
        while (classesIt.hasNext()) {
            Object cls = classesIt.next();
            if (cls instanceof RefType) {
                s.add(this.resolveConcreteDispatch(((RefType)cls).getSootClass(), m));
                continue;
            }
            if (cls instanceof ArrayType) {
                s.add(this.resolveConcreteDispatch(RefType.v("java.lang.Object").getSootClass(), m));
                continue;
            }
            throw new RuntimeException("Unable to resolve concrete dispatch of type " + cls);
        }
        ArrayList l = new ArrayList();
        l.addAll(s);
        return Collections.unmodifiableList(l);
    }

    public List resolveAbstractDispatch(SootClass c, SootMethod m) {
        this.checkState();
        Iterator classesIt = null;
        if (c.isInterface()) {
            classesIt = this.getImplementersOf(c).iterator();
            HashSet classes = new HashSet();
            while (classesIt.hasNext()) {
                classes.addAll(this.getSubclassesOfIncluding((SootClass)classesIt.next()));
            }
            classesIt = classes.iterator();
        } else {
            classesIt = this.getSubclassesOfIncluding(c).iterator();
        }
        ArraySet s = new ArraySet();
        while (classesIt.hasNext()) {
            SootClass cl = (SootClass)classesIt.next();
            if (Modifier.isAbstract(cl.getModifiers())) continue;
            s.add(this.resolveConcreteDispatch(cl, m));
        }
        ArrayList l = new ArrayList();
        l.addAll(s);
        return Collections.unmodifiableList(l);
    }

    public List resolveAbstractDispatch(List classes, SootMethod m) {
        ArraySet s = new ArraySet();
        Iterator classesIt = classes.iterator();
        while (classesIt.hasNext()) {
            s.addAll((Collection)this.resolveAbstractDispatch((SootClass)classesIt.next(), m));
        }
        ArrayList l = new ArrayList();
        l.addAll(s);
        return Collections.unmodifiableList(l);
    }

    public SootMethod resolveSpecialDispatch(SpecialInvokeExpr ie, SootMethod container2) {
        SootMethod target = ie.getMethod();
        if (target.getName().equals("<init>") || target.isPrivate()) {
            return target;
        }
        if (this.isClassSubclassOf(target.getDeclaringClass(), container2.getDeclaringClass())) {
            return this.resolveConcreteDispatch(container2.getDeclaringClass(), target);
        }
        return target;
    }
}

