/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import soot.AnySubType;
import soot.ArrayType;
import soot.NullType;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.SpecialInvokeExpr;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class FastHierarchy {
    protected Map classToSubclasses = new HashMap();
    protected MultiMap interfaceToSubinterfaces = new HashMultiMap();
    protected MultiMap interfaceToImplementers = new HashMultiMap();
    protected MultiMap interfaceToAllSubinterfaces = new HashMultiMap();
    protected MultiMap interfaceToAllImplementers = new HashMultiMap();
    protected Map classToInterval = new HashMap();
    protected Scene sc = Scene.v();

    private static void put(Map m, Object key, Object value) {
        ArrayList<Object> l = (ArrayList<Object>)m.get(key);
        if (l == null) {
            l = new ArrayList<Object>();
            m.put(key, l);
        }
        l.add(value);
    }

    protected int dfsVisit(int start, SootClass c) {
        Interval r = new Interval();
        r.lower = start++;
        Collection col = (Collection)this.classToSubclasses.get(c);
        if (col != null) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                SootClass sc = (SootClass)it.next();
                if (sc.isInterface()) continue;
                start = this.dfsVisit(start, sc);
            }
        }
        r.upper = start++;
        if (c.isInterface()) {
            throw new RuntimeException("Attempt to dfs visit interface " + c);
        }
        this.classToInterval.put(c, r);
        return start;
    }

    public FastHierarchy() {
        Iterator clIt = this.sc.getClasses().iterator();
        while (clIt.hasNext()) {
            SootClass cl = (SootClass)clIt.next();
            if (!cl.isInterface() && cl.hasSuperclass()) {
                FastHierarchy.put(this.classToSubclasses, cl.getSuperclass(), cl);
            }
            Iterator superclIt = cl.getInterfaces().iterator();
            while (superclIt.hasNext()) {
                SootClass supercl = (SootClass)superclIt.next();
                if (cl.isInterface()) {
                    this.interfaceToSubinterfaces.put(supercl, cl);
                    continue;
                }
                this.interfaceToImplementers.put(supercl, cl);
            }
        }
        this.dfsVisit(0, Scene.v().getSootClass("java.lang.Object"));
    }

    protected boolean isSubclass(SootClass child, SootClass parent) {
        Interval parentInterval = (Interval)this.classToInterval.get(parent);
        Interval childInterval = (Interval)this.classToInterval.get(child);
        return parentInterval.isSubrange(childInterval);
    }

    public Set getAllImplementersOfInterface(SootClass parent) {
        Set subs;
        if (this.interfaceToAllImplementers.containsKey(parent)) {
            subs = this.interfaceToAllImplementers.get(parent);
        } else {
            subs = this.interfaceToAllImplementers.get(parent);
            Iterator subinterfaceIt = this.getAllSubinterfaces(parent).iterator();
            while (subinterfaceIt.hasNext()) {
                SootClass subinterface = (SootClass)subinterfaceIt.next();
                if (subinterface == parent) continue;
                subs.addAll(this.getAllImplementersOfInterface(subinterface));
            }
            subs.addAll(this.interfaceToImplementers.get(parent));
        }
        return subs;
    }

    protected Set getAllSubinterfaces(SootClass parent) {
        Set subs;
        if (this.interfaceToAllSubinterfaces.containsKey(parent)) {
            subs = this.interfaceToAllSubinterfaces.get(parent);
        } else {
            subs = this.interfaceToAllSubinterfaces.get(parent);
            subs.add(parent);
            Iterator it = this.interfaceToSubinterfaces.get(parent).iterator();
            while (it.hasNext()) {
                subs.addAll(this.getAllSubinterfaces((SootClass)it.next()));
            }
        }
        return subs;
    }

    public boolean canStoreType(Type child, Type parent) {
        if (child.equals(parent)) {
            return true;
        }
        if (parent instanceof NullType) {
            return false;
        }
        if (child instanceof RefType) {
            if (parent instanceof RefType) {
                return this.canStoreClass(((RefType)child).getSootClass(), ((RefType)parent).getSootClass());
            }
            return false;
        }
        if (child instanceof AnySubType) {
            if (!(parent instanceof RefLikeType)) {
                throw new RuntimeException("Unhandled type " + parent);
            }
            RefType base = ((AnySubType)child).getBase();
            if (parent instanceof RefType && ((RefType)parent).getSootClass().isInterface()) {
                return true;
            }
            if (base instanceof RefType && base.getSootClass().isInterface()) {
                return true;
            }
            return this.canStoreType(parent, base) || this.canStoreType(base, parent);
        }
        ArrayType achild = (ArrayType)child;
        if (parent instanceof RefType) {
            return parent.equals(RefType.v("java.lang.Object")) || parent.equals(RefType.v("java.io.Serializable")) || parent.equals(RefType.v("java.lang.Cloneable"));
        }
        ArrayType aparent = (ArrayType)parent;
        if (achild.numDimensions == aparent.numDimensions) {
            if (achild.baseType.equals(aparent.baseType)) {
                return true;
            }
            if (!(achild.baseType instanceof RefType)) {
                return false;
            }
            if (!(aparent.baseType instanceof RefType)) {
                return false;
            }
            return this.canStoreType(achild.baseType, aparent.baseType);
        }
        if (achild.numDimensions > aparent.numDimensions) {
            if (aparent.baseType.equals(RefType.v("java.lang.Object"))) {
                return true;
            }
            if (aparent.baseType.equals(RefType.v("java.io.Serializable"))) {
                return true;
            }
            return aparent.baseType.equals(RefType.v("java.lang.Cloneable"));
        }
        return false;
    }

    protected boolean canStoreClass(SootClass child, SootClass parent) {
        Interval parentInterval = (Interval)this.classToInterval.get(parent);
        Interval childInterval = (Interval)this.classToInterval.get(child);
        if (parentInterval != null && childInterval != null) {
            return parentInterval.isSubrange(childInterval);
        }
        if (childInterval == null) {
            if (parentInterval != null) {
                return parent.equals(RefType.v("java.lang.Object").getSootClass());
            }
            return this.getAllSubinterfaces(parent).contains(child);
        }
        Set impl = this.getAllImplementersOfInterface(parent);
        Iterator it = impl.iterator();
        while (it.hasNext()) {
            parentInterval = (Interval)this.classToInterval.get(it.next());
            if (!parentInterval.isSubrange(childInterval)) continue;
            return true;
        }
        return false;
    }

    public Collection resolveConcreteDispatchWithoutFailing(Collection concreteTypes, SootMethod m, RefType declaredTypeOfBase) {
        HashSet<SootMethod> ret = new HashSet<SootMethod>();
        SootClass declaringClass = declaredTypeOfBase.getSootClass();
        Iterator tIt = concreteTypes.iterator();
        while (tIt.hasNext()) {
            Type t = (Type)tIt.next();
            if (t instanceof AnySubType) {
                String methodSig = m.getSubSignature();
                HashSet<SootClass> s = new HashSet<SootClass>();
                s.add(declaringClass);
                while (!s.isEmpty()) {
                    SootMethod concreteM;
                    SootClass c = (SootClass)s.iterator().next();
                    s.remove(c);
                    if (!c.isInterface() && !c.isAbstract() && this.canStoreClass(c, declaringClass) && (concreteM = this.resolveConcreteDispatch(c, m)) != null) {
                        ret.add(concreteM);
                    }
                    if (this.classToSubclasses.containsKey(c)) {
                        s.addAll((Collection)this.classToSubclasses.get(c));
                    }
                    if (this.interfaceToSubinterfaces.containsKey(c)) {
                        s.addAll(this.interfaceToSubinterfaces.get(c));
                    }
                    if (!this.interfaceToImplementers.containsKey(c)) continue;
                    s.addAll(this.interfaceToImplementers.get(c));
                }
                return ret;
            }
            if (t instanceof RefType) {
                RefType concreteType = (RefType)t;
                SootClass concreteClass = concreteType.getSootClass();
                if (!this.canStoreClass(concreteClass, declaringClass)) continue;
                SootMethod concreteM = null;
                try {
                    concreteM = this.resolveConcreteDispatch(concreteClass, m);
                }
                catch (Exception e) {
                    concreteM = null;
                }
                if (concreteM == null) continue;
                ret.add(concreteM);
                continue;
            }
            if (t instanceof ArrayType) {
                SootMethod concreteM = null;
                try {
                    concreteM = this.resolveConcreteDispatch(RefType.v("java.lang.Object").getSootClass(), m);
                }
                catch (Exception e) {
                    concreteM = null;
                }
                if (concreteM == null) continue;
                ret.add(concreteM);
                continue;
            }
            throw new RuntimeException("Unrecognized reaching type " + t);
        }
        return ret;
    }

    public Collection resolveConcreteDispatch(Collection concreteTypes, SootMethod m, RefType declaredTypeOfBase) {
        HashSet<SootMethod> ret = new HashSet<SootMethod>();
        SootClass declaringClass = declaredTypeOfBase.getSootClass();
        Iterator tIt = concreteTypes.iterator();
        while (tIt.hasNext()) {
            Type t = (Type)tIt.next();
            if (t instanceof AnySubType) {
                String methodSig = m.getSubSignature();
                HashSet<SootClass> s = new HashSet<SootClass>();
                s.add(declaringClass);
                while (!s.isEmpty()) {
                    SootMethod concreteM;
                    SootClass c = (SootClass)s.iterator().next();
                    s.remove(c);
                    if (!c.isInterface() && !c.isAbstract() && this.canStoreClass(c, declaringClass) && (concreteM = this.resolveConcreteDispatch(c, m)) != null) {
                        ret.add(concreteM);
                    }
                    if (this.classToSubclasses.containsKey(c)) {
                        s.addAll((Collection)this.classToSubclasses.get(c));
                    }
                    if (this.interfaceToSubinterfaces.containsKey(c)) {
                        s.addAll(this.interfaceToSubinterfaces.get(c));
                    }
                    if (!this.interfaceToImplementers.containsKey(c)) continue;
                    s.addAll(this.interfaceToImplementers.get(c));
                }
                return ret;
            }
            if (t instanceof RefType) {
                SootMethod concreteM;
                RefType concreteType = (RefType)t;
                SootClass concreteClass = concreteType.getSootClass();
                if (!this.canStoreClass(concreteClass, declaringClass) || (concreteM = this.resolveConcreteDispatch(concreteClass, m)) == null) continue;
                ret.add(concreteM);
                continue;
            }
            if (t instanceof ArrayType) {
                SootMethod concreteM = this.resolveConcreteDispatch(RefType.v("java.lang.Object").getSootClass(), m);
                if (concreteM == null) continue;
                ret.add(concreteM);
                continue;
            }
            throw new RuntimeException("Unrecognized reaching type " + t);
        }
        return ret;
    }

    private boolean isVisible(SootClass from, SootMethod m) {
        if (m.isPublic()) {
            return true;
        }
        if (m.isPrivate()) {
            return from.equals(m.getDeclaringClass());
        }
        if (m.isProtected()) {
            return this.canStoreClass(from, m.getDeclaringClass());
        }
        return from.getJavaPackageName().equals(m.getDeclaringClass().getJavaPackageName());
    }

    public Set resolveAbstractDispatch(SootClass abstractType, SootMethod m) {
        String methodSig = m.getSubSignature();
        HashSet<SootClass> resolved = new HashSet<SootClass>();
        HashSet<SootMethod> ret = new HashSet<SootMethod>();
        LinkedList<SootClass> worklist = new LinkedList<SootClass>();
        worklist.add(abstractType);
        block0: while (!worklist.isEmpty()) {
            SootClass concreteType;
            SootClass savedConcreteType = concreteType = (SootClass)worklist.removeFirst();
            if (concreteType.isInterface()) {
                worklist.addAll(this.getAllImplementersOfInterface(concreteType));
                continue;
            }
            Collection c = (Collection)this.classToSubclasses.get(concreteType);
            if (c != null) {
                worklist.addAll(c);
            }
            if (concreteType.isAbstract()) continue;
            while (!resolved.contains(concreteType)) {
                resolved.add(concreteType);
                if (concreteType.declaresMethod(methodSig)) {
                    SootMethod method = concreteType.getMethod(methodSig);
                    if (method.isAbstract()) {
                        throw new RuntimeException("abstract dispatch resolved to abstract method!\nAbstract Type: " + abstractType + "\nConcrete Type: " + savedConcreteType + "\nMethod: " + m);
                    }
                    if (this.isVisible(concreteType, m)) {
                        ret.add(concreteType.getMethod(methodSig));
                        continue block0;
                    }
                }
                if (!concreteType.hasSuperclass()) {
                    throw new RuntimeException("could not resolve abstract dispatch!\nAbstract Type: " + abstractType + "\nConcrete Type: " + savedConcreteType + "\nMethod: " + m);
                }
                concreteType = concreteType.getSuperclass();
            }
        }
        return ret;
    }

    public SootMethod resolveConcreteDispatch(SootClass concreteType, SootMethod m) {
        if (concreteType.isInterface()) {
            throw new RuntimeException("A concrete type cannot be an interface: " + concreteType);
        }
        if (concreteType.isAbstract()) {
            throw new RuntimeException("A concrete type cannot be abstract: " + concreteType);
        }
        String methodSig = m.getSubSignature();
        while (true) {
            if (concreteType.declaresMethod(methodSig) && this.isVisible(concreteType, m)) {
                return concreteType.getMethod(methodSig);
            }
            if (!concreteType.hasSuperclass()) break;
            concreteType = concreteType.getSuperclass();
        }
        throw new RuntimeException("could not resolve concrete dispatch!\nType: " + concreteType + "\nMethod: " + m);
    }

    public SootMethod resolveSpecialDispatch(SpecialInvokeExpr ie, SootMethod container2) {
        SootMethod target = ie.getMethod();
        if (target.getName().equals("<init>") || target.isPrivate()) {
            return target;
        }
        if (this.isSubclass(target.getDeclaringClass(), container2.getDeclaringClass())) {
            return this.resolveConcreteDispatch(container2.getDeclaringClass(), target);
        }
        return target;
    }

    public Collection getSubclassesOf(SootClass c) {
        Collection ret = (Collection)this.classToSubclasses.get(c);
        if (ret == null) {
            return Collections.EMPTY_LIST;
        }
        return ret;
    }

    protected class Interval {
        int lower;
        int upper;

        protected Interval() {
        }

        boolean isSubrange(Interval potentialSubrange) {
            if (this.lower > potentialSubrange.lower) {
                return false;
            }
            return this.upper >= potentialSubrange.upper;
        }
    }
}

