/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import soot.Unit;
import soot.UnitBox;
import soot.tagkit.AbstractHost;
import soot.util.Switch;

public abstract class AbstractUnit
extends AbstractHost
implements Unit {
    public static final List emptyList = Collections.EMPTY_LIST;
    List boxesPointingToThis = null;
    List valueBoxes = null;

    public abstract Object clone();

    public List getUseBoxes() {
        return emptyList;
    }

    public List getDefBoxes() {
        return emptyList;
    }

    public List getUnitBoxes() {
        return emptyList;
    }

    public List getBoxesPointingToThis() {
        if (this.boxesPointingToThis == null) {
            return emptyList;
        }
        return Collections.unmodifiableList(this.boxesPointingToThis);
    }

    public void addBoxPointingToThis(UnitBox b) {
        if (this.boxesPointingToThis == null) {
            this.boxesPointingToThis = new ArrayList();
        }
        this.boxesPointingToThis.add(b);
    }

    public void removeBoxPointingToThis(UnitBox b) {
        if (this.boxesPointingToThis != null) {
            this.boxesPointingToThis.remove(b);
        }
    }

    public void clearUnitBoxes() {
        Iterator it = this.getUnitBoxes().iterator();
        while (it.hasNext()) {
            UnitBox ub = (UnitBox)it.next();
            ub.setUnit(null);
        }
    }

    public List getUseAndDefBoxes() {
        List useBoxes = this.getUseBoxes();
        List defBoxes = this.getDefBoxes();
        if (useBoxes.isEmpty()) {
            if (defBoxes.isEmpty()) {
                return emptyList;
            }
            return Collections.unmodifiableList(defBoxes);
        }
        if (defBoxes.isEmpty()) {
            return Collections.unmodifiableList(useBoxes);
        }
        this.valueBoxes = new ArrayList();
        this.valueBoxes.addAll(defBoxes);
        this.valueBoxes.addAll(useBoxes);
        this.valueBoxes = Collections.unmodifiableList(this.valueBoxes);
        return this.valueBoxes;
    }

    public void apply(Switch sw) {
    }

    public void redirectJumpsToThisTo(Unit newLocation) {
        List boxesPointing = this.getBoxesPointingToThis();
        Object[] boxes = boxesPointing.toArray();
        for (int i = 0; i < boxes.length; ++i) {
            UnitBox box = (UnitBox)boxes[i];
            if (box.getUnit() != this) {
                throw new RuntimeException("Something weird's happening");
            }
            if (!box.isBranchTarget()) continue;
            box.setUnit(newLocation);
        }
    }
}

