/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Import;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.SourceCollection;
import polyglot.ast.SourceFile;
import polyglot.ast.TopLevelDecl;
import polyglot.frontend.Job;
import polyglot.frontend.TargetFactory;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.Package;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;
import polyglot.visit.PrettyPrinter;

public class Translator
extends PrettyPrinter
implements Copy {
    protected Job job;
    protected NodeFactory nf;
    protected TargetFactory tf;
    protected TypeSystem ts;
    protected Context context;
    protected ClassType outerClass = null;

    public Translator(Job job, TypeSystem ts, NodeFactory nf, TargetFactory tf) {
        this.job = job;
        this.nf = nf;
        this.tf = tf;
        this.ts = ts;
        this.context = job.context();
        if (this.context == null) {
            this.context = ts.createContext();
        }
    }

    public Job job() {
        return this.job;
    }

    public Translator context(Context c) {
        if (c == this.context) {
            return this;
        }
        Translator tr = (Translator)this.copy();
        tr.context = c;
        return tr;
    }

    public Object copy() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("Java clone() weirdness.");
        }
    }

    public ClassType outerClass() {
        return this.outerClass;
    }

    public void setOuterClass(ClassType ct) {
        this.outerClass = ct;
    }

    public TypeSystem typeSystem() {
        return this.ts;
    }

    public Context context() {
        return this.context;
    }

    public NodeFactory nodeFactory() {
        return this.nf;
    }

    public void print(Node parent, Node child, CodeWriter w) {
        Translator tr;
        if (parent != null) {
            Context c = parent.enterScope(this.context);
            tr = this.context(c);
        } else {
            tr = this;
        }
        child.del().translate(w, tr);
        if (parent != null) {
            parent.addDecls(this.context);
        }
    }

    public boolean translate(Node ast) {
        if (ast instanceof SourceFile) {
            SourceFile sfn = (SourceFile)ast;
            return this.translateSource(sfn);
        }
        if (ast instanceof SourceCollection) {
            SourceCollection sc = (SourceCollection)ast;
            boolean okay = true;
            Iterator i = sc.sources().iterator();
            while (i.hasNext()) {
                SourceFile sfn = (SourceFile)i.next();
                okay &= this.translateSource(sfn);
            }
            return okay;
        }
        throw new InternalCompilerError("AST root must be a SourceFile; found a " + ast.getClass().getName());
    }

    protected boolean translateSource(SourceFile sfn) {
        TypeSystem ts = this.typeSystem();
        NodeFactory nf = this.nodeFactory();
        TargetFactory tf = this.tf;
        int outputWidth = this.job.compiler().outputWidth();
        Collection outputFiles = this.job.compiler().outputFiles();
        List exports = this.exports(sfn);
        try {
            File of;
            String pkg = "";
            if (sfn.package_() != null) {
                Package p = sfn.package_().package_();
                pkg = p.toString();
            }
            Context c = sfn.enterScope(this.context);
            TopLevelDecl first = null;
            if (exports.size() == 0) {
                of = tf.outputFile(pkg, sfn.source());
            } else {
                first = (TopLevelDecl)exports.get(0);
                of = tf.outputFile(pkg, first.name(), sfn.source());
            }
            String opfPath = of.getPath();
            if (!opfPath.endsWith("$")) {
                outputFiles.add(of.getPath());
            }
            Writer ofw = tf.outputWriter(of);
            CodeWriter w = new CodeWriter(ofw, outputWidth);
            this.writeHeader(sfn, w);
            Iterator i = sfn.decls().iterator();
            while (i.hasNext()) {
                TopLevelDecl decl = (TopLevelDecl)i.next();
                if (decl.flags().isPublic() && decl != first) {
                    w.flush();
                    ofw.close();
                    of = tf.outputFile(pkg, decl.name(), sfn.source());
                    outputFiles.add(of.getPath());
                    ofw = tf.outputWriter(of);
                    w = new CodeWriter(ofw, outputWidth);
                    this.writeHeader(sfn, w);
                }
                decl.del().translate(w, this.context(c));
                if (!i.hasNext()) continue;
                w.newline(0);
            }
            w.flush();
            ofw.close();
            return true;
        }
        catch (IOException e) {
            this.job.compiler().errorQueue().enqueue(2, "I/O error while translating: " + e.getMessage());
            return false;
        }
    }

    protected void writeHeader(SourceFile sfn, CodeWriter w) {
        if (sfn.package_() != null) {
            w.write("package ");
            sfn.package_().del().translate(w, this);
            w.write(";");
            w.newline(0);
            w.newline(0);
        }
        boolean newline = false;
        Iterator i = sfn.imports().iterator();
        while (i.hasNext()) {
            Import imp = (Import)i.next();
            imp.del().translate(w, this);
            newline = true;
        }
        if (newline) {
            w.newline(0);
        }
    }

    protected List exports(SourceFile sfn) {
        LinkedList<TopLevelDecl> exports = new LinkedList<TopLevelDecl>();
        Iterator i = sfn.decls().iterator();
        while (i.hasNext()) {
            TopLevelDecl decl = (TopLevelDecl)i.next();
            if (!decl.flags().isPublic()) continue;
            exports.add(decl);
        }
        return exports;
    }

    public String toString() {
        return "Translator";
    }
}

