/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Binary;
import polyglot.ast.CodeDecl;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.Unary;
import polyglot.frontend.Job;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.IdentityKey;
import polyglot.util.InternalCompilerError;
import polyglot.util.StringUtil;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ErrorHandlingVisitor;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;

public abstract class DataFlow
extends ErrorHandlingVisitor {
    protected final boolean forward;
    protected final boolean dataflowOnEntry;
    protected LinkedList flowgraphStack;
    protected static int flowCounter = 0;

    public DataFlow(Job job, TypeSystem ts, NodeFactory nf, boolean forward) {
        this(job, ts, nf, forward, false);
    }

    public DataFlow(Job job, TypeSystem ts, NodeFactory nf, boolean forward, boolean dataflowOnEntry) {
        super(job, ts, nf);
        this.forward = forward;
        this.dataflowOnEntry = dataflowOnEntry;
        this.flowgraphStack = dataflowOnEntry ? new LinkedList() : null;
    }

    protected abstract Item createInitialItem(FlowGraph var1);

    protected abstract Map flow(Item var1, FlowGraph var2, Term var3, Set var4);

    protected abstract Item confluence(List var1, Term var2);

    protected abstract void check(FlowGraph var1, Term var2, Item var3, Map var4) throws SemanticException;

    protected void dataflow(CodeDecl cd) throws SemanticException {
        FlowGraph g;
        if (cd.body() != null && (g = this.initGraph(cd, cd)) != null) {
            CFGBuilder v = new CFGBuilder(this.ts, g, this);
            v.visitGraph();
            this.dataflow(g);
            this.post(g, cd);
            if (this.dataflowOnEntry) {
                this.flowgraphStack.addFirst(new FlowGraphSource(g, cd));
            }
        }
    }

    protected void dataflow(FlowGraph graph) {
        LinkedList<FlowGraph.Peer> queue = new LinkedList<FlowGraph.Peer>(graph.peers(graph.startNode()));
        while (!queue.isEmpty()) {
            FlowGraph.Peer p = (FlowGraph.Peer)queue.removeFirst();
            ArrayList<Item> inItems = new ArrayList<Item>(p.preds.size());
            Iterator i = p.preds.iterator();
            while (i.hasNext()) {
                FlowGraph.Edge e = (FlowGraph.Edge)i.next();
                FlowGraph.Peer o = e.getTarget();
                Item it = null;
                if (o.outItems == null) continue;
                it = (Item)o.outItems.get(e.getKey());
                if (it == null) {
                    throw new InternalCompilerError("There should have an out Item with edge key " + e.getKey() + "; instead there were only " + o.outItems.keySet());
                }
                inItems.add(it);
            }
            p.inItem = inItems.isEmpty() ? this.createInitialItem(graph) : (inItems.size() == 1 ? (Item)inItems.get(0) : this.confluence(inItems, p.node));
            Map oldOutItems = p.outItems;
            p.outItems = this.flow(p.inItem, graph, p.node, p.succEdgeKeys());
            if (!((Object)p.succEdgeKeys()).equals(p.outItems.keySet())) {
                throw new InternalCompilerError("The flow only defined outputs for " + p.outItems.keySet() + "; needs to " + "define outputs for all of: " + p.succEdgeKeys());
            }
            if (oldOutItems == p.outItems || oldOutItems != null && ((Object)oldOutItems).equals(p.outItems)) continue;
            Iterator i2 = p.succs.iterator();
            while (i2.hasNext()) {
                FlowGraph.Peer q = ((FlowGraph.Edge)i2.next()).getTarget();
                if (queue.contains(q)) continue;
                queue.addLast(q);
            }
        }
    }

    protected FlowGraph initGraph(CodeDecl code, Term root) {
        return new FlowGraph(root, this.forward);
    }

    protected NodeVisitor enterCall(Node n) throws SemanticException {
        if (this.dataflowOnEntry && n instanceof CodeDecl) {
            this.dataflow((CodeDecl)n);
        }
        return this;
    }

    public Node leave(Node parent, Node old, Node n, NodeVisitor v) {
        Object o;
        if (old != n && this.dataflowOnEntry && this.currentFlowGraph() != null && (o = this.currentFlowGraph().peerMap.get(new IdentityKey(old))) != null) {
            this.currentFlowGraph().peerMap.put(new IdentityKey(n), o);
        }
        return super.leave(parent, old, n, v);
    }

    protected Node leaveCall(Node n) throws SemanticException {
        if (n instanceof CodeDecl) {
            if (!this.dataflowOnEntry) {
                this.dataflow((CodeDecl)n);
            } else if (this.dataflowOnEntry && !this.flowgraphStack.isEmpty()) {
                FlowGraphSource fgs = (FlowGraphSource)this.flowgraphStack.getFirst();
                if (fgs.source.equals(n)) {
                    this.flowgraphStack.removeFirst();
                }
            }
        }
        return n;
    }

    protected void post(FlowGraph graph, Term root) throws SemanticException {
        if (Report.should_report(Report.cfg, 2)) {
            this.dumpFlowGraph(graph, root);
        }
        HashSet uncheckedPeers = new HashSet(graph.peers());
        LinkedList<FlowGraph.Peer> peersToCheck = new LinkedList<FlowGraph.Peer>(graph.peers(graph.startNode()));
        while (!peersToCheck.isEmpty()) {
            FlowGraph.Peer p = (FlowGraph.Peer)peersToCheck.removeFirst();
            uncheckedPeers.remove(p);
            this.check(graph, p.node, p.inItem, p.outItems);
            Iterator iter = p.succs.iterator();
            while (iter.hasNext()) {
                FlowGraph.Peer q = ((FlowGraph.Edge)iter.next()).getTarget();
                if (!uncheckedPeers.contains(q) || peersToCheck.contains(q)) continue;
                peersToCheck.addLast(q);
            }
            if (!peersToCheck.isEmpty() || uncheckedPeers.isEmpty()) continue;
            Iterator i = uncheckedPeers.iterator();
            peersToCheck.add((FlowGraph.Peer)i.next());
            i.remove();
        }
    }

    protected FlowGraph currentFlowGraph() {
        if (!this.dataflowOnEntry) {
            throw new InternalCompilerError("currentFlowGraph() cannot be called when dataflow is not performed on entry");
        }
        if (this.flowgraphStack.isEmpty()) {
            return null;
        }
        return ((FlowGraphSource)this.flowgraphStack.getFirst()).flowgraph;
    }

    protected static final Map itemToMap(Item i, Set edgeKeys) {
        HashMap m = new HashMap();
        Iterator iter = edgeKeys.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            m.put(o, i);
        }
        return m;
    }

    protected static final boolean hasTrueFalseBranches(Set edgeKeys) {
        return edgeKeys.contains(FlowGraph.EDGE_KEY_FALSE) && edgeKeys.contains(FlowGraph.EDGE_KEY_TRUE);
    }

    protected static Map constructItemsFromCondition(Expr booleanCond, Item startingItem, Set succEdgeKeys, ConditionNavigator navigator) {
        if (!booleanCond.type().isBoolean()) {
            throw new IllegalArgumentException("booleanCond must be a boolean expression");
        }
        if (!DataFlow.hasTrueFalseBranches(succEdgeKeys)) {
            throw new IllegalArgumentException("succEdgeKeys does not have true and false branches.");
        }
        BoolItem results = navigator.navigate(booleanCond, startingItem);
        HashMap<FlowGraph.EdgeKey, Item> m = new HashMap<FlowGraph.EdgeKey, Item>();
        m.put(FlowGraph.EDGE_KEY_TRUE, results.trueItem);
        m.put(FlowGraph.EDGE_KEY_FALSE, results.falseItem);
        Iterator iter = succEdgeKeys.iterator();
        while (iter.hasNext()) {
            FlowGraph.EdgeKey e = (FlowGraph.EdgeKey)iter.next();
            if (FlowGraph.EDGE_KEY_TRUE.equals(e) || FlowGraph.EDGE_KEY_FALSE.equals(e)) continue;
            m.put(e, startingItem);
        }
        return m;
    }

    protected void dumpFlowGraph(FlowGraph graph, Term root) {
        String name = StringUtil.getShortNameComponent(this.getClass().getName());
        name = name + flowCounter++;
        String rootName = "";
        if (graph.root() instanceof CodeDecl) {
            CodeDecl cd = (CodeDecl)graph.root();
            rootName = cd.codeInstance().toString() + " in " + cd.codeInstance().container().toString();
        }
        Report.report(2, "digraph DataFlow" + name + " {");
        Report.report(2, "  label=\"Dataflow: " + name + "\\n" + rootName + "\"; fontsize=20; center=true; ratio=auto; size = \"8.5,11\";");
        Iterator iter = graph.peers().iterator();
        while (iter.hasNext()) {
            FlowGraph.Peer p = (FlowGraph.Peer)iter.next();
            Report.report(2, p.hashCode() + " [ label = \"" + StringUtil.escape(p.node.toString()) + "\\n(" + StringUtil.escape(StringUtil.getShortNameComponent(p.node.getClass().getName())) + ")\" ];");
            Iterator iter2 = p.succs.iterator();
            while (iter2.hasNext()) {
                FlowGraph.Edge q = (FlowGraph.Edge)iter2.next();
                Report.report(2, q.getTarget().hashCode() + " [ label = \"" + StringUtil.escape(q.getTarget().node.toString()) + " (" + StringUtil.escape(StringUtil.getShortNameComponent(q.getTarget().node.getClass().getName())) + ")\" ];");
                String label = q.getKey().toString();
                label = q.getTarget().outItems != null ? label + "\\n" + q.getTarget().outItems.get(q.getKey()) : label + "\\n[no dataflow available]";
                Report.report(2, p.hashCode() + " -> " + q.getTarget().hashCode() + " [label=\"" + label + "\"];");
            }
        }
        Report.report(2, "}");
    }

    protected static abstract class ConditionNavigator {
        protected ConditionNavigator() {
        }

        public BoolItem navigate(Expr expr, Item startingItem) {
            if (expr.type().isBoolean()) {
                Unary u;
                if (expr instanceof Binary) {
                    Binary b = (Binary)expr;
                    if (Binary.COND_AND.equals(b.operator()) || Binary.BIT_AND.equals(b.operator())) {
                        BoolItem leftRes = this.navigate(b.left(), startingItem);
                        Item rightResStart = startingItem;
                        if (Binary.COND_AND.equals(b.operator())) {
                            rightResStart = leftRes.trueItem;
                        }
                        BoolItem rightRes = this.navigate(b.right(), rightResStart);
                        return this.andResults(leftRes, rightRes, startingItem);
                    }
                    if (Binary.COND_OR.equals(b.operator()) || Binary.BIT_OR.equals(b.operator())) {
                        BoolItem leftRes = this.navigate(b.left(), startingItem);
                        Item rightResStart = startingItem;
                        if (Binary.COND_OR.equals(b.operator())) {
                            rightResStart = leftRes.falseItem;
                        }
                        BoolItem rightRes = this.navigate(b.right(), rightResStart);
                        return this.orResults(leftRes, rightRes, startingItem);
                    }
                } else if (expr instanceof Unary && Unary.NOT.equals((u = (Unary)expr).operator())) {
                    BoolItem res = this.navigate(u.expr(), startingItem);
                    return this.notResult(res);
                }
            }
            return this.handleExpression(expr, startingItem);
        }

        public BoolItem andResults(BoolItem left, BoolItem right, Item startingItem) {
            return new BoolItem(this.combine(left.trueItem, right.trueItem), startingItem);
        }

        public BoolItem orResults(BoolItem left, BoolItem right, Item startingItem) {
            return new BoolItem(startingItem, this.combine(left.falseItem, right.falseItem));
        }

        public BoolItem notResult(BoolItem results) {
            return new BoolItem(results.falseItem, results.trueItem);
        }

        public abstract Item combine(Item var1, Item var2);

        public abstract BoolItem handleExpression(Expr var1, Item var2);
    }

    protected static class BoolItem {
        Item trueItem;
        Item falseItem;

        public BoolItem(Item trueItem, Item falseItem) {
            this.trueItem = trueItem;
            this.falseItem = falseItem;
        }

        public String toString() {
            return "[ true: " + this.trueItem + "; false: " + this.falseItem + " ]";
        }
    }

    public static abstract class Item {
        public abstract boolean equals(Object var1);

        public abstract int hashCode();
    }

    protected static class FlowGraphSource {
        FlowGraph flowgraph;
        CodeDecl source;

        FlowGraphSource(FlowGraph g, CodeDecl s) {
            this.flowgraph = g;
            this.source = s;
        }
    }
}

