/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.Iterator;
import java.util.Stack;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.frontend.Job;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Enum;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

public class AmbiguityRemover
extends ContextVisitor {
    public static final Kind SUPER = new Kind("disam-super");
    public static final Kind SIGNATURES = new Kind("disam-sigs");
    public static final Kind FIELDS = new Kind("disam-fields");
    public static final Kind ALL = new Kind("disam-all");
    protected Kind kind;

    public AmbiguityRemover(Job job, TypeSystem ts, NodeFactory nf, Kind kind) {
        super(job, ts, nf);
        this.kind = kind;
    }

    public Kind kind() {
        return this.kind;
    }

    protected NodeVisitor enterCall(Node n) throws SemanticException {
        if (Report.should_report(Report.visit, 2)) {
            Report.report(2, ">> " + this.kind + "::enter " + n);
        }
        NodeVisitor v = n.del().disambiguateEnter(this);
        if (Report.should_report(Report.visit, 2)) {
            Report.report(2, "<< " + this.kind + "::enter " + n + " -> " + v);
        }
        return v;
    }

    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        if (Report.should_report(Report.visit, 2)) {
            Report.report(2, ">> " + this.kind + "::leave " + n);
        }
        Node m = n.del().disambiguate((AmbiguityRemover)v);
        if (Report.should_report(Report.visit, 2)) {
            Report.report(2, "<< " + this.kind + "::leave " + n + " -> " + m);
        }
        return m;
    }

    public void addSuperDependencies(ClassType ct) {
        Stack<Type> s = new Stack<Type>();
        s.push(ct);
        while (!s.isEmpty()) {
            Type t = (Type)s.pop();
            if (!t.isClass()) continue;
            ClassType classt = t.toClass();
            if (classt instanceof ParsedClassType) {
                this.job().extensionInfo().addDependencyToCurrentJob(((ParsedClassType)classt).fromSource());
            }
            Iterator i = classt.interfaces().iterator();
            while (i.hasNext()) {
                s.push((Type)i.next());
            }
            if (classt.superType() == null) continue;
            s.push(classt.superType());
        }
    }

    public static class Kind
    extends Enum {
        protected Kind(String name) {
            super(name);
        }
    }
}

