/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.Serializable;

public class Position
implements Serializable {
    static final long serialVersionUID = -4588386982624074261L;
    String file;
    int line;
    int column;
    public static final int UNKNOWN = -1;
    public static final Position COMPILER_GENERATED = new Position("Compiler Generated");

    protected Position() {
    }

    public Position(String file) {
        this(file, -1, -1);
    }

    public Position(String file, int line) {
        this(file, line, -1);
    }

    public Position(String file, int line, int column) {
        this.file = file;
        this.line = line;
        this.column = column;
    }

    public int line() {
        return this.line;
    }

    public int column() {
        return this.column;
    }

    public String file() {
        return this.file;
    }

    public String nameAndLineString() {
        String s = this.file;
        if (this.line != -1) {
            s = s + ":" + this.line;
        }
        return s;
    }

    public String toString() {
        String s = this.file;
        if (this.line != -1) {
            s = s + ":" + this.line;
            if (this.column != -1) {
                s = s + "," + this.column;
            }
        }
        return s;
    }
}

