/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types.reflect;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.reflect.Attribute;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.Constant;
import polyglot.types.reflect.Exceptions;

class Method {
    ClassFile clazz;
    int modifiers;
    int name;
    int type;
    Attribute[] attrs;
    Exceptions exceptions;

    Method(DataInputStream in, ClassFile clazz) throws IOException {
        this.clazz = clazz;
        this.modifiers = in.readUnsignedShort();
        this.name = in.readUnsignedShort();
        this.type = in.readUnsignedShort();
        int numAttributes = in.readUnsignedShort();
        this.attrs = new Attribute[numAttributes];
        for (int i = 0; i < numAttributes; ++i) {
            int nameIndex = in.readUnsignedShort();
            int length = in.readInt();
            Constant name = clazz.constants[nameIndex];
            if (name != null && "Exceptions".equals(name.value())) {
                this.exceptions = new Exceptions(clazz, in, nameIndex, length);
                this.attrs[i] = this.exceptions;
                continue;
            }
            in.skip(length);
        }
    }

    String name() {
        return (String)this.clazz.constants[this.name].value();
    }

    MethodInstance methodInstance(TypeSystem ts, ClassType ct) {
        String name = (String)this.clazz.constants[this.name].value();
        String type = (String)this.clazz.constants[this.type].value();
        if (type.charAt(0) != '(') {
            throw new ClassFormatError("Bad method type descriptor.");
        }
        int index = type.indexOf(41, 1);
        List argTypes = this.clazz.typeListForString(ts, type.substring(1, index));
        Type returnType = this.clazz.typeForString(ts, type.substring(index + 1));
        ArrayList<ClassType> excTypes = new ArrayList<ClassType>();
        if (this.exceptions != null) {
            for (int i = 0; i < this.exceptions.exceptions.length; ++i) {
                String s = this.clazz.classNameCP(this.exceptions.exceptions[i]);
                excTypes.add(this.clazz.typeForName(ts, s));
            }
        }
        return ts.methodInstance(ct.position(), ct, ts.flagsForBits(this.modifiers), returnType, name, argTypes, excTypes);
    }

    ConstructorInstance constructorInstance(TypeSystem ts, ClassType ct) {
        MethodInstance mi = this.methodInstance(ts, ct);
        return ts.constructorInstance(mi.position(), ct, mi.flags(), mi.formalTypes(), mi.throwTypes());
    }
}

