/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import polyglot.frontend.Compiler;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.FileSource;
import polyglot.main.Report;
import polyglot.types.BadSerializationException;
import polyglot.types.LoadedClassResolver;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.SemanticException;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.ClassFileLoader;

public class SourceClassResolver
extends LoadedClassResolver {
    Compiler compiler;
    ExtensionInfo ext;

    public SourceClassResolver(Compiler compiler, ExtensionInfo ext, String classpath, ClassFileLoader loader, boolean allowRawClasses) {
        super(ext.typeSystem(), classpath, loader, ext.version(), allowRawClasses);
        this.compiler = compiler;
        this.ext = ext;
    }

    public Named find(String name) throws SemanticException {
        if (Report.should_report(report_topics, 3)) {
            Report.report(3, "SourceCR.find(" + name + ")");
        }
        ClassFile clazz = null;
        ClassFile encodedClazz = null;
        FileSource source = null;
        clazz = this.loadFile(name);
        if (clazz != null && clazz.encodedClassType(this.version.name()) != null) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Class " + name + " has encoded type info");
            }
            encodedClazz = clazz;
        }
        source = this.ext.sourceLoader().classSource(name);
        if (Report.should_report(report_topics, 4)) {
            if (source == null) {
                Report.report(4, "Class " + name + " not found in source file");
            } else {
                Report.report(4, "Class " + name + " found in source " + source);
            }
        }
        if (encodedClazz != null || source != null) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Not using raw class file for " + name);
            }
            clazz = null;
        }
        if (encodedClazz != null && source != null) {
            long classModTime = encodedClazz.sourceLastModified(this.version.name());
            long sourceModTime = source.lastModified().getTime();
            int comp = this.checkCompilerVersion(encodedClazz.compilerVersion(this.version.name()));
            if (classModTime < sourceModTime) {
                if (Report.should_report(report_topics, 3)) {
                    Report.report(3, "Source file version is newer than compiled for " + name + ".");
                }
                encodedClazz = null;
            } else if (comp != 0) {
                if (Report.should_report(report_topics, 3)) {
                    Report.report(3, "Incompatible source file version for " + name + ".");
                }
                encodedClazz = null;
            }
        }
        if (encodedClazz != null) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Using encoded class type for " + name);
            }
            try {
                return this.getEncodedType(encodedClazz, name);
            }
            catch (BadSerializationException e) {
                throw e;
            }
            catch (SemanticException e) {
                if (Report.should_report(report_topics, 4)) {
                    Report.report(4, "Could not load encoded class " + name);
                }
                encodedClazz = null;
            }
        }
        if (clazz != null && this.allowRawClasses) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Using raw class file for " + name);
            }
            return clazz.type(this.ts);
        }
        if (source != null) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Using source file for " + name);
            }
            return this.getTypeFromSource(source, name);
        }
        if (clazz != null && !this.allowRawClasses) {
            throw new SemanticException("Class \"" + name + "\" not found." + " A class file was found, but it did not contain appropriate" + " information for the Polyglot-based compiler " + this.ext.compilerName() + ". Try using " + this.ext.compilerName() + " to recompile the source code.");
        }
        throw new NoClassException(name);
    }

    protected Named getTypeFromSource(FileSource source, String name) throws SemanticException {
        this.ext.readSource(source);
        return this.ts.parsedResolver().find(name);
    }
}

