/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.FileSource;
import polyglot.main.Report;

public class SourceLoader {
    ExtensionInfo sourceExt;
    Collection sourcePath;
    Map directoryContentsCache;
    static File current_dir = null;

    public SourceLoader(ExtensionInfo sourceExt, Collection sourcePath) {
        this.sourcePath = sourcePath;
        this.sourceExt = sourceExt;
        this.directoryContentsCache = new HashMap();
    }

    public FileSource fileSource(String fileName) throws IOException {
        File sourceFile = new File(fileName);
        if (!sourceFile.exists()) {
            throw new FileNotFoundException(fileName);
        }
        if (!fileName.endsWith("." + this.sourceExt.fileExtension())) {
            throw new IOException("Source \"" + fileName + "\" does not have the extension \"." + this.sourceExt.fileExtension() + "\".");
        }
        if (Report.should_report(Report.frontend, 2)) {
            Report.report(2, "Loading class from " + sourceFile);
        }
        return new FileSource(fileName);
    }

    public FileSource classSource(String className) {
        String fileName = className.replace('.', File.separatorChar) + "." + this.sourceExt.fileExtension();
        if (current_dir == null) {
            current_dir = new File(System.getProperty("user.dir"));
        }
        Iterator i = this.sourcePath.iterator();
        while (i.hasNext()) {
            File sourceFile;
            String firstPart;
            int index;
            File directory = (File)i.next();
            HashSet<String> dirContents = (HashSet<String>)this.directoryContentsCache.get(directory);
            if (dirContents == null) {
                dirContents = new HashSet<String>();
                this.directoryContentsCache.put(directory, dirContents);
                if (directory.exists()) {
                    String[] contents = directory.list();
                    for (int j = 0; j < contents.length; ++j) {
                        dirContents.add(contents[j]);
                    }
                }
            }
            if ((index = fileName.indexOf(File.separatorChar)) < 0) {
                index = fileName.length();
            }
            if (!dirContents.contains(firstPart = fileName.substring(0, index)) || !(sourceFile = directory != null && directory.equals(current_dir) ? new File(fileName) : new File(directory, fileName)).exists()) continue;
            if (Report.should_report(Report.frontend, 2)) {
                Report.report(2, "Loading " + className + " from " + sourceFile);
            }
            return new FileSource(sourceFile);
        }
        return null;
    }
}

