/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl.ast;

import polyglot.ast.FloatLit;
import polyglot.ast.Node;
import polyglot.ast.Precedence;
import polyglot.ext.jl.ast.Lit_c;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class FloatLit_c
extends Lit_c
implements FloatLit {
    protected FloatLit.Kind kind;
    protected double value;

    public FloatLit_c(Position pos, FloatLit.Kind kind, double value) {
        super(pos);
        this.kind = kind;
        this.value = value;
    }

    public FloatLit.Kind kind() {
        return this.kind;
    }

    public FloatLit kind(FloatLit.Kind kind) {
        FloatLit_c n = (FloatLit_c)this.copy();
        n.kind = kind;
        return n;
    }

    public double value() {
        return this.value;
    }

    public Object objValue() {
        return new Double(this.value);
    }

    public FloatLit value(double value) {
        FloatLit_c n = (FloatLit_c)this.copy();
        n.value = value;
        return n;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        if (this.kind == FloatLit.FLOAT) {
            return this.type(tc.typeSystem().Float());
        }
        if (this.kind == FloatLit.DOUBLE) {
            return this.type(tc.typeSystem().Double());
        }
        throw new InternalCompilerError("Unrecognized FloatLit kind " + this.kind);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.kind == FloatLit.FLOAT) {
            w.write(Float.toString((float)this.value) + "F");
        } else if (this.kind == FloatLit.DOUBLE) {
            w.write(Double.toString(this.value));
        } else {
            throw new InternalCompilerError("Unrecognized FloatLit kind " + this.kind);
        }
    }

    public boolean isConstant() {
        return true;
    }

    public Object constantValue() {
        if (this.kind == FloatLit.FLOAT) {
            return new Float(this.value);
        }
        return new Double(this.value);
    }

    public Precedence precedence() {
        if (this.value < 0.0) {
            return Precedence.UNARY;
        }
        return Precedence.LITERAL;
    }
}

