/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Call;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.ext.jl.ast.Expr_c;
import polyglot.types.ClassType;
import polyglot.types.CodeInstance;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.MethodInstance;
import polyglot.types.ProcedureInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.UnknownType;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class Call_c
extends Expr_c
implements Call {
    protected Receiver target;
    protected String name;
    protected List arguments;
    protected MethodInstance mi;
    static /* synthetic */ Class class$polyglot$ast$Expr;

    public Call_c(Position pos, Receiver target, String name, List arguments) {
        super(pos);
        this.target = target;
        this.name = name;
        this.arguments = TypedList.copyAndCheck(arguments, class$polyglot$ast$Expr == null ? (class$polyglot$ast$Expr = Call_c.class$("polyglot.ast.Expr")) : class$polyglot$ast$Expr, true);
    }

    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    public Receiver target() {
        return this.target;
    }

    public Call target(Receiver target) {
        Call_c n = (Call_c)this.copy();
        n.target = target;
        return n;
    }

    public String name() {
        return this.name;
    }

    public Call name(String name) {
        Call_c n = (Call_c)this.copy();
        n.name = name;
        return n;
    }

    public ProcedureInstance procedureInstance() {
        return this.methodInstance();
    }

    public MethodInstance methodInstance() {
        return this.mi;
    }

    public Call methodInstance(MethodInstance mi) {
        Call_c n = (Call_c)this.copy();
        n.mi = mi;
        return n;
    }

    public List arguments() {
        return this.arguments;
    }

    public Call arguments(List arguments) {
        Call_c n = (Call_c)this.copy();
        n.arguments = TypedList.copyAndCheck(arguments, class$polyglot$ast$Expr == null ? (class$polyglot$ast$Expr = Call_c.class$("polyglot.ast.Expr")) : class$polyglot$ast$Expr, true);
        return n;
    }

    protected Call_c reconstruct(Receiver target, List arguments) {
        if (target != this.target || !CollectionUtil.equals(arguments, this.arguments)) {
            Call_c n = (Call_c)this.copy();
            n.target = target;
            n.arguments = TypedList.copyAndCheck(arguments, class$polyglot$ast$Expr == null ? (class$polyglot$ast$Expr = Call_c.class$("polyglot.ast.Expr")) : class$polyglot$ast$Expr, true);
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Receiver target = (Receiver)this.visitChild(this.target, v);
        List arguments = this.visitList(this.arguments, v);
        return this.reconstruct(target, arguments);
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        Call_c n = (Call_c)super.buildTypes(tb);
        TypeSystem ts = tb.typeSystem();
        ArrayList<UnknownType> l = new ArrayList<UnknownType>(this.arguments.size());
        for (int i = 0; i < this.arguments.size(); ++i) {
            l.add(ts.unknownType(this.position()));
        }
        MethodInstance mi = ts.methodInstance(this.position(), ts.Object(), Flags.NONE, ts.unknownType(this.position()), this.name, l, Collections.EMPTY_LIST);
        return n.methodInstance(mi);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        void var8_14;
        TypeSystem ts = tc.typeSystem();
        Context c = tc.context();
        ReferenceType targetType = null;
        boolean staticContext = false;
        if (this.target instanceof TypeNode) {
            TypeNode tn = (TypeNode)this.target;
            Type t = tn.type();
            staticContext = true;
            if (!t.isReference()) throw new SemanticException("Cannot invoke static method \"" + this.name + "\" on non-reference type " + t + ".", tn.position());
            targetType = t.toReference();
        } else if (this.target instanceof Expr) {
            Expr e = (Expr)this.target;
            if (!e.type().isReference()) throw new SemanticException("Cannot invoke method \"" + this.name + "\" on " + "an expression of non-reference type " + e.type() + ".", e.position());
            targetType = e.type().toReference();
        } else {
            if (this.target != null) {
                throw new SemanticException("Receiver of method invocation must be a reference type.", this.target.position());
            }
            CodeInstance ci = c.currentCode();
            if (ci.flags().isStatic()) {
                staticContext = true;
            }
        }
        ArrayList<Type> argTypes = new ArrayList<Type>(this.arguments.size());
        Iterator i = this.arguments.iterator();
        while (i.hasNext()) {
            Expr expr = (Expr)i.next();
            argTypes.add(expr.type());
        }
        MethodInstance mi = targetType != null ? ts.findMethod(targetType, this.name, argTypes, c) : c.findMethod(this.name, argTypes);
        if (staticContext && !mi.flags().isStatic()) {
            void var8_11;
            if (targetType == null) {
                ClassType classType = c.findMethodScope(this.name);
                throw new SemanticException("Cannot call non-static method " + this.name + " of " + var8_11 + " in static " + "context.");
            } else {
                ReferenceType referenceType = targetType;
            }
            throw new SemanticException("Cannot call non-static method " + this.name + " of " + var8_11 + " in static " + "context.");
        }
        if (this.target == null) {
            void var9_19;
            NodeFactory nf = tc.nodeFactory();
            if (mi.flags().isStatic()) {
                TypeNode typeNode = nf.CanonicalTypeNode(this.position(), mi.container()).type(mi.container());
            } else {
                ClassType scope = c.findMethodScope(this.name);
                if (!ts.equals(scope, c.currentClass())) {
                    Expr expr = nf.This(this.position(), nf.CanonicalTypeNode(this.position(), scope)).type(scope);
                } else {
                    Expr expr = nf.This(this.position()).type(scope);
                }
            }
            Call call = this.target((Receiver)var9_19);
            return var8_14.methodInstance(mi).type(mi.returnType());
        } else {
            Call_c call_c = this;
        }
        return var8_14.methodInstance(mi).type(mi.returnType());
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.target) {
            return this.mi.container();
        }
        Iterator i = this.arguments.iterator();
        Iterator j = this.mi.formalTypes().iterator();
        while (i.hasNext() && j.hasNext()) {
            Expr e = (Expr)i.next();
            Type t = (Type)j.next();
            if (e != child) continue;
            return t;
        }
        return child.type();
    }

    public String toString() {
        String s = (this.target != null ? this.target.toString() + "." : "") + this.name + "(";
        int count = 0;
        Iterator i = this.arguments.iterator();
        while (i.hasNext()) {
            if (count++ > 2) {
                s = s + "...";
                break;
            }
            Expr n = (Expr)i.next();
            s = s + n.toString();
            if (!i.hasNext()) continue;
            s = s + ", ";
        }
        s = s + ")";
        return s;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.target instanceof Expr) {
            this.printSubExpr((Expr)this.target, w, tr);
            w.write(".");
        } else if (this.target != null) {
            this.print(this.target, w, tr);
            w.write(".");
        }
        w.write(this.name + "(");
        w.begin(0);
        Iterator i = this.arguments.iterator();
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            this.print(e, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.end();
        w.write(")");
    }

    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.mi != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.mi + ")");
            w.end();
        }
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(name " + this.name + ")");
        w.end();
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(arguments " + this.arguments + ")");
        w.end();
    }

    public Term entry() {
        if (this.target instanceof Expr) {
            return ((Expr)this.target).entry();
        }
        return Call_c.listEntry(this.arguments, this);
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.target instanceof Expr) {
            Expr t = (Expr)this.target;
            v.visitCFG((Term)t, Call_c.listEntry(this.arguments, this));
        }
        v.visitCFGList(this.arguments, this);
        return succs;
    }

    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        if (this.mi == null) {
            throw new InternalCompilerError(this.position(), "Null method instance after type check.");
        }
        return super.exceptionCheck(ec);
    }

    public List throwTypes(TypeSystem ts) {
        LinkedList<ClassType> l = new LinkedList<ClassType>();
        l.addAll(this.mi.throwTypes());
        l.addAll(ts.uncheckedExceptions());
        if (this.target instanceof Expr && !(this.target instanceof Special)) {
            l.add(ts.NullPointerException());
        }
        return l;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

