/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.Binary;
import polyglot.ast.BooleanLit;
import polyglot.ast.Expr;
import polyglot.ast.IntLit;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.NumLit;
import polyglot.ast.Precedence;
import polyglot.ast.StringLit;
import polyglot.ast.Term;
import polyglot.ext.jl.ast.Expr_c;
import polyglot.types.PrimitiveType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ConstantFolder;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Binary_c
extends Expr_c
implements Binary {
    protected Expr left;
    protected Binary.Operator op;
    protected Expr right;
    protected Precedence precedence;

    public Binary_c(Position pos, Expr left, Binary.Operator op, Expr right) {
        super(pos);
        this.left = left;
        this.op = op;
        this.right = right;
        this.precedence = op.precedence();
    }

    public Expr left() {
        return this.left;
    }

    public Binary left(Expr left) {
        Binary_c n = (Binary_c)this.copy();
        n.left = left;
        return n;
    }

    public Binary.Operator operator() {
        return this.op;
    }

    public Binary operator(Binary.Operator op) {
        Binary_c n = (Binary_c)this.copy();
        n.op = op;
        return n;
    }

    public Expr right() {
        return this.right;
    }

    public Binary right(Expr right) {
        Binary_c n = (Binary_c)this.copy();
        n.right = right;
        return n;
    }

    public Precedence precedence() {
        return this.precedence;
    }

    public Binary precedence(Precedence precedence) {
        Binary_c n = (Binary_c)this.copy();
        n.precedence = precedence;
        return n;
    }

    protected Binary_c reconstruct(Expr left, Expr right) {
        if (left != this.left || right != this.right) {
            Binary_c n = (Binary_c)this.copy();
            n.left = left;
            n.right = right;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr left = (Expr)this.visitChild(this.left, v);
        Expr right = (Expr)this.visitChild(this.right, v);
        return this.reconstruct(left, right);
    }

    public Object constantValue() {
        Object lv = this.left.constantValue();
        Object rv = this.right.constantValue();
        if (lv == null || rv == null) {
            return null;
        }
        if (this.op == Binary.ADD && (lv instanceof String || rv instanceof String)) {
            return lv.toString() + rv.toString();
        }
        if (this.op == Binary.EQ && lv instanceof String && rv instanceof String) {
            return new Boolean(((String)lv).intern() == ((String)rv).intern());
        }
        if (this.op == Binary.NE && lv instanceof String && rv instanceof String) {
            return new Boolean(((String)lv).intern() != ((String)rv).intern());
        }
        if (lv instanceof Character) {
            lv = new Integer(((Character)lv).charValue());
        }
        if (rv instanceof Character) {
            rv = new Integer(((Character)rv).charValue());
        }
        try {
            if (lv instanceof Number && rv instanceof Number) {
                long r;
                long l;
                if (lv instanceof Double || rv instanceof Double) {
                    double l2 = ((Number)lv).doubleValue();
                    double r2 = ((Number)rv).doubleValue();
                    if (this.op == Binary.ADD) {
                        return new Double(l2 + r2);
                    }
                    if (this.op == Binary.SUB) {
                        return new Double(l2 - r2);
                    }
                    if (this.op == Binary.MUL) {
                        return new Double(l2 * r2);
                    }
                    if (this.op == Binary.DIV) {
                        return new Double(l2 / r2);
                    }
                    if (this.op == Binary.MOD) {
                        return new Double(l2 % r2);
                    }
                    if (this.op == Binary.EQ) {
                        return new Boolean(l2 == r2);
                    }
                    if (this.op == Binary.NE) {
                        return new Boolean(l2 != r2);
                    }
                    if (this.op == Binary.LT) {
                        return new Boolean(l2 < r2);
                    }
                    if (this.op == Binary.LE) {
                        return new Boolean(l2 <= r2);
                    }
                    if (this.op == Binary.GE) {
                        return new Boolean(l2 >= r2);
                    }
                    if (this.op == Binary.GT) {
                        return new Boolean(l2 > r2);
                    }
                    return null;
                }
                if (lv instanceof Float || rv instanceof Float) {
                    float l3 = ((Number)lv).floatValue();
                    float r3 = ((Number)rv).floatValue();
                    if (this.op == Binary.ADD) {
                        return new Float(l3 + r3);
                    }
                    if (this.op == Binary.SUB) {
                        return new Float(l3 - r3);
                    }
                    if (this.op == Binary.MUL) {
                        return new Float(l3 * r3);
                    }
                    if (this.op == Binary.DIV) {
                        return new Float(l3 / r3);
                    }
                    if (this.op == Binary.MOD) {
                        return new Float(l3 % r3);
                    }
                    if (this.op == Binary.EQ) {
                        return new Boolean(l3 == r3);
                    }
                    if (this.op == Binary.NE) {
                        return new Boolean(l3 != r3);
                    }
                    if (this.op == Binary.LT) {
                        return new Boolean(l3 < r3);
                    }
                    if (this.op == Binary.LE) {
                        return new Boolean(l3 <= r3);
                    }
                    if (this.op == Binary.GE) {
                        return new Boolean(l3 >= r3);
                    }
                    if (this.op == Binary.GT) {
                        return new Boolean(l3 > r3);
                    }
                    return null;
                }
                if (lv instanceof Long && rv instanceof Number) {
                    l = (Long)lv;
                    r = ((Number)rv).longValue();
                    if (this.op == Binary.SHL) {
                        return new Long(l << (int)r);
                    }
                    if (this.op == Binary.SHR) {
                        return new Long(l >> (int)r);
                    }
                    if (this.op == Binary.USHR) {
                        return new Long(l >>> (int)r);
                    }
                }
                if (lv instanceof Long || rv instanceof Long) {
                    l = ((Number)lv).longValue();
                    r = ((Number)rv).longValue();
                    if (this.op == Binary.ADD) {
                        return new Long(l + r);
                    }
                    if (this.op == Binary.SUB) {
                        return new Long(l - r);
                    }
                    if (this.op == Binary.MUL) {
                        return new Long(l * r);
                    }
                    if (this.op == Binary.DIV) {
                        return new Long(l / r);
                    }
                    if (this.op == Binary.MOD) {
                        return new Long(l % r);
                    }
                    if (this.op == Binary.EQ) {
                        return new Boolean(l == r);
                    }
                    if (this.op == Binary.NE) {
                        return new Boolean(l != r);
                    }
                    if (this.op == Binary.LT) {
                        return new Boolean(l < r);
                    }
                    if (this.op == Binary.LE) {
                        return new Boolean(l <= r);
                    }
                    if (this.op == Binary.GE) {
                        return new Boolean(l >= r);
                    }
                    if (this.op == Binary.GT) {
                        return new Boolean(l > r);
                    }
                    if (this.op == Binary.BIT_AND) {
                        return new Long(l & r);
                    }
                    if (this.op == Binary.BIT_OR) {
                        return new Long(l | r);
                    }
                    if (this.op == Binary.BIT_XOR) {
                        return new Long(l ^ r);
                    }
                    return null;
                }
                int l4 = ((Number)lv).intValue();
                int r4 = ((Number)rv).intValue();
                if (this.op == Binary.ADD) {
                    return new Integer(l4 + r4);
                }
                if (this.op == Binary.SUB) {
                    return new Integer(l4 - r4);
                }
                if (this.op == Binary.MUL) {
                    return new Integer(l4 * r4);
                }
                if (this.op == Binary.DIV) {
                    return new Integer(l4 / r4);
                }
                if (this.op == Binary.MOD) {
                    return new Integer(l4 % r4);
                }
                if (this.op == Binary.EQ) {
                    return new Boolean(l4 == r4);
                }
                if (this.op == Binary.NE) {
                    return new Boolean(l4 != r4);
                }
                if (this.op == Binary.LT) {
                    return new Boolean(l4 < r4);
                }
                if (this.op == Binary.LE) {
                    return new Boolean(l4 <= r4);
                }
                if (this.op == Binary.GE) {
                    return new Boolean(l4 >= r4);
                }
                if (this.op == Binary.GT) {
                    return new Boolean(l4 > r4);
                }
                if (this.op == Binary.BIT_AND) {
                    return new Integer(l4 & r4);
                }
                if (this.op == Binary.BIT_OR) {
                    return new Integer(l4 | r4);
                }
                if (this.op == Binary.BIT_XOR) {
                    return new Integer(l4 ^ r4);
                }
                if (this.op == Binary.SHL) {
                    return new Integer(l4 << r4);
                }
                if (this.op == Binary.SHR) {
                    return new Integer(l4 >> r4);
                }
                if (this.op == Binary.USHR) {
                    return new Integer(l4 >>> r4);
                }
                return null;
            }
        }
        catch (ArithmeticException e) {
            return null;
        }
        if (lv instanceof Boolean && rv instanceof Boolean) {
            boolean l = (Boolean)lv;
            boolean r = (Boolean)rv;
            if (this.op == Binary.EQ) {
                return new Boolean(l == r);
            }
            if (this.op == Binary.NE) {
                return new Boolean(l != r);
            }
            if (this.op == Binary.BIT_AND) {
                return new Boolean(l & r);
            }
            if (this.op == Binary.BIT_OR) {
                return new Boolean(l | r);
            }
            if (this.op == Binary.BIT_XOR) {
                return new Boolean(l ^ r);
            }
            if (this.op == Binary.COND_AND) {
                return new Boolean(l && r);
            }
            if (this.op == Binary.COND_OR) {
                return new Boolean(l || r);
            }
        }
        return null;
    }

    protected Node num(NodeFactory nf, long value) {
        Position p = this.position();
        Type t = this.type();
        TypeSystem ts = t.typeSystem();
        IntLit.Kind kind = IntLit.INT;
        if (this.left instanceof IntLit && ((IntLit)this.left).kind() == IntLit.LONG) {
            kind = IntLit.LONG;
        }
        if (this.right instanceof IntLit && ((IntLit)this.right).kind() == IntLit.LONG) {
            kind = IntLit.LONG;
        }
        return nf.IntLit(p, kind, value).type(t);
    }

    protected Node bool(NodeFactory nf, boolean value) {
        return nf.BooleanLit(this.position(), value).type(this.type());
    }

    public Node foldConstants(ConstantFolder cf) {
        NodeFactory nf = cf.nodeFactory();
        if (this.left instanceof NumLit && this.right instanceof NumLit) {
            long l = ((NumLit)this.left).longValue();
            long r = ((NumLit)this.right).longValue();
            if (this.op == Binary.ADD) {
                return this.num(nf, l + r);
            }
            if (this.op == Binary.SUB) {
                return this.num(nf, l - r);
            }
            if (this.op == Binary.MUL) {
                return this.num(nf, l * r);
            }
            if (this.op == Binary.DIV && r != 0L) {
                return this.num(nf, l / r);
            }
            if (this.op == Binary.MOD && r != 0L) {
                return this.num(nf, l % r);
            }
            if (this.op == Binary.BIT_OR) {
                return this.num(nf, l | r);
            }
            if (this.op == Binary.BIT_AND) {
                return this.num(nf, l & r);
            }
            if (this.op == Binary.BIT_XOR) {
                return this.num(nf, l ^ r);
            }
            if (this.op == Binary.SHL) {
                return this.num(nf, l << (int)r);
            }
            if (this.op == Binary.SHR) {
                return this.num(nf, l >> (int)r);
            }
            if (this.op == Binary.USHR) {
                return this.num(nf, l >>> (int)r);
            }
            if (this.op == Binary.GT) {
                return this.bool(nf, l > r);
            }
            if (this.op == Binary.LT) {
                return this.bool(nf, l < r);
            }
            if (this.op == Binary.GE) {
                return this.bool(nf, l >= r);
            }
            if (this.op == Binary.LE) {
                return this.bool(nf, l <= r);
            }
            if (this.op == Binary.NE) {
                return this.bool(nf, l != r);
            }
            if (this.op == Binary.EQ) {
                return this.bool(nf, l == r);
            }
        } else if (this.left instanceof NumLit) {
            long l = ((NumLit)this.left).longValue();
            if (this.op == Binary.ADD && l == 0L) {
                return this.right;
            }
            if (this.op == Binary.SUB && l == 0L) {
                return this.right;
            }
            if (this.op == Binary.MUL && l == 1L) {
                return this.right;
            }
            if (this.op == Binary.BIT_OR && l == 0L) {
                return this.right;
            }
            if (this.op == Binary.BIT_XOR && l == 0L) {
                return this.right;
            }
        } else if (this.right instanceof NumLit) {
            long r = ((NumLit)this.right).longValue();
            if (this.op == Binary.ADD && r == 0L) {
                return this.left;
            }
            if (this.op == Binary.SUB && r == 0L) {
                return this.left;
            }
            if (this.op == Binary.MUL && r == 1L) {
                return this.left;
            }
            if (this.op == Binary.DIV && r == 1L) {
                return this.left;
            }
            if (this.op == Binary.MOD && r == 1L) {
                return this.left;
            }
            if (this.op == Binary.BIT_OR && r == 0L) {
                return this.left;
            }
            if (this.op == Binary.BIT_XOR && r == 0L) {
                return this.left;
            }
            if (this.op == Binary.SHL && r == 0L) {
                return this.left;
            }
            if (this.op == Binary.SHR && r == 0L) {
                return this.left;
            }
            if (this.op == Binary.USHR && r == 0L) {
                return this.left;
            }
        } else if (this.left instanceof BooleanLit && this.right instanceof BooleanLit) {
            boolean l = ((BooleanLit)this.left).value();
            boolean r = ((BooleanLit)this.right).value();
            if (this.op == Binary.BIT_OR) {
                return nf.BooleanLit(this.position(), l | r).type(this.type());
            }
            if (this.op == Binary.BIT_AND) {
                return nf.BooleanLit(this.position(), l & r).type(this.type());
            }
            if (this.op == Binary.BIT_XOR) {
                return nf.BooleanLit(this.position(), l ^ r).type(this.type());
            }
            if (this.op == Binary.COND_OR) {
                return nf.BooleanLit(this.position(), l || r).type(this.type());
            }
            if (this.op == Binary.COND_AND) {
                return nf.BooleanLit(this.position(), l && r).type(this.type());
            }
            if (this.op == Binary.NE) {
                return nf.BooleanLit(this.position(), l != r).type(this.type());
            }
            if (this.op == Binary.EQ) {
                return nf.BooleanLit(this.position(), l == r).type(this.type());
            }
        } else if (this.left instanceof BooleanLit) {
            boolean l = ((BooleanLit)this.left).value();
            if (this.op == Binary.COND_OR && l) {
                return nf.BooleanLit(this.position(), true).type(this.type());
            }
            if (this.op == Binary.COND_AND && !l) {
                return nf.BooleanLit(this.position(), false).type(this.type());
            }
            if (this.op == Binary.COND_OR && !l) {
                return this.right;
            }
            if (this.op == Binary.COND_AND && l) {
                return this.right;
            }
            if (this.op == Binary.BIT_OR && !l) {
                return this.right;
            }
            if (this.op == Binary.BIT_AND && l) {
                return this.right;
            }
        } else if (this.left instanceof StringLit && this.right instanceof StringLit) {
            String l = ((StringLit)this.left).value();
            String r = ((StringLit)this.right).value();
        }
        return this;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Type l = this.left.type();
        Type r = this.right.type();
        TypeSystem ts = tc.typeSystem();
        if (this.op == Binary.GT || this.op == Binary.LT || this.op == Binary.GE || this.op == Binary.LE) {
            if (!l.isNumeric()) {
                throw new SemanticException("The " + this.op + " operator must have numeric operands.", this.left.position());
            }
            if (!r.isNumeric()) {
                throw new SemanticException("The " + this.op + " operator must have numeric operands.", this.right.position());
            }
            return this.type(ts.Boolean());
        }
        if (this.op == Binary.EQ || this.op == Binary.NE) {
            if (!ts.isCastValid(l, r) && !ts.isCastValid(r, l)) {
                throw new SemanticException("The " + this.op + " operator must have operands of similar type.", this.position());
            }
            return this.type(ts.Boolean());
        }
        if (this.op == Binary.COND_OR || this.op == Binary.COND_AND) {
            if (!l.isBoolean()) {
                throw new SemanticException("The " + this.op + " operator must have boolean operands.", this.left.position());
            }
            if (!r.isBoolean()) {
                throw new SemanticException("The " + this.op + " operator must have boolean operands.", this.right.position());
            }
            return this.type(ts.Boolean());
        }
        if (this.op == Binary.ADD && (ts.equals(l, ts.String()) || ts.equals(r, ts.String()))) {
            if (!ts.canCoerceToString(r, tc.context())) {
                throw new SemanticException("Cannot coerce an expression of type " + r + " to a String.", this.right.position());
            }
            if (!ts.canCoerceToString(l, tc.context())) {
                throw new SemanticException("Cannot coerce an expression of type " + l + " to a String.", this.left.position());
            }
            return this.precedence(Precedence.STRING_ADD).type(ts.String());
        }
        if ((this.op == Binary.BIT_AND || this.op == Binary.BIT_OR || this.op == Binary.BIT_XOR) && l.isBoolean() && r.isBoolean()) {
            return this.type(ts.Boolean());
        }
        if (this.op == Binary.ADD) {
            if (!l.isNumeric()) {
                throw new SemanticException("The " + this.op + " operator must have numeric or String operands.", this.left.position());
            }
            if (!r.isNumeric()) {
                throw new SemanticException("The " + this.op + " operator must have numeric or String operands.", this.right.position());
            }
        }
        if (this.op == Binary.BIT_AND || this.op == Binary.BIT_OR || this.op == Binary.BIT_XOR) {
            if (!ts.isImplicitCastValid(l, ts.Long())) {
                throw new SemanticException("The " + this.op + " operator must have numeric or boolean operands.", this.left.position());
            }
            if (!ts.isImplicitCastValid(r, ts.Long())) {
                throw new SemanticException("The " + this.op + " operator must have numeric or boolean operands.", this.right.position());
            }
        }
        if (this.op == Binary.SUB || this.op == Binary.MUL || this.op == Binary.DIV || this.op == Binary.MOD) {
            if (!l.isNumeric()) {
                throw new SemanticException("The " + this.op + " operator must have numeric operands.", this.left.position());
            }
            if (!r.isNumeric()) {
                throw new SemanticException("The " + this.op + " operator must have numeric operands.", this.right.position());
            }
        }
        if (this.op == Binary.SHL || this.op == Binary.SHR || this.op == Binary.USHR) {
            if (!ts.isImplicitCastValid(l, ts.Long())) {
                throw new SemanticException("The " + this.op + " operator must have numeric operands.", this.left.position());
            }
            if (!ts.isImplicitCastValid(r, ts.Long())) {
                throw new SemanticException("The " + this.op + " operator must have numeric operands.", this.right.position());
            }
        }
        if (this.op == Binary.SHL || this.op == Binary.SHR || this.op == Binary.USHR) {
            return this.type(ts.promote(l));
        }
        return this.type(ts.promote(l, r));
    }

    /*
     * WARNING - void declaration
     */
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        Expr other;
        if (child == this.left) {
            other = this.right;
        } else if (child == this.right) {
            other = this.left;
        } else {
            return child.type();
        }
        TypeSystem ts = av.typeSystem();
        try {
            void var3_3;
            if (this.op == Binary.EQ || this.op == Binary.NE) {
                if ((child.type().isReference() || child.type().isNull()) && (var3_3.type().isReference() || var3_3.type().isNull())) {
                    return ts.leastCommonAncestor(child.type(), var3_3.type());
                }
                if (child.type().isBoolean() && var3_3.type().isBoolean()) {
                    return ts.Boolean();
                }
                if (child.type().isNumeric() && var3_3.type().isNumeric()) {
                    return ts.promote(child.type(), var3_3.type());
                }
                if (child.type().isImplicitCastValid(var3_3.type())) {
                    return var3_3.type();
                }
                return child.type();
            }
            if (this.op == Binary.ADD && ts.equals(this.type, ts.String())) {
                return ts.String();
            }
            if (this.op == Binary.GT || this.op == Binary.LT || this.op == Binary.GE || this.op == Binary.LE) {
                if (child.type().isNumeric() && var3_3.type().isNumeric()) {
                    return ts.promote(child.type(), var3_3.type());
                }
                return child.type();
            }
            if (this.op == Binary.COND_OR || this.op == Binary.COND_AND) {
                return ts.Boolean();
            }
            if (this.op == Binary.BIT_AND || this.op == Binary.BIT_OR || this.op == Binary.BIT_XOR) {
                if (var3_3.type().isBoolean()) {
                    return ts.Boolean();
                }
                if (child.type().isNumeric() && var3_3.type().isNumeric()) {
                    return ts.promote(child.type(), var3_3.type());
                }
                return child.type();
            }
            if (this.op == Binary.ADD || this.op == Binary.SUB || this.op == Binary.MUL || this.op == Binary.DIV || this.op == Binary.MOD) {
                if (child.type().isNumeric() && var3_3.type().isNumeric()) {
                    PrimitiveType t = ts.promote(child.type(), var3_3.type());
                    if (ts.isImplicitCastValid(t, av.toType())) {
                        return t;
                    }
                    return av.toType();
                }
                return child.type();
            }
            if (this.op == Binary.SHL || this.op == Binary.SHR || this.op == Binary.USHR) {
                if (child.type().isNumeric() && var3_3.type().isNumeric()) {
                    if (child == this.left) {
                        PrimitiveType t = ts.promote(child.type());
                        if (ts.isImplicitCastValid(t, av.toType())) {
                            return t;
                        }
                        return av.toType();
                    }
                    return ts.promote(child.type());
                }
                return child.type();
            }
            return child.type();
        }
        catch (SemanticException e) {
            return child.type();
        }
    }

    public boolean throwsArithmeticException() {
        return this.op == Binary.DIV || this.op == Binary.MOD;
    }

    public String toString() {
        return this.left + " " + this.op + " " + this.right;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.printSubExpr(this.left, true, w, tr);
        w.write(" ");
        w.write(this.op.toString());
        w.allowBreak(this.type() == null || this.type().isPrimitive() ? 2 : 0, " ");
        this.printSubExpr(this.right, false, w, tr);
    }

    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.type != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(type " + this.type + ")");
            w.end();
        }
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(operator " + this.op + ")");
        w.end();
    }

    public Term entry() {
        return this.left.entry();
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.op == Binary.COND_AND || this.op == Binary.COND_OR) {
            if (this.left instanceof BooleanLit) {
                BooleanLit b = (BooleanLit)this.left;
                if (b.value() && this.op == Binary.COND_OR || !b.value() && this.op == Binary.COND_AND) {
                    v.visitCFG((Term)this.left, this);
                } else {
                    v.visitCFG((Term)this.left, this.right.entry());
                    v.visitCFG((Term)this.right, this);
                }
            } else {
                if (this.op == Binary.COND_AND) {
                    v.visitCFG(this.left, FlowGraph.EDGE_KEY_TRUE, this.right.entry(), FlowGraph.EDGE_KEY_FALSE, this);
                } else {
                    v.visitCFG(this.left, FlowGraph.EDGE_KEY_FALSE, this.right.entry(), FlowGraph.EDGE_KEY_TRUE, this);
                }
                v.visitCFG((Term)this.right, this);
            }
        } else {
            v.visitCFG((Term)this.left, this.right.entry());
            v.visitCFG((Term)this.right, this);
        }
        return succs;
    }

    public List throwTypes(TypeSystem ts) {
        if (this.throwsArithmeticException()) {
            return Collections.singletonList(ts.ArithmeticException());
        }
        return Collections.EMPTY_LIST;
    }
}

