/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.toolkits.bandera;

import edu.ksu.cis.bandera.tool.ToolConfigurationView;
import edu.ksu.cis.bandera.tool.ToolIconView;
import edu.ksu.cis.indus.toolkits.bandera.OFATool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import soot.IntType;
import soot.Scene;
import soot.SootMethod;
import soot.Type;

public class OFAToolTest
extends TestCase {
    public void setNonEmptyConfigurations() {
        OFATool oFATool = new OFATool();
        String[] stringArray = new String[]{"a", "1", "#", ".", "<configuration/>", "someConfigurationString"};
        for (int i = 0; i < stringArray.length; ++i) {
            oFATool.setConfiguration(stringArray[i]);
        }
    }

    public void testCreation() {
        try {
            new OFATool();
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)"Could not create an instance of the tool");
        }
    }

    public void testGetConfiguration() {
        OFATool oFATool = new OFATool();
        String string = oFATool.getConfiguration();
        OFAToolTest.assertNull((String)"The configuration String should be null.", (Object)string);
    }

    public void testGetInputParameterList() {
        OFATool oFATool = new OFATool();
        List list = oFATool.getInputParameterList();
        OFAToolTest.assertNotNull((String)"The input parameter list should not be null.", (Object)list);
        OFAToolTest.assertTrue((String)"The input parameter list is not big enough.", (list.size() >= 1 ? 1 : 0) != 0);
        OFAToolTest.assertTrue((String)"The input parameter list should contain the scene key.", (boolean)list.contains("scene"));
        OFAToolTest.assertTrue((String)"The input parameter list should contain the entry points key.", (boolean)list.contains("entryPoints"));
    }

    public void testGetOutputParameterList() {
        OFATool oFATool = new OFATool();
        List list = oFATool.getOutputParameterList();
        OFAToolTest.assertNotNull((String)"The output parameter list should not be null.", (Object)list);
        OFAToolTest.assertTrue((String)"The output parameter list is not big enough.", (list.size() >= 1 ? 1 : 0) != 0);
        OFAToolTest.assertTrue((String)"The output parameter list should contain callgraph key.", (boolean)list.contains("callgraph"));
        OFAToolTest.assertTrue((String)"The output parameter list should contain the reachable class and fields key.", (boolean)list.contains("reachableClassesAndFields"));
    }

    public void testQuit() {
        OFATool oFATool = new OFATool();
        oFATool.quit();
    }

    public void testSetEmptyConfiguration() {
        OFATool oFATool = new OFATool();
        oFATool.setConfiguration("");
    }

    public void testSetEmptyInputMap() {
        OFATool oFATool = new OFATool();
        try {
            HashMap hashMap = new HashMap(0);
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an empty Map should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an empty Map should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testSetNullConfiguration() {
        OFATool oFATool = new OFATool();
        oFATool.setConfiguration(null);
    }

    public void testSetNullInputMap() {
        OFATool oFATool = new OFATool();
        try {
            Map map = null;
            oFATool.setInputMap(map);
            OFAToolTest.fail((String)"Calling setInputMap with a null Map should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with a null Map should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testToolConfigurationView() {
        OFATool oFATool = new OFATool();
        ToolConfigurationView toolConfigurationView = oFATool.getToolConfigurationView();
        OFAToolTest.assertNull((String)"The ToolConfigurationView should be null.", (Object)toolConfigurationView);
    }

    public void testToolIconView() {
        OFATool oFATool = new OFATool();
        ToolIconView toolIconView = oFATool.getToolIconView();
        OFAToolTest.assertNull((String)"The ToolIconView should be null.", (Object)toolIconView);
    }

    public void testsetInputMapWithEmptySceneAndEmptyEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap hashMap = new HashMap(1);
            hashMap.put("entryPoints", new HashSet(0));
            hashMap.put("scene", Scene.v());
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (empty scene, empty entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (empty scene, empty entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithEmptySceneAndNoEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap<String, Scene> hashMap = new HashMap<String, Scene>(1);
            hashMap.put("scene", Scene.v());
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (empty scene, no entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (empty scene, no entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithEmptySceneAndNullEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap<String, Scene> hashMap = new HashMap<String, Scene>(1);
            hashMap.put("entryPoints", null);
            hashMap.put("scene", Scene.v());
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (empty scene, null entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (empty scene, null entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithEmptySceneAndObjectEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
            hashMap.put("entryPoints", new Object());
            hashMap.put("scene", Scene.v());
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (empty scene, Object entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (empty scene, Object entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithEmptySceneAndValidEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap hashMap = new HashMap(1);
            HashSet<SootMethod> hashSet = new HashSet<SootMethod>(1);
            SootMethod sootMethod = new SootMethod("someMethod", new ArrayList(0), (Type)IntType.v());
            hashSet.add(sootMethod);
            hashMap.put("entryPoints", hashSet);
            hashMap.put("scene", Scene.v());
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (empty scene, valid entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (empty scene, valid entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithNoSceneAndEmptyEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap hashMap = new HashMap(1);
            hashMap.put("entryPoints", new HashSet(0));
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (no scene, empty entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (no scene, empty entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithNoSceneAndNullEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
            hashMap.put("entryPoints", null);
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (no scene, null entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (no scene, null entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithNoSceneAndObjectEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
            hashMap.put("entryPoints", new Object());
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (no scene, Object entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (no scene, Object entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithNoSceneAndValidEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap hashMap = new HashMap(1);
            HashSet<SootMethod> hashSet = new HashSet<SootMethod>(1);
            SootMethod sootMethod = new SootMethod("someMethod", new ArrayList(0), (Type)IntType.v());
            hashSet.add(sootMethod);
            hashMap.put("entryPoints", hashSet);
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (no scene, valid entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (no scene, valid entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithNullSceneAndEmptyEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap hashMap = new HashMap(1);
            hashMap.put("entryPoints", new HashSet(0));
            hashMap.put("scene", null);
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (null scene, empty entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (null scene, empty entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithNullSceneAndNoEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
            hashMap.put("scene", null);
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (null scene, no entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (null scene, no entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithNullSceneAndNullEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
            hashMap.put("entryPoints", null);
            hashMap.put("scene", null);
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (null scene, null entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (null scene, null entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithNullSceneAndObjectEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
            hashMap.put("entryPoints", new Object());
            hashMap.put("scene", null);
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (null scene, Object entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (null scene, Object entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithNullSceneAndValidEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap hashMap = new HashMap(1);
            HashSet<SootMethod> hashSet = new HashSet<SootMethod>(1);
            SootMethod sootMethod = new SootMethod("someMethod", new ArrayList(0), (Type)IntType.v());
            hashSet.add(sootMethod);
            hashMap.put("entryPoints", hashSet);
            hashMap.put("scene", null);
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (null scene, valid entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (null scene, valid entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithObjectSceneAndEmptyEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
            hashMap.put("entryPoints", new HashSet(0));
            hashMap.put("scene", new Object());
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (Object scene, empty entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (Object scene, empty entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithObjectSceneAndNoEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
            hashMap.put("scene", new Object());
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (Object scene, no entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (Object scene, no entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithObjectSceneAndNullEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
            hashMap.put("entryPoints", null);
            hashMap.put("scene", new Object());
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (Object scene, null entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (Object scene, null entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithObjectSceneAndObjectEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
            hashMap.put("entryPoints", new Object());
            hashMap.put("scene", new Object());
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (Object scene, Object entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (Object scene, Object entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithObjectSceneAndValidEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
            HashSet<SootMethod> hashSet = new HashSet<SootMethod>(1);
            SootMethod sootMethod = new SootMethod("someMethod", new ArrayList(0), (Type)IntType.v());
            hashSet.add(sootMethod);
            hashMap.put("entryPoints", hashSet);
            hashMap.put("scene", new Object());
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (Object scene, valid entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (Object scene, valid entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithValidSceneAndEmptyEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap hashMap = new HashMap(1);
            hashMap.put("entryPoints", new HashSet(0));
            hashMap.put("scene", Scene.v());
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (valid scene, empty entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (valid scene, empty entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithValidSceneAndNoEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap<String, Scene> hashMap = new HashMap<String, Scene>(1);
            hashMap.put("scene", Scene.v());
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (valid scene, no entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (valid scene, no entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithValidSceneAndNullEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap<String, Scene> hashMap = new HashMap<String, Scene>(1);
            hashMap.put("entryPoints", null);
            hashMap.put("scene", Scene.v());
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (valid scene, null entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (valid scene, null entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }

    public void testsetInputMapWithValidSceneAndObjectEntryPoints() {
        OFATool oFATool = new OFATool();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
            hashMap.put("entryPoints", new Object());
            hashMap.put("scene", Scene.v());
            oFATool.setInputMap(hashMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (valid scene, Object entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (valid scene, Object entry points) should throw an IllegalArgumentException.  Got instead: " + exception.toString()));
        }
    }
}

