/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.toolkits.bandera;

import edu.ksu.cis.bandera.tool.Tool;
import edu.ksu.cis.bandera.tool.ToolConfigurationView;
import edu.ksu.cis.bandera.tool.ToolIconView;
import edu.ksu.cis.bandera.util.BaseObservable;
import edu.ksu.cis.indus.common.soot.ExceptionFlowSensitiveStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.CallGraph;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.ValueAnalyzerBasedProcessingController;
import edu.ksu.cis.indus.staticanalyses.tokens.TokenUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Scene;
import soot.SootClass;
import soot.util.Chain;

public final class OFATool
extends BaseObservable
implements Tool {
    public static final String SCENE_INPUT_KEY = "scene";
    public static final String ENTRY_POINTS_INPUT_KEY = "entryPoints";
    public static final String CALL_GRAPH_OUTPUT_KEY = "callgraph";
    public static final String REACHABLE_CLASSES_AND_FIELDS_OUTPUT_KEY = "reachableClassesAndFields";
    private static List inputParameterList;
    private static List outputParameterList;
    private ICallGraphInfo callgraph;
    private final Map reachableClass2Fields = new HashMap();
    private Scene scene;
    private Set entryPoints;

    public void setConfiguration(String string) {
    }

    public String getConfiguration() {
        return null;
    }

    public void setInputMap(Map map) throws Exception {
        if (map == null) {
            throw new IllegalArgumentException("The input Map cannot be null.");
        }
        int n = map.size();
        if (n < 2) {
            throw new IllegalArgumentException("The input Map must have at least two values.");
        }
        Object v = map.get(SCENE_INPUT_KEY);
        if (v == null) {
            throw new IllegalArgumentException("A scene is required.");
        }
        if (!(v instanceof Scene)) {
            throw new IllegalArgumentException("A scene of type soot.Scene is required.");
        }
        Scene scene = (Scene)v;
        Chain chain = scene.getClasses();
        if (chain == null) {
            throw new IllegalArgumentException("Cannot use an empty scene.");
        }
        if (chain.size() < 1) {
            throw new IllegalArgumentException("Cannot use an empty scene.");
        }
        Object v2 = map.get(ENTRY_POINTS_INPUT_KEY);
        if (v2 == null) {
            throw new IllegalArgumentException("The set of entry points is required.");
        }
        if (!(v2 instanceof Set)) {
            throw new IllegalArgumentException("The set of entry points must be of type Set.");
        }
        Set set = (Set)v2;
        if (set.size() < 1) {
            throw new IllegalArgumentException("The set of entry points must have at least one entry point");
        }
        this.scene = scene;
        this.entryPoints = set;
    }

    public List getInputParameterList() {
        return inputParameterList;
    }

    public Map getOutputMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
        hashMap.put(CALL_GRAPH_OUTPUT_KEY, this.callgraph);
        hashMap.put(REACHABLE_CLASSES_AND_FIELDS_OUTPUT_KEY, Collections.unmodifiableMap(this.reachableClass2Fields));
        return hashMap;
    }

    public List getOutputParameterList() {
        return outputParameterList;
    }

    public ToolConfigurationView getToolConfigurationView() {
        return null;
    }

    public ToolIconView getToolIconView() {
        return null;
    }

    public void quit() {
    }

    public void run() throws IllegalStateException {
        if (this.scene == null) {
            throw new IllegalStateException("Cannot run with a null Scene.");
        }
        if (this.entryPoints == null) {
            throw new IllegalStateException("Cannot run with a null Set of entry points.");
        }
        OFAnalyzer oFAnalyzer = OFAnalyzer.getFSOSAnalyzer("CallGraphXMLizer:FA", TokenUtil.getTokenManager());
        ValueAnalyzerBasedProcessingController valueAnalyzerBasedProcessingController = new ValueAnalyzerBasedProcessingController();
        ArrayList<ICallGraphInfo> arrayList = new ArrayList<ICallGraphInfo>();
        this.callgraph = new CallGraph();
        valueAnalyzerBasedProcessingController.setAnalyzer(oFAnalyzer);
        valueAnalyzerBasedProcessingController.setProcessingFilter((IProcessingFilter)new TagBasedProcessingFilter("CallGraphXMLizer:FA"));
        valueAnalyzerBasedProcessingController.setStmtGraphFactory((IStmtGraphFactory)new ExceptionFlowSensitiveStmtGraphFactory());
        HashMap<String, ICallGraphInfo> hashMap = new HashMap<String, ICallGraphInfo>();
        hashMap.put("Callgraph Information", this.callgraph);
        oFAnalyzer.reset();
        oFAnalyzer.analyze(this.scene, this.entryPoints);
        ((CallGraph)this.callgraph).reset();
        arrayList.clear();
        arrayList.add(this.callgraph);
        valueAnalyzerBasedProcessingController.reset();
        valueAnalyzerBasedProcessingController.driveProcessors(arrayList);
        arrayList.clear();
        this.retrieveReachableClassesAndFields(oFAnalyzer, "CallGraphXMLizer:FA");
    }

    private static void initInputParameters() {
        inputParameterList = new ArrayList(2);
        inputParameterList.add(SCENE_INPUT_KEY);
        inputParameterList.add(ENTRY_POINTS_INPUT_KEY);
    }

    private static void initOutputParameters() {
        outputParameterList = new ArrayList(1);
        outputParameterList.add(CALL_GRAPH_OUTPUT_KEY);
        outputParameterList.add(REACHABLE_CLASSES_AND_FIELDS_OUTPUT_KEY);
    }

    private void retrieveReachableClassesAndFields(IValueAnalyzer iValueAnalyzer, String string) {
        Iterator iterator = iValueAnalyzer.getEnvironment().getClasses().iterator();
        while (iterator.hasNext()) {
            SootClass sootClass = (SootClass)iterator.next();
            Collection collection = Util.getHostsWithTag((Collection)sootClass.getFields(), (String)string);
            this.reachableClass2Fields.put(sootClass, collection);
        }
    }

    static {
        OFATool.initInputParameters();
        OFATool.initOutputParameters();
    }
}

