/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.tokens;

import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.staticanalyses.tokens.IType;
import edu.ksu.cis.indus.staticanalyses.tokens.ITypeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.RefType;
import soot.SootClass;
import soot.Type;
import soot.Value;

public class SootValueTypeManager
implements ITypeManager {
    private final Map sootType2Type = new HashMap();

    public Collection getAllTypes(Object object) {
        Collection<Object> collection;
        Value value = (Value)object;
        Type type = value.getType();
        if (type instanceof RefType) {
            collection = new ArrayList<IType>();
            collection.add(this.getTypeForIRType(type));
            Iterator iterator = Util.getAncestors((SootClass)((RefType)type).getSootClass()).iterator();
            while (iterator.hasNext()) {
                collection.add(this.getTypeForIRType((Type)((SootClass)iterator.next()).getType()));
            }
        } else {
            collection = Collections.singleton(this.getTypeForIRType(type));
        }
        return collection;
    }

    public IType getExactType(Object object) {
        return this.getTypeForIRType(((Value)object).getType());
    }

    public IType getTypeForIRType(Type type) {
        IType iType = (IType)this.sootType2Type.get(type);
        if (iType == null) {
            iType = new IType(){};
            this.sootType2Type.put(type, iType);
        }
        return iType;
    }

    public void reset() {
        this.sootType2Type.clear();
    }
}

