/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.tokens;

import edu.ksu.cis.indus.common.CollectionsUtilities;
import edu.ksu.cis.indus.interfaces.AbstractPrototype;
import edu.ksu.cis.indus.staticanalyses.tokens.AbstractTokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenFilter;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.staticanalyses.tokens.IType;
import edu.ksu.cis.indus.staticanalyses.tokens.ITypeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Factory;

public class IntegerTokenManager
extends AbstractTokenManager {
    static final int NO_OF_BITS_IN_AN_INTEGER = 31;
    final List valueList = new ArrayList();
    final Map type2tokens = new HashMap();

    public IntegerTokenManager(ITypeManager iTypeManager) {
        super(iTypeManager);
    }

    public ITokens getNewTokenSet() {
        return new IntegerTokens(this);
    }

    public ITokens getTokens(Collection collection) {
        IntegerTokens integerTokens = new IntegerTokens(this);
        if (!collection.isEmpty()) {
            Collection collection2 = CollectionUtils.intersection((Collection)this.valueList, (Collection)collection);
            Object object = collection2.iterator();
            while (object.hasNext()) {
                integerTokens.integer |= 1 << this.valueList.indexOf(object.next());
            }
            object = CollectionUtils.subtract((Collection)collection, (Collection)collection2);
            int n = 1 << this.valueList.size();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                if (this.valueList.size() == 31) {
                    throw new IllegalStateException("This token manager cannot handle a type system instance with more than 31 values.");
                }
                Object e = iterator.next();
                this.valueList.add(e);
                integerTokens.integer |= n;
                Collection collection3 = this.typeMgr.getAllTypes(e);
                Iterator iterator2 = collection3.iterator();
                while (iterator2.hasNext()) {
                    Object e2 = iterator2.next();
                    MutableInteger mutableInteger = (MutableInteger)CollectionsUtilities.getFromMap((Map)this.type2tokens, e2, (Factory)MutableInteger.FACTORY);
                    mutableInteger.setValue(mutableInteger.intValue() | n);
                }
                n <<= 1;
            }
        }
        return integerTokens;
    }

    public ITokenFilter getTypeBasedFilter(IType iType) {
        IntegerTokenFilter integerTokenFilter = new IntegerTokenFilter(iType);
        return integerTokenFilter;
    }

    public void reset() {
        this.type2tokens.clear();
        this.valueList.clear();
    }

    class IntegerTokens
    extends AbstractPrototype
    implements ITokens {
        int integer;
        private IntegerTokenManager tokenMgr;

        IntegerTokens(IntegerTokenManager integerTokenManager2) {
            this.tokenMgr = integerTokenManager2;
        }

        public Object getClone() {
            IntegerTokens integerTokens = new IntegerTokens(this.tokenMgr);
            integerTokens.integer = this.integer;
            return integerTokens;
        }

        public boolean isEmpty() {
            return this.integer == 0;
        }

        public Collection getValues() {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < 31; ++i) {
                if ((this.integer & 1 << i) <= 0) continue;
                arrayList.add(this.tokenMgr.valueList.get(i));
            }
            return arrayList;
        }

        public void addTokens(ITokens iTokens) {
            this.integer |= ((IntegerTokens)iTokens).integer;
        }

        public void clear() {
            this.integer = 0;
        }

        public ITokens diffTokens(ITokens iTokens) {
            IntegerTokens integerTokens = new IntegerTokens(this.tokenMgr);
            integerTokens.integer = this.integer & ~((IntegerTokens)iTokens).integer;
            return integerTokens;
        }
    }

    public static class MutableInteger
    extends Number {
        public static final Factory FACTORY = new Factory(){

            public Object create() {
                return new MutableInteger();
            }
        };
        private int value;

        public void setValue(int n) {
            this.value = n;
        }

        public double doubleValue() {
            return this.value;
        }

        public float floatValue() {
            return this.value;
        }

        public int intValue() {
            return this.value;
        }

        public long longValue() {
            return this.value;
        }
    }

    public class IntegerTokenFilter
    implements ITokenFilter {
        final Object filterType;

        IntegerTokenFilter(Object object) {
            this.filterType = object;
        }

        public ITokens filter(ITokens iTokens) {
            IntegerTokens integerTokens = new IntegerTokens(IntegerTokenManager.this);
            integerTokens.integer |= ((IntegerTokens)iTokens).integer;
            MutableInteger mutableInteger = (MutableInteger)CollectionsUtilities.getFromMap((Map)IntegerTokenManager.this.type2tokens, (Object)this.filterType, (Factory)MutableInteger.FACTORY);
            integerTokens.integer &= mutableInteger.intValue();
            return integerTokens;
        }
    }
}

