/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.tokens;

import edu.ksu.cis.indus.interfaces.AbstractPrototype;
import edu.ksu.cis.indus.staticanalyses.tokens.AbstractTokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenFilter;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.staticanalyses.tokens.IType;
import edu.ksu.cis.indus.staticanalyses.tokens.ITypeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CollectionTokenManager
extends AbstractTokenManager {
    static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$tokens$CollectionTokenManager == null ? (class$edu$ksu$cis$indus$staticanalyses$tokens$CollectionTokenManager = CollectionTokenManager.class$("edu.ksu.cis.indus.staticanalyses.tokens.CollectionTokenManager")) : class$edu$ksu$cis$indus$staticanalyses$tokens$CollectionTokenManager));
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$tokens$CollectionTokenManager;

    public CollectionTokenManager(ITypeManager iTypeManager) {
        super(iTypeManager);
    }

    public ITokens getNewTokenSet() {
        return new CollectionTokens(Collections.EMPTY_LIST);
    }

    public ITokens getTokens(Collection collection) {
        return new CollectionTokens(collection);
    }

    public ITokenFilter getTypeBasedFilter(IType iType) {
        CollectionTokenFilter collectionTokenFilter = new CollectionTokenFilter(iType);
        return collectionTokenFilter;
    }

    public void reset() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CollectionTokens
    extends AbstractPrototype
    implements ITokens {
        private Collection values;

        CollectionTokens(Collection collection) {
            this.values = new HashSet(collection);
        }

        public Object getClone() {
            return new CollectionTokens(this.values);
        }

        public boolean isEmpty() {
            return this.values.isEmpty();
        }

        public Collection getValues() {
            return Collections.unmodifiableCollection(this.values);
        }

        public void addTokens(ITokens iTokens) {
            this.values.addAll(((CollectionTokens)iTokens).values);
        }

        public void clear() {
            this.values.clear();
        }

        public ITokens diffTokens(ITokens iTokens) {
            return new CollectionTokens(CollectionUtils.subtract((Collection)this.values, (Collection)((CollectionTokens)iTokens).values));
        }
    }

    private class CollectionTokenFilter
    implements ITokenFilter {
        private final IType filterType;

        CollectionTokenFilter(IType iType) {
            this.filterType = iType;
        }

        public ITokens filter(ITokens iTokens) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = iTokens.getValues().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!CollectionTokenManager.this.typeMgr.getAllTypes(e).contains(this.filterType)) continue;
                arrayList.add(e);
            }
            return CollectionTokenManager.this.getTokens(arrayList);
        }
    }
}

