/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.tokens;

import edu.ksu.cis.indus.IndusTestCase;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenFilter;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.staticanalyses.tokens.ITypeManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import soot.jimple.IntConstant;
import soot.jimple.StringConstant;

public abstract class AbstractTokenManagerTest
extends IndusTestCase {
    protected Collection values = new HashSet();
    protected ITokenManager tokenManager;

    public void testGetTokens() {
        ITokens iTokens = this.tokenManager.getTokens(this.values);
        AbstractTokenManagerTest.assertNotNull((Object)iTokens);
        AbstractTokenManagerTest.assertTrue((boolean)iTokens.getValues().containsAll(this.values));
        AbstractTokenManagerTest.assertTrue((boolean)this.values.containsAll(iTokens.getValues()));
    }

    public final void testGetTypeBasedFilter() {
        ITypeManager iTypeManager = this.tokenManager.getTypeManager();
        ITokenFilter iTokenFilter = this.tokenManager.getTypeBasedFilter(iTypeManager.getExactType(this.values.iterator().next()));
        AbstractTokenManagerTest.assertNotNull((Object)iTokenFilter);
        ITokens iTokens = this.tokenManager.getTokens(Collections.singleton(IntConstant.v((int)1)));
        AbstractTokenManagerTest.assertTrue((boolean)iTokenFilter.filter(iTokens).isEmpty());
        ITokens iTokens2 = this.tokenManager.getTokens(Collections.singleton(StringConstant.v((String)"string")));
        AbstractTokenManagerTest.assertFalse((boolean)iTokenFilter.filter(iTokens2).isEmpty());
    }

    public final void testGetTypeManager() {
        ITypeManager iTypeManager = this.tokenManager.getTypeManager();
        AbstractTokenManagerTest.assertNotNull((Object)iTypeManager);
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            AbstractTokenManagerTest.assertNotNull((Object)iTypeManager.getExactType(e));
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.values.add(StringConstant.v((String)"Hi"));
        this.values.add(StringConstant.v((String)"Bye"));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.values.clear();
        this.values = null;
    }
}

