/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.interfaces;

import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.interfaces.AbstractStatus;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzerBasedProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.SootMethod;
import soot.toolkits.graph.UnitGraph;

public abstract class AbstractAnalysis
extends AbstractStatus {
    protected IValueAnalyzerBasedProcessor preprocessor;
    protected final Map info = new HashMap();
    private BasicBlockGraphMgr graphManager;

    public abstract void analyze();

    public IValueAnalyzerBasedProcessor getPreProcessor() {
        return this.preprocessor;
    }

    public String getStatistics() {
        return ((Object)((Object)this)).getClass() + " does not implement this method.";
    }

    public boolean doesPreProcessing() {
        return this.preprocessor != null;
    }

    public final void initialize(Map map) throws InitializationException {
        this.info.putAll(map);
        this.setup();
    }

    public void setBasicBlockGraphManager(BasicBlockGraphMgr basicBlockGraphMgr) {
        this.graphManager = basicBlockGraphMgr;
    }

    public void reset() {
        this.unstable();
        this.info.clear();
    }

    protected BasicBlockGraph getBasicBlockGraph(SootMethod sootMethod) {
        return this.graphManager.getBasicBlockGraph(sootMethod);
    }

    protected List getStmtList(SootMethod sootMethod) {
        ArrayList arrayList = Collections.EMPTY_LIST;
        UnitGraph unitGraph = this.graphManager.getUnitGraph(sootMethod);
        if (unitGraph != null) {
            arrayList = new ArrayList(unitGraph.getBody().getUnits());
        }
        return arrayList;
    }

    protected UnitGraph getUnitGraph(SootMethod sootMethod) {
        return this.graphManager.getUnitGraph(sootMethod);
    }

    protected void setup() throws InitializationException {
    }
}

