/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors;

import edu.ksu.cis.indus.common.CollectionsUtilities;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.AbstractValueAnalyzerBasedProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Factory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.RefLikeType;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.NewExpr;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;

public class ThreadGraph
extends AbstractValueAnalyzerBasedProcessor
implements IThreadGraphInfo {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$processors$ThreadGraph == null ? (class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$processors$ThreadGraph = ThreadGraph.class$("edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.ThreadGraph")) : class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$processors$ThreadGraph));
    final CFGAnalysis cfgAnalysis;
    private final Collection newThreadExprs = new HashSet();
    private final Collection startSites = new HashSet();
    private final Collection threadAllocSitesMulti;
    private final Collection threadAllocSitesSingle;
    private final ICallGraphInfo cgi;
    private final Map method2threads = new HashMap();
    private final Map thread2methods = new HashMap();
    private OFAnalyzer analyzer;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$processors$ThreadGraph;
    static /* synthetic */ Class class$soot$jimple$NewExpr;
    static /* synthetic */ Class class$soot$jimple$VirtualInvokeExpr;

    public ThreadGraph(ICallGraphInfo iCallGraphInfo, CFGAnalysis cFGAnalysis) {
        this.cgi = iCallGraphInfo;
        this.threadAllocSitesSingle = new HashSet();
        this.threadAllocSitesMulti = new HashSet();
        this.cfgAnalysis = cFGAnalysis;
    }

    public Collection getAllocationSites() {
        return Collections.unmodifiableCollection(this.newThreadExprs);
    }

    public void setAnalyzer(IValueAnalyzer iValueAnalyzer) {
        this.analyzer = (OFAnalyzer)iValueAnalyzer;
    }

    public Collection getExecutedMethods(NewExpr newExpr, Context context) {
        Set<Object> set = (Set)this.thread2methods.get(new IThreadGraphInfo.NewExprTriple(context.getCurrentMethod(), context.getStmt(), newExpr));
        set = set == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(set);
        return set;
    }

    public Collection getExecutionThreads(SootMethod sootMethod) {
        Set<Object> set = (Set)this.method2threads.get(sootMethod);
        set = set == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(set);
        return set;
    }

    public Object getId() {
        return "Threadgraph Information";
    }

    public Collection getMultiThreadAllocSites() {
        return Collections.unmodifiableCollection(this.threadAllocSitesMulti);
    }

    public Collection getStartSites() {
        return Collections.unmodifiableCollection(this.startSites);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void callback(ValueBox valueBox, Context context) {
        IEnvironment iEnvironment = this.analyzer.getEnvironment();
        Value value = valueBox.getValue();
        if (value instanceof NewExpr) {
            NewExpr newExpr = (NewExpr)value;
            SootClass sootClass = iEnvironment.getClass(newExpr.getBaseType().getClassName());
            if (!Util.isDescendentOf((SootClass)sootClass, (String)"java.lang.Thread")) return;
            SootClass sootClass2 = Util.getDeclaringClass((SootClass)sootClass, (String)"start", (List)Collections.EMPTY_LIST, (Type)VoidType.v());
            if (sootClass2 != null && sootClass2.getName().equals("java.lang.Thread")) {
                Stmt stmt = context.getStmt();
                SootMethod sootMethod = context.getCurrentMethod();
                IThreadGraphInfo.NewExprTriple newExprTriple = new IThreadGraphInfo.NewExprTriple(sootMethod, stmt, newExpr);
                this.newThreadExprs.add(newExprTriple);
                if (this.cfgAnalysis.checkForLoopEnclosedNewExpr(stmt, sootMethod)) {
                    this.threadAllocSitesMulti.add(newExprTriple);
                    return;
                }
                this.threadAllocSitesSingle.add(newExprTriple);
                return;
            }
            if (!LOGGER.isWarnEnabled()) throw new RuntimeException("start() method is unavailable via " + sootClass + " even though it is a descendent of java.lang.Thread.");
            LOGGER.warn((Object)"How can there be a descendent of java.lang.Thread without access to start() method.");
            throw new RuntimeException("start() method is unavailable via " + sootClass + " even though it is a descendent of java.lang.Thread.");
        }
        if (!(value instanceof VirtualInvokeExpr)) return;
        VirtualInvokeExpr virtualInvokeExpr = (VirtualInvokeExpr)value;
        RefLikeType refLikeType = (RefLikeType)virtualInvokeExpr.getBase().getType();
        SootClass sootClass = null;
        if (!(refLikeType instanceof RefType)) return;
        sootClass = iEnvironment.getClass(((RefType)refLikeType).getClassName());
        SootMethod sootMethod = virtualInvokeExpr.getMethod();
        if (!Util.isDescendentOf((SootClass)sootClass, (String)"java.lang.Thread")) return;
        if (!sootMethod.getName().equals("start")) return;
        if (!(sootMethod.getReturnType() instanceof VoidType)) return;
        if (sootMethod.getParameterCount() != 0) return;
        SootClass sootClass3 = Util.getDeclaringClass((SootClass)sootClass, (String)"start", (List)Collections.EMPTY_LIST, (Type)VoidType.v());
        if (sootClass3 != null && sootClass3.getName().equals("java.lang.Thread")) {
            this.startSites.add(new ICallGraphInfo.CallTriple(context.getCurrentMethod(), context.getStmt(), (InvokeExpr)virtualInvokeExpr));
            return;
        }
        if (!LOGGER.isWarnEnabled()) throw new RuntimeException("start() method is unavailable via " + sootClass + " even though it is a descendent of java.lang.Thread.");
        LOGGER.warn((Object)"How can there be a descendent class of java.lang.Thread without access to start() method.");
        throw new RuntimeException("start() method is unavailable via " + sootClass + " even though it is a descendent of java.lang.Thread.");
    }

    public void consolidate() {
        Object object;
        Object object2;
        SootMethod sootMethod;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        NewExpr newExpr;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"BEGIN: thread graph consolidation");
        }
        long l = System.currentTimeMillis();
        IEnvironment iEnvironment = this.analyzer.getEnvironment();
        SootClass sootClass = iEnvironment.getClass("java.lang.Thread");
        SootMethod sootMethod2 = sootClass.getMethodByName("start");
        Context context = new Context();
        context.setRootMethod(sootMethod2);
        Collection collection = this.analyzer.getValuesForThis(context);
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("New thread expressions are: " + collection));
        }
        Object object7 = collection.iterator();
        while (object7.hasNext()) {
            Object e = object7.next();
            if (!(e instanceof NewExpr)) continue;
            newExpr = (NewExpr)e;
            object6 = iEnvironment.getClass(newExpr.getBaseType().getClassName());
            if (!hashMap.containsKey(object6)) {
                boolean bl = false;
                object5 = Util.getDeclaringClass((SootClass)object6, (String)"run", (List)Collections.EMPTY_LIST, (Type)VoidType.v());
                if (object5 == null) {
                    LOGGER.error((Object)"How can there be a descendent of java.lang.Thread without access to run() method.");
                    throw new RuntimeException("run() method is unavailable via " + object6 + " even though it is a descendent of java.lang.Thread.");
                }
                bl = object5.getName().equals("java.lang.Thread");
                if (bl) {
                    object4 = new ArrayList();
                    object4.add(newExpr);
                    object3 = new HashSet();
                    sootMethod = this.analyzer.getValues(sootClass.getFieldByName("target"), (Collection)object4).iterator();
                    while (sootMethod.hasNext()) {
                        object2 = sootMethod.next();
                        if (!(object4 instanceof NewExpr)) continue;
                        NewExpr newExpr2 = (NewExpr)object2;
                        object5 = iEnvironment.getClass(newExpr2.getBaseType().getClassName());
                        object3.addAll(this.transitiveThreadCallClosure(object5.getMethod("run", Collections.EMPTY_LIST, (Type)VoidType.v())));
                    }
                } else {
                    object3 = this.transitiveThreadCallClosure(object6.getMethod("run", Collections.EMPTY_LIST, (Type)VoidType.v()));
                }
                hashMap.put(object6, object3);
            }
            if ((object = this.extractNewExprTripleFor(newExpr)) == null) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn((Object)("thread cannot be null. This can happen if there are not threads other than the main thread in the system. [" + newExpr + "]"));
                continue;
            }
            object3 = (Collection)hashMap.get(object6);
            this.thread2methods.put(object, object3);
            object5 = object3.iterator();
            while (object5.hasNext()) {
                object4 = (SootMethod)object5.next();
                CollectionsUtilities.putIntoCollectionInMap((Map)this.method2threads, (Object)object4, (Object)newExpr, (Factory)CollectionsUtilities.HASH_SET_FACTORY);
            }
        }
        object7 = this.cgi.getHeads();
        int n = 1;
        newExpr = new IThreadGraphInfo.NewExprTriple(null, null, Jimple.v().newNewExpr(RefType.v((String)"ClassInitThread:1:_jvm_")));
        object6 = object7.iterator();
        while (object6.hasNext()) {
            object3 = (SootMethod)object6.next();
            object = null;
            object = object3.getName().equals("<clinit>") ? newExpr : new IThreadGraphInfo.NewExprTriple(null, null, Jimple.v().newNewExpr(RefType.v((String)("MainThread:" + n++ + ":" + object3.getSignature()))));
            this.newThreadExprs.add(object);
            object5 = this.transitiveThreadCallClosure((SootMethod)object3);
            this.thread2methods.put(object, object5);
            object4 = object5.iterator();
            while (object4.hasNext()) {
                sootMethod = (SootMethod)object4.next();
                CollectionsUtilities.putIntoCollectionInMap((Map)this.method2threads, (Object)sootMethod, (Object)object, (Factory)CollectionsUtilities.HASH_SET_FACTORY);
            }
        }
        object6 = new HashSet();
        object3 = this.cgi.getReachableMethods();
        object = this.startSites.iterator();
        while (object.hasNext()) {
            object5 = (ICallGraphInfo.CallTriple)object.next();
            if (object3.contains(object5.getMethod())) continue;
            object6.add(object5);
        }
        this.startSites.removeAll((Collection<?>)object6);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"consolidate thread allocation site execution frequency information.");
        }
        object = new HashSet(this.threadAllocSitesSingle);
        object5 = object.iterator();
        while (object5.hasNext()) {
            object4 = (IThreadGraphInfo.NewExprTriple)object5.next();
            sootMethod = object4.getMethod();
            if (!this.cfgAnalysis.executedMultipleTimes(sootMethod)) continue;
            this.threadAllocSitesSingle.remove(object4);
            this.threadAllocSitesMulti.add(object4);
        }
        object5 = new HashSet();
        object4 = this.threadAllocSitesMulti.iterator();
        while (object4.hasNext()) {
            sootMethod = (IThreadGraphInfo.NewExprTriple)object4.next();
            context.setRootMethod(sootMethod.getMethod());
            context.setStmt(sootMethod.getStmt());
            object5.addAll(this.getExecutedMethods(sootMethod.getExpr(), context));
        }
        object.clear();
        object.addAll(this.threadAllocSitesSingle);
        object4 = object.iterator();
        while (object4.hasNext()) {
            sootMethod = (IThreadGraphInfo.NewExprTriple)object4.next();
            object2 = sootMethod.getMethod();
            if (!object5.contains(object2)) continue;
            this.threadAllocSitesSingle.remove(sootMethod);
            this.threadAllocSitesMulti.add(sootMethod);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END: equivalence class based escape analysis consolidation");
        }
        long l2 = System.currentTimeMillis();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END: thread graph consolidation");
            LOGGER.info((Object)("TIMING: thread graph consolidation took " + (l2 - l) + "ms."));
        }
    }

    public String dumpGraph() {
        String string;
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        stringBuffer.append("Total number of threads: " + this.thread2methods.size() + "\n");
        ArrayList arrayList2 = new ArrayList();
        arrayList2.addAll(this.thread2methods.keySet());
        Collections.sort(arrayList2, new Comparator(){

            public int compare(Object object, Object object2) {
                IThreadGraphInfo.NewExprTriple newExprTriple = (IThreadGraphInfo.NewExprTriple)object;
                String string = newExprTriple.getStmt() + "@" + newExprTriple.getMethod() + "->" + newExprTriple.getExpr();
                newExprTriple = (IThreadGraphInfo.NewExprTriple)object2;
                return string.compareTo(newExprTriple.getStmt() + "@" + newExprTriple.getMethod() + "->" + newExprTriple.getExpr());
            }
        });
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            object2 = (IThreadGraphInfo.NewExprTriple)iterator.next();
            if (object2.getMethod() == null) {
                stringBuffer.append("\n" + object2.getExpr().getType() + "\n");
            } else {
                stringBuffer.append("\n" + object2.getStmt() + "@" + object2.getMethod() + "->" + object2.getExpr() + "\n");
            }
            arrayList.clear();
            object = ((Collection)this.thread2methods.get(object2)).iterator();
            while (object.hasNext()) {
                string = (SootMethod)object.next();
                arrayList.add(string.getSignature());
            }
            Collections.sort(arrayList);
            object = arrayList.iterator();
            while (object.hasNext()) {
                stringBuffer.append("\t" + object.next() + "\n");
            }
        }
        int n = 1;
        stringBuffer.append("\nThread mapping:\n");
        object2 = this.getAllocationSites().iterator();
        while (object2.hasNext()) {
            object = (IThreadGraphInfo.NewExprTriple)object2.next();
            string = "T" + n++;
            if (object.getMethod() == null) {
                stringBuffer.append(string + " -> " + object.getExpr().getType() + "\n");
                continue;
            }
            stringBuffer.append(string + " -> " + object.getStmt() + "@" + object.getMethod() + "\n");
        }
        return stringBuffer.toString();
    }

    public void hookup(ProcessingController processingController) {
        this.unstable();
        processingController.register(class$soot$jimple$NewExpr == null ? (class$soot$jimple$NewExpr = ThreadGraph.class$("soot.jimple.NewExpr")) : class$soot$jimple$NewExpr, (IProcessor)this);
        processingController.register(class$soot$jimple$VirtualInvokeExpr == null ? (class$soot$jimple$VirtualInvokeExpr = ThreadGraph.class$("soot.jimple.VirtualInvokeExpr")) : class$soot$jimple$VirtualInvokeExpr, (IProcessor)this);
    }

    public void reset() {
        this.thread2methods.clear();
        this.method2threads.clear();
        this.analyzer = null;
        this.startSites.clear();
        this.newThreadExprs.clear();
        this.threadAllocSitesMulti.clear();
        this.threadAllocSitesSingle.clear();
        this.unstable();
    }

    public void unhook(ProcessingController processingController) {
        processingController.unregister(class$soot$jimple$NewExpr == null ? (class$soot$jimple$NewExpr = ThreadGraph.class$("soot.jimple.NewExpr")) : class$soot$jimple$NewExpr, (IProcessor)this);
        processingController.unregister(class$soot$jimple$VirtualInvokeExpr == null ? (class$soot$jimple$VirtualInvokeExpr = ThreadGraph.class$("soot.jimple.VirtualInvokeExpr")) : class$soot$jimple$VirtualInvokeExpr, (IProcessor)this);
        this.stable();
    }

    private IThreadGraphInfo.NewExprTriple extractNewExprTripleFor(NewExpr newExpr) {
        IThreadGraphInfo.NewExprTriple newExprTriple = null;
        Iterator iterator = this.newThreadExprs.iterator();
        while (iterator.hasNext()) {
            IThreadGraphInfo.NewExprTriple newExprTriple2 = (IThreadGraphInfo.NewExprTriple)iterator.next();
            if (newExprTriple2.getExpr() != newExpr) continue;
            newExprTriple = newExprTriple2;
            break;
        }
        return newExprTriple;
    }

    private Collection transitiveThreadCallClosure(SootMethod sootMethod) {
        HashSet<SootMethod> hashSet = new HashSet<SootMethod>();
        HistoryAwareFIFOWorkBag historyAwareFIFOWorkBag = new HistoryAwareFIFOWorkBag(hashSet);
        historyAwareFIFOWorkBag.addWork((Object)sootMethod);
        hashSet.add(sootMethod);
        while (historyAwareFIFOWorkBag.hasWork()) {
            SootMethod sootMethod2 = (SootMethod)historyAwareFIFOWorkBag.getWork();
            if (sootMethod2.getName().equals("start") && sootMethod2.getDeclaringClass().getName().equals("java.lang.Thread") && sootMethod2.getParameterCount() == 0 && sootMethod2.getReturnType().equals(VoidType.v())) continue;
            Collection collection = this.cgi.getCallees(sootMethod2);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ICallGraphInfo.CallTriple callTriple = (ICallGraphInfo.CallTriple)iterator.next();
                SootMethod sootMethod3 = callTriple.getMethod();
                historyAwareFIFOWorkBag.addWorkNoDuplicates((Object)sootMethod3);
            }
        }
        return hashSet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

