/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors;

import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.xmlizer.AbstractXMLizer;
import edu.ksu.cis.indus.xmlizer.CustomXMLOutputter;
import edu.ksu.cis.indus.xmlizer.XMLizingProcessingFilter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.SootMethod;

final class CallGraphXMLizer
extends AbstractXMLizer {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$processors$CallGraphXMLizer == null ? (class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$processors$CallGraphXMLizer = CallGraphXMLizer.class$("edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.CallGraphXMLizer")) : class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$processors$CallGraphXMLizer));
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$processors$CallGraphXMLizer;

    CallGraphXMLizer() {
    }

    public String getFileName(String string) {
        return "callgraph_" + CallGraphXMLizer.xmlizeString((String)string) + ".xml";
    }

    public void writeXML(Map map) {
        File file = new File(this.getXmlOutputDir() + File.separator + this.getFileName((String)map.get(FILE_NAME_ID)));
        try {
            SootMethod sootMethod;
            FileWriter fileWriter = new FileWriter(file);
            CustomXMLOutputter customXMLOutputter = new CustomXMLOutputter((Writer)fileWriter);
            ICallGraphInfo iCallGraphInfo = (ICallGraphInfo)map.get("Callgraph Information");
            customXMLOutputter.declaration();
            customXMLOutputter.startTag("callgraph");
            XMLizingProcessingFilter xMLizingProcessingFilter = new XMLizingProcessingFilter();
            HashSet<SootMethod> hashSet = new HashSet<SootMethod>();
            Iterator iterator = xMLizingProcessingFilter.filterMethods(iCallGraphInfo.getReachableMethods()).iterator();
            while (iterator.hasNext()) {
                ICallGraphInfo.CallTriple callTriple;
                sootMethod = (SootMethod)iterator.next();
                customXMLOutputter.startTag("method");
                customXMLOutputter.attribute("id", this.getIdGenerator().getIdForMethod(sootMethod));
                hashSet.clear();
                Iterator iterator2 = iCallGraphInfo.getCallees(sootMethod).iterator();
                while (iterator2.hasNext()) {
                    callTriple = (ICallGraphInfo.CallTriple)iterator2.next();
                    hashSet.add(callTriple.getMethod());
                }
                iterator2 = xMLizingProcessingFilter.filterMethods(hashSet).iterator();
                while (iterator2.hasNext()) {
                    callTriple = (SootMethod)iterator2.next();
                    customXMLOutputter.startTag("callee");
                    customXMLOutputter.attribute("calleeId", this.getIdGenerator().getIdForMethod((SootMethod)callTriple));
                    customXMLOutputter.endTag();
                }
                hashSet.clear();
                iterator2 = iCallGraphInfo.getCallers(sootMethod).iterator();
                while (iterator2.hasNext()) {
                    callTriple = (ICallGraphInfo.CallTriple)iterator2.next();
                    hashSet.add(callTriple.getMethod());
                }
                iterator2 = xMLizingProcessingFilter.filterMethods(hashSet).iterator();
                while (iterator2.hasNext()) {
                    callTriple = (SootMethod)iterator2.next();
                    customXMLOutputter.startTag("caller");
                    customXMLOutputter.attribute("callerId", this.getIdGenerator().getIdForMethod((SootMethod)callTriple));
                    customXMLOutputter.endTag();
                }
                customXMLOutputter.endTag();
            }
            customXMLOutputter.startTag("reachables");
            iterator = iCallGraphInfo.getReachableMethods().iterator();
            while (iterator.hasNext()) {
                sootMethod = (SootMethod)iterator.next();
                customXMLOutputter.startTag("method");
                customXMLOutputter.attribute("methodId", this.getIdGenerator().getIdForMethod(sootMethod));
                customXMLOutputter.endTag();
            }
            customXMLOutputter.endDocument();
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"Error while xmlizing call graph", (Throwable)iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

