/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors;

import edu.ksu.cis.indus.common.graph.AbstractDirectedGraphTest;
import edu.ksu.cis.indus.common.graph.SimpleNodeGraph;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.staticanalyses.flow.FA;
import edu.ksu.cis.indus.staticanalyses.flow.IFAProcessorTest;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.CallGraph;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import soot.SootClass;
import soot.SootMethod;

public final class CallGraphTest
extends AbstractDirectedGraphTest
implements IFAProcessorTest {
    private ICallGraphInfo cgi;
    private OFAnalyzer ofa;
    private SimpleNodeGraph cg;

    public void setAnalyzer(IValueAnalyzer iValueAnalyzer) {
        this.ofa = (OFAnalyzer)iValueAnalyzer;
    }

    public void setFA(FA fA) {
    }

    public void setFATagName(String string) {
    }

    public void setProcessor(IProcessor iProcessor) {
        CallGraph callGraph = (CallGraph)iProcessor;
        this.cgi = callGraph;
        this.cg = (SimpleNodeGraph)callGraph.getCallGraph();
        this.dg = this.cg;
    }

    public void localtestIsReachable() {
        Collection collection = this.cgi.getReachableMethods();
        Collection collection2 = this.cgi.getHeads();
        Iterator iterator = this.ofa.getEnvironment().getClasses().iterator();
        while (iterator.hasNext()) {
            SootClass sootClass = (SootClass)iterator.next();
            Iterator iterator2 = sootClass.getMethods().iterator();
            while (iterator2.hasNext()) {
                SootMethod sootMethod = (SootMethod)iterator2.next();
                CallGraphTest.assertEquals((boolean)this.cgi.isReachable(sootMethod), (boolean)collection.contains(sootMethod));
                if (!this.cgi.isReachable(sootMethod)) continue;
                boolean bl = false;
                Iterator iterator3 = collection2.iterator();
                while (iterator3.hasNext()) {
                    bl |= this.cg.isReachable(this.cg.getNode(iterator3.next()), this.cg.getNode((Object)sootMethod), true);
                }
                CallGraphTest.assertTrue((bl || collection2.contains(sootMethod) ? 1 : 0) != 0);
            }
        }
    }

    public void testGetCallGraph() {
        if (this.cgi instanceof CallGraph) {
            CallGraphTest.assertNotNull((Object)((CallGraph)this.cgi).getCallGraph());
        }
    }

    public void testGetCalleesInvokeExprContext() {
        Context context = new Context();
        ArrayList<SootMethod> arrayList = new ArrayList<SootMethod>();
        Iterator iterator = this.cgi.getReachableMethods().iterator();
        while (iterator.hasNext()) {
            ICallGraphInfo.CallTriple callTriple;
            SootMethod sootMethod = (SootMethod)iterator.next();
            Collection collection = this.cgi.getCallees(sootMethod);
            arrayList.clear();
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                callTriple = (ICallGraphInfo.CallTriple)iterator2.next();
                arrayList.add(callTriple.getMethod());
            }
            iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                callTriple = (ICallGraphInfo.CallTriple)iterator2.next();
                context.setStmt(callTriple.getStmt());
                context.setRootMethod(sootMethod);
                Collection collection2 = this.cgi.getCallees(callTriple.getExpr(), context);
                Iterator iterator3 = collection.iterator();
                while (iterator3.hasNext()) {
                    ICallGraphInfo.CallTriple callTriple2 = (ICallGraphInfo.CallTriple)iterator3.next();
                    if (!callTriple2.getExpr().equals(callTriple.getExpr())) continue;
                    CallGraphTest.assertTrue((boolean)collection2.contains(callTriple2.getMethod()));
                }
                arrayList.removeAll(collection2);
            }
            CallGraphTest.assertTrue((boolean)arrayList.isEmpty());
        }
    }

    public void testGetCallersAndGetCallees() {
        Collection collection = this.cgi.getHeads();
        Collection collection2 = this.cg.getTails();
        Iterator iterator = this.cgi.getReachableMethods().iterator();
        while (iterator.hasNext()) {
            SootMethod sootMethod = (SootMethod)iterator.next();
            Collection collection3 = this.cgi.getCallers(sootMethod);
            CallGraphTest.assertNotNull((Object)collection3);
            if (collection3.isEmpty()) {
                CallGraphTest.assertTrue((boolean)collection.contains(sootMethod));
                continue;
            }
            Iterator iterator2 = collection3.iterator();
            while (iterator2.hasNext()) {
                ICallGraphInfo.CallTriple callTriple = (ICallGraphInfo.CallTriple)iterator2.next();
                SootMethod sootMethod2 = callTriple.getMethod();
                CallGraphTest.assertTrue((boolean)this.cgi.isReachable(sootMethod2));
                Collection collection4 = this.cgi.getCallees(sootMethod2);
                if (collection4.isEmpty()) {
                    CallGraphTest.assertTrue((boolean)collection2.contains(sootMethod2));
                    continue;
                }
                boolean bl = false;
                Iterator iterator3 = collection4.iterator();
                while (iterator3.hasNext()) {
                    ICallGraphInfo.CallTriple callTriple2 = (ICallGraphInfo.CallTriple)iterator3.next();
                    if (!callTriple2.getMethod().equals(sootMethod)) continue;
                    bl = true;
                    break;
                }
                CallGraphTest.assertTrue((boolean)bl);
            }
        }
    }

    public void testGetNodes() {
        Collection collection = this.cgi.getReachableMethods();
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = this.dg.getNodes().iterator();
        while (iterator.hasNext()) {
            SimpleNodeGraph.SimpleNode simpleNode = (SimpleNodeGraph.SimpleNode)iterator.next();
            hashSet.add(simpleNode.getObject());
        }
        CallGraphTest.assertTrue((boolean)hashSet.containsAll(collection));
        CallGraphTest.assertTrue((boolean)collection.containsAll(hashSet));
    }

    public void testGetReachableMethods() {
        Collection collection = this.cgi.getReachableMethods();
        CallGraphTest.assertNotNull((Object)collection);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CallGraphTest.assertTrue((boolean)(iterator.next() instanceof SootMethod));
        }
    }

    public void testSize() {
        CallGraphTest.assertTrue((this.cgi.getReachableMethods().size() == this.dg.getNodes().size() ? 1 : 0) != 0);
    }

    public void testTagsOnReachableMethods() {
        Object object;
        Context context = new Context();
        Collection collection = this.cgi.getReachableMethods();
        CallGraphTest.assertNotNull((Object)collection);
        Object object2 = collection.iterator();
        while (object2.hasNext()) {
            object = (SootMethod)object2.next();
            CallGraphTest.assertTrue((boolean)object.hasTag("indus.staticanalyses.flow.FATestSetup:FA"));
            CallGraphTest.assertTrue((boolean)object.getDeclaringClass().hasTag("indus.staticanalyses.flow.FATestSetup:FA"));
            if (object.isStatic()) continue;
            context.setRootMethod((SootMethod)object);
            CallGraphTest.assertNotNull((Object)this.ofa.getValuesForThis(context));
        }
        object2 = new HashSet();
        object = this.ofa.getEnvironment().getClasses().iterator();
        while (object.hasNext()) {
            object2.addAll(((SootClass)object.next()).getMethods());
        }
        object2 = CollectionUtils.subtract((Collection)object2, (Collection)collection);
        object = object2.iterator();
        while (object.hasNext()) {
            SootMethod sootMethod = (SootMethod)object.next();
            if (sootMethod.isAbstract()) continue;
            CallGraphTest.assertFalse((boolean)sootMethod.hasTag("indus.staticanalyses.flow.FATestSetup:FA"));
        }
    }

    protected void localtestGetHeads() {
        SimpleNodeGraph.SimpleNode simpleNode;
        Collection collection = new HashSet<Object>();
        Iterator iterator = this.dg.getHeads().iterator();
        while (iterator.hasNext()) {
            simpleNode = (SimpleNodeGraph.SimpleNode)iterator.next();
            collection.add(simpleNode.getObject());
        }
        CallGraphTest.assertTrue((boolean)collection.containsAll(this.cgi.getHeads()));
        CallGraphTest.assertTrue((boolean)this.cgi.getHeads().containsAll(collection));
        collection = this.cgi.getHeads();
        CallGraphTest.assertNotNull(collection);
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            simpleNode = (SootMethod)iterator.next();
            CallGraphTest.assertTrue((boolean)this.cgi.getCallers((SootMethod)simpleNode).isEmpty());
        }
        CallGraphTest.assertTrue((boolean)this.cgi.getReachableMethods().containsAll(collection));
    }

    protected void localtestGetSCCs() {
        List list = this.cgi.getSCCs(true);
        Collection collection = this.cgi.getReachableMethods();
        CallGraphTest.assertNotNull((Object)list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Collection collection2 = (Collection)iterator.next();
            CallGraphTest.assertNotNull((Object)collection2);
            CallGraphTest.assertTrue((boolean)collection.containsAll(collection2));
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Collection collection3 = (Collection)iterator2.next();
                if (collection2 == collection3) continue;
                CallGraphTest.assertTrue((boolean)CollectionUtils.intersection((Collection)collection2, (Collection)collection3).isEmpty());
            }
        }
    }

    protected void localtestGraphGetTails() {
        SimpleNodeGraph.SimpleNode simpleNode;
        Iterator iterator = this.dg.getTails().iterator();
        while (iterator.hasNext()) {
            simpleNode = (SimpleNodeGraph.SimpleNode)iterator.next();
            CallGraphTest.assertTrue((boolean)this.cgi.getCallees((SootMethod)simpleNode.getObject()).isEmpty());
        }
        iterator = this.cgi.getReachableMethods().iterator();
        while (iterator.hasNext()) {
            simpleNode = (SootMethod)iterator.next();
            if (!this.cgi.getCallees((SootMethod)simpleNode).isEmpty()) continue;
            CallGraphTest.assertTrue((boolean)this.cg.getNode((Object)simpleNode).getSuccsOf().isEmpty());
        }
    }

    protected void tearDown() throws Exception {
        this.cg = null;
        this.cgi = null;
        this.ofa = null;
        super.tearDown();
    }
}

