/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors;

import edu.ksu.cis.indus.common.ToStringBasedComparator;
import edu.ksu.cis.indus.common.graph.IDirectedGraph;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.graph.SimpleNodeGraph;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.AbstractValueAnalyzerBasedProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NewExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.VirtualInvokeExpr;

public class CallGraph
extends AbstractValueAnalyzerBasedProcessor
implements ICallGraphInfo {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$processors$CallGraph == null ? (class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$processors$CallGraph = CallGraph.class$("edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.CallGraph")) : class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$processors$CallGraph));
    private final Collection heads = new HashSet();
    private Collection reachables = new HashSet();
    private IValueAnalyzer analyzer;
    private List bottomUpSCC;
    private List topDownSCC;
    private Map callee2callers = new HashMap();
    private Map caller2callees = new HashMap();
    private SimpleNodeGraph graphCache;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$processors$CallGraph;
    static /* synthetic */ Class class$soot$jimple$VirtualInvokeExpr;
    static /* synthetic */ Class class$soot$jimple$InterfaceInvokeExpr;
    static /* synthetic */ Class class$soot$jimple$StaticInvokeExpr;
    static /* synthetic */ Class class$soot$jimple$SpecialInvokeExpr;

    public void setAnalyzer(IValueAnalyzer iValueAnalyzer) {
        this.analyzer = (OFAnalyzer)iValueAnalyzer;
        this.heads.clear();
        this.reachables.clear();
        this.graphCache = null;
    }

    public Collection getCallees(SootMethod sootMethod) {
        Collection<Object> collection = Collections.EMPTY_LIST;
        Collection collection2 = (Collection)this.caller2callees.get(sootMethod);
        if (collection2 != null) {
            collection = Collections.unmodifiableCollection(collection2);
        }
        return collection;
    }

    public Collection getCallees(InvokeExpr invokeExpr, Context context) {
        ArrayList<SootMethod> arrayList;
        Collection collection = (Collection)this.caller2callees.get(context.getCurrentMethod());
        if (collection != null && !collection.isEmpty()) {
            arrayList = new ArrayList<SootMethod>();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ICallGraphInfo.CallTriple callTriple = (ICallGraphInfo.CallTriple)iterator.next();
                if (!callTriple.getExpr().equals(invokeExpr)) continue;
                arrayList.add(callTriple.getMethod());
            }
        } else {
            arrayList = Collections.EMPTY_LIST;
        }
        return arrayList;
    }

    public Collection getCallers(SootMethod sootMethod) {
        Collection<Object> collection = Collections.EMPTY_LIST;
        Collection collection2 = (Collection)this.callee2callers.get(sootMethod);
        if (collection2 != null) {
            collection = Collections.unmodifiableCollection(collection2);
        }
        return collection;
    }

    public Collection getHeads() {
        return Collections.unmodifiableCollection(this.heads);
    }

    public Collection getMethodsReachableFrom(Stmt stmt, SootMethod sootMethod) {
        InvokeExpr invokeExpr = stmt.getInvokeExpr();
        Context context = new Context();
        context.setRootMethod(sootMethod);
        HashSet hashSet = new HashSet();
        Collection collection = this.getCallees(invokeExpr, context);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            hashSet.addAll(this.getMethodsReachableFrom((SootMethod)iterator.next(), true));
        }
        return hashSet;
    }

    public Collection getMethodsReachableFrom(SootMethod sootMethod, boolean bl) {
        Collection collection = this.graphCache.getReachablesFrom(this.graphCache.getNode((Object)sootMethod), bl);
        CollectionUtils.transform((Collection)collection, (Transformer)SimpleNodeGraph.OBJECT_EXTRACTOR);
        return collection;
    }

    public boolean isReachable(SootMethod sootMethod) {
        return this.reachables.contains(sootMethod);
    }

    public Collection getReachableMethods() {
        return Collections.unmodifiableCollection(this.reachables);
    }

    public List getSCCs(boolean bl) {
        if (this.topDownSCC == null) {
            this.topDownSCC = new ArrayList();
            List list = this.graphCache.getSCCs(true);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Collection collection = (Collection)iterator.next();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    arrayList.add(((SimpleNodeGraph.SimpleNode)iterator2.next()).getObject());
                }
                this.topDownSCC.add(Collections.unmodifiableList(arrayList));
            }
            this.topDownSCC = Collections.unmodifiableList(this.topDownSCC);
            this.bottomUpSCC = new ArrayList(this.topDownSCC);
            Collections.reverse(this.bottomUpSCC);
            this.bottomUpSCC = Collections.unmodifiableList(this.bottomUpSCC);
        }
        return bl ? this.topDownSCC : this.bottomUpSCC;
    }

    public void callback(ValueBox valueBox, Context context) {
        Stmt stmt = context.getStmt();
        SootMethod sootMethod = context.getCurrentMethod();
        SootMethod sootMethod2 = null;
        Value value = valueBox.getValue();
        if (value instanceof StaticInvokeExpr) {
            Set<ICallGraphInfo.CallTriple> set;
            Set<ICallGraphInfo.CallTriple> set2;
            InvokeExpr invokeExpr = (InvokeExpr)value;
            sootMethod2 = invokeExpr.getMethod();
            if (this.caller2callees.containsKey(sootMethod)) {
                set2 = (Set)this.caller2callees.get(sootMethod);
            } else {
                set2 = new HashSet();
                this.caller2callees.put(sootMethod, set2);
            }
            ICallGraphInfo.CallTriple callTriple = new ICallGraphInfo.CallTriple(sootMethod2, stmt, invokeExpr);
            set2.add(callTriple);
            if (this.callee2callers.containsKey(sootMethod2)) {
                set = (Set)this.callee2callers.get(sootMethod2);
            } else {
                set = new HashSet();
                this.callee2callers.put(sootMethod2, set);
            }
            callTriple = new ICallGraphInfo.CallTriple(sootMethod, stmt, invokeExpr);
            set.add(callTriple);
        } else if (value instanceof InterfaceInvokeExpr || value instanceof VirtualInvokeExpr || value instanceof SpecialInvokeExpr) {
            this.callBackOnInstanceInvokeExpr(context, (InstanceInvokeExpr)value);
        }
    }

    public void callback(SootMethod sootMethod) {
        this.reachables.add(sootMethod);
        if (sootMethod.getName().equals("<clinit>")) {
            this.heads.add(sootMethod);
        }
    }

    public void consolidate() {
        Object object;
        Iterator iterator;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"BEGIN: call graph consolidation");
        }
        long l = System.currentTimeMillis();
        this.heads.addAll(this.analyzer.getEnvironment().getRoots());
        if (this.caller2callees.isEmpty()) {
            iterator = this.heads.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                this.caller2callees.put(object, Collections.EMPTY_LIST);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting construction of call graph...");
        }
        this.graphCache = new SimpleNodeGraph();
        iterator = this.reachables.iterator();
        while (iterator.hasNext()) {
            object = (SootMethod)iterator.next();
            Collection collection = (Collection)this.caller2callees.get(object);
            INode iNode = this.graphCache.getNode(object);
            if (collection == null) continue;
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                ICallGraphInfo.CallTriple callTriple = (ICallGraphInfo.CallTriple)iterator2.next();
                SootMethod sootMethod = callTriple.getMethod();
                this.graphCache.addEdgeFromTo(iNode, this.graphCache.getNode((Object)sootMethod));
            }
        }
        long l2 = System.currentTimeMillis();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END: call graph consolidation");
            LOGGER.info((Object)("TIMING: call graph consolidation took " + (l2 - l) + "ms."));
        }
    }

    public String dumpGraph() {
        ICallGraphInfo.CallTriple callTriple;
        Iterator iterator;
        SootMethod sootMethod;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Root of the system: ");
        Object object = this.getHeads().iterator();
        while (object.hasNext()) {
            stringBuffer.append("\t" + ((SootMethod)object.next()).getSignature());
        }
        stringBuffer.append("\nReachable methods in the system: " + this.getReachableMethods().size() + "\n");
        stringBuffer.append("Strongly Connected components in the system: " + this.getSCCs(true).size() + "\n");
        stringBuffer.append("top-down\n");
        object = new ArrayList();
        ArrayList arrayList = new ArrayList();
        object.addAll(this.caller2callees.keySet());
        Collections.sort(object, ToStringBasedComparator.SINGLETON);
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            sootMethod = (SootMethod)iterator2.next();
            stringBuffer.append("\n" + sootMethod.getSignature() + "\n");
            arrayList.clear();
            arrayList.addAll((Collection)this.caller2callees.get(sootMethod));
            Collections.sort(arrayList, new CallTripleMethodToStringBasedComparator());
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                callTriple = (ICallGraphInfo.CallTriple)iterator.next();
                stringBuffer.append("\t" + callTriple + "\n");
            }
        }
        stringBuffer.append("bottom-up\n");
        object.clear();
        object.addAll(this.callee2callers.keySet());
        Collections.sort(object, ToStringBasedComparator.SINGLETON);
        iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            sootMethod = (SootMethod)iterator2.next();
            stringBuffer.append("\n" + sootMethod.getSignature() + "\n");
            arrayList.clear();
            arrayList.addAll((Collection)this.callee2callers.get(sootMethod));
            Collections.sort(arrayList, new CallTripleMethodToStringBasedComparator());
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                callTriple = (ICallGraphInfo.CallTriple)iterator.next();
                stringBuffer.append("\t" + callTriple.getMethod().getSignature() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public void hookup(ProcessingController processingController) {
        this.unstable();
        processingController.register(class$soot$jimple$VirtualInvokeExpr == null ? (class$soot$jimple$VirtualInvokeExpr = CallGraph.class$("soot.jimple.VirtualInvokeExpr")) : class$soot$jimple$VirtualInvokeExpr, (IProcessor)this);
        processingController.register(class$soot$jimple$InterfaceInvokeExpr == null ? (class$soot$jimple$InterfaceInvokeExpr = CallGraph.class$("soot.jimple.InterfaceInvokeExpr")) : class$soot$jimple$InterfaceInvokeExpr, (IProcessor)this);
        processingController.register(class$soot$jimple$StaticInvokeExpr == null ? (class$soot$jimple$StaticInvokeExpr = CallGraph.class$("soot.jimple.StaticInvokeExpr")) : class$soot$jimple$StaticInvokeExpr, (IProcessor)this);
        processingController.register(class$soot$jimple$SpecialInvokeExpr == null ? (class$soot$jimple$SpecialInvokeExpr = CallGraph.class$("soot.jimple.SpecialInvokeExpr")) : class$soot$jimple$SpecialInvokeExpr, (IProcessor)this);
        processingController.register((IProcessor)this);
    }

    public void reset() {
        this.unstable();
        this.caller2callees.clear();
        this.callee2callers.clear();
        this.analyzer = null;
        this.graphCache = null;
        this.topDownSCC = null;
        this.bottomUpSCC = null;
        this.reachables.clear();
        this.heads.clear();
    }

    public void unhook(ProcessingController processingController) {
        processingController.unregister(class$soot$jimple$VirtualInvokeExpr == null ? (class$soot$jimple$VirtualInvokeExpr = CallGraph.class$("soot.jimple.VirtualInvokeExpr")) : class$soot$jimple$VirtualInvokeExpr, (IProcessor)this);
        processingController.unregister(class$soot$jimple$InterfaceInvokeExpr == null ? (class$soot$jimple$InterfaceInvokeExpr = CallGraph.class$("soot.jimple.InterfaceInvokeExpr")) : class$soot$jimple$InterfaceInvokeExpr, (IProcessor)this);
        processingController.unregister(class$soot$jimple$StaticInvokeExpr == null ? (class$soot$jimple$StaticInvokeExpr = CallGraph.class$("soot.jimple.StaticInvokeExpr")) : class$soot$jimple$StaticInvokeExpr, (IProcessor)this);
        processingController.unregister(class$soot$jimple$SpecialInvokeExpr == null ? (class$soot$jimple$SpecialInvokeExpr = CallGraph.class$("soot.jimple.SpecialInvokeExpr")) : class$soot$jimple$SpecialInvokeExpr, (IProcessor)this);
        processingController.unregister((IProcessor)this);
        this.stable();
    }

    final IDirectedGraph getCallGraph() {
        return this.graphCache;
    }

    private void callBackOnInstanceInvokeExpr(Context context, InstanceInvokeExpr instanceInvokeExpr) {
        Stmt stmt = context.getStmt();
        SootMethod sootMethod = context.getCurrentMethod();
        SootMethod sootMethod2 = instanceInvokeExpr.getMethod();
        context.setProgramPoint(instanceInvokeExpr.getBaseBox());
        Collection collection = this.analyzer.getValues(instanceInvokeExpr.getBase(), context);
        if (!collection.isEmpty()) {
            Set<ICallGraphInfo.CallTriple> set;
            if (this.caller2callees.containsKey(sootMethod)) {
                set = (Set)this.caller2callees.get(sootMethod);
            } else {
                set = new HashSet();
                this.caller2callees.put(sootMethod, set);
            }
            ICallGraphInfo.CallTriple callTriple = new ICallGraphInfo.CallTriple(sootMethod, stmt, (InvokeExpr)instanceInvokeExpr);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Set<ICallGraphInfo.CallTriple> set2;
                Object object;
                Object e = iterator.next();
                if (!(e instanceof NewExpr) && !(e instanceof StringConstant)) continue;
                SootClass sootClass = null;
                if (instanceInvokeExpr instanceof SpecialInvokeExpr && sootMethod2.getName().equals("<init>")) {
                    sootClass = sootMethod2.getDeclaringClass();
                } else if (e instanceof NewExpr) {
                    object = (NewExpr)e;
                    sootClass = this.analyzer.getEnvironment().getClass(object.getBaseType().getClassName());
                } else if (e instanceof StringConstant) {
                    sootClass = this.analyzer.getEnvironment().getClass("java.lang.String");
                }
                object = sootMethod2.getName();
                List list = sootMethod2.getParameterTypes();
                Type type = sootMethod2.getReturnType();
                SootMethod sootMethod3 = this.findMethodImplementation(sootClass, (String)object, list, type);
                ICallGraphInfo.CallTriple callTriple2 = new ICallGraphInfo.CallTriple(sootMethod3, stmt, (InvokeExpr)instanceInvokeExpr);
                set.add(callTriple2);
                if (this.callee2callers.containsKey(sootMethod3)) {
                    set2 = (Set)this.callee2callers.get(sootMethod3);
                } else {
                    set2 = new HashSet();
                    this.callee2callers.put(sootMethod3, set2);
                }
                set2.add(callTriple);
            }
        }
    }

    private SootMethod findMethodImplementation(SootClass sootClass, String string, List list, Type type) {
        SootMethod sootMethod = null;
        if (sootClass.declaresMethod(string, list, type)) {
            sootMethod = sootClass.getMethod(string, list, type);
        } else if (sootClass.hasSuperclass()) {
            SootClass sootClass2 = sootClass.getSuperclass();
            sootMethod = this.findMethodImplementation(sootClass2, string, list, type);
        } else if (LOGGER.isErrorEnabled()) {
            LOGGER.error((Object)(string + "(" + list + "):" + type + " is not accessible from " + sootClass));
        }
        return sootMethod;
    }

    public Object getId() {
        return "Callgraph Information";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CallTripleMethodToStringBasedComparator
    implements Comparator {
        private CallTripleMethodToStringBasedComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((ICallGraphInfo.CallTriple)object).getMethod().getSignature().compareTo(((ICallGraphInfo.CallTriple)object2).getMethod().getSignature());
        }
    }
}

