/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors;

import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.AliasedUseDefInfo;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import soot.SootMethod;
import soot.jimple.Stmt;

public class AliasedUseDefInfov2
extends AliasedUseDefInfo {
    protected final ICallGraphInfo cgi;
    private Map method2EnclosingInvokingStmtsCache;

    public AliasedUseDefInfov2(IValueAnalyzer iValueAnalyzer, ICallGraphInfo iCallGraphInfo, BasicBlockGraphMgr basicBlockGraphMgr) {
        super(iValueAnalyzer, basicBlockGraphMgr);
        this.cgi = iCallGraphInfo;
    }

    public void consolidate() {
        this.method2EnclosingInvokingStmtsCache = new HashMap();
        super.consolidate();
        this.method2EnclosingInvokingStmtsCache = null;
    }

    protected boolean isReachableViaInterProceduralFlow(SootMethod sootMethod, Stmt stmt, SootMethod sootMethod2, Stmt stmt2) {
        boolean bl = false;
        Collection collection = this.cgi.getMethodsReachableFrom(sootMethod, true);
        if (collection.contains(sootMethod2)) {
            bl = this.doesControlFlowPathExistsBetween(sootMethod, stmt, sootMethod2, true);
        }
        Collection collection2 = this.cgi.getMethodsReachableFrom(sootMethod2, true);
        if (!bl && collection2.contains(sootMethod)) {
            bl = this.doesControlFlowPathExistsBetween(sootMethod2, stmt2, sootMethod, false);
        }
        if (!bl) {
            bl = this.doesControlPathExistsFromTo(sootMethod, sootMethod2, collection, collection2);
        }
        return bl;
    }

    private Iterator getInvokingStmtIteratorFor(SootMethod sootMethod) {
        Iterator iterator;
        Collection collection = (Collection)this.method2EnclosingInvokingStmtsCache.get(sootMethod);
        if (collection == null) {
            Predicate predicate = new Predicate(){

                public boolean evaluate(Object object) {
                    return ((Stmt)object).containsInvokeExpr();
                }
            };
            Iterator iterator2 = this.bbgMgr.getBasicBlockGraph(sootMethod).getStmtGraph().iterator();
            iterator = IteratorUtils.filteredIterator((Iterator)iterator2, (Predicate)predicate);
            this.method2EnclosingInvokingStmtsCache.put(sootMethod, IteratorUtils.toList((Iterator)iterator));
        } else {
            iterator = collection.iterator();
        }
        return iterator;
    }

    private boolean doesControlFlowPathExistsBetween(SootMethod sootMethod, Stmt stmt, SootMethod sootMethod2, boolean bl) {
        Stmt stmt2;
        boolean bl2 = false;
        BasicBlockGraph basicBlockGraph = this.bbgMgr.getBasicBlockGraph(sootMethod);
        BasicBlockGraph.BasicBlock basicBlock = basicBlockGraph.getEnclosingBlock(stmt);
        HashSet hashSet = new HashSet(basicBlockGraph.getReachablesFrom((INode)basicBlock, bl));
        List list = bl ? basicBlock.getStmtsFrom(stmt) : basicBlock.getStmtFromTo(basicBlock.getLeaderStmt(), stmt);
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !bl2) {
            stmt2 = (Stmt)iterator.next();
            if (!stmt2.containsInvokeExpr()) continue;
            bl2 = this.cgi.getMethodsReachableFrom(stmt2, sootMethod).contains(sootMethod2);
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext() && !bl2) {
            stmt2 = (BasicBlockGraph.BasicBlock)iterator.next();
            Iterator iterator2 = stmt2.getStmtsOf().iterator();
            while (iterator2.hasNext() && !bl2) {
                Stmt stmt3 = (Stmt)iterator2.next();
                if (!stmt3.containsInvokeExpr()) continue;
                bl2 = this.cgi.getMethodsReachableFrom(stmt3, sootMethod).contains(sootMethod2);
            }
        }
        return bl2;
    }

    private boolean doesControlPathExistsFromTo(SootMethod sootMethod, SootMethod sootMethod2, Collection collection, Collection collection2) {
        boolean bl = false;
        Collection collection3 = CollectionUtils.intersection((Collection)collection2, (Collection)collection);
        Iterator iterator = collection3.iterator();
        while (iterator.hasNext() && !bl) {
            Iterator iterator2;
            SootMethod sootMethod3 = (SootMethod)iterator.next();
            Iterator iterator3 = iterator2 = this.getInvokingStmtIteratorFor(sootMethod3);
            while (iterator3.hasNext() && !bl) {
                Stmt stmt = (Stmt)iterator3.next();
                Collection collection4 = this.cgi.getMethodsReachableFrom(stmt, sootMethod3);
                if (!collection4.contains(sootMethod) || collection4.contains(sootMethod2)) continue;
                bl = this.doesControlFlowPathExistsBetween(sootMethod3, stmt, sootMethod2, true);
            }
        }
        return bl;
    }
}

