/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.instances.ofa;

import edu.ksu.cis.indus.common.ToStringBasedComparator;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.SootBasedDriver;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAXMLizer;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.CGBasedXMLizingProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.CallGraph;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.ValueAnalyzerBasedProcessingController;
import edu.ksu.cis.indus.staticanalyses.tokens.TokenUtil;
import edu.ksu.cis.indus.xmlizer.AbstractXMLizer;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.IXMLizer;
import edu.ksu.cis.indus.xmlizer.UniqueJimpleIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.SootMethod;

public final class OFAXMLizerCLI
extends SootBasedDriver {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$OFAXMLizerCLI == null ? (class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$OFAXMLizerCLI = OFAXMLizerCLI.class$("edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAXMLizerCLI")) : class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$OFAXMLizerCLI));
    private boolean cumulative;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$OFAXMLizerCLI;

    public static String getBaseNameOfFileAndRootMethods(Object object, Collection collection) {
        String string;
        if (object instanceof SootMethod) {
            SootMethod sootMethod = (SootMethod)object;
            string = (sootMethod.getDeclaringClass().getJavaStyleName() + "_" + sootMethod.getSubSignature()).replaceAll(" ", "_");
            collection.add(sootMethod);
        } else {
            string = "collective_call_graph" + System.currentTimeMillis();
            collection.addAll((Collection)object);
        }
        return string;
    }

    public static void main(String[] stringArray) {
        Options options = new Options();
        Option option = new Option("c", "cumulative", false, "Consider all root methods in the same execution.");
        options.addOption(option);
        option = new Option("o", "output", true, "Directory into which xml files will be written into.  Defaults to current directory if omitted");
        option.setArgs(1);
        options.addOption(option);
        option = new Option("j", "jimple", false, "Dump xmlized jimple.");
        options.addOption(option);
        option = new Option("h", "help", false, "Display message.");
        option.setOptionalArg(false);
        options.addOption(option);
        PosixParser posixParser = new PosixParser();
        try {
            Object object;
            CommandLine commandLine = posixParser.parse(options, stringArray);
            if (commandLine.hasOption("h")) {
                object = "java " + (class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$OFAXMLizerCLI == null ? (class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$OFAXMLizerCLI = OFAXMLizerCLI.class$("edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAXMLizerCLI")) : class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$OFAXMLizerCLI).getName();
                new HelpFormatter().printHelp(((String)object).length(), (String)object, "", options, "", true);
                System.exit(1);
            }
            object = new OFAXMLizer();
            String string = commandLine.getOptionValue('o');
            if (string == null) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)"Defaulting to current directory for output.");
                }
                string = ".";
            }
            object.setXmlOutputDir(string);
            object.setGenerator((IJimpleIDGenerator)new UniqueJimpleIDGenerator());
            if (commandLine.getArgList().isEmpty()) {
                throw new MissingArgumentException("Please specify atleast one class.");
            }
            OFAXMLizerCLI oFAXMLizerCLI = new OFAXMLizerCLI();
            oFAXMLizerCLI.setCumulative(commandLine.hasOption('c'));
            oFAXMLizerCLI.setClassNames(commandLine.getArgList());
            oFAXMLizerCLI.initialize();
            oFAXMLizerCLI.execute((IXMLizer)object, commandLine.hasOption('j'));
        }
        catch (ParseException parseException) {
            LOGGER.error((Object)"Error while parsing command line.", (Throwable)parseException);
            String string = "java " + (class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$OFAXMLizerCLI == null ? (class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$OFAXMLizerCLI = OFAXMLizerCLI.class$("edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAXMLizerCLI")) : class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$OFAXMLizerCLI).getName();
            new HelpFormatter().printHelp(string.length(), string, "", options, "");
        }
    }

    private void setCumulative(boolean bl) {
        this.cumulative = bl;
    }

    private void execute(IXMLizer iXMLizer, boolean bl) {
        this.setLogger(LOGGER);
        OFAnalyzer oFAnalyzer = OFAnalyzer.getFSOSAnalyzer("CallGraphXMLizer:FA", TokenUtil.getTokenManager());
        ValueAnalyzerBasedProcessingController valueAnalyzerBasedProcessingController = new ValueAnalyzerBasedProcessingController();
        ArrayList<CallGraph> arrayList = new ArrayList<CallGraph>();
        CallGraph callGraph = new CallGraph();
        ArrayList arrayList2 = new ArrayList();
        ProcessingController processingController = new ProcessingController();
        valueAnalyzerBasedProcessingController.setAnalyzer(oFAnalyzer);
        TagBasedProcessingFilter tagBasedProcessingFilter = new TagBasedProcessingFilter("CallGraphXMLizer:FA");
        valueAnalyzerBasedProcessingController.setProcessingFilter((IProcessingFilter)tagBasedProcessingFilter);
        valueAnalyzerBasedProcessingController.setStmtGraphFactory(this.getStmtGraphFactory());
        processingController.setEnvironment(oFAnalyzer.getEnvironment());
        CGBasedXMLizingProcessingFilter cGBasedXMLizingProcessingFilter = new CGBasedXMLizingProcessingFilter(callGraph);
        cGBasedXMLizingProcessingFilter.chain((IProcessingFilter)tagBasedProcessingFilter);
        processingController.setProcessingFilter((IProcessingFilter)cGBasedXMLizingProcessingFilter);
        processingController.setStmtGraphFactory(this.getStmtGraphFactory());
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.put(IValueAnalyzer.ID, callGraph);
        hashMap.put(IValueAnalyzer.TAG_ID, "CallGraphXMLizer:FA");
        ArrayList<Collection> arrayList3 = new ArrayList<Collection>();
        if (this.cumulative) {
            arrayList3.add(this.getRootMethods());
        } else {
            arrayList3.addAll(this.getRootMethods());
        }
        Collections.sort(arrayList3, ToStringBasedComparator.SINGLETON);
        this.writeInfo("Root methods are: " + arrayList3.size() + "\n" + arrayList3);
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            arrayList2.clear();
            Object e = iterator.next();
            String string = OFAXMLizerCLI.getBaseNameOfFileAndRootMethods(e, arrayList2);
            this.writeInfo("RootMethod: " + e);
            this.writeInfo("BEGIN: FA");
            long l = System.currentTimeMillis();
            oFAnalyzer.reset();
            this.getBbm().reset();
            oFAnalyzer.analyze(this.getScene(), arrayList2);
            long l2 = System.currentTimeMillis();
            this.addTimeLog("FA", l2 - l);
            this.writeInfo("END: FA");
            callGraph.reset();
            arrayList.clear();
            arrayList.add(callGraph);
            valueAnalyzerBasedProcessingController.reset();
            valueAnalyzerBasedProcessingController.driveProcessors(arrayList);
            arrayList.clear();
            hashMap.put(AbstractXMLizer.FILE_NAME_ID, string);
            hashMap.put(IStmtGraphFactory.ID, this.getStmtGraphFactory());
            iXMLizer.writeXML(hashMap);
            if (!bl || !(iXMLizer instanceof AbstractXMLizer)) continue;
            ((AbstractXMLizer)iXMLizer).dumpJimple(string, iXMLizer.getXmlOutputDir(), processingController);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

