/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.instances.ofa;

import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.xmlizer.AbstractXMLizer;
import edu.ksu.cis.indus.xmlizer.CustomXMLOutputter;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.XMLizingProcessingFilter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.znerd.xmlenc.XMLOutputter;
import soot.SootClass;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.Stmt;

public final class OFAXMLizer
extends AbstractXMLizer {
    static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$OFAXMLizer == null ? (class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$OFAXMLizer = OFAXMLizer.class$("edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAXMLizer")) : class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$OFAXMLizer));
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$OFAXMLizer;

    public String getFileName(String string) {
        return "ofa_" + OFAXMLizer.xmlizeString((String)string) + ".xml";
    }

    public void writeXML(Map map) {
        ProcessingController processingController = new ProcessingController();
        OFAnalyzer oFAnalyzer = (OFAnalyzer)map.get(IValueAnalyzer.ID);
        IEnvironment iEnvironment = oFAnalyzer.getEnvironment();
        TagBasedProcessingFilter tagBasedProcessingFilter = new TagBasedProcessingFilter((String)map.get(IValueAnalyzer.TAG_ID));
        processingController.setStmtGraphFactory((IStmtGraphFactory)map.get(IStmtGraphFactory.ID));
        processingController.setProcessingFilter((IProcessingFilter)tagBasedProcessingFilter);
        processingController.setEnvironment(iEnvironment);
        tagBasedProcessingFilter.chain((IProcessingFilter)new XMLizingProcessingFilter());
        File file = new File(this.getXmlOutputDir() + File.separator + this.getFileName((String)map.get(FILE_NAME_ID)));
        try {
            FileWriter fileWriter = new FileWriter(file);
            OFAXMLizingProcessor oFAXMLizingProcessor = new OFAXMLizingProcessor(fileWriter, oFAnalyzer);
            oFAXMLizingProcessor.hookup(processingController);
            processingController.process();
            oFAXMLizingProcessor.unhook(processingController);
            fileWriter.close();
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"Error while xmlizing OFA information ", (Throwable)iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class OFAXMLizingProcessor
    extends AbstractProcessor {
        private final IJimpleIDGenerator idGenerator;
        private OFAnalyzer ofa;
        private XMLOutputter xmlWriter;
        private boolean processingClass;
        private boolean processingMethod;

        public OFAXMLizingProcessor(FileWriter fileWriter, OFAnalyzer oFAnalyzer) {
            this.idGenerator = OFAXMLizer.this.getIdGenerator();
            this.ofa = oFAnalyzer;
            try {
                this.xmlWriter = new CustomXMLOutputter((Writer)fileWriter);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOGGER.error((Object)"This is not supposed to happen", (Throwable)unsupportedEncodingException);
            }
        }

        public void callback(ValueBox valueBox, Context context) {
            context.setProgramPoint(valueBox);
            ArrayList<String> arrayList = new ArrayList<String>();
            Stmt stmt = this.ofa.getValues(valueBox.getValue(), context).iterator();
            while (stmt.hasNext()) {
                arrayList.add(stmt.next().toString());
            }
            if (!arrayList.isEmpty()) {
                Collections.sort(arrayList);
                try {
                    stmt = context.getStmt();
                    SootMethod sootMethod = context.getCurrentMethod();
                    this.xmlWriter.startTag("program_point");
                    this.xmlWriter.attribute("id", this.idGenerator.getIdForValueBox(valueBox, stmt, sootMethod));
                    Iterator iterator = new HashSet(arrayList).iterator();
                    while (iterator.hasNext()) {
                        this.xmlWriter.startTag("object");
                        this.xmlWriter.attribute("expr", AbstractXMLizer.xmlizeString((String)((String)iterator.next())));
                        this.xmlWriter.endTag();
                    }
                    this.xmlWriter.endTag();
                }
                catch (IOException iOException) {
                    LOGGER.error((Object)"Error while xmlizing OFA information ", (Throwable)iOException);
                }
            }
        }

        public void callback(SootMethod sootMethod) {
            try {
                if (this.processingMethod) {
                    this.xmlWriter.endTag();
                } else {
                    this.processingMethod = true;
                }
                this.xmlWriter.startTag("method");
                this.xmlWriter.attribute("id", this.idGenerator.getIdForMethod(sootMethod));
                this.xmlWriter.attribute("name", sootMethod.getSignature());
            }
            catch (IOException iOException) {
                LOGGER.error((Object)"Error while xmlizing OFA information ", (Throwable)iOException);
            }
        }

        public void callback(SootClass sootClass) {
            try {
                if (this.processingMethod) {
                    this.xmlWriter.endTag();
                }
                if (this.processingClass) {
                    this.xmlWriter.endTag();
                } else {
                    this.processingClass = true;
                }
                this.xmlWriter.startTag("class");
                this.xmlWriter.attribute("id", this.idGenerator.getIdForClass(sootClass));
                this.xmlWriter.attribute("name", sootClass.getName());
            }
            catch (IOException iOException) {
                LOGGER.error((Object)"Error while xmlizing OFA information ", (Throwable)iOException);
            }
            this.processingMethod = false;
        }

        public void consolidate() {
            try {
                this.xmlWriter.endDocument();
            }
            catch (IOException iOException) {
                LOGGER.error((Object)"Error while xmlizing OFA information ", (Throwable)iOException);
            }
        }

        public void hookup(ProcessingController processingController) {
            processingController.registerForAllValues((IProcessor)this);
            processingController.register((IProcessor)this);
        }

        public void processingBegins() {
            this.processingClass = false;
            this.processingMethod = false;
            try {
                this.xmlWriter.declaration();
                this.xmlWriter.startTag("ofa");
            }
            catch (IOException iOException) {
                LOGGER.error((Object)"Error while xmlizing OFA information ", (Throwable)iOException);
            }
        }

        public void unhook(ProcessingController processingController) {
            processingController.unregisterForAllValues((IProcessor)this);
            processingController.unregister((IProcessor)this);
        }
    }
}

