/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.instances.ofa;

import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.flow.FA;
import edu.ksu.cis.indus.staticanalyses.flow.IFGNode;
import edu.ksu.cis.indus.staticanalyses.flow.MethodVariant;
import edu.ksu.cis.indus.staticanalyses.flow.MethodVariantManager;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.AbstractAccessExprWork;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.ArrayType;
import soot.RefLikeType;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.NullConstant;

class InvokeExprWork
extends AbstractAccessExprWork {
    protected static final Jimple JIMPLE = Jimple.v();
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$InvokeExprWork == null ? (class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$InvokeExprWork = InvokeExprWork.class$("edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.InvokeExprWork")) : class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$InvokeExprWork));
    protected final boolean returnsRefLikeType;
    private final Set installedVariants = new HashSet();
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$InvokeExprWork;

    public InvokeExprWork(MethodVariant methodVariant, Context context, ITokens iTokens) {
        super(methodVariant, context, iTokens);
        ValueBox valueBox = context.getProgramPoint();
        if (!(valueBox.getValue() instanceof InstanceInvokeExpr)) {
            throw new IllegalArgumentException("accessExprBox has to contain a InstanceInvokeExpr object as value.");
        }
        InstanceInvokeExpr instanceInvokeExpr = (InstanceInvokeExpr)valueBox.getValue();
        this.returnsRefLikeType = instanceInvokeExpr.getMethod().getReturnType() instanceof RefLikeType;
    }

    public synchronized void execute() {
        InstanceInvokeExpr instanceInvokeExpr = (InstanceInvokeExpr)this.accessExprBox.getValue();
        ValueBox valueBox = this.context.getProgramPoint();
        Collection collection = this.tokens.getValues();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(collection + " values arrived at base node of " + this.accessExprBox.getValue() + " in " + (Object)((Object)this.context)));
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Value value = (Value)iterator.next();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Value: " + value));
            }
            if (value instanceof NullConstant) continue;
            try {
                this.processExprAgainstReceiver(instanceInvokeExpr, value);
            }
            catch (IllegalStateException illegalStateException) {
                this.context.setProgramPoint(valueBox);
                throw illegalStateException;
            }
        }
        this.context.setProgramPoint(valueBox);
    }

    public String toString() {
        return "InvokeExprWork: " + this.caller.getMethod() + "@" + this.accessExprBox.getValue();
    }

    private void processExprAgainstReceiver(InstanceInvokeExpr instanceInvokeExpr, Value value) {
        SootMethod sootMethod;
        SootClass sootClass;
        Type type = value.getType();
        FA fA = this.caller.getFA();
        if (type instanceof RefType) {
            sootClass = fA.getClass(((RefType)value.getType()).getClassName());
        } else if (type instanceof ArrayType) {
            sootClass = fA.getClass("java.lang.Object");
        } else {
            IllegalStateException illegalStateException = new IllegalStateException("Non-reference/array type flowing into invocation site.");
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)instanceInvokeExpr);
            }
            throw illegalStateException;
        }
        try {
            sootMethod = MethodVariantManager.findDeclaringMethod(sootClass, instanceInvokeExpr.getMethod());
        }
        catch (IllegalStateException illegalStateException) {
            LOGGER.error((Object)(sootClass + ":" + this.context.getCurrentMethod() + "@" + instanceInvokeExpr), (Throwable)illegalStateException);
            throw illegalStateException;
        }
        MethodVariant methodVariant = fA.getMethodVariant(sootMethod, this.context);
        if (!this.installedVariants.contains(methodVariant)) {
            IFGNode iFGNode;
            IFGNode iFGNode2;
            for (int i = 0; i < sootMethod.getParameterCount(); ++i) {
                if (!(sootMethod.getParameterType(i) instanceof RefLikeType)) continue;
                iFGNode2 = methodVariant.queryParameterNode(i);
                this.context.setProgramPoint(instanceInvokeExpr.getArgBox(i));
                iFGNode = this.caller.queryASTNode(instanceInvokeExpr.getArg(i), this.context);
                iFGNode.addSucc(iFGNode2);
            }
            iFGNode2 = methodVariant.queryThisNode();
            this.context.setProgramPoint(instanceInvokeExpr.getBaseBox());
            iFGNode = this.caller.queryASTNode(instanceInvokeExpr.getBase(), this.context);
            iFGNode.addSucc(iFGNode2);
            if (this.returnsRefLikeType) {
                iFGNode = methodVariant.queryReturnNode();
                this.context.setProgramPoint(this.accessExprBox);
                iFGNode2 = this.caller.queryASTNode((Value)instanceInvokeExpr, this.context);
                iFGNode.addSucc(iFGNode2);
            }
            this.installedVariants.add(methodVariant);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

