/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.instances.ofa;

import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.staticanalyses.flow.AbstractExprSwitch;
import edu.ksu.cis.indus.staticanalyses.flow.AbstractStmtSwitch;
import edu.ksu.cis.indus.staticanalyses.flow.ArrayVariant;
import edu.ksu.cis.indus.staticanalyses.flow.IFGNode;
import edu.ksu.cis.indus.staticanalyses.flow.IFGNodeConnector;
import edu.ksu.cis.indus.staticanalyses.flow.MethodVariant;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.ArrayAccessExprWork;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.FGAccessNode;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.FieldAccessExprWork;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.InvokeExprWork;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.StmtSwitch;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.ArrayType;
import soot.Local;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.StringConstant;
import soot.jimple.ThisRef;
import soot.jimple.UnopExpr;
import soot.jimple.VirtualInvokeExpr;

class FlowInsensitiveExprSwitch
extends AbstractExprSwitch {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$FlowInsensitiveExprSwitch == null ? (class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$FlowInsensitiveExprSwitch = FlowInsensitiveExprSwitch.class$("edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.FlowInsensitiveExprSwitch")) : class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$FlowInsensitiveExprSwitch));
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$FlowInsensitiveExprSwitch;

    public FlowInsensitiveExprSwitch(AbstractStmtSwitch abstractStmtSwitch, IFGNodeConnector iFGNodeConnector) {
        super((soot.jimple.StmtSwitch)abstractStmtSwitch, iFGNodeConnector);
    }

    public Object getClone(Object object) {
        return new FlowInsensitiveExprSwitch((StmtSwitch)((Object)object), this.connector);
    }

    public void caseArrayRef(ArrayRef arrayRef) {
        this.process(arrayRef.getBaseBox());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)arrayRef.getBaseBox());
        }
        IFGNode iFGNode = (IFGNode)this.getResult();
        IFGNode iFGNode2 = this.method.getASTNode((Value)arrayRef);
        ITokenManager iTokenManager = this.fa.getTokenManager();
        ArrayAccessExprWork arrayAccessExprWork = new ArrayAccessExprWork(this.method, this.context, iFGNode2, this.connector, iTokenManager.getNewTokenSet());
        FGAccessNode fGAccessNode = new FGAccessNode(arrayAccessExprWork, this.fa, iTokenManager);
        iFGNode.addSucc(fGAccessNode);
        this.process(arrayRef.getIndexBox());
        this.setResult(iFGNode2);
    }

    public void caseCastExpr(CastExpr castExpr) {
        this.process(castExpr.getOpBox());
        if (Util.isReferenceType((Type)castExpr.getCastType())) {
            IFGNode iFGNode = (IFGNode)this.getResult();
            IFGNode iFGNode2 = this.method.getASTNode((Value)castExpr);
            ITokenManager iTokenManager = this.fa.getTokenManager();
            iFGNode2.setFilter(iTokenManager.getTypeBasedFilter(iTokenManager.getTypeManager().getExactType(castExpr)));
            iFGNode.addSucc(iFGNode2);
            this.setResult(iFGNode2);
        }
    }

    public void caseCaughtExceptionRef(CaughtExceptionRef caughtExceptionRef) {
        IFGNode iFGNode = this.method.getASTNode((Value)caughtExceptionRef);
        this.setResult(iFGNode);
    }

    public void caseInstanceFieldRef(InstanceFieldRef instanceFieldRef) {
        this.process(instanceFieldRef.getBaseBox());
        IFGNode iFGNode = (IFGNode)this.getResult();
        IFGNode iFGNode2 = this.method.getASTNode((Value)instanceFieldRef);
        ITokenManager iTokenManager = this.fa.getTokenManager();
        FieldAccessExprWork fieldAccessExprWork = new FieldAccessExprWork(this.method, this.context, iFGNode2, this.connector, iTokenManager.getNewTokenSet());
        FGAccessNode fGAccessNode = new FGAccessNode(fieldAccessExprWork, this.fa, iTokenManager);
        iFGNode.addSucc(fGAccessNode);
        this.setResult(iFGNode2);
    }

    public void caseInstanceOfExpr(InstanceOfExpr instanceOfExpr) {
        this.process(instanceOfExpr.getOpBox());
    }

    public void caseInterfaceInvokeExpr(InterfaceInvokeExpr interfaceInvokeExpr) {
        this.processInstanceInvokeExpr((InstanceInvokeExpr)interfaceInvokeExpr);
    }

    public void caseLocal(Local local) {
        IFGNode iFGNode = this.method.getASTNode((Value)local);
        this.setResult(iFGNode);
    }

    public void caseNewArrayExpr(NewArrayExpr newArrayExpr) {
        this.process(newArrayExpr.getSizeBox());
        IFGNode iFGNode = this.method.getASTNode((Value)newArrayExpr);
        this.fa.getArrayVariant((ArrayType)newArrayExpr.getType(), this.context);
        iFGNode.injectValue(newArrayExpr);
        this.setResult(iFGNode);
    }

    public void caseNewExpr(NewExpr newExpr) {
        IFGNode iFGNode = this.method.getASTNode((Value)newExpr);
        iFGNode.injectValue(newExpr);
        this.setResult(iFGNode);
    }

    public void caseNewMultiArrayExpr(NewMultiArrayExpr newMultiArrayExpr) {
        ArrayType arrayType = newMultiArrayExpr.getBaseType();
        Type type = arrayType.baseType;
        int n = newMultiArrayExpr.getSizeCount();
        int n2 = arrayType.numDimensions;
        while (n2 > 0) {
            arrayType = ArrayType.v((Type)type, (int)n2);
            ArrayVariant arrayVariant = this.fa.getArrayVariant(arrayType, this.context);
            if (n > 0) {
                arrayVariant.getFGNode().injectValue(newMultiArrayExpr);
            }
            --n2;
            --n;
        }
        IFGNode iFGNode = this.method.getASTNode((Value)newMultiArrayExpr);
        iFGNode.injectValue(newMultiArrayExpr);
        this.setResult(iFGNode);
    }

    public void caseNullConstant(NullConstant nullConstant) {
        IFGNode iFGNode = this.method.getASTNode((Value)nullConstant);
        iFGNode.injectValue(nullConstant);
        this.setResult(iFGNode);
    }

    public void caseParameterRef(ParameterRef parameterRef) {
        this.setResult(this.method.queryParameterNode(parameterRef.getIndex()));
    }

    public void caseSpecialInvokeExpr(SpecialInvokeExpr specialInvokeExpr) {
        SootMethod sootMethod = specialInvokeExpr.getMethod();
        if (sootMethod.getName().equals("<init>")) {
            this.processInvokedMethod((InvokeExpr)specialInvokeExpr);
        } else {
            this.processInstanceInvokeExpr((InstanceInvokeExpr)specialInvokeExpr);
        }
    }

    public void caseStaticFieldRef(StaticFieldRef staticFieldRef) {
        SootField sootField = staticFieldRef.getField();
        IFGNode iFGNode = this.method.getASTNode((Value)staticFieldRef);
        IFGNode iFGNode2 = this.fa.getFieldVariant(sootField).getFGNode();
        this.connector.connect(iFGNode, iFGNode2);
        this.setResult(iFGNode);
    }

    public void caseStaticInvokeExpr(StaticInvokeExpr staticInvokeExpr) {
        this.processInvokedMethod((InvokeExpr)staticInvokeExpr);
    }

    public void caseStringConstant(StringConstant stringConstant) {
        IFGNode iFGNode = this.method.getASTNode((Value)stringConstant);
        iFGNode.injectValue(stringConstant);
        this.setResult(iFGNode);
    }

    public void caseThisRef(ThisRef thisRef) {
        this.setResult(this.method.queryThisNode());
    }

    public void caseVirtualInvokeExpr(VirtualInvokeExpr virtualInvokeExpr) {
        this.processInstanceInvokeExpr((InstanceInvokeExpr)virtualInvokeExpr);
    }

    public void defaultCase(Object object) {
        Value value = (Value)object;
        if (value instanceof BinopExpr) {
            BinopExpr binopExpr = (BinopExpr)value;
            this.process(binopExpr.getOp1Box());
            this.process(binopExpr.getOp2Box());
        } else if (value instanceof UnopExpr) {
            UnopExpr unopExpr = (UnopExpr)value;
            this.process(unopExpr.getOpBox());
        } else {
            super.defaultCase(object);
        }
    }

    protected void processInstanceInvokeExpr(InstanceInvokeExpr instanceInvokeExpr) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("BEGIN: processing " + instanceInvokeExpr));
        }
        this.fa.processClass(instanceInvokeExpr.getMethod().getDeclaringClass());
        this.process(instanceInvokeExpr.getBaseBox());
        IFGNode iFGNode = (IFGNode)this.getResult();
        for (int i = 0; i < instanceInvokeExpr.getArgCount(); ++i) {
            this.process(instanceInvokeExpr.getArgBox(i));
        }
        if (Util.isReferenceType((Type)instanceInvokeExpr.getMethod().getReturnType())) {
            this.setResult(this.method.getASTNode((Value)instanceInvokeExpr));
        } else {
            this.setResult(null);
        }
        ITokenManager iTokenManager = this.fa.getTokenManager();
        InvokeExprWork invokeExprWork = new InvokeExprWork(this.method, this.context, iTokenManager.getNewTokenSet());
        FGAccessNode fGAccessNode = new FGAccessNode(invokeExprWork, this.fa, iTokenManager);
        iFGNode.addSucc(fGAccessNode);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("END: processed " + instanceInvokeExpr));
        }
    }

    private void processInvokedMethod(InvokeExpr invokeExpr) {
        IFGNode iFGNode;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("BEGIN: processing " + invokeExpr));
        }
        MethodVariant methodVariant = this.fa.getMethodVariant(invokeExpr.getMethod(), this.context);
        if (invokeExpr instanceof SpecialInvokeExpr) {
            SpecialInvokeExpr specialInvokeExpr = (SpecialInvokeExpr)invokeExpr;
            iFGNode = methodVariant.queryThisNode();
            this.process(specialInvokeExpr.getBaseBox());
            IFGNode iFGNode2 = (IFGNode)this.getResult();
            iFGNode2.addSucc(iFGNode);
        }
        for (int i = 0; i < invokeExpr.getArgCount(); ++i) {
            if (!Util.isReferenceType((Type)invokeExpr.getArg(i).getType())) continue;
            this.process(invokeExpr.getArgBox(i));
            iFGNode = (IFGNode)this.getResult();
            iFGNode.addSucc(methodVariant.queryParameterNode(i));
        }
        if (Util.isReferenceType((Type)invokeExpr.getMethod().getReturnType())) {
            IFGNode iFGNode3 = this.method.getASTNode((Value)invokeExpr);
            methodVariant.queryReturnNode().addSucc(iFGNode3);
            this.setResult(iFGNode3);
        } else {
            this.setResult(null);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("END: processed " + invokeExpr));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

