/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow;

import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.flow.AbstractFGNode;
import edu.ksu.cis.indus.staticanalyses.flow.AbstractStmtSwitch;
import edu.ksu.cis.indus.staticanalyses.flow.AbstractVariantManager;
import edu.ksu.cis.indus.staticanalyses.flow.FA;
import edu.ksu.cis.indus.staticanalyses.flow.IFGNode;
import edu.ksu.cis.indus.staticanalyses.flow.IVariant;
import edu.ksu.cis.indus.staticanalyses.flow.InvocationVariant;
import edu.ksu.cis.indus.staticanalyses.flow.ValuedVariant;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenManager;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.Local;
import soot.RefLikeType;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.JimpleBody;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.SimpleLocalDefs;

public class MethodVariant
implements IVariant {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$flow$MethodVariant == null ? (class$edu$ksu$cis$indus$staticanalyses$flow$MethodVariant = MethodVariant.class$("edu.ksu.cis.indus.staticanalyses.flow.MethodVariant")) : class$edu$ksu$cis$indus$staticanalyses$flow$MethodVariant));
    protected final AbstractVariantManager astvm;
    protected AbstractStmtSwitch stmt;
    protected final IFGNode returnVar;
    protected final IFGNode thisVar;
    protected final IFGNode[] parameters;
    protected WeakReference defs = new WeakReference<Object>(null);
    protected boolean unRetrievable;
    private final Context context;
    private final FA fa;
    private final SootMethod method;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$flow$MethodVariant;

    protected MethodVariant(SootMethod sootMethod, AbstractVariantManager abstractVariantManager, FA fA) {
        Object object;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("BEGIN: preprocessing of " + sootMethod));
        }
        this.method = sootMethod;
        this.fa = fA;
        this.context = (Context)this.fa.getAnalyzer().context.clone();
        this.context.callNewMethod(sootMethod);
        HashSet<Type> hashSet = new HashSet<Type>();
        int n = sootMethod.getParameterCount();
        if (n > 0) {
            this.parameters = new AbstractFGNode[n];
            for (int i = 0; i < n; ++i) {
                if (!(sootMethod.getParameterType(i) instanceof RefLikeType)) continue;
                this.parameters[i] = this.fa.getNewFGNode();
                hashSet.add(sootMethod.getParameterType(i));
            }
        } else {
            this.parameters = new AbstractFGNode[0];
        }
        if (sootMethod.isStatic()) {
            this.thisVar = null;
        } else {
            this.thisVar = this.fa.getNewFGNode();
            ITokenManager iTokenManager = this.fa.getTokenManager();
            object = sootMethod.getDeclaringClass().getType();
            this.thisVar.setFilter(iTokenManager.getTypeBasedFilter(iTokenManager.getTypeManager().getTypeForIRType((Type)object)));
        }
        if (sootMethod.getReturnType() instanceof RefLikeType) {
            this.returnVar = this.fa.getNewFGNode();
            hashSet.add(sootMethod.getReturnType());
        } else {
            this.returnVar = null;
        }
        this.astvm = abstractVariantManager;
        sootMethod.addTag(this.fa.getTag());
        this.fa.processClass(sootMethod.getDeclaringClass());
        JimpleBody jimpleBody = hashSet.iterator();
        while (jimpleBody.hasNext()) {
            this.fa.processType((Type)jimpleBody.next());
        }
        if (this.method.isConcrete()) {
            jimpleBody = (JimpleBody)this.method.retrieveActiveBody();
            object = jimpleBody.getLocals().iterator();
            while (object.hasNext()) {
                Type type = ((Local)object.next()).getType();
                if (!(type instanceof RefLikeType)) continue;
                this.fa.processType(type);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("END: preprocessed " + sootMethod));
        }
    }

    public final IFGNode getASTNode(Value value) {
        return this.getASTVariant(value, this.context).getFGNode();
    }

    public final IFGNode getASTNode(Value value, Context context) {
        return this.getASTVariant(value, context).getFGNode();
    }

    public final Context getContext() {
        return this.context;
    }

    public List getDefsOfAt(Local local, Stmt stmt) {
        List list = Collections.EMPTY_LIST;
        if (!this.unRetrievable) {
            SimpleLocalDefs simpleLocalDefs = (SimpleLocalDefs)this.defs.get();
            if (simpleLocalDefs != null) {
                list = simpleLocalDefs.getDefsOfAt(local, (Unit)stmt);
            } else if (this.method.hasActiveBody()) {
                SimpleLocalDefs simpleLocalDefs2 = new SimpleLocalDefs((UnitGraph)new CompleteUnitGraph(this.method.retrieveActiveBody()));
                this.defs = new WeakReference<SimpleLocalDefs>(simpleLocalDefs2);
                list = simpleLocalDefs2.getDefsOfAt(local, (Unit)stmt);
            } else {
                this.unRetrievable = true;
            }
        }
        return list;
    }

    public final FA getFA() {
        return this.fa;
    }

    public final SootMethod getMethod() {
        return this.method;
    }

    public void process() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("BEGIN: processing of " + this.method));
        }
        JimpleBody jimpleBody = null;
        if (this.method.isConcrete()) {
            jimpleBody = (JimpleBody)this.method.retrieveActiveBody();
            ArrayList arrayList = new ArrayList(jimpleBody.getUnits());
            this.stmt = this.fa.getStmt(this);
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                this.stmt.process((Stmt)object.next());
            }
            object = new HashSet();
            boolean bl = false;
            InvokeExpr invokeExpr = null;
            Iterator iterator = jimpleBody.getTraps().iterator();
            while (iterator.hasNext()) {
                Trap trap = (Trap)iterator.next();
                Stmt stmt = (Stmt)trap.getBeginUnit();
                Stmt stmt2 = (Stmt)trap.getEndUnit();
                CaughtExceptionRef caughtExceptionRef = (CaughtExceptionRef)((IdentityStmt)trap.getHandlerUnit()).getRightOp();
                SootClass sootClass = trap.getException();
                int n = arrayList.indexOf(stmt2);
                for (int i = arrayList.indexOf(stmt); i < n; ++i) {
                    Object object2;
                    Stmt stmt3 = (Stmt)arrayList.get(i);
                    if (stmt3 instanceof ThrowStmt) {
                        SootClass sootClass2;
                        object2 = (ThrowStmt)stmt3;
                        if (!object.contains(object2) && Util.isDescendentOf((SootClass)(sootClass2 = this.fa.getClass(((RefType)object2.getOp().getType()).getClassName())), (SootClass)sootClass)) {
                            this.context.setStmt((Stmt)object2);
                            IFGNode iFGNode = this.getASTNode(object2.getOp(), this.context);
                            iFGNode.addSucc(this.getASTNode((Value)caughtExceptionRef));
                            object.add(object2);
                        }
                    } else if (stmt3.containsInvokeExpr()) {
                        invokeExpr = stmt3.getInvokeExpr();
                        bl = true;
                    }
                    if (!bl) continue;
                    bl = false;
                    if (object.contains(stmt3)) continue;
                    this.context.setStmt(stmt3);
                    object2 = this.queryThrowNode(invokeExpr, sootClass);
                    if (object2 == null) continue;
                    object2.addSucc(this.getASTNode((Value)caughtExceptionRef));
                }
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(this.method + " is not a concrete method. Hence, it's body could not be retrieved."));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("END: processing of " + this.method));
        }
    }

    public final IFGNode queryASTNode(Value value) {
        return this.queryASTNode(value, this.context);
    }

    public final IFGNode queryASTNode(Value value, Context context) {
        ValuedVariant valuedVariant = this.queryASTVariant(value, context);
        IFGNode iFGNode = null;
        if (valuedVariant != null) {
            iFGNode = valuedVariant.getFGNode();
        }
        return iFGNode;
    }

    public final ValuedVariant queryASTVariant(Value value, Context context) {
        return (ValuedVariant)this.astvm.query(value, context);
    }

    public final IFGNode queryParameterNode(int n) {
        IFGNode iFGNode = null;
        if (n >= 0 && n <= this.method.getParameterCount()) {
            iFGNode = this.parameters[n];
        }
        return iFGNode;
    }

    public final IFGNode queryReturnNode() {
        return this.returnVar;
    }

    public final IFGNode queryThisNode() {
        return this.thisVar;
    }

    public final IFGNode queryThrowNode(InvokeExpr invokeExpr, SootClass sootClass) {
        return this.queryThrowNode(invokeExpr, sootClass, this.context);
    }

    public final IFGNode queryThrowNode(InvokeExpr invokeExpr, SootClass sootClass, Context context) {
        InvocationVariant invocationVariant = (InvocationVariant)this.queryASTVariant((Value)invokeExpr, context);
        IFGNode iFGNode = null;
        if (invocationVariant != null) {
            iFGNode = invocationVariant.queryThrowNode(sootClass);
        }
        return iFGNode;
    }

    final ValuedVariant getASTVariant(Value value, Context context) {
        return (ValuedVariant)this.astvm.select(value, context);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

