/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow;

import edu.ksu.cis.indus.IndusTestCase;
import edu.ksu.cis.indus.staticanalyses.flow.FA;
import edu.ksu.cis.indus.staticanalyses.flow.IFATest;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;

public final class FATest
extends IndusTestCase
implements IFATest {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$flow$FATest == null ? (class$edu$ksu$cis$indus$staticanalyses$flow$FATest = FATest.class$("edu.ksu.cis.indus.staticanalyses.flow.FATest")) : class$edu$ksu$cis$indus$staticanalyses$flow$FATest));
    private FA fa;
    private String faTagName;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$flow$FATest;

    public void setAnalyzer(IValueAnalyzer iValueAnalyzer) {
    }

    public void setFA(FA fA) {
        this.fa = fA;
    }

    public void setFATagName(String string) {
        this.faTagName = string;
    }

    public void testContainment() {
        this.checkContainmentOnTaggedEntity();
        this.checkContainmentOnUnTaggedEntity();
    }

    public void testProcessing() {
        Collection collection = this.fa.getClasses();
        Iterator iterator = this.fa.getScene().getClasses().iterator();
        while (iterator.hasNext()) {
            SootClass sootClass = (SootClass)iterator.next();
            if (sootClass.hasTag(this.faTagName)) {
                FATest.assertTrue((boolean)collection.contains(sootClass));
                continue;
            }
            FATest.assertFalse((boolean)collection.contains(sootClass));
        }
    }

    protected void setUp() throws Exception {
        if (this.fa == null || this.faTagName == null) {
            throw new IllegalStateException("Please call setFA() and setFATagName() before using this test.");
        }
    }

    protected void tearDown() throws Exception {
        this.fa = null;
        this.faTagName = null;
    }

    private void checkContainmentOnTaggedEntity() {
        Iterator iterator = this.fa.getScene().getClasses().iterator();
        while (iterator.hasNext()) {
            SootField sootField;
            SootClass sootClass = (SootClass)iterator.next();
            boolean bl = false;
            if (LOGGER.isDebugEnabled() && sootClass.hasTag(this.faTagName)) {
                LOGGER.debug((Object)("TAGGED Class: " + sootClass));
            }
            Iterator iterator2 = sootClass.getFields().iterator();
            while (iterator2.hasNext()) {
                sootField = (SootField)iterator2.next();
                if (!sootField.hasTag(this.faTagName)) continue;
                bl = true;
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("TAGGED Field: " + sootField));
            }
            iterator2 = sootClass.getMethods().iterator();
            while (iterator2.hasNext()) {
                sootField = (SootMethod)iterator2.next();
                if (sootField.hasTag(this.faTagName)) {
                    FATest.assertNotNull((Object)this.fa.queryMethodVariant((SootMethod)sootField));
                    bl = true;
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)("TAGGED Method: " + sootField));
                    continue;
                }
                FATest.assertNull((Object)this.fa.queryMethodVariant((SootMethod)sootField));
            }
            if (!bl) continue;
            FATest.assertTrue((boolean)sootClass.hasTag(this.faTagName));
        }
    }

    private void checkContainmentOnUnTaggedEntity() {
        Iterator iterator = this.fa.getScene().getClasses().iterator();
        while (iterator.hasNext()) {
            SootClass sootClass = (SootClass)iterator.next();
            if (sootClass.hasTag(this.faTagName)) continue;
            Iterator iterator2 = sootClass.getFields().iterator();
            while (iterator2.hasNext()) {
                FATest.assertFalse((boolean)((SootField)iterator2.next()).hasTag(this.faTagName));
            }
            iterator2 = sootClass.getMethods().iterator();
            while (iterator2.hasNext()) {
                FATest.assertFalse((boolean)((SootMethod)iterator2.next()).hasTag(this.faTagName));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

